/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.tools.wizard;

import com.sas.graphics.tools.wizard.GraphWizard;
import com.sas.graphics.tools.wizard.WizardEntry;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.w3c.dom.Element;

public class ChartCategory {
    private String name = null;
    private String displayName = null;
    private String iconName = null;
    private ImageIcon icon = null;
    private WizardEntry[] entries = null;

    public ChartCategory(Element catRoot, ResourceBundle rb, GraphWizard wizard) {
        this.name = catRoot.getAttribute("name");
        this.displayName = GraphWizard.GRS(rb, catRoot.getAttribute("displayNameKey"), this.name);
        this.iconName = catRoot.getAttribute("icon");
        Image i = ChartCategory.getImage(wizard, this.iconName);
        if (i != null) {
            this.icon = new ImageIcon(i);
        }
        Vector<WizardEntry> v = new Vector<WizardEntry>();
        Element chart = null;
        int index = 1;
        while ((chart = GraphWizard.getChildWithTagName("ChartType", catRoot, index++)) != null) {
            WizardEntry entry;
            String entryClass = chart.getAttribute("entry");
            if (entryClass == null || entryClass.length() == 0 || (entry = this.loadEntry(entryClass)) == null) continue;
            entry.init(chart, wizard.getData(), rb);
            if (!entry.canLoad()) continue;
            v.addElement(entry);
        }
        this.entries = new WizardEntry[v.size()];
        v.copyInto(this.entries);
    }

    static Image getImage(Component comp, String name) {
        Image img;
        String s = name;
        if (comp == null || name == null) {
            return null;
        }
        if (!(s.startsWith("/") || s.startsWith("http:") || s.startsWith("file:"))) {
            s = "/" + s;
        }
        s.replace('\\', '/');
        InputStream is = comp.getClass().getResourceAsStream(s);
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (baos == null) {
            return null;
        }
        try {
            int c;
            while ((c = is.read()) >= 0) {
                baos.write(c);
            }
            Toolkit tk = comp.getToolkit();
            if (tk == null) {
                return null;
            }
            img = tk.createImage(baos.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return img;
    }

    private WizardEntry loadEntry(String classname) {
        WizardEntry rc = null;
        try {
            Class<?> c = Class.forName(classname);
            Object o = c.newInstance();
            Class<WizardEntry> jc = WizardEntry.class;
            if (jc.isInstance(o)) {
                rc = (WizardEntry)o;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rc;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getName() {
        return this.name;
    }

    public WizardEntry[] getEntries() {
        return this.entries;
    }
}

