/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles;

import com.sas.graphics.styles.AttributeNames;
import com.sas.graphics.styles.Size;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.HTMLColors;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextStyleElement
extends StyleElement
implements AttributeNames {
    public static final Color defaultTextColor = Color.BLACK;
    public static final String defaultFontFamily = "[SansSerif]";
    public static final Size defaultFontSize = new Size(10, 0);
    public static final int defaultFontSytle = 0;
    public static final int defaultFontWeight = 0;
    public static final boolean defaultDropShadowEnabled = false;
    private static Hashtable fontLookupTable = null;
    public static final Color defaultAltTextColor = Color.BLACK;
    public boolean useFontLookupTable = true;

    public TextStyleElement(Element styleElement) {
        super(styleElement);
    }

    public Color getTextColor() {
        return this.getColorAttribute("textColor", defaultTextColor);
    }

    public boolean setTextColor(Color c) {
        if (c == null) {
            return false;
        }
        String s = HTMLColors.getColorString(c);
        if (s == null) {
            return false;
        }
        return this.setAttribute("textColor", s);
    }

    public String getFontFamily() {
        return this.getFontFamily(defaultFontFamily);
    }

    public String getFontFamily(String defaultFamily) {
        String rc = this.getAttribute("fontFamily");
        String[] arr = TextStyleElement.parseStringArray(rc);
        Font f = FontManager.getFont(arr, this.getFontStyle(), this.getFontSize().getSizeValue(), null, this.useFontLookupTable ? fontLookupTable : null);
        if (f == null) {
            return defaultFamily;
        }
        return f.getFamily();
    }

    public boolean setFontFamily(String family) {
        return this.setAttribute("fontFamily", family);
    }

    public Size getFontSize() {
        return this.getSizeAttribute("fontSize", defaultFontSize);
    }

    public boolean setFontSize(Size size) {
        if (size == null) {
            return false;
        }
        return this.setAttribute("fontSize", size.toString());
    }

    public int getFontStyle() {
        if (!this.hasAttribute("fontStyle")) {
            return 0;
        }
        String style = this.getAttribute("fontStyle");
        if (style.equalsIgnoreCase("normal")) {
            return 0;
        }
        if (style.equalsIgnoreCase("italic")) {
            return 2;
        }
        return 0;
    }

    public boolean setFontStyle(int style) {
        if (style != 0 && style != 2) {
            return false;
        }
        if (style == 0) {
            this.setAttribute("fontStyle", "normal");
        } else if (style == 2) {
            this.setAttribute("fontStyle", "italic");
        } else {
            return false;
        }
        return true;
    }

    public int getFontWeight() {
        if (!this.hasAttribute("fontWeight")) {
            return 0;
        }
        String weight = this.getAttribute("fontWeight");
        if (weight.equalsIgnoreCase("normal")) {
            return 0;
        }
        if (weight.equalsIgnoreCase("bold")) {
            return 1;
        }
        return 0;
    }

    public boolean setFontWeight(int weight) {
        if (weight != 0 && weight != 1) {
            return false;
        }
        if (weight == 0) {
            this.setAttribute("fontWeight", "normal");
        } else if (weight == 1) {
            this.setAttribute("fontWeight", "bold");
        } else {
            return false;
        }
        return true;
    }

    public boolean isTextDropShadowEnabled() {
        return this.getBooleanAttribute("textDropShadowEnabled", false);
    }

    public void setTextDropShadowEnabled(boolean enabled) {
        this.setAttribute("textDropShadowEnabled", "" + enabled);
    }

    @Override
    public Color getDefaultColor() {
        return this.getTextColor();
    }

    public Font getFont() {
        return FontManager.getFont(TextStyleElement.parseStringArray(this.getAttribute("fontFamily")), this.getFontStyle() + this.getFontWeight(), this.getFontSize().getSizeValue(), null, this.useFontLookupTable ? fontLookupTable : null);
    }

    public static String[] parseStringArray(String str) {
        if (str == null || str.length() < 1) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, ",");
        String[] rc = new String[st.countTokens()];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = st.nextToken().trim().toUpperCase();
        }
        return rc;
    }

    public Font getAdjustedFont() {
        Size s = this.getFontSize();
        double adjustedSize = FontManager.adjustFontSize(s.getSizeValue());
        return FontManager.getFont(this.getFontFamily(), this.getFontStyle() + this.getFontWeight(), (int)adjustedSize);
    }

    public static void parseLogicalFontTable(Element e) {
        if (e == null || !e.getTagName().equals("LogicalFonts")) {
            return;
        }
        if (fontLookupTable == null) {
            fontLookupTable = new Hashtable();
        }
        NodeList list = e.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            String directive = child.getTagName().toUpperCase();
            String fontName = "";
            NodeList list1 = child.getChildNodes();
            for (int j = 0; j < list1.getLength(); ++j) {
                fontName = fontName + list1.item(j).getNodeValue();
            }
            fontLookupTable.put(directive.trim(), fontName.trim());
        }
    }

    public Color getAltTextColor() {
        return this.getColorAttribute("altTextColor", defaultAltTextColor);
    }

    public boolean setAltTextColor(Color c) {
        if (c == null) {
            return false;
        }
        String s = HTMLColors.getColorString(c);
        if (s == null) {
            return false;
        }
        return this.setAttribute("altTextColor", s);
    }
}

