/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles;

import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.MarkerStyleElement;
import com.sas.graphics.styles.RampStyleElement;
import com.sas.graphics.styles.ShadowStyleElement;
import com.sas.graphics.styles.Size;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleUtils;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.HTMLColors;
import java.awt.Color;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class StyleElement {
    private Element styleElement;
    private boolean printMessages = false;
    private Vector changeListeners = null;
    private DataStyleElement dataStyleElement = null;
    private RampStyleElement rampStyleElement = null;
    private FillStyleElement fillStyleElement = null;
    private ShadowStyleElement shadowStyleElement = null;
    private LineStyleElement lineStyleElement = null;
    private TextStyleElement textStyleElement = null;
    private MarkerStyleElement markerStyleElement = null;
    private static Hashtable colorCache = new Hashtable();
    private String displayName = null;
    private boolean readOnly = false;
    static int numAllocated = 0;

    public StyleElement() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.newDocument();
            this.styleElement = doc.createElement("style:Style");
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
    }

    public StyleElement(Element styleElement) {
        this.styleElement = styleElement;
    }

    public StyleElement(StyleElement element) {
        if (element.styleElement != null) {
            this.styleElement = (Element)element.styleElement.cloneNode(false);
        } else {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = factory.newDocumentBuilder();
                Document doc = db.newDocument();
                this.styleElement = doc.createElement("style:Style");
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
        }
    }

    public Element getElement() {
        return this.styleElement;
    }

    public String getContextName() {
        return this.getAttribute("context");
    }

    public String getTemplateClassname() {
        return StyleUtils.getTemplateNameForContextName(this.getContextName());
    }

    public String getDisplayName() {
        return this.getTemplateClassname();
    }

    public String getAttribute(String attributeName) {
        return this.getAttribute(attributeName, null);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        if (this.printMessages && this.styleElement != null && !this.styleElement.hasAttribute(attributeName) && !StyleUtils.isStandardAttributeName(attributeName)) {
            System.out.println(MessageFormat.format(Style.getString("AttributeNotFoundMessage.txt"), attributeName));
        }
        if (this.styleElement == null || !this.styleElement.hasAttribute(attributeName)) {
            return defaultValue;
        }
        return this.styleElement.getAttribute(attributeName);
    }

    public boolean setAttribute(String attributeName, String attributeValue) {
        String oldValue;
        if (this.styleElement == null || attributeName == null || this.readOnly) {
            return false;
        }
        String string = oldValue = this.styleElement.hasAttribute(attributeName) ? this.styleElement.getAttribute(attributeName) : null;
        if (attributeValue == null) {
            this.styleElement.removeAttribute(attributeName);
        } else {
            this.styleElement.setAttribute(attributeName, attributeValue);
            if (attributeName.equals("color")) {
                this.styleElement.setAttribute("fillColor", attributeValue);
            }
            if (attributeName.equals("fillColor")) {
                this.styleElement.setAttribute("color", attributeValue);
            }
            if (attributeName.equals("altColor")) {
                this.styleElement.setAttribute("markerColor", attributeValue);
                this.styleElement.setAttribute("lineColor", attributeValue);
            }
            if (attributeName.equals("markerColor")) {
                this.styleElement.setAttribute("altColor", attributeValue);
                this.styleElement.setAttribute("lineColor", attributeValue);
            }
            if (attributeName.equals("lineColor")) {
                this.styleElement.setAttribute("markerColor", attributeValue);
                this.styleElement.setAttribute("altColor", attributeValue);
            }
        }
        if (oldValue != null && attributeValue != null && !oldValue.toString().equals(attributeValue.toString())) {
            this.styleElement.setAttribute("_modified", "true");
        }
        this.fireChangeEvent(attributeName, oldValue, attributeValue);
        return true;
    }

    public boolean hasAttribute(String attributeName) {
        if (this.styleElement == null) {
            return false;
        }
        return this.styleElement.hasAttribute(attributeName);
    }

    public boolean removeAttribute(String attributeName) {
        if (this.styleElement == null || attributeName == null) {
            return false;
        }
        this.styleElement.removeAttribute(attributeName);
        return true;
    }

    public Color getColorAttribute(String attributeName, Color defaultValue) {
        if (this.styleElement == null || !this.styleElement.hasAttribute(attributeName)) {
            return defaultValue;
        }
        HTMLColors colors = HTMLColors.getInstance();
        String attr = this.styleElement.getAttribute(attributeName);
        if (colorCache.containsKey(attr)) {
            return (Color)colorCache.get(attr);
        }
        Color rc = null;
        rc = attr.startsWith("SystemColor.") ? this.getSystemColor(attr.substring(12)) : colors.getColor(attr);
        if (rc != null) {
            colorCache.put(attr, rc);
        }
        if (rc == null) {
            return defaultValue;
        }
        return rc;
    }

    private Color getSystemColor(String systemColorName) {
        UIDefaults def = UIManager.getLookAndFeelDefaults();
        Color color = def.getColor(systemColorName);
        if (color != null) {
            return color;
        }
        SystemColor rc = SystemColor.control;
        if (systemColorName.equalsIgnoreCase("desktop")) {
            rc = SystemColor.desktop;
        }
        if (systemColorName.equalsIgnoreCase("activeCaption")) {
            rc = SystemColor.activeCaption;
        }
        if (systemColorName.equalsIgnoreCase("activeCaptionText")) {
            rc = SystemColor.activeCaptionText;
        }
        if (systemColorName.equalsIgnoreCase("activeCaptionBorder")) {
            rc = SystemColor.activeCaptionBorder;
        }
        if (systemColorName.equalsIgnoreCase("inactiveCaption")) {
            rc = SystemColor.inactiveCaption;
        }
        if (systemColorName.equalsIgnoreCase("inactiveCaptionText")) {
            rc = SystemColor.inactiveCaptionText;
        }
        if (systemColorName.equalsIgnoreCase("inactiveCaptionBorder")) {
            rc = SystemColor.inactiveCaptionBorder;
        }
        if (systemColorName.equalsIgnoreCase("window")) {
            rc = SystemColor.window;
        }
        if (systemColorName.equalsIgnoreCase("windowBorder")) {
            rc = SystemColor.windowBorder;
        }
        if (systemColorName.equalsIgnoreCase("windowText")) {
            rc = SystemColor.windowText;
        }
        if (systemColorName.equalsIgnoreCase("menu")) {
            rc = SystemColor.menu;
        }
        if (systemColorName.equalsIgnoreCase("menuText")) {
            rc = SystemColor.menuText;
        }
        if (systemColorName.equalsIgnoreCase("text")) {
            rc = SystemColor.text;
        }
        if (systemColorName.equalsIgnoreCase("textText")) {
            rc = SystemColor.textText;
        }
        if (systemColorName.equalsIgnoreCase("textHighlight")) {
            rc = SystemColor.textHighlight;
        }
        if (systemColorName.equalsIgnoreCase("textHighlightText")) {
            rc = SystemColor.textHighlightText;
        }
        if (systemColorName.equalsIgnoreCase("control")) {
            rc = SystemColor.control;
        }
        if (systemColorName.equalsIgnoreCase("controlText")) {
            rc = SystemColor.controlText;
        }
        if (systemColorName.equalsIgnoreCase("controlLtHighlight")) {
            rc = SystemColor.controlLtHighlight;
        }
        if (systemColorName.equalsIgnoreCase("controlHighlight")) {
            rc = SystemColor.controlHighlight;
        }
        if (systemColorName.equalsIgnoreCase("controlShadow")) {
            rc = SystemColor.controlShadow;
        }
        if (systemColorName.equalsIgnoreCase("controlDkShadow")) {
            rc = SystemColor.controlDkShadow;
        }
        if (systemColorName.equalsIgnoreCase("scrollbar")) {
            rc = SystemColor.scrollbar;
        }
        if (systemColorName.equalsIgnoreCase("info")) {
            rc = SystemColor.info;
        }
        if (systemColorName.equalsIgnoreCase("infoText")) {
            rc = SystemColor.infoText;
        }
        return rc;
    }

    public Color applyElementTransparency(Color c) {
        if (c == null) {
            return null;
        }
        if (!this.hasAttribute("transparency")) {
            return c;
        }
        return StyleUtils.applyTransparencyToColor(c, this.getDoubleAttribute("transparency", 0.0));
    }

    public int getIntegerAttribute(String attributeName, int defaultValue) {
        if (this.styleElement == null || !this.styleElement.hasAttribute(attributeName)) {
            return defaultValue;
        }
        try {
            Integer i = Integer.valueOf(this.styleElement.getAttribute(attributeName));
            return i;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBooleanAttribute(String attributeName, boolean defaultValue) {
        if (this.styleElement == null || !this.styleElement.hasAttribute(attributeName)) {
            return defaultValue;
        }
        String value = this.styleElement.getAttribute(attributeName);
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
            return false;
        }
        return defaultValue;
    }

    public double getDoubleAttribute(String attributeName, double defaultValue) {
        if (this.styleElement == null || !this.styleElement.hasAttribute(attributeName)) {
            return defaultValue;
        }
        try {
            Double d = Double.valueOf(this.styleElement.getAttribute(attributeName));
            return d;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Size getSizeAttribute(String attributeName, Size defaultValue) {
        if (this.styleElement == null || !this.styleElement.hasAttribute(attributeName)) {
            return defaultValue;
        }
        return new Size(this.styleElement.getAttribute(attributeName));
    }

    public DataStyleElement getAsDataStyle() {
        if (this instanceof DataStyleElement) {
            this.dataStyleElement = (DataStyleElement)this;
        }
        if (this.dataStyleElement == null) {
            this.dataStyleElement = new DataStyleElement(this.styleElement);
            this.dataStyleElement.setReadOnly(this.readOnly);
            if (this.changeListeners != null) {
                for (int i = 0; i < this.changeListeners.size(); ++i) {
                    this.dataStyleElement.addChangeListener((PropertyChangeListener)this.changeListeners.elementAt(i));
                }
            }
        }
        return this.dataStyleElement;
    }

    public RampStyleElement getAsRampStyle() {
        if (this instanceof RampStyleElement) {
            this.rampStyleElement = (RampStyleElement)this;
        }
        if (this.rampStyleElement == null) {
            this.rampStyleElement = new RampStyleElement(this.styleElement);
            this.rampStyleElement.setReadOnly(this.readOnly);
            if (this.changeListeners != null) {
                for (int i = 0; i < this.changeListeners.size(); ++i) {
                    this.rampStyleElement.addChangeListener((PropertyChangeListener)this.changeListeners.elementAt(i));
                }
            }
        }
        return this.rampStyleElement;
    }

    public FillStyleElement getAsFillStyle() {
        if (this instanceof FillStyleElement) {
            this.fillStyleElement = (FillStyleElement)this;
        }
        if (this.fillStyleElement == null) {
            this.fillStyleElement = new FillStyleElement(this.styleElement);
            this.fillStyleElement.setReadOnly(this.readOnly);
            if (this.changeListeners != null) {
                for (int i = 0; i < this.changeListeners.size(); ++i) {
                    this.fillStyleElement.addChangeListener((PropertyChangeListener)this.changeListeners.elementAt(i));
                }
            }
        }
        return this.fillStyleElement;
    }

    public ShadowStyleElement getAsShadowStyle() {
        if (this instanceof ShadowStyleElement) {
            this.shadowStyleElement = (ShadowStyleElement)this;
        }
        if (this.shadowStyleElement == null) {
            this.shadowStyleElement = new ShadowStyleElement(this.styleElement);
            this.shadowStyleElement.setReadOnly(this.readOnly);
            if (this.changeListeners != null) {
                for (int i = 0; i < this.changeListeners.size(); ++i) {
                    this.shadowStyleElement.addChangeListener((PropertyChangeListener)this.changeListeners.elementAt(i));
                }
            }
        }
        return this.shadowStyleElement;
    }

    public LineStyleElement getAsLineStyle() {
        if (this instanceof LineStyleElement) {
            this.lineStyleElement = (LineStyleElement)this;
        }
        if (this.lineStyleElement == null) {
            this.lineStyleElement = new LineStyleElement(this.styleElement);
            this.lineStyleElement.setReadOnly(this.readOnly);
            if (this.changeListeners != null) {
                for (int i = 0; i < this.changeListeners.size(); ++i) {
                    this.lineStyleElement.addChangeListener((PropertyChangeListener)this.changeListeners.elementAt(i));
                }
            }
        }
        return this.lineStyleElement;
    }

    public TextStyleElement getAsTextStyle() {
        if (this instanceof TextStyleElement) {
            this.textStyleElement = (TextStyleElement)this;
        }
        if (this.textStyleElement == null) {
            this.textStyleElement = new TextStyleElement(this.styleElement);
            this.textStyleElement.setReadOnly(this.readOnly);
            if (this.changeListeners != null) {
                for (int i = 0; i < this.changeListeners.size(); ++i) {
                    this.textStyleElement.addChangeListener((PropertyChangeListener)this.changeListeners.elementAt(i));
                }
            }
        }
        return this.textStyleElement;
    }

    public MarkerStyleElement getAsMarkerStyle() {
        if (this instanceof MarkerStyleElement) {
            this.markerStyleElement = (MarkerStyleElement)this;
        }
        if (this.markerStyleElement == null) {
            this.markerStyleElement = new MarkerStyleElement(this.styleElement);
            this.markerStyleElement.setReadOnly(this.readOnly);
            if (this.changeListeners != null) {
                for (int i = 0; i < this.changeListeners.size(); ++i) {
                    this.markerStyleElement.addChangeListener((PropertyChangeListener)this.changeListeners.elementAt(i));
                }
            }
        }
        return this.markerStyleElement;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public NamedNodeMap getAttributes() {
        if (this.styleElement == null) {
            return null;
        }
        return this.styleElement.getAttributes();
    }

    public Color getDefaultColor() {
        return Color.black;
    }

    public StyleElement mergeWith(StyleElement element) {
        if (element == null && this.styleElement == null) {
            return new StyleElement();
        }
        if (element == null) {
            return new StyleElement((Element)this.styleElement.cloneNode(false));
        }
        if (this.styleElement == null) {
            return new StyleElement(element);
        }
        Element newElement = (Element)this.styleElement.cloneNode(false);
        if (element != null && element.styleElement != null) {
            NamedNodeMap attrs = element.styleElement.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                newElement.setAttribute(((Attr)attrs.item(i)).getName(), ((Attr)attrs.item(i)).getValue());
            }
        }
        return new StyleElement(newElement);
    }

    void addChangeListener(PropertyChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new Vector();
        }
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.addElement(listener);
        }
    }

    void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    void removeChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeListeners == null) {
            return;
        }
        if (this.changeListeners.contains(listener)) {
            this.changeListeners.remove(listener);
        }
    }

    private void fireChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.changeListeners == null) {
            return;
        }
        PropertyChangeEvent changeEvent = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            PropertyChangeListener pcl = (PropertyChangeListener)this.changeListeners.elementAt(i);
            pcl.propertyChange(changeEvent);
        }
    }

    public boolean isPrintMessages() {
        return this.printMessages;
    }

    public void setPrintMessages(boolean printMessages) {
        this.printMessages = printMessages;
    }
}

