/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles;

import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.MarkerStyleElement;
import com.sas.graphics.styles.PredefinedStyles;
import com.sas.graphics.styles.RampStyleElement;
import com.sas.graphics.styles.ShadowStyleElement;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.styles.StyleUtils;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.HTMLColors;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Style {
    private Element schemeRoot = null;
    private Element styleRoot = null;
    private boolean fallbackEnabled = false;
    private StyleElementChangeListener changeListener = new StyleElementChangeListener();
    private Vector changeListeners = null;
    private Hashtable elementCache = new Hashtable();
    private static int NONE = -1;
    private static int DATA = 0;
    private static int RAMP = 1;
    private static int FILL = 2;
    private static int SHADOW = 3;
    private static int LINE = 4;
    private static int TEXT = 5;
    private static int MARKER = 6;
    private static final String BUNDLE_NAME = "com.sas.graphics.styles.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.sas.graphics.styles.messages");
    private boolean printMessages = false;
    private boolean readOnly = false;
    private String attrPriority = null;

    public Style() {
    }

    public Style(String name) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.newDocument();
            this.schemeRoot = doc.createElement("style:Scheme");
            this.schemeRoot.setAttribute("name", name);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
    }

    public Style(Style styleIn) {
        this.schemeRoot = (Element)styleIn.schemeRoot.cloneNode(true);
        this.styleRoot = this.getStyleElementByName(styleIn.getStyleName());
        this.attrPriority = styleIn.attrPriority;
    }

    public StyleElement getStyleElement(String elementName) {
        StyleElement se = this.getStyleElement(elementName, NONE);
        if (se != null) {
            return se;
        }
        if (!this.fallbackEnabled) {
            return null;
        }
        if (!StyleUtils.isPredefinedContextName(elementName)) {
            se = new DataStyleElement(null);
            se.addChangeListener(this.changeListener);
            return se;
        }
        if (StyleUtils.isTextContextName(elementName)) {
            TextStyleElement te = (TextStyleElement)this.getStyleElement("ValueText", TEXT);
            if (te == null) {
                te = new TextStyleElement(null);
                te.addChangeListener(this.changeListener);
            }
            return te;
        }
        if (StyleUtils.isFillContextName(elementName)) {
            se = new FillStyleElement(null);
            se.addChangeListener(this.changeListener);
            return se;
        }
        DataStyleElement de = (DataStyleElement)this.getStyleElement("GraphDataStyleDefault", DATA);
        if (de == null) {
            de = new DataStyleElement(null);
            de.addChangeListener(this.changeListener);
        }
        return de;
    }

    private StyleElement getStyleElement(String elementName, int type) {
        StyleElement rc = null;
        if (elementName == null) {
            return null;
        }
        if (this.elementCache.containsKey(elementName)) {
            rc = (StyleElement)this.elementCache.get(elementName);
        } else {
            if (this.schemeRoot == null || this.styleRoot == null) {
                return null;
            }
            NodeList children = this.styleRoot.getChildNodes();
            int num = children.getLength();
            for (int i = 0; i < num; ++i) {
                Element e;
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !(e = (Element)child).hasAttribute("context") || !e.getAttribute("context").equalsIgnoreCase(elementName)) continue;
                rc = new StyleElement(e);
                rc.setPrintMessages(this.printMessages);
                if ("LegendFill".equalsIgnoreCase(elementName) && this.styleRoot.hasAttribute("legendTransparency")) {
                    rc.setAttribute("transparency", this.styleRoot.getAttribute("legendTransparency"));
                } else if ("WallFill".equalsIgnoreCase(elementName) && this.styleRoot.hasAttribute("wallTransparency")) {
                    rc.setAttribute("transparency", this.styleRoot.getAttribute("wallTransparency"));
                } else if (StyleUtils.isDataContextName(elementName) && this.styleRoot.hasAttribute("chartTransparency")) {
                    rc.setAttribute("transparency", this.styleRoot.getAttribute("chartTransparency"));
                }
                rc.addChangeListener(this.changeListener);
                rc.setReadOnly(this.readOnly);
                this.elementCache.put(elementName, rc);
                break;
            }
        }
        if (rc == null) {
            if (this.printMessages && !StyleUtils.isPredefinedContextName(elementName)) {
                System.out.println(MessageFormat.format(Style.getString("ElementNotFoundMessage.txt"), elementName, this.getName()));
            }
            return rc;
        }
        if (type == DATA) {
            rc = rc.getAsDataStyle();
        } else if (type == RAMP) {
            rc = rc.getAsRampStyle();
        } else if (type == FILL) {
            rc = rc.getAsFillStyle();
        } else if (type == SHADOW) {
            rc = rc.getAsShadowStyle();
        } else if (type == LINE) {
            rc = rc.getAsLineStyle();
        } else if (type == TEXT) {
            rc = rc.getAsTextStyle();
        } else if (type == MARKER) {
            rc = rc.getAsMarkerStyle();
        }
        if (rc != null) {
            rc.addChangeListener(this.changeListener);
        }
        return rc;
    }

    public DataStyleElement getDataStyleElement(String elementName) {
        DataStyleElement se = (DataStyleElement)this.getStyleElement(elementName, DATA);
        if (se != null) {
            return se;
        }
        if (!this.fallbackEnabled) {
            return null;
        }
        se = (DataStyleElement)this.getStyleElement("GraphDataStyleDefault", DATA);
        if (se != null) {
            return se;
        }
        se = new DataStyleElement(null);
        se.addChangeListener(this.changeListener);
        return se;
    }

    public RampStyleElement getRampStyleElement(String elementName) {
        RampStyleElement rc = (RampStyleElement)this.getStyleElement(elementName, RAMP);
        if (rc != null) {
            return rc;
        }
        if (!this.fallbackEnabled) {
            return null;
        }
        rc = (RampStyleElement)this.getStyleElement("ThreeColorRamp", RAMP);
        if (rc != null) {
            return rc;
        }
        rc = new RampStyleElement(null);
        rc.addChangeListener(this.changeListener);
        return rc;
    }

    public FillStyleElement getFillStyleElement(String elementName) {
        FillStyleElement rc = (FillStyleElement)this.getStyleElement(elementName, FILL);
        if (rc != null) {
            return rc;
        }
        if (!this.fallbackEnabled) {
            return null;
        }
        rc = (FillStyleElement)this.getStyleElement("Backfill", FILL);
        if (rc != null) {
            return rc;
        }
        rc = new FillStyleElement(null);
        rc.addChangeListener(this.changeListener);
        return rc;
    }

    public ShadowStyleElement getShadowStyleElement(String elementName) {
        ShadowStyleElement rc = (ShadowStyleElement)this.getStyleElement(elementName, SHADOW);
        if (rc != null) {
            return rc;
        }
        if (!this.fallbackEnabled) {
            return null;
        }
        rc = (ShadowStyleElement)this.getStyleElement("DropShadow", SHADOW);
        if (rc != null) {
            return rc;
        }
        rc = new ShadowStyleElement(null);
        rc.addChangeListener(this.changeListener);
        return rc;
    }

    public LineStyleElement getLineStyleElement(String elementName) {
        LineStyleElement rc = (LineStyleElement)this.getStyleElement(elementName, LINE);
        if (rc != null) {
            return rc;
        }
        if (!this.fallbackEnabled) {
            return null;
        }
        rc = (LineStyleElement)this.getStyleElement("Outlines", LINE);
        if (rc != null) {
            return rc;
        }
        rc = new LineStyleElement(null);
        rc.addChangeListener(this.changeListener);
        return rc;
    }

    public TextStyleElement getTextStyleElement(String elementName) {
        TextStyleElement rc = (TextStyleElement)this.getStyleElement(elementName, TEXT);
        if (rc != null) {
            return rc;
        }
        if (!this.fallbackEnabled) {
            return null;
        }
        rc = (TextStyleElement)this.getStyleElement("ValueText", TEXT);
        if (rc != null) {
            return rc;
        }
        rc = new TextStyleElement(null);
        rc.addChangeListener(this.changeListener);
        return rc;
    }

    public MarkerStyleElement getMarkerStyleElement(String elementName) {
        MarkerStyleElement rc = (MarkerStyleElement)this.getStyleElement(elementName, MARKER);
        if (rc != null) {
            return rc;
        }
        if (!this.fallbackEnabled) {
            return null;
        }
        rc = (MarkerStyleElement)this.getStyleElement("GraphDataStyleDefault", MARKER);
        if (rc != null) {
            return rc;
        }
        rc = new MarkerStyleElement(null);
        rc.addChangeListener(this.changeListener);
        return rc;
    }

    private static Element getChildWithTagName(String name, Element parent) {
        NodeList children = parent.getChildNodes();
        int num = children.getLength();
        for (int i = 0; i < num; ++i) {
            Element e;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(e = (Element)child).getTagName().equalsIgnoreCase(name)) continue;
            return e;
        }
        return null;
    }

    public static Style getStyle(InputStream input) {
        return Style.getStyle(input, null);
    }

    public static Style getStyle(InputStream input, String styleName) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new InputSource(input));
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (document == null) {
            return null;
        }
        Element rc = document.getDocumentElement();
        return Style.getStyle(rc, styleName);
    }

    public static Style getReadOnlyStyle(InputStream input) {
        Style rc = Style.getStyle(input);
        rc.readOnly = true;
        return rc;
    }

    public static Style getReadOnlyStyle(InputStream input, String styleName) {
        Style rc = Style.getStyle(input, styleName);
        rc.readOnly = true;
        return rc;
    }

    private Element getStyleElementByName(String name) {
        if (name == null) {
            return Style.getChildWithTagName("style:Style", this.schemeRoot);
        }
        NodeList children = this.schemeRoot.getChildNodes();
        int num = children.getLength();
        for (int i = 0; i < num; ++i) {
            Element e;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(e = (Element)child).getTagName().equalsIgnoreCase("style:Style") || !e.hasAttribute("name") || !name.equalsIgnoreCase(e.getAttribute("name"))) continue;
            return e;
        }
        return null;
    }

    public Element getStyleRootElement() {
        return this.styleRoot;
    }

    public static Style getStyle(Element element) {
        return Style.getStyle(element, null, false);
    }

    public static Style getStyle(Element element, boolean expandDataElements) {
        return Style.getStyle(element, null, expandDataElements);
    }

    public static Style getStyle(Element element, String styleName) {
        return Style.getStyle(element, styleName, false);
    }

    public static Style getStyle(Element element, String styleName, boolean expandDataElements) {
        if (element == null) {
            return null;
        }
        if (!element.getTagName().equals("style:Scheme")) {
            return null;
        }
        Style rc = new Style();
        rc.schemeRoot = element;
        rc.styleRoot = rc.getStyleElementByName(styleName);
        if (expandDataElements) {
            Style.expandGraphDataElements(rc);
        } else if (rc.styleRoot != null) {
            rc.setAttrPriority(rc.styleRoot.getAttribute("styleAttrPriority"));
        }
        NodeList list = rc.schemeRoot.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element e;
            Node child = list.item(i);
            if (child.getNodeType() != 1 || !(e = (Element)child).getTagName().equalsIgnoreCase("LogicalFonts")) continue;
            TextStyleElement.parseLogicalFontTable(e);
        }
        return rc;
    }

    public Object[] getDataAttributes(String attrName) {
        String c;
        StyleElement se = null;
        int current = 1;
        Vector<String> list = new Vector<String>();
        while ((se = this.getStyleElement("GraphDataStyle" + current)) != null && se.getAttribute("context").equalsIgnoreCase("GraphDataStyle" + current) && (c = se.getAttribute(attrName)) != null) {
            list.addElement(c);
            ++current;
        }
        return list.toArray();
    }

    private static void expandGraphDataElements(Style style) {
        Object[] cc;
        Element root = style.styleRoot;
        if (root == null) {
            return;
        }
        String str = root.getAttribute("styleAttrPriority");
        if (!str.equalsIgnoreCase("COLOR")) {
            return;
        }
        Object[] fc = style.getDataAttributes("fillColor");
        int num_colors = Math.min(fc.length, (cc = style.getDataAttributes("altColor")).length);
        if (num_colors == 0) {
            num_colors = Math.max(fc.length, cc.length);
        }
        if (num_colors == 0) {
            return;
        }
        Object[] ms = style.getDataAttributes("markerSymbol");
        Object[] lp = style.getDataAttributes("lineStyle");
        Object[] fp = style.getDataAttributes("fillPattern");
        int num_shapes = Math.min(ms.length, lp.length);
        if (num_shapes == 0) {
            num_shapes = Math.max(ms.length, lp.length);
        }
        if (fp.length > 0) {
            num_shapes = num_shapes > 0 ? Math.min(num_shapes, fp.length) : fp.length;
        }
        if (num_shapes == 0) {
            return;
        }
        int num_items = num_colors * num_shapes;
        for (int i = 1; i <= num_items; ++i) {
            String ctx = "GraphDataStyle" + i;
            style.removeElement(ctx);
            style.addElement(ctx);
            StyleElement se = style.getStyleElement(ctx);
            if (fc.length > 0) {
                String clr = (String)fc[(i - 1) % num_colors];
                se.setAttribute("color", clr);
                se.setAttribute("fillColor", clr);
                se.setAttribute("altTextColor", clr);
            }
            if (cc.length > 0) {
                String c_clr = (String)cc[(i - 1) % num_colors];
                se.setAttribute("altColor", c_clr);
                se.setAttribute("lineColor", c_clr);
                se.setAttribute("markerColor", c_clr);
                se.setAttribute("textColor", c_clr);
            }
            if (ms.length > 0) {
                String symbol = (String)ms[(i - 1) / num_colors];
                se.setAttribute("markerSymbol", symbol);
            }
            if (lp.length > 0) {
                String pattern = (String)lp[(i - 1) / num_colors];
                se.setAttribute("lineStyle", pattern);
            }
            if (fp.length <= 0) continue;
            String fpattern = (String)fp[(i - 1) / num_colors];
            se.setAttribute("fillPattern", fpattern);
        }
    }

    public void toOutputStream(OutputStream out) throws IOException {
        String s = Style.toString(this.schemeRoot);
        out.write(s.getBytes());
    }

    public Element toElement() {
        if (this.schemeRoot == null) {
            return null;
        }
        return (Element)this.schemeRoot.cloneNode(true);
    }

    public String getName() {
        return this.getSchemeName();
    }

    public String getSchemeName() {
        if (this.schemeRoot == null || !this.schemeRoot.hasAttribute("name")) {
            return null;
        }
        return this.schemeRoot.getAttribute("name");
    }

    public void setSchemeName(String name) {
        if (this.schemeRoot == null || name == null) {
            return;
        }
        this.schemeRoot.setAttribute("name", name);
    }

    public String getStyleName() {
        if (this.styleRoot == null || !this.styleRoot.hasAttribute("name")) {
            return null;
        }
        return this.styleRoot.getAttribute("name");
    }

    public void setStyleName(String name) {
        if (this.styleRoot == null || name == null) {
            return;
        }
        this.styleRoot.setAttribute("name", name);
    }

    public String getParent() {
        if (this.schemeRoot == null || !this.schemeRoot.hasAttribute("parent")) {
            return null;
        }
        return this.schemeRoot.getAttribute("parent");
    }

    public void setParent(String parentName) {
        if (this.schemeRoot == null) {
            return;
        }
        this.schemeRoot.setAttribute("parent", parentName);
    }

    public String getDisplayName() {
        return PredefinedStyles.getDisplayName(this.getSchemeName());
    }

    public Color[] getDataFillColors() {
        Color c;
        DataStyleElement element = null;
        int current = 1;
        Vector<Color> list = new Vector<Color>();
        while ((element = (DataStyleElement)this.getStyleElement("GraphDataStyle" + current, DATA)) != null && (c = element.getColorAttribute("color", null)) != null) {
            list.addElement(element.getFillColor());
            ++current;
        }
        Object[] rc = new Color[list.size()];
        list.copyInto(rc);
        if ((rc == null || rc.length == 0) && this.fallbackEnabled) {
            DataStyleElement dse = this.getDataStyleElement("GraphDataStyleDefault");
            if (dse == null) {
                dse = new DataStyleElement(null);
            }
            rc = new Color[]{dse.getFillColor()};
        }
        return rc;
    }

    public Color[] getDataLineColors() {
        Color c;
        DataStyleElement element = null;
        int current = 1;
        Vector<Color> list = new Vector<Color>();
        while ((element = (DataStyleElement)this.getStyleElement("GraphDataStyle" + current, DATA)) != null && (c = element.getColorAttribute("altColor", null)) != null) {
            list.addElement(element.getContrastColor());
            ++current;
        }
        Object[] rc = new Color[list.size()];
        list.copyInto(rc);
        if ((rc == null || rc.length == 0) && this.fallbackEnabled) {
            DataStyleElement dse = this.getDataStyleElement("GraphDataStyleDefault");
            if (dse == null) {
                dse = new DataStyleElement(null);
            }
            rc = new Color[]{dse.getContrastColor()};
        }
        return rc;
    }

    public int[] getDataMarkerSymbols() {
        String s;
        DataStyleElement element = null;
        int current = 1;
        Vector<Integer> list = new Vector<Integer>();
        while ((element = (DataStyleElement)this.getStyleElement("GraphDataStyle" + current, DATA)) != null && (s = element.getAttribute("markerSymbol", null)) != null) {
            list.addElement(new Integer(element.getMarkerSymbol()));
            ++current;
        }
        int[] rc = new int[list.size()];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = (Integer)list.elementAt(i);
        }
        if ((rc == null || rc.length == 0) && this.fallbackEnabled) {
            DataStyleElement dse = this.getDataStyleElement("GraphDataStyleDefault");
            if (dse == null) {
                dse = new DataStyleElement(null);
            }
            rc = new int[]{dse.getMarkerSymbol()};
        }
        return rc;
    }

    public int[] getDataLinePatterns() {
        int style;
        DataStyleElement element = null;
        int current = 1;
        Vector<Integer> list = new Vector<Integer>();
        while ((element = (DataStyleElement)this.getStyleElement("GraphDataStyle" + current, DATA)) != null && (style = element.getIntegerAttribute("lineStyle", -1)) >= 0) {
            list.addElement(new Integer(element.getLineStyle()));
            ++current;
        }
        int[] rc = new int[list.size()];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = (Integer)list.elementAt(i);
        }
        if ((rc == null || rc.length == 0) && this.fallbackEnabled) {
            DataStyleElement dse = this.getDataStyleElement("GraphDataStyleDefault");
            if (dse == null) {
                dse = new DataStyleElement(null);
            }
            rc = new int[]{dse.getLineStyle()};
        }
        return rc;
    }

    public DataStyleElement getDataStyleElement(int n) {
        int numDataStylesDefined;
        if (this.elementCache.containsKey(new Integer(n))) {
            return (DataStyleElement)this.elementCache.get(new Integer(n));
        }
        Color[] colorList = this.getDataFillColors();
        int numOfColors = colorList.length;
        DataStyleElement dse = null;
        if (n < numOfColors && (dse = (DataStyleElement)this.getStyleElement("GraphDataStyle" + (n + 1), DATA)) != null) {
            this.elementCache.put(new Integer(n), dse);
            return dse;
        }
        for (numDataStylesDefined = 1; (dse = (DataStyleElement)this.getStyleElement("GraphDataStyle" + numDataStylesDefined, DATA)) != null && numDataStylesDefined <= numOfColors; ++numDataStylesDefined) {
        }
        if (--numDataStylesDefined == 0) {
            return this.getDataStyleElement("GraphDataStyleDefault");
        }
        int block = n / numDataStylesDefined;
        int reference = n % numDataStylesDefined;
        boolean numSteps = block % 3 != 0;
        boolean direction = block % 3 == 1;
        DataStyleElement startElement = this.getDataStyleElement(reference);
        startElement = new DataStyleElement((Element)startElement.getElement().cloneNode(false));
        Color fillColor = startElement.getFillColor();
        Color altColor = startElement.getContrastColor();
        if (!direction) {
            fillColor = StyleUtils.darker(fillColor, 0.25 * (double)numSteps);
            altColor = StyleUtils.darker(altColor, 0.25 * (double)numSteps);
        } else {
            fillColor = StyleUtils.brighter(fillColor, 0.25 * (double)numSteps);
            altColor = StyleUtils.brighter(altColor, 0.25 * (double)numSteps);
        }
        startElement.setFillColor(fillColor);
        startElement.setContrastColor(altColor);
        startElement.addChangeListener(this.changeListener);
        this.elementCache.put(new Integer(n), startElement);
        return startElement;
    }

    public StyleElement[] getAllStyleElements() {
        if (this.schemeRoot == null || this.styleRoot == null) {
            return null;
        }
        NodeList children = this.styleRoot.getChildNodes();
        Vector<StyleElement> collection = new Vector<StyleElement>();
        int num = children.getLength();
        for (int i = 0; i < num; ++i) {
            Element e;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(e = (Element)child).hasAttribute("context")) continue;
            StyleElement s = new StyleElement(e);
            if ("LegendFill".equalsIgnoreCase(s.getContextName()) && this.styleRoot.hasAttribute("legendTransparency")) {
                s.setAttribute("transparency", this.styleRoot.getAttribute("legendTransparency"));
            } else if ("WallFill".equalsIgnoreCase(s.getContextName()) && this.styleRoot.hasAttribute("wallTransparency")) {
                s.setAttribute("transparency", this.styleRoot.getAttribute("wallTransparency"));
            } else if (StyleUtils.isDataContextName(s.getContextName()) && this.styleRoot.hasAttribute("chartTransparency")) {
                s.setAttribute("transparency", this.styleRoot.getAttribute("chartTransparency"));
            }
            s.setReadOnly(this.readOnly);
            if (s.hasAttribute("_modified")) {
                s.removeAttribute("_modified");
                s.setAttribute("_modified", "false");
            }
            s.addChangeListener(this.changeListener);
            collection.addElement(s);
        }
        Object[] rc = new StyleElement[collection.size()];
        collection.copyInto(rc);
        return rc;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean addElement(String contextName) {
        if (this.schemeRoot == null) {
            return false;
        }
        Document d = this.schemeRoot.getOwnerDocument();
        if (d == null) {
            return false;
        }
        Element e = d.createElement("style:Style");
        e.setAttribute("context", contextName);
        if (this.styleRoot == null) {
            this.styleRoot = d.createElement("style:Style");
            this.schemeRoot.appendChild(this.styleRoot);
        }
        this.styleRoot.appendChild(e);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "ELEMENT_ADDED", contextName, null));
        return true;
    }

    public boolean removeElement(String contextName) {
        StyleElement se = this.getStyleElement(contextName);
        if (se == null) {
            return false;
        }
        if (this.styleRoot == null) {
            return false;
        }
        this.styleRoot.removeChild(se.getElement());
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "ELEMENT_REMOVED", contextName, null));
        return true;
    }

    public boolean isFallbackEnabled() {
        return this.fallbackEnabled;
    }

    public void setFallbackEnabled(boolean fallbackEnabled) {
        this.fallbackEnabled = fallbackEnabled;
    }

    public void addStyleChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeListeners == null) {
            this.changeListeners = new Vector();
        }
        this.changeListeners.addElement(listener);
    }

    public void removeStyleChangeListener(PropertyChangeListener listener) {
        if (this.changeListeners == null || listener == null) {
            return;
        }
        if (this.changeListeners.contains(listener)) {
            this.changeListeners.remove(listener);
        }
    }

    private void firePropertyChangeEvent(PropertyChangeEvent evt) {
        if (this.changeListeners == null || this.changeListeners.isEmpty()) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, evt.getPropertyName(), null, evt);
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            ((PropertyChangeListener)this.changeListeners.elementAt(i)).propertyChange(event);
        }
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public boolean isPrintMessages() {
        return this.printMessages;
    }

    public void setPrintMessages(boolean printMessages) {
        this.printMessages = printMessages;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean copyInto(Style s) {
        if (s == null || s.isReadOnly()) {
            return false;
        }
        StyleElement[] all = this.getAllStyleElements();
        for (int i = 0; i < all.length; ++i) {
            StyleElement se = s.getStyleElement(all[i].getContextName());
            NamedNodeMap map = all[i].getAttributes();
            for (int j = 0; j < map.getLength(); ++j) {
                Node node = map.item(j);
                se.setAttribute(node.getNodeName(), node.getNodeValue());
            }
        }
        return true;
    }

    public static String toString(Node node) {
        return Style.toString(node, false);
    }

    public static String toString(Node node, boolean xmlDeclaration) {
        Transformer transformer;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            Properties p = new Properties();
            p.setProperty("indent", "yes");
            if (!xmlDeclaration) {
                p.setProperty("omit-xml-declaration", "yes");
            }
            transformer.setOutputProperties(p);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
            return null;
        }
        DOMSource src = new DOMSource(node);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        try {
            transformer.transform(src, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return null;
        }
        return sw.toString();
    }

    public boolean updateModifiedAttr(boolean flag) {
        if (this.schemeRoot == null || this.styleRoot == null) {
            return false;
        }
        NodeList children = this.styleRoot.getChildNodes();
        int num = children.getLength();
        for (int i = 0; i < num; ++i) {
            String str;
            Element e;
            StyleElement s;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(s = new StyleElement(e = (Element)child)).hasAttribute("_modified") || !(str = s.getAttribute("_modified")).equalsIgnoreCase("false")) continue;
            s.removeAttribute("_modified");
            if (!flag) continue;
            s.setAttribute("_modified", "true");
        }
        return true;
    }

    public String[] getDataFillPatterns() {
        String str;
        DataStyleElement element = null;
        int current = 1;
        Vector<String> list = new Vector<String>();
        while ((element = (DataStyleElement)this.getStyleElement("GraphDataStyle" + current, DATA)) != null && (str = element.getAttribute("fillPattern")) != null && str.length() >= 1) {
            list.addElement(element.getFillPattern());
            ++current;
        }
        String[] rc = new String[list.size()];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = list.elementAt(i).toString();
        }
        if ((rc == null || rc.length == 0) && this.fallbackEnabled) {
            DataStyleElement dse = this.getDataStyleElement("GraphDataStyleDefault");
            if (dse == null) {
                dse = new DataStyleElement(null);
            }
            rc = new String[]{dse.getFillPattern()};
        }
        return rc;
    }

    public Color[] getKPIRangeNormalColors() {
        Color c;
        DataStyleElement element = null;
        int current = 1;
        Vector<Color> list = new Vector<Color>();
        while ((element = (DataStyleElement)this.getStyleElement("KPIRange" + current, DATA)) != null && (c = element.getColorAttribute("color", null)) != null) {
            list.addElement(c);
            ++current;
        }
        if (list.size() == 0) {
            return null;
        }
        Object[] rc = new Color[list.size()];
        list.copyInto(rc);
        return rc;
    }

    public Color[] getKPIRangeActiveColors() {
        int colorsLength;
        DataStyleElement element = null;
        int current = 1;
        Vector<Color> list = new Vector<Color>();
        Color[] KPINormalColors = this.getKPIRangeNormalColors();
        int n = colorsLength = KPINormalColors != null ? KPINormalColors.length : 0;
        while ((element = (DataStyleElement)this.getStyleElement("KPIRange" + current, DATA)) != null) {
            Color c = null;
            if (element != null) {
                c = element.getColorAttribute("altColor", null);
            }
            if (c == null && current <= colorsLength) {
                c = KPINormalColors[current - 1];
            }
            if (c == null) break;
            list.addElement(c);
            ++current;
        }
        if (list.size() == 0) {
            return null;
        }
        Object[] rc = new Color[list.size()];
        list.copyInto(rc);
        return rc;
    }

    public String getAttrPriority() {
        return this.attrPriority;
    }

    public void setAttrPriority(String attrPriority) {
        this.attrPriority = attrPriority;
    }

    static boolean isNumber(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static int getGraphDataN(String contextName) {
        if (contextName == null) {
            return -1;
        }
        String str = contextName.replaceAll("GraphDataStyle", "");
        if (contextName.startsWith("GraphDataStyle") && Style.isNumber(str)) {
            return Integer.parseInt(str);
        }
        return -1;
    }

    private DataStyleElement getIndexedGraphDataElement(DataStyleElement ds, String attrType, int idx) {
        if (attrType.equalsIgnoreCase("line")) {
            ds = new DataStyleElement((Element)ds.getElement().cloneNode(false));
            Object[] attrList = this.getDataAttributes("lineColor");
            if (attrList.length > 0) {
                ds.setAttribute("lineColor", (String)attrList[(idx - 1) % attrList.length]);
            }
            if ((attrList = this.getDataAttributes("lineStyle")).length > 0) {
                ds.setAttribute("lineStyle", (String)attrList[(idx - 1) % attrList.length]);
            }
        } else if (attrType.equalsIgnoreCase("marker")) {
            ds = new DataStyleElement((Element)ds.getElement().cloneNode(false));
            Object[] attrList = this.getDataAttributes("markerColor");
            if (attrList.length > 0) {
                ds.setAttribute("markerColor", (String)attrList[(idx - 1) % attrList.length]);
            }
            if ((attrList = this.getDataAttributes("markerSymbol")).length > 0) {
                ds.setAttribute("markerSymbol", (String)attrList[(idx - 1) % attrList.length]);
            }
        } else if (attrType.equalsIgnoreCase("fill")) {
            ds = new DataStyleElement((Element)ds.getElement().cloneNode(false));
            Color clr = this.getDataStyleElement(idx - 1).getFillColor();
            ds.setAttribute("fillColor", HTMLColors.getColorString(clr));
        } else {
            ds = new DataStyleElement((Element)ds.getElement().cloneNode(false));
            Object[] attrList = this.getDataAttributes("altColor");
            if (attrList.length > 0) {
                ds.setAttribute("altColor", (String)attrList[(idx - 1) % attrList.length]);
            }
            if ((attrList = this.getDataAttributes("fillPattern")).length > 0) {
                ds.setAttribute("fillPattern", (String)attrList[(idx - 1) % attrList.length]);
            }
        }
        return ds;
    }

    private int getColorCount() {
        Object[] contrastColorList;
        Object[] colorList = this.getDataAttributes("color");
        int num_colors = Math.min(colorList.length, (contrastColorList = this.getDataAttributes("altColor")).length);
        if (num_colors == 0) {
            num_colors = Math.max(colorList.length, contrastColorList.length);
        }
        return num_colors;
    }

    public DataStyleElement getRemappedGraphDataElement(DataStyleElement ds, String attrType, String defaultStyleElem) {
        int idx = Style.getGraphDataN(defaultStyleElem);
        if (idx <= 0) {
            return ds;
        }
        if (!this.isColorPriority()) {
            return this.getIndexedGraphDataElement(ds, attrType, idx);
        }
        int nc = this.getColorCount();
        if (nc == 0) {
            return this.getIndexedGraphDataElement(ds, attrType, idx);
        }
        ds = new DataStyleElement((Element)ds.getElement().cloneNode(false));
        int mappedIDX = (idx - 1) / nc;
        if (attrType.equalsIgnoreCase("line")) {
            Object[] attrList = this.getDataAttributes("lineColor");
            if (attrList.length > 0) {
                ds.setAttribute("lineColor", (String)attrList[(idx - 1) % attrList.length]);
            }
            if ((attrList = this.getDataAttributes("lineStyle")).length > 0) {
                ds.setAttribute("lineStyle", (String)attrList[mappedIDX % attrList.length]);
            }
        } else if (attrType.equalsIgnoreCase("marker")) {
            Object[] attrList = this.getDataAttributes("markerColor");
            if (attrList.length > 0) {
                ds.setAttribute("markerColor", (String)attrList[(idx - 1) % attrList.length]);
            }
            if ((attrList = this.getDataAttributes("markerSymbol")).length > 0) {
                ds.setAttribute("markerSymbol", (String)attrList[mappedIDX % attrList.length]);
            }
        } else if (attrType.equalsIgnoreCase("fill")) {
            Color clr = this.getDataStyleElement(idx - 1).getFillColor();
            ds.setAttribute("fillColor", HTMLColors.getColorString(clr));
        } else {
            Object[] attrList = this.getDataAttributes("altColor");
            if (attrList.length > 0) {
                ds.setAttribute("altColor", (String)attrList[(idx - 1) % attrList.length]);
            }
            if ((attrList = this.getDataAttributes("fillPattern")).length > 0) {
                ds.setAttribute("fillPattern", (String)attrList[mappedIDX % attrList.length]);
            }
        }
        return ds;
    }

    private boolean isColorPriority() {
        return this.attrPriority != null && this.attrPriority.equalsIgnoreCase("COLOR");
    }

    public String remapDataElement(String contextName, String attrType) {
        Object[] attrList;
        if (!this.isColorPriority()) {
            return contextName;
        }
        int idx = Style.getGraphDataN(contextName);
        if (idx <= 0) {
            return contextName;
        }
        int nc = this.getColorCount();
        if (nc == 0) {
            return contextName;
        }
        int mappedIDX = (idx - 1) / nc;
        if (attrType.equals("color") || attrType.equals("fillColor")) {
            Object[] attrList2 = this.getDataAttributes("color");
            if (attrList2.length > 0) {
                contextName = "GraphDataStyle" + ((idx - 1) % attrList2.length + 1);
            }
        } else if (attrType.equals("altColor") || attrType.equals("textColor") || attrType.equals("lineColor") || attrType.equals("markerColor")) {
            Object[] attrList3 = this.getDataAttributes("altColor");
            if (attrList3.length > 0) {
                contextName = "GraphDataStyle" + ((idx - 1) % attrList3.length + 1);
            }
        } else if (attrType.equals("lineStyle")) {
            Object[] attrList4 = this.getDataAttributes("lineStyle");
            if (attrList4.length > 0) {
                contextName = "GraphDataStyle" + (mappedIDX % attrList4.length + 1);
            }
        } else if (attrType.equals("markerSymbol")) {
            Object[] attrList5 = this.getDataAttributes("markerSymbol");
            if (attrList5.length > 0) {
                contextName = "GraphDataStyle" + (mappedIDX % attrList5.length + 1);
            }
        } else if (attrType.equals("fillPattern") && (attrList = this.getDataAttributes("fillPattern")).length > 0) {
            contextName = "GraphDataStyle" + (mappedIDX % attrList.length + 1);
        }
        return contextName;
    }

    public Color[] getDataNodeFillColors() {
        Color c;
        DataStyleElement element = null;
        int current = 1;
        Vector<Color> list = new Vector<Color>();
        while ((element = (DataStyleElement)this.getStyleElement("GraphDataNode" + current, DATA)) != null && (c = element.getColorAttribute("color", null)) != null) {
            list.addElement(element.getFillColor());
            ++current;
        }
        Object[] rc = new Color[list.size()];
        list.copyInto(rc);
        if ((rc == null || rc.length == 0) && this.fallbackEnabled) {
            DataStyleElement dse = this.getDataStyleElement("GraphDataStyleDefault");
            if (dse == null) {
                dse = new DataStyleElement(null);
            }
            rc = new Color[]{dse.getFillColor()};
        }
        return rc;
    }

    class StyleElementChangeListener
    implements PropertyChangeListener {
        StyleElementChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Style.this.firePropertyChangeEvent(evt);
        }
    }
}

