/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles;

import com.sas.graphics.styles.AttributeNames;
import com.sas.graphics.styles.Size;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.HTMLColors;
import java.awt.Color;
import org.w3c.dom.Element;

public class LineStyleElement
extends StyleElement
implements AttributeNames {
    public static final Color defaultLineColor = Color.BLACK;
    public static final int defaultLineStyle = 1;
    public static final Size defaultLineThickness = new Size(1, 1);
    public static final double defaultTransparency = 1.0;

    public LineStyleElement(Element styleElement) {
        super(styleElement);
    }

    public Color getLineColor() {
        return this.getColorAttribute("lineColor", this.getColorAttribute("altColor", defaultLineColor));
    }

    public boolean setLineColor(Color c) {
        String s = HTMLColors.getColorString(c);
        if (s == null) {
            return false;
        }
        return this.setAttribute("lineColor", s);
    }

    public int getLineStyle() {
        return this.getIntegerAttribute("lineStyle", 1);
    }

    public boolean setLineStyle(int style) {
        return this.setAttribute("lineStyle", "" + style);
    }

    public Size getLineThickness() {
        return this.getSizeAttribute("lineThickness", defaultLineThickness);
    }

    public boolean setLineThickness(Size thickness) {
        if (thickness == null) {
            return false;
        }
        return this.setAttribute("lineThickness", thickness.toString());
    }

    public double getTransparency() {
        return this.getDoubleAttribute("transparency", 1.0);
    }

    public boolean setTransparency(double trans) {
        if (Double.isNaN(trans)) {
            return false;
        }
        return this.setAttribute("transparency", "" + trans);
    }

    @Override
    public Color getDefaultColor() {
        return this.getLineColor();
    }
}

