/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles;

import com.sas.graphics.styles.AttributeNames;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.styles.StyleUtils;
import com.sas.graphics.util.HTMLColors;
import java.awt.Color;
import org.w3c.dom.Element;

public class FillStyleElement
extends StyleElement
implements AttributeNames {
    public static final int FILL_TYPE_PATTERN = 0;
    public static final int FILL_TYPE_GRADIENT = 1;
    public static final int FILL_TYPE_IMAGE = 2;
    public static final int FILL_TYPE_IMAGE_COLOR_BLEND = 3;
    public static final int FILL_TYPE_IMAGE_GRADIENT_BLEND = 4;
    public static final int GRADIENT_DIRECTION_X_AXIS = 0;
    public static final int GRADIENT_DIRECTION_Y_AXIS = 1;
    public static final int IMAGE_FIT_SCALE = 0;
    public static final int IMAGE_FIT_TILE = 1;
    public static final int IMAGE_FIT_CENTER = 2;
    public static final int IMAGE_FIT_POSITION = 3;
    public static final int IMAGE_FIT_TOP = 4;
    public static final int IMAGE_FIT_BOTTOM = 5;
    public static final int IMAGE_FIT_LEFT = 6;
    public static final int IMAGE_FIT_RIGHT = 7;
    public static final int IMAGE_FIT_TOP_LEFT = 8;
    public static final int IMAGE_FIT_TOP_RIGHT = 9;
    public static final int IMAGE_FIT_BOTTOM_LEFT = 10;
    public static final int IMAGE_FIT_BOTTOM_RIGHT = 11;
    public static final int FILL_GRADIENT_TRANSPARENCY_NONE = -1;
    public static final int FILL_GRADIENT_TRANSPARENCY_ENABLED = 0;
    public static final int FILL_GRADIENT_TRANSPARENCY_START_COLOR_ONLY = 1;
    public static final int FILL_GRADIENT_TRANSPARENCY_END_COLOR_ONLY = 2;
    public static final String[] imageFitStyleStrings = new String[]{"Scale", "Tile", "Center", "Position", "Top", "Bottom", "Left", "Right", "TopLeft", "TopRight", "BottomLeft", "BottomRight"};
    private static final String[] gradientDirectionStrings = new String[]{"Xaxis", "Yaxis"};
    private static final String[] fillTypeStrings = new String[]{"Pattern", "Gradient", "Image", "ImageColorBlend", "ImageGradientBlend"};
    private static final String[] FillGradientTransparencyStrings = new String[]{"Enabled", "StartColorOnly", "EndColorOnly"};
    public static final int defaultFilType = 0;
    public static final Color defaultFillColor = Color.white;

    public FillStyleElement(Element styleElement) {
        super(styleElement);
    }

    public int getFillType() {
        if (!this.hasAttribute("fillType")) {
            return 0;
        }
        return FillStyleElement.fillTypeForString(this.getAttribute("fillType"));
    }

    public boolean setFillType(int fillType) {
        String s = FillStyleElement.fillTypeAsString(fillType);
        if (s == null) {
            return false;
        }
        return this.setAttribute("fillType", s);
    }

    public Color getFillColor() {
        return this.getColorAttribute("fillColor", this.getColorAttribute("color", defaultFillColor));
    }

    public boolean setFillColor(Color fillColor) {
        String s = HTMLColors.getColorString(fillColor);
        if (s == null) {
            return false;
        }
        return this.setAttribute("fillColor", s);
    }

    public double getFillTransparency() {
        return this.getDoubleAttribute("transparency", 0.0);
    }

    public boolean setFillTransparency(double trans) {
        return this.setAttribute("transparency", trans + "");
    }

    public Color getFillGradientEndColor() {
        if (!this.hasAttribute("fillGradientEndColor")) {
            return null;
        }
        Color c = HTMLColors.getInstance().getColor(this.getAttribute("fillGradientEndColor"));
        int trans = this.getFillGradientTransparency();
        switch (trans) {
            case 0: 
            case 2: {
                c = StyleUtils.applyTransparencyToColor(c, 1.0);
            }
        }
        return c;
    }

    public Color getFillGradientStartColor() {
        Color c = this.getFillColor();
        int trans = this.getFillGradientTransparency();
        switch (trans) {
            case 0: 
            case 1: {
                c = StyleUtils.applyTransparencyToColor(c, 1.0);
            }
        }
        return c;
    }

    public boolean setFillGradientEndColor(Color endColor) {
        String s = HTMLColors.getColorString(endColor);
        if (s == null) {
            return false;
        }
        return this.setAttribute("fillGradientEndColor", s);
    }

    public int getFillGradientType() {
        if (!this.hasAttribute("fillGradientType")) {
            return 0;
        }
        return FillStyleElement.graadientDirectionForString(this.getAttribute("fillGradientType"));
    }

    public boolean setFillGradientType(int type) {
        String s = FillStyleElement.gradientDirectionAsString(type);
        if (s == null) {
            return false;
        }
        return this.setAttribute("fillGradientType", s);
    }

    public String getFillFile() {
        if (!this.hasAttribute("fillFile")) {
            return null;
        }
        return this.getAttribute("fillFile");
    }

    public boolean setFillFile(String fillFile) {
        return this.setAttribute("fillFile", fillFile);
    }

    public int getFillImageFitStyle() {
        if (!this.hasAttribute("fillImageFitStyle")) {
            return 1;
        }
        return FillStyleElement.imageFitStyleForString(this.getAttribute("fillImageFitStyle"));
    }

    public boolean setFillImageFitStyle(int style) {
        String s = FillStyleElement.imageFitStyleAsString(style);
        if (s == null) {
            return false;
        }
        return this.setAttribute("fillImageFitStyle", s);
    }

    public static String gradientDirectionAsString(int gradientDirection) {
        if (gradientDirection < 0 || gradientDirection >= gradientDirectionStrings.length) {
            return null;
        }
        return gradientDirectionStrings[gradientDirection];
    }

    public static int graadientDirectionForString(String gradientDirection) {
        if (gradientDirection == null) {
            return 0;
        }
        for (int i = 0; i < gradientDirectionStrings.length; ++i) {
            if (!gradientDirection.equalsIgnoreCase(gradientDirectionStrings[i])) continue;
            return i;
        }
        return 0;
    }

    public static String fillTypeAsString(int fillType) {
        if (fillType < 0 || fillType >= fillTypeStrings.length) {
            return null;
        }
        return fillTypeStrings[fillType];
    }

    public static int fillTypeForString(String fillType) {
        if (fillType == null) {
            return 0;
        }
        for (int i = 0; i < fillTypeStrings.length; ++i) {
            if (!fillType.equalsIgnoreCase(fillTypeStrings[i])) continue;
            return i;
        }
        return 0;
    }

    public static String imageFitStyleAsString(int fitStyle) {
        if (fitStyle < 0 || fitStyle >= imageFitStyleStrings.length) {
            return null;
        }
        return imageFitStyleStrings[fitStyle];
    }

    public static int imageFitStyleForString(String styleString) {
        if (styleString == null) {
            return 0;
        }
        for (int i = 0; i < imageFitStyleStrings.length; ++i) {
            if (!styleString.equalsIgnoreCase(imageFitStyleStrings[i])) continue;
            return i;
        }
        return 0;
    }

    @Override
    public Color getDefaultColor() {
        return this.getFillColor();
    }

    public static final int fillGradientTransparencyForString(String str) {
        if (str == null) {
            return -1;
        }
        for (int i = 0; i < FillGradientTransparencyStrings.length; ++i) {
            if (!str.equalsIgnoreCase(FillGradientTransparencyStrings[i])) continue;
            return i;
        }
        return -1;
    }

    public static final String fillGradientTransparencyAsString(int i) {
        if (i < 0 || i >= FillGradientTransparencyStrings.length) {
            return null;
        }
        return FillGradientTransparencyStrings[i];
    }

    public int getFillGradientTransparency() {
        if (!this.hasAttribute("fillGradientTransparency")) {
            return -1;
        }
        return FillStyleElement.fillGradientTransparencyForString(this.getAttribute("fillGradientTransparency"));
    }

    public boolean setFillGradientTransparency(int i) {
        return this.setAttribute("fillGradientTransparency", FillStyleElement.fillGradientTransparencyAsString(i));
    }
}

