/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.image;

import com.sas.graphics.image.Filter;
import com.sas.graphics.image.GaussianFilter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;

public class GlowFilter
extends Filter {
    private boolean inner = true;
    private float blurX = 5.0f;
    private float blurY = 5.0f;
    private float strength = 1.0f;
    private int quality = 1;
    private Color color = Color.red;
    private float alpha = 0.6f;
    private boolean knockout = false;
    private int height;
    private int width;

    public void setInner(boolean b) {
        this.inner = b;
    }

    public boolean isInner() {
        return this.inner;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    public void setAlpha(float a) {
        this.alpha = a;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setBlurX(float blur) {
        this.blurX = blur;
    }

    public float getBlurX() {
        return this.blurX;
    }

    public void setBlurY(float blur) {
        this.blurY = blur;
    }

    public float getBlurY() {
        return this.blurY;
    }

    public void setStrength(float s) {
        this.strength = s;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setQuality(int q) {
        this.quality = q;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setKnockout(boolean b) {
        this.knockout = b;
    }

    public boolean isKnockout() {
        return this.knockout;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        this.width = src.getWidth();
        this.height = src.getHeight();
        if (dst == null) {
            dst = new BufferedImage(this.width, this.height, 2);
        }
        int glowColor = this.color.getRGB();
        float glowR = (float)(glowColor >> 16 & 0xFF) / 255.0f;
        float glowG = (float)(glowColor >> 8 & 0xFF) / 255.0f;
        float glowB = (float)(glowColor & 0xFF) / 255.0f;
        float[][] extractAlpha = new float[][]{{0.0f, 0.0f, 0.0f, glowR}, {0.0f, 0.0f, 0.0f, glowG}, {0.0f, 0.0f, 0.0f, glowB}, {0.0f, 0.0f, 0.0f, this.alpha}};
        BufferedImage glowSrc = this.inner ? this.createGlowSourceImage(src) : src;
        BufferedImage glow = new BufferedImage(this.width, this.height, 2);
        new BandCombineOp(extractAlpha, null).filter(glowSrc.getRaster(), glow.getRaster());
        if ((this.blurX > 0.0f || this.blurY > 0.0f) && this.quality > 0) {
            double bx = 0.0;
            double by = 0.0;
            for (int i = 0; i < this.quality; ++i) {
                bx += (double)(this.blurX * this.blurX);
                by += (double)(this.blurY * this.blurY);
            }
            this.blurX = (float)Math.sqrt(bx);
            this.blurY = (float)Math.sqrt(by);
            GaussianFilter filter = new GaussianFilter(this.blurX, this.blurY);
            filter.filter(glow, glow);
        }
        int[] srcPixels = new int[this.width * this.height];
        src.getRGB(0, 0, this.width, this.height, srcPixels, 0, this.width);
        int[] glowPixels = new int[this.width * this.height];
        glow.getRGB(0, 0, this.width, this.height, glowPixels, 0, this.width);
        if (this.strength > 1.0f) {
            this.applyStrength(glowPixels);
        }
        this.clipGlowImage(glowPixels, srcPixels);
        glow.setRGB(0, 0, this.width, this.height, glowPixels, 0, this.width);
        Graphics2D g = dst.createGraphics();
        if (!this.knockout) {
            g.drawRenderedImage(src, null);
        }
        g.setComposite(AlphaComposite.SrcOver);
        g.drawRenderedImage(glow, null);
        g.dispose();
        return dst;
    }

    private BufferedImage createGlowSourceImage(BufferedImage src) {
        BufferedImage dst = new BufferedImage(this.width, this.height, 2);
        int[] srcPixels = new int[this.width * this.height];
        int[] dstPixels = new int[this.width * this.height];
        src.getRGB(0, 0, this.width, this.height, srcPixels, 0, this.width);
        dst.getRGB(0, 0, this.width, this.height, dstPixels, 0, this.width);
        for (int j = 0; j < this.height; ++j) {
            int offset = this.width * j;
            for (int i = 0; i < this.width; ++i) {
                int rgb = srcPixels[offset + i];
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                a = 255 - a;
                dstPixels[offset + i] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        dst.setRGB(0, 0, this.width, this.height, dstPixels, 0, this.width);
        return dst;
    }

    private void clipGlowImage(int[] glowPixels, int[] srcPixels) {
        for (int i = 0; i < glowPixels.length; ++i) {
            int rgb = glowPixels[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            int rgb2 = srcPixels[i];
            int a2 = rgb2 >> 24 & 0xFF;
            a = this.inner ? (int)((double)(a * a2) / 255.0) : (int)((double)a * (255.0 - (double)a2) / 255.0);
            glowPixels[i] = a << 24 | r << 16 | g << 8 | b;
        }
    }

    private void clipGlowImage(BufferedImage glow, BufferedImage src) {
        int[] srcPixels = new int[this.width * this.height];
        int[] glowPixels = new int[this.width * this.height];
        glow.getRGB(0, 0, this.width, this.height, glowPixels, 0, this.width);
        src.getRGB(0, 0, this.width, this.height, srcPixels, 0, this.width);
        for (int j = 0; j < this.height; ++j) {
            int offset = this.width * j;
            for (int i = 0; i < this.width; ++i) {
                int rgb = glowPixels[offset + i];
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                int rgb2 = srcPixels[offset + i];
                int a2 = rgb2 >> 24 & 0xFF;
                a = this.inner ? (int)((double)(a * a2) / 255.0) : (int)((double)(a * (255 - a2)) / 255.0);
                glowPixels[offset + i] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        glow.setRGB(0, 0, this.width, this.height, glowPixels, 0, this.width);
    }

    private void applyStrength(int[] glowPixels) {
        int alphaCap = (int)((double)this.alpha * 255.0);
        for (int i = 0; i < glowPixels.length; ++i) {
            int rgb = glowPixels[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            a = (int)Math.min((float)alphaCap, (float)a * this.strength);
            glowPixels[i] = a << 24 | r << 16 | g << 8 | b;
        }
    }

    private void applyStrength(BufferedImage glow) {
        int[] glowPixels = new int[this.width * this.height];
        glow.getRGB(0, 0, this.width, this.height, glowPixels, 0, this.width);
        int alphaCap = (int)((double)this.alpha * 255.0);
        for (int j = 0; j < this.height; ++j) {
            int offset = this.width * j;
            for (int i = 0; i < this.width; ++i) {
                int rgb = glowPixels[offset + i];
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                a = (int)Math.min((float)alphaCap, (float)a * this.strength);
                glowPixels[offset + i] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        glow.setRGB(0, 0, this.width, this.height, glowPixels, 0, this.width);
    }
}

