/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.image;

import com.sas.graphics.image.Filter;
import com.sas.graphics.image.GaussianFilter;
import java.awt.image.BufferedImage;

public class BlendFilter
extends Filter {
    private Mode mode;
    private float opacity;
    private BufferedImage blendingImage;
    private int offsetX = 0;
    private int offsetY = 0;

    public BlendFilter() {
    }

    public BlendFilter(BufferedImage img, Mode m) {
        this.blendingImage = img;
        this.mode = m;
    }

    public void setImage(BufferedImage img) {
        this.blendingImage = img;
    }

    public BufferedImage getImage() {
        return this.blendingImage;
    }

    public void setMode(Mode m) {
        this.mode = m;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setOpacity(float o) {
        this.opacity = o;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOffsets(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = new BufferedImage(width, height, 2);
        }
        int size = width * height;
        int[] srcPixels = new int[size];
        src.getRGB(0, 0, width, height, srcPixels, 0, width);
        int[] dstPixels = new int[size];
        src.getRGB(0, 0, width, height, dstPixels, 0, width);
        int width2 = this.blendingImage.getWidth();
        int height2 = this.blendingImage.getHeight();
        int[] blendingPixels = new int[width2 * height2];
        this.blendingImage.getRGB(0, 0, width2, height2, blendingPixels, 0, width2);
        boolean preAlpha_bottom = src.isAlphaPremultiplied();
        boolean preAlpha_top = this.blendingImage.isAlphaPremultiplied();
        for (int j = 0; j < height2; ++j) {
            int off = width * (j + this.offsetY);
            int off2 = width2 * j;
            for (int i = 0; i < width2; ++i) {
                int pos = off + (i + this.offsetX);
                int pos2 = off2 + i;
                int bottom = srcPixels[pos];
                int top = blendingPixels[pos2];
                dstPixels[pos] = this.blendPixel(top, preAlpha_top, bottom, preAlpha_bottom, this.mode);
            }
        }
        dst.setRGB(0, 0, width, height, dstPixels, 0, width);
        return dst;
    }

    private int blendPixel(int top, boolean preAlpha_top, int bottom, boolean preAlpha_bottom, Mode mode) {
        float a255;
        int top_a = top >> 24 & 0xFF;
        int top_r = top >> 16 & 0xFF;
        int top_g = top >> 8 & 0xFF;
        int top_b = top & 0xFF;
        int bottom_a = bottom >> 24 & 0xFF;
        int bottom_r = bottom >> 16 & 0xFF;
        int bottom_g = bottom >> 8 & 0xFF;
        int bottom_b = bottom & 0xFF;
        if (!preAlpha_top) {
            a255 = (float)top_a * 0.003921569f;
            top_r = (int)((float)top_r * a255);
            top_g = (int)((float)top_g * a255);
            top_b = (int)((float)top_b * a255);
        }
        if (!preAlpha_bottom) {
            a255 = (float)bottom_a * 0.003921569f;
            bottom_r = (int)((float)bottom_r * a255);
            bottom_g = (int)((float)bottom_g * a255);
            bottom_b = (int)((float)bottom_b * a255);
        }
        float a = 0.0f;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        switch (mode) {
            case COLOR_BURN: {
                a = (float)(bottom_a + top_a) - (float)(bottom_a * top_a) / 255.0f;
                r = 255.0f - (255.0f - (float)bottom_r) / (float)top_r * 255.0f;
                g = 255.0f - (255.0f - (float)bottom_g) / (float)top_g * 255.0f;
                b = 255.0f - (255.0f - (float)bottom_b) / (float)top_b * 255.0f;
                break;
            }
            case COLOR_DODGE: {
                a = bottom_a != 255 ? (float)bottom_a : (float)(bottom_a + top_a) - (float)(bottom_a * top_a) / 255.0f;
                r = top_r == 255 ? 255.0f : (float)bottom_r / (255.0f - (float)top_r) * 255.0f;
                g = top_g == 255 ? 255.0f : (float)bottom_g / (255.0f - (float)top_g) * 255.0f;
                b = top_b == 255 ? 255.0f : (float)bottom_b / (255.0f - (float)top_b) * 255.0f;
                break;
            }
            case MULTIPLY: {
                a = bottom_a != 255 ? (float)bottom_a : (float)(bottom_a + top_a) - (float)(bottom_a * top_a) / 255.0f;
                r = (float)(bottom_r * top_r) / 255.0f;
                g = (float)(bottom_g * top_g) / 255.0f;
                b = (float)(bottom_b * top_b) / 255.0f;
            }
        }
        int ia = GaussianFilter.clamp((int)((double)a + 0.5));
        int ir = GaussianFilter.clamp((int)((double)r + 0.5));
        int ig = GaussianFilter.clamp((int)((double)g + 0.5));
        int ib = GaussianFilter.clamp((int)((double)b + 0.5));
        return ia << 24 | ir << 16 | ig << 8 | ib;
    }

    public static enum Mode {
        MULTIPLY,
        COLOR_BURN,
        COLOR_DODGE;

    }
}

