/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.image;

import com.sas.graphics.image.Filter;
import com.sas.graphics.image.GaussianFilter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class BevelFilter
extends Filter {
    static final int INNER = 0;
    static final int OUTER = 1;
    static final int FULL = 2;
    private int type = 0;
    private float distance = 5.0f;
    private float angle = 45.0f;
    private float blurX = 5.0f;
    private float blurY = 5.0f;
    private float strength = 1.0f;
    private int quality = 1;
    private Color highlightColor = Color.white;
    private float highlightAlpha = 0.5f;
    private Color shadowColor = Color.black;
    private float shadowAlpha = 0.3f;
    private boolean knockout = false;
    private boolean postProcessRequired = false;
    private boolean extendEdge = true;
    private int height;
    private int width;
    private int offsetX;
    private int offsetY;

    public void setType(int t) {
        this.type = t;
    }

    public int getType() {
        return this.type;
    }

    public void setDistance(float d) {
        this.distance = d;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setAngle(float ang) {
        this.angle = ang;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setHighlightColor(Color c) {
        this.highlightColor = c;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightAlpha(float a) {
        this.highlightAlpha = a;
    }

    public float getHighlightAlpha() {
        return this.highlightAlpha;
    }

    public void setShadowColor(Color c) {
        this.shadowColor = c;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowAlpha(float a) {
        this.shadowAlpha = a;
    }

    public float getShadowAlpha() {
        return this.shadowAlpha;
    }

    public void setBlurX(float blur) {
        this.blurX = blur;
    }

    public float getBlurX() {
        return this.blurX;
    }

    public void setBlurY(float blur) {
        this.blurY = blur;
    }

    public float getBlurY() {
        return this.blurY;
    }

    public void setStrength(float s) {
        this.strength = s;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setQuality(int q) {
        this.quality = q;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setKnockout(boolean b) {
        this.knockout = b;
    }

    public boolean isKnockout() {
        return this.knockout;
    }

    public void setPostProcessRequired(boolean b) {
        this.postProcessRequired = b;
    }

    public boolean isPostProcessRequired() {
        return this.postProcessRequired;
    }

    public void setExtendEdge(boolean b) {
        this.extendEdge = b;
    }

    public boolean isExtendEdge() {
        return this.extendEdge;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        this.width = src.getWidth();
        this.height = src.getHeight();
        this.computeOffsets();
        if (dst == null) {
            dst = new BufferedImage(this.width, this.height, 2);
        }
        BufferedImage highlight = new BufferedImage(this.width, this.height, 2);
        BufferedImage shadow = new BufferedImage(this.width, this.height, 2);
        this.createBevelSourceImage(src, highlight, shadow);
        if ((this.blurX > 0.0f || this.blurY > 0.0f) && this.quality > 0) {
            double bx = 0.0;
            double by = 0.0;
            for (int i = 0; i < this.quality; ++i) {
                bx += (double)(this.blurX * this.blurX);
                by += (double)(this.blurY * this.blurY);
            }
            this.blurX = (float)Math.sqrt(bx);
            this.blurY = (float)Math.sqrt(by);
            GaussianFilter filter = new GaussianFilter(this.blurX, this.blurY);
            if (this.extendEdge) {
                if (this.highlightAlpha != 0.0f) {
                    filter.filter(highlight, highlight, this.offsetX, this.offsetY);
                }
                if (this.shadowAlpha != 0.0f) {
                    filter.filter(shadow, shadow, -this.offsetX, -this.offsetY);
                }
            } else {
                if (this.highlightAlpha != 0.0f) {
                    filter.filter(highlight, highlight);
                }
                if (this.shadowAlpha != 0.0f) {
                    filter.filter(shadow, shadow);
                }
            }
        }
        int[] srcPixels = new int[this.width * this.height];
        src.getRGB(0, 0, this.width, this.height, srcPixels, 0, this.width);
        int[] highlightPixels = new int[this.width * this.height];
        highlight.getRGB(0, 0, this.width, this.height, highlightPixels, 0, this.width);
        int[] shadowPixels = new int[this.width * this.height];
        shadow.getRGB(0, 0, this.width, this.height, shadowPixels, 0, this.width);
        if (this.strength > 1.0f) {
            int alpha1 = (int)(this.highlightAlpha * 255.0f);
            int alpha2 = (int)(this.shadowAlpha * 255.0f);
            this.applyStrength(highlightPixels, alpha1);
            this.applyStrength(shadowPixels, alpha2);
        }
        this.clipBevelSourceImage(highlightPixels, shadowPixels, srcPixels);
        if (this.postProcessRequired) {
            this.postProcessBevelImage(highlightPixels, shadowPixels);
        }
        highlight.setRGB(0, 0, this.width, this.height, highlightPixels, 0, this.width);
        shadow.setRGB(0, 0, this.width, this.height, shadowPixels, 0, this.width);
        Graphics2D g = dst.createGraphics();
        if (!this.knockout) {
            g.drawRenderedImage(src, null);
        }
        g.setComposite(AlphaComposite.SrcOver);
        if (this.shadowAlpha != 0.0f) {
            g.drawRenderedImage(shadow, null);
        }
        if (this.highlightAlpha != 0.0f) {
            g.drawRenderedImage(highlight, null);
        }
        g.dispose();
        return dst;
    }

    private void computeOffsets() {
        this.offsetX = (int)((double)this.distance * Math.cos((double)this.angle * Math.PI / 180.0) + 0.5);
        this.offsetY = (int)((double)this.distance * Math.sin((double)this.angle * Math.PI / 180.0) + 0.5);
    }

    private void createBevelSourceImage(BufferedImage src, BufferedImage highlight, BufferedImage shadow) {
        int a;
        int a2;
        int rgb2;
        int i;
        int offset;
        int j;
        int alpha1 = (int)(this.highlightAlpha * 255.0f);
        int r1 = this.highlightColor.getRed();
        int g1 = this.highlightColor.getGreen();
        int b1 = this.highlightColor.getBlue();
        int alpha2 = (int)(this.shadowAlpha * 255.0f);
        int r2 = this.shadowColor.getRed();
        int g2 = this.shadowColor.getGreen();
        int b2 = this.shadowColor.getBlue();
        if (alpha1 == 0) {
            alpha1 = 255;
        }
        if (alpha2 == 0) {
            alpha2 = 255;
        }
        int[] srcPixels = new int[this.width * this.height];
        int[] highlightPixels = new int[this.width * this.height];
        int[] shadowPixels = new int[this.width * this.height];
        src.getRGB(0, 0, this.width, this.height, srcPixels, 0, this.width);
        highlight.getRGB(0, 0, this.width, this.height, highlightPixels, 0, this.width);
        shadow.getRGB(0, 0, this.width, this.height, shadowPixels, 0, this.width);
        BufferedImage tmp = new BufferedImage(this.width, this.height, 2);
        int[] tmpPixels = new int[this.width * this.height];
        AffineTransformOp op = new AffineTransformOp(AffineTransform.getTranslateInstance(this.offsetX, this.offsetY), null);
        op.filter(src, tmp);
        tmp.getRGB(0, 0, this.width, this.height, tmpPixels, 0, this.width);
        for (j = 0; j < this.height; ++j) {
            offset = this.width * j;
            for (i = 0; i < this.width; ++i) {
                rgb2 = tmpPixels[offset + i];
                a2 = rgb2 >> 24 & 0xFF;
                a = (int)((double)alpha1 * (255.0 - (double)a2) / 255.0);
                highlightPixels[offset + i] = a << 24 | r1 << 16 | g1 << 8 | b1;
            }
        }
        for (int i2 = 0; i2 < tmpPixels.length; ++i2) {
            tmpPixels[i2] = 0;
        }
        tmp.setRGB(0, 0, this.width, this.height, tmpPixels, 0, this.width);
        op = new AffineTransformOp(AffineTransform.getTranslateInstance(-this.offsetX, -this.offsetY), null);
        op.filter(src, tmp);
        tmp.getRGB(0, 0, this.width, this.height, tmpPixels, 0, this.width);
        for (j = 0; j < this.height; ++j) {
            offset = this.width * j;
            for (i = 0; i < this.width; ++i) {
                rgb2 = tmpPixels[offset + i];
                a2 = rgb2 >> 24 & 0xFF;
                a = (int)((double)alpha2 * (255.0 - (double)a2) / 255.0);
                shadowPixels[offset + i] = a << 24 | r2 << 16 | g2 << 8 | b2;
            }
        }
        for (j = 0; j < this.height; ++j) {
            offset = this.width * j;
            for (i = 0; i < this.width; ++i) {
                int rgb = highlightPixels[offset + i];
                rgb2 = shadowPixels[offset + i];
                a = rgb >> 24 & 0xFF;
                a2 = rgb2 >> 24 & 0xFF;
                if (a == 0 || a2 == 0) continue;
                highlightPixels[offset + i] = 0;
                shadowPixels[offset + i] = 0;
            }
        }
        highlight.setRGB(0, 0, this.width, this.height, highlightPixels, 0, this.width);
        shadow.setRGB(0, 0, this.width, this.height, shadowPixels, 0, this.width);
    }

    private void clipBevelSourceImage(int[] highlightPixels, int[] shadowPixels, int[] srcPixels) {
        for (int j = 0; j < this.height; ++j) {
            int offset = this.width * j;
            for (int i = 0; i < this.width; ++i) {
                int rgb1 = highlightPixels[offset + i];
                int a1 = rgb1 >> 24 & 0xFF;
                int r1 = rgb1 >> 16 & 0xFF;
                int g1 = rgb1 >> 8 & 0xFF;
                int b1 = rgb1 & 0xFF;
                int rgb2 = shadowPixels[offset + i];
                int a2 = rgb2 >> 24 & 0xFF;
                int r2 = rgb2 >> 16 & 0xFF;
                int g2 = rgb2 >> 8 & 0xFF;
                int b2 = rgb2 & 0xFF;
                int rgb = srcPixels[offset + i];
                int a = rgb >> 24 & 0xFF;
                a1 = (int)((double)(a1 * a) / 255.0);
                a2 = (int)((double)(a2 * a) / 255.0);
                highlightPixels[offset + i] = a1 << 24 | r1 << 16 | g1 << 8 | b1;
                shadowPixels[offset + i] = a2 << 24 | r2 << 16 | g2 << 8 | b2;
            }
        }
    }

    private void applyStrength(int[] skinPixels, int alphaCap) {
        if (alphaCap == 0) {
            return;
        }
        for (int i = 0; i < skinPixels.length; ++i) {
            int rgb = skinPixels[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            a = (int)Math.min((float)alphaCap, (float)a * this.strength);
            skinPixels[i] = a << 24 | r << 16 | g << 8 | b;
        }
    }

    private void applyStrength2(int[] skinPixels, int alphaCap) {
        int[] aRange = this.getAlphaRange(skinPixels);
        int maxIntensity = alphaCap;
        double pow = 1.0 / (double)this.strength;
        double scale = (double)maxIntensity / Math.pow(aRange[1] - aRange[0], pow);
        for (int i = 0; i < skinPixels.length; ++i) {
            int rgb = skinPixels[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            if (a <= aRange[0]) {
                a = 0;
            }
            if (a != 0) {
                a = (int)(scale * Math.pow(a - aRange[0], pow));
            }
            skinPixels[i] = a << 24 | r << 16 | g << 8 | b;
        }
        aRange = this.getAlphaRange(skinPixels);
    }

    private int[] getAlphaRange(int[] src) {
        int min = 255;
        int max = 0;
        for (int i = 0; i < src.length; ++i) {
            int rgb = src[i];
            int a = rgb >> 24 & 0xFF;
            if (a == 0) continue;
            if (a < min) {
                min = a;
            }
            if (a <= max) continue;
            max = a;
        }
        return new int[]{min, max};
    }

    private void postProcessBevelImage(int[] highlightPixels, int[] shadowPixels) {
        float alpha1 = this.highlightAlpha;
        float alpha2 = this.shadowAlpha;
        float ratio = alpha1 / alpha2;
        boolean common = false;
        for (int j = 0; j < this.height; ++j) {
            int offset = this.width * j;
            for (int i = 0; i < this.width; ++i) {
                int rgb1 = highlightPixels[offset + i];
                int a1 = rgb1 >> 24 & 0xFF;
                int r1 = rgb1 >> 16 & 0xFF;
                int g1 = rgb1 >> 8 & 0xFF;
                int b1 = rgb1 & 0xFF;
                int rgb2 = shadowPixels[offset + i];
                int a2 = rgb2 >> 24 & 0xFF;
                int r2 = rgb2 >> 16 & 0xFF;
                int g2 = rgb2 >> 8 & 0xFF;
                int b2 = rgb2 & 0xFF;
                if (a1 == 0 || a2 == 0) continue;
                if ((float)a1 < (float)a2 * ratio) {
                    a1 = 0;
                } else if ((float)a1 > (float)a2 * ratio) {
                    a2 = 0;
                } else {
                    a1 = 0;
                    a2 = 0;
                }
                highlightPixels[offset + i] = a1 << 24 | r1 << 16 | g1 << 8 | b1;
                shadowPixels[offset + i] = a2 << 24 | r2 << 16 | g2 << 8 | b2;
                common = true;
            }
        }
        if (common) {
            this.remapping(highlightPixels);
            this.remapping(shadowPixels);
        }
    }

    private void remapping(int[] skinPixels) {
        int threshold = this.getThreshold(skinPixels);
        if (threshold == 0) {
            return;
        }
        int[] aRange = this.getAlphaRange(skinPixels);
        aRange[0] = threshold;
        int maxIntensity = aRange[1];
        double scale = (double)maxIntensity / (double)(aRange[1] - aRange[0]);
        for (int i = 0; i < skinPixels.length; ++i) {
            int rgb = skinPixels[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            if (a < aRange[0]) {
                a = 0;
            }
            if (a != 0) {
                a = (int)Math.min((double)maxIntensity, scale * (double)(a - aRange[0]) + 0.5);
            }
            skinPixels[i] = a << 24 | r << 16 | g << 8 | b;
        }
    }

    private int getThreshold2(int[] skinPixels) {
        int[] hist = new int[256];
        int total = 0;
        int min = 255;
        int max = 0;
        for (int i = 0; i < skinPixels.length; ++i) {
            int rgb = skinPixels[i];
            int a = rgb >> 24 & 0xFF;
            if (a == 0) continue;
            if (a < min) {
                min = a;
            }
            if (a > max) {
                max = a;
            }
            int n = a;
            hist[n] = hist[n] + 1;
            ++total;
        }
        int range75 = (int)((double)(max - min) * 0.75);
        int cutoff = max - range75;
        return cutoff;
    }

    private int getThreshold(int[] skinPixels) {
        int threshold = 0;
        if (this.angle == 0.0f && this.width > 5) {
            int max = 0;
            int w2 = (int)((double)(this.width - 1) * 0.5);
            for (int j = 0; j < this.height; ++j) {
                int offset = this.width * j;
                for (int i = w2 - 1; i <= w2 + 1; ++i) {
                    int rgb = skinPixels[offset + i];
                    int a = rgb >> 24 & 0xFF;
                    if (a <= max) continue;
                    max = a;
                }
            }
            threshold = max;
        } else if (this.angle == 90.0f && this.height > 5) {
            int max = 0;
            int h2 = (int)((double)(this.height - 1) * 0.5);
            for (int j = h2 - 1; j <= h2 + 1; ++j) {
                int offset = this.width * j;
                for (int i = 0; i < this.width; ++i) {
                    int rgb = skinPixels[offset + i];
                    int a = rgb >> 24 & 0xFF;
                    if (a <= max) continue;
                    max = a;
                }
            }
            threshold = max;
        } else if (this.angle == 45.0f && this.height > 5 && this.width > 5) {
            int wh = Math.min(this.width, this.height);
            int dw2 = (int)((double)(this.width - wh) * 0.5);
            int dh2 = (int)((double)(this.height - wh) * 0.5);
            int max = 0;
            int margin = 1;
            int endh = this.height - dh2 - margin;
            int n = margin;
            for (int j = dh2 + margin; j < endh; ++j) {
                int offset = this.width * j;
                int diag = this.width - dw2 - 1 - n;
                for (int i = diag - 1; i <= diag + 1; ++i) {
                    int rgb = skinPixels[offset + i];
                    int a = rgb >> 24 & 0xFF;
                    if (a <= max) continue;
                    max = a;
                }
                ++n;
            }
            threshold = max;
        }
        return threshold;
    }
}

