/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security.login;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IOMIHelper;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.Credential;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.connection.SecurityPackageCredential;
import com.sas.services.connection.TrustedPeerCredential;
import com.sas.services.security.login.BadHostException;
import com.sas.services.security.login.ConnectRefusedException;
import com.sas.services.security.login.CredentialException;
import com.sas.services.security.login.NetworkException;
import com.sas.services.security.login.PFSCredential;
import com.sas.services.security.login.SasLoginModule;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class TrustedLoginModule
extends SasLoginModule {
    private IOMI _trustedCnxn;
    protected String _genUser;
    protected String _genPass;
    protected ConnectionInterface tcx = null;
    protected ConnectionFactoryInterface cxf = null;
    protected ConnectionInterface cx = null;
    private String _trustedUser;
    private String _trustedPw;
    private String _trustedIDPropagation;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this._trustedUser = (String)options.get("trusteduser");
        this._trustedPw = (String)options.get("trustedpw");
        if (this._trustedPw != null) {
            try {
                this._trustedPw = SasPasswordString.decode((String)this._trustedPw);
            }
            catch (SasPasswordEncodingException spee) {
                this._trustedPw = (String)options.get("trustedpw");
            }
        }
        String idp = (String)options.get("trustedidpropagation");
        this._trustedIDPropagation = TrustedLoginModule.normalizeIDPropagation(idp);
        if (this._debug) {
            this.doDebugOutput("Trusted user is " + this._trustedUser);
        }
    }

    @Override
    public boolean login() throws LoginException {
        return this.doLogin();
    }

    protected boolean doLogin() throws LoginException {
        boolean result = this.setupAuthParams();
        if (!result) {
            return false;
        }
        result = this.setupConnectionResources();
        if (!result) {
            return false;
        }
        if (this._debug) {
            this.doDebugOutput("Request to authenticate " + this._username);
        }
        if (this._username.indexOf("!*(generatedpassworddomain)*!") > -1) {
            this._genUser = this._username;
            this._genPass = this._password;
            this._password = null;
            this._username = this._username.substring(0, this._username.indexOf("!*(generatedpassworddomain)*!") - 1);
            result = this.attemptConnection(this._genUser, this._genPass);
            this.closeTrust();
            if (!result) {
                return false;
            }
        } else {
            this._password = null;
            result = this.generatePassword();
            if (!result) {
                return false;
            }
            result = this.attemptConnection(this._genUser, this._genPass);
            this.closeTrust();
            if (!result) {
                return false;
            }
        }
        this.getUserInfo();
        this.closeCx();
        this._succeeded = true;
        return true;
    }

    protected void addDefaultCredential() {
        PFSCredential pc = new PFSCredential(this._username, "", this.getDomain());
        this._credentials.add(0, pc);
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this._succeeded) {
            return false;
        }
        this.addDefaultCredential();
        return super.commit();
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        super.logout();
        return true;
    }

    public boolean generatePassword() throws LoginException {
        if (this._trustedCnxn == null) {
            try {
                ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration(this._metadataCluster);
                ConnectionFactoryManager cxfManager = this.getConnectionFactoryManager();
                this.cxf = cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
                java.lang.Object cred = null;
                cred = this._trustedUser != null && this._trustedPw != null || this._trustedIDPropagation == null ? new PasswordCredential(this._trustedUser, this._trustedPw) : (this._trustedIDPropagation.equals("sspi") ? SecurityPackageCredential.getInstance() : TrustedPeerCredential.getInstance());
                this.tcx = this.cxf.getConnection((Credential)cred);
                Object obj2 = this.tcx.getObject();
                this._trustedCnxn = IOMIHelper.narrow((Object)obj2);
            }
            catch (Throwable t) {
                String eText = t.getMessage();
                if (eText != null) {
                    if (this.isDebug()) {
                        this.doDebugOutput("Exception in generatePassword(): " + eText);
                    }
                    if (eText.indexOf("1326") > -1) {
                        throw new CredentialException(eText);
                    }
                    if (eText.indexOf("java.net") > -1) {
                        if (eText.indexOf("ConnectException") > -1) {
                            throw new ConnectRefusedException(eText);
                        }
                        if (eText.indexOf("UnknownHostException") > -1) {
                            throw new BadHostException(eText);
                        }
                        throw new NetworkException(eText);
                    }
                } else {
                    eText = t.getClass().getName();
                    if (this.isDebug()) {
                        this.doDebugOutput("Exception in generatePassword(): " + eText);
                    }
                }
                if (this.tcx != null) {
                    this.tcx.close();
                }
                if (this.cxf != null) {
                    try {
                        this.cxf.getAdminInterface().destroy();
                    }
                    catch (ConnectionFactoryException cred) {
                        // empty catch block
                    }
                }
                throw new LoginException(eText);
            }
        }
        StringHolder qualUserNameHolder = new StringHolder();
        StringHolder genPasswordHolder = new StringHolder();
        try {
            this.tcx.generatePassword(this._username, qualUserNameHolder, genPasswordHolder);
        }
        catch (ConnectionFactoryException ex) {
            Throwable t;
            for (t = ex; t.getCause() != null && t.getCause() != t; t = t.getCause()) {
            }
            LoginException le = new LoginException(t.getMessage());
            le.initCause(t);
            throw le;
        }
        catch (Exception se) {
            this.closeTrust();
            LoginException le = new LoginException(se.getMessage());
            le.initCause(se);
            throw le;
        }
        this._genUser = qualUserNameHolder.value;
        this._genPass = genPasswordHolder.value;
        return true;
    }

    protected void closeTrust() {
        try {
            if (this.isDebug()) {
                this.doDebugOutput(this.getRBString("TrustedModule.closetrust.msg.txt"));
            }
            if (this.tcx != null) {
                this.tcx.close();
            }
            if (this.cxf != null) {
                this.cxf.getAdminInterface().shutdown();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

