/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security.login;

import com.sas.services.security.login.PFSPrincipalInterface;
import java.io.Serializable;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;

public class PFSPrincipal
implements PFSPrincipalInterface,
Serializable {
    private static final long serialVersionUID = 5534496086068351149L;
    public static final String MANGLED_NAME_PREFIX = "sas.security.";
    private String _name;
    private boolean _processed;
    private String _host;
    private int _port;
    private String _domain;
    private String _reposId;
    private boolean _isValidated = false;

    public PFSPrincipal(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean isProcessed() {
        return this._processed;
    }

    @Override
    public void setProcessed() {
        this._processed = true;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String _host) {
        this._host = _host;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int _port) {
        this._port = _port;
    }

    public String getReposId() {
        return this._reposId;
    }

    void setReposId(String id) {
        this._reposId = id;
    }

    public String getDomain() {
        return this._domain;
    }

    public void setDomain(String _domain) {
        this._domain = _domain;
    }

    public boolean isValidated() {
        return this._isValidated;
    }

    public final void setIsValidated(boolean validated) {
        this._isValidated = validated;
    }

    @Override
    public String toString() {
        return "PFSPrincipal: " + this._name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PFSPrincipal)) {
            return false;
        }
        PFSPrincipal p = (PFSPrincipal)o;
        if (!this.getEquivalenceClass().equals(p.getEquivalenceClass())) {
            return false;
        }
        return this.blindlyEquals(p, true);
    }

    public boolean blindlyEquals(PFSPrincipal o, boolean forward) {
        if (!this.stringEquals(this.getName(), o.getName())) {
            return false;
        }
        if (o.getHost() != null && !this.stringEquals(this.getHost(), o.getHost())) {
            return false;
        }
        if (o.getPort() != 0 && this.getPort() != o.getPort()) {
            return false;
        }
        if (o.getDomain() != null && !this.stringEquals(this.getDomain(), o.getDomain())) {
            return false;
        }
        return !forward || o.blindlyEquals(this, false);
    }

    @Override
    public int hashCode() {
        int result = 17;
        if (this._name != null) {
            result = 37 * result + this._name.hashCode();
        }
        if (this._host != null) {
            result = 37 * result + this._host.hashCode();
        }
        if (this._port != 0) {
            result = 37 * result + this._port;
        }
        if (this._domain != null) {
            result = 37 * result + this._domain.hashCode();
        }
        return result;
    }

    @Override
    public boolean implies(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        for (Principal o : principals) {
            PFSPrincipal p;
            if (!(o instanceof PFSPrincipal) || !(p = (PFSPrincipal)o).isValidated() || !p.equals(this)) continue;
            return true;
        }
        return false;
    }

    protected Object getEquivalenceClass() {
        return PFSPrincipal.class;
    }

    protected boolean stringEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s1 != null && s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }
}

