/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security.login;

import com.sas.services.security.login.BadHostException;
import com.sas.services.security.login.ConnectRefusedException;
import com.sas.services.security.login.CredentialException;
import com.sas.services.security.login.NetworkException;
import com.sas.services.security.login.PFSCredential;
import com.sas.services.security.login.PFSPrincipal;
import com.sas.services.security.login.ServerPrincipal;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class LdapLoginModule
implements LoginModule {
    private Subject _subject;
    private CallbackHandler _callbackHandler;
    private boolean _succeeded = false;
    private String _name;
    private String _username;
    private String _userDn;
    private String _password;
    private String _defaultHost;
    private int _defaultPort;
    private String _defaultBase;
    private String _defaultDomain;
    private String _privDN;
    private String _privCred;
    private String _host;
    private int _port;
    private String _domain;
    private boolean _debug;
    private ResourceBundle _rb;
    ArrayList groupList;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String locale_resource = "Resources" + language + ".properties";
        InputStream inputStream = this.getClass().getResourceAsStream(locale_resource);
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream("Resources.properties");
        }
        try {
            this._rb = new PropertyResourceBundle(inputStream);
        }
        catch (IOException ioex) {
            this._rb = null;
        }
        this._subject = subject;
        this._callbackHandler = callbackHandler;
        this._succeeded = false;
        this._domain = null;
        this._defaultHost = (String)options.get("host");
        this._defaultPort = Integer.valueOf((String)options.get("port"));
        this._defaultBase = (String)options.get("base");
        this._defaultDomain = (String)options.get("domain");
        this._privDN = (String)options.get("privilegedUser");
        try {
            this._privCred = SasPasswordString.decode((String)((String)options.get("privilegedPassword")));
        }
        catch (SasPasswordEncodingException spee) {
            this._privCred = (String)options.get("privilegedPassword");
        }
        this._debug = false;
        String debugString = (String)options.get("debug");
        if (debugString != null && debugString.equalsIgnoreCase("true")) {
            this._debug = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean login() throws LoginException {
        InitialDirContext ctx = null;
        this._succeeded = false;
        if (this._callbackHandler == null) {
            throw new LoginException(this._rb.getString("LdapLoginModule.nocallback.msg.txt"));
        }
        Callback[] callbacks = new Callback[8];
        callbacks[0] = new NameCallback("Name");
        callbacks[1] = new PasswordCallback("PWD", false);
        try {
            SearchControls ctls;
            String provider;
            Hashtable<String, String> env;
            String principal;
            block44: {
                this._callbackHandler.handle(callbacks);
                this._username = ((NameCallback)callbacks[0]).getName();
                if (this._username == null) {
                    return false;
                }
                char[] pwArray = ((PasswordCallback)callbacks[1]).getPassword();
                this._password = pwArray == null ? new String("") : new String(pwArray);
                this._password = new String(((PasswordCallback)callbacks[1]).getPassword());
                this._host = this._defaultHost;
                this._port = this._defaultPort;
                if (this._username.startsWith("[@")) {
                    int index = this._username.indexOf(93);
                    if (index > -1) {
                        this._domain = this._username.substring(2, index);
                        this._username = this._username.substring(index + 1);
                    } else {
                        this._domain = this._defaultDomain;
                    }
                } else {
                    this._domain = this._defaultDomain;
                }
                if (this._host.equalsIgnoreCase(this._defaultHost) && this._port == this._defaultPort && !this._domain.equalsIgnoreCase(this._defaultDomain)) {
                    if (this._debug) {
                        Object[] arguments = new Object[]{this._domain, this._defaultDomain};
                        System.out.println(MessageFormat.format(this._rb.getString("LdapLoginModule.wrongdomain.msg.fmt.txt"), arguments));
                    }
                    return false;
                }
                principal = this._username;
                env = new Hashtable<String, String>();
                if (principal.indexOf("=") == -1) {
                    env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                    env.put("java.naming.referral", "follow");
                    env.put("java.naming.ldap.version", "3");
                    env.put("java.naming.security.authentication", "simple");
                    provider = new String("ldap://" + this._host + ":" + this._port);
                    env.put("java.naming.provider.url", provider);
                    env.put("java.naming.security.principal", this._privDN);
                    env.put("java.naming.security.credentials", this._privCred);
                    ctls = new SearchControls();
                    ctls.setSearchScope(2);
                    try {
                        ctx = new InitialDirContext(env);
                    }
                    catch (AuthenticationException ae) {
                        if (this._debug) {
                            System.err.println(MessageFormat.format(this._rb.getString("LdapLoginModule.prividentbad.msg.fmt.txt"), this._privDN));
                            ae.printStackTrace(System.err);
                            System.err.println("");
                            System.err.println(this._rb.getString("LdapLoginModule.anonget.msg.txt"));
                        }
                        env.remove("java.naming.security.principal");
                        env.remove("java.naming.security.credentials");
                        try {
                            ctx = new InitialDirContext(env);
                        }
                        catch (CommunicationException ce) {
                            String message;
                            Throwable t;
                            if (this._debug) {
                                ce.printStackTrace(System.out);
                            }
                            if ((t = ce.getRootCause()) instanceof ConnectException && (message = t.getMessage()) != null) {
                                if (message.indexOf("Connection refused") > -1) {
                                    throw new ConnectRefusedException(message);
                                }
                                if (message.indexOf("UnknownHostException") > -1) {
                                    throw new BadHostException(message);
                                }
                            }
                            if (t instanceof UnknownHostException) {
                                throw new BadHostException(t.getMessage());
                            }
                            throw new NetworkException(ce.getExplanation());
                        }
                        catch (NamingException t2) {
                            String message;
                            if (this._debug) {
                                t2.printStackTrace(System.out);
                            }
                            if ((message = t2.getExplanation()) != null) {
                                if (message.indexOf("Connection refused") > -1) {
                                    throw new ConnectRefusedException(message);
                                }
                                if (message.indexOf("UnknownHost") > -1) {
                                    throw new BadHostException(message);
                                }
                            }
                            throw t2;
                        }
                    }
                    NamingEnumeration<SearchResult> results = ctx.search(this._defaultBase, "uid=" + principal, ctls);
                    ctx.close();
                    if (results.hasMoreElements()) {
                        SearchResult sr = (SearchResult)results.nextElement();
                        principal = this._userDn = sr.getName() + "," + this._defaultBase;
                        break block44;
                    } else {
                        if (this._debug) {
                            System.out.println(MessageFormat.format(this._rb.getString("LdapLoginModule.uidnotfound.msg.fmt.txt"), principal));
                        }
                        throw new CredentialException(MessageFormat.format(this._rb.getString("LdapLoginModule.uidnotfound.msg.fmt.txt"), principal));
                    }
                }
                this._userDn = principal;
            }
            try {
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.referral", "follow");
                env.put("java.naming.ldap.version", "3");
                env.put("java.naming.security.authentication", "simple");
                provider = new String("ldap://" + this._host + ":" + this._port);
                env.put("java.naming.provider.url", provider);
                env.put("java.naming.security.principal", principal);
                env.put("java.naming.security.credentials", this._password);
                ctls = new SearchControls();
                ctls.setSearchScope(2);
                ctx = new InitialDirContext(env);
                Attributes attrs = ctx.getAttributes(principal);
                Attribute attr = attrs.get("cn");
                this._name = (String)attr.get();
            }
            catch (Exception ex) {
                String message;
                if (this._debug) {
                    ex.printStackTrace(System.out);
                }
                if ((message = ex.getMessage()) != null && message.indexOf("Invalid Credentials") > -1) {
                    throw new CredentialException(message);
                }
                throw ex;
            }
            this._succeeded = true;
            if (this._userDn != null) {
                this.groupList = new ArrayList();
                this.getGroups(ctx, this._userDn);
                Iterator grpItor = this.groupList.iterator();
                StringBuffer filterBuffer = new StringBuffer();
                filterBuffer.append("(&(");
                filterBuffer.append("(objectclass=saslogin)");
                filterBuffer.append("(|(sasreferencedn=");
                filterBuffer.append(this._userDn);
                filterBuffer.append(")");
                filterBuffer.append("(sasallowedclientdn=");
                filterBuffer.append(this._userDn);
                filterBuffer.append(")");
                while (grpItor.hasNext()) {
                    String nextGroup = (String)grpItor.next();
                    filterBuffer.append("(sasreferencedn=");
                    filterBuffer.append(nextGroup);
                    filterBuffer.append(")");
                    filterBuffer.append("(sasallowedclientdn=");
                    filterBuffer.append(nextGroup);
                    filterBuffer.append(")");
                }
                filterBuffer.append(")");
                filterBuffer.append(")");
                filterBuffer.append(")");
                SearchControls ctls2 = new SearchControls();
                ctls2.setSearchScope(2);
                NamingEnumeration<SearchResult> ne = ctx.search(this._defaultBase, filterBuffer.toString(), ctls2);
                while (ne.hasMoreElements()) {
                    SearchResult sr = (SearchResult)ne.nextElement();
                    Attributes attrs = sr.getAttributes();
                    Attribute attr = attrs.get("sasloginname");
                    String uid = (String)attr.get();
                    attr = attrs.get("sasuserpassword");
                    String pw = (String)attr.get();
                    attr = attrs.get("sasdomainname");
                    String domain = (String)attr.get();
                    this._subject.getPrivateCredentials().add(new PFSCredential(uid, pw, domain));
                }
            }
        }
        catch (CommunicationException ce) {
            String message;
            Throwable t;
            if (this._debug) {
                ce.printStackTrace(System.out);
            }
            if ((t = ce.getRootCause()) instanceof ConnectException && (message = t.getMessage()) != null && message.indexOf("Connection refused") > -1) {
                throw new ConnectRefusedException(message);
            }
            if (t instanceof UnknownHostException) {
                throw new BadHostException(t.getMessage());
            }
            throw new NetworkException(ce.getExplanation());
        }
        catch (Throwable e) {
            if (this._debug) {
                e.printStackTrace(System.out);
            }
            if (this._succeeded) {
                return true;
            }
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw new LoginException(e.getMessage());
        }
        this._succeeded = true;
        return true;
    }

    private void getGroups(InitialDirContext repo, String dn) {
        Iterator grpItor = this.grouper(repo, dn);
        while (grpItor.hasNext()) {
            String nextGroup = (String)grpItor.next();
            if (this.groupList.contains(nextGroup)) continue;
            this.groupList.add(nextGroup);
            this.getGroups(repo, nextGroup);
        }
    }

    private Iterator grouper(InitialDirContext repo, String dn) {
        ArrayList<String> list = new ArrayList<String>();
        String filter = "(&(|((objectclass=group)(objectclass=groupofuniquenames)))(|(member=" + dn + ")(uniquemember=" + dn + ")))";
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> ne = repo.search(this._defaultBase, filter, ctls);
            while (ne.hasMoreElements()) {
                SearchResult sr = (SearchResult)ne.nextElement();
                String nextGroup = sr.getName() + "," + this._defaultBase;
                list.add(nextGroup);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list.iterator();
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this._succeeded) {
            return false;
        }
        try {
            ServerPrincipal sp = new ServerPrincipal(this._name);
            sp.setUserId(this._userDn);
            sp.setHost(this._host);
            sp.setPort(this._port);
            sp.setDomain(this._domain);
            sp.setProtocol("ldap");
            sp.setBase(this._defaultBase);
            if (!this._subject.getPrincipals().contains(sp)) {
                this._subject.getPrincipals().add(sp);
            }
            PFSPrincipal p = new PFSPrincipal(this._username + "@" + this._domain);
            if (!this._subject.getPrincipals().contains(p)) {
                this._subject.getPrincipals().add(p);
            }
            if (this.groupList != null) {
                for (String groupName : this.groupList) {
                    int index = groupName.indexOf("cn=");
                    if (index <= -1) continue;
                    int index2 = groupName.indexOf(",", index += 3);
                    groupName = groupName.substring(index, index2);
                    p = new PFSPrincipal(groupName + "@" + this._domain);
                    if (this._subject.getPrincipals().contains(p)) continue;
                    this._subject.getPrincipals().add(p);
                }
            }
            PFSCredential pc = new PFSCredential(this._userDn, this._password, this._domain);
            if (!this._subject.getPrivateCredentials().contains(pc)) {
                this._subject.getPrivateCredentials().add(pc);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }
}

