/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.directives.client;

import com.sas.svcs.directives.client.DirectiveParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Directive
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String URL_TYPE = "url";
    public static final String REF_TYPE = "ref";
    public static final String HREF_TYPE = "href";
    private String name;
    private String description;
    private String type;
    private String actual;
    private String owningComponent;
    private String appName;
    private String uri;
    private String href;
    private List<DirectiveParameter> parameters;
    private List<String> keywords;
    private boolean utilityAdd;
    private boolean isPublic;
    private boolean isLogonTarget;
    private boolean isAdmin;

    public Directive() {
    }

    public Directive(String n) {
        this.setName(n);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = StringUtils.trimToEmpty((String)n);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = StringUtils.trimToEmpty((String)d);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) {
        this.type = StringUtils.trimToEmpty((String)t).toLowerCase();
    }

    public String getActual() {
        return this.actual;
    }

    public void setActual(String a) {
        this.actual = StringUtils.trimToEmpty((String)a);
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String n) {
        this.appName = StringUtils.trimToEmpty((String)n);
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String h) {
        this.href = StringUtils.trimToEmpty((String)h);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String u) {
        this.uri = StringUtils.trimToEmpty((String)u);
    }

    public List<DirectiveParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<DirectiveParameter> p) {
        this.parameters = p;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> k) {
        this.keywords = k;
    }

    public void addKeyword(String s) {
        if (null == this.keywords) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(s);
    }

    public boolean hasKeyword(String s) {
        if (null == this.keywords) {
            return false;
        }
        return this.keywords.contains(s);
    }

    public boolean isUtilityAdd() {
        return this.utilityAdd;
    }

    public void setUtilityAdd(boolean a) {
        this.utilityAdd = a;
    }

    public void setUtilityAdd(String a) {
        this.utilityAdd = false;
        if (null == (a = StringUtils.trimToNull((String)a))) {
            return;
        }
        if ("y".equalsIgnoreCase(a)) {
            this.utilityAdd = true;
        }
    }

    public String getOwningComponent() {
        return this.owningComponent;
    }

    public void setOwningComponent(String owningComponent) {
        this.owningComponent = owningComponent;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean isLogonTarget() {
        return this.isLogonTarget;
    }

    public void setLogonTarget(boolean isLogonTarget) {
        this.isLogonTarget = isLogonTarget;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean admin) {
        this.isAdmin = admin;
    }

    public boolean validate() {
        boolean valid = true;
        String t = this.getType();
        if (URL_TYPE.equals(t)) {
            if (null != this.getActual()) {
                valid = false;
            }
            if (null == this.getUri()) {
                valid = false;
            }
        } else if (REF_TYPE.equals(t)) {
            if (null != this.getAppName() || null != this.getUri()) {
                valid = false;
            }
            if (null == this.getActual()) {
                valid = false;
            }
        }
        return valid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Directive: Name=");
        String s = this.getName();
        if (null != s) {
            sb.append(s);
        } else {
            sb.append("<empty>");
        }
        sb.append("\nDescription=");
        s = this.getDescription();
        if (null != s) {
            sb.append(s);
        } else {
            sb.append("<empty>");
        }
        sb.append("\nKeywords=");
        List<String> l = this.getKeywords();
        if (null != l) {
            int ctr = 0;
            Iterator<String> i = this.keywords.iterator();
            while (i.hasNext()) {
                if (++ctr > 1) {
                    sb.append(", ");
                }
                String kw = i.next();
                sb.append(kw);
            }
            sb.append(", ");
        } else {
            sb.append("<empty>, ");
        }
        sb.append("Type=");
        s = this.getType();
        if (null != s) {
            sb.append(s);
        } else {
            sb.append("<empty>");
        }
        sb.append("\nPublic=").append(this.isPublic()).append(", ");
        sb.append("LogonTarget=").append(this.isLogonTarget()).append(", ");
        sb.append("Admin=").append(this.isAdmin());
        sb.append("\nActual=");
        s = this.getActual();
        if (null != s) {
            sb.append(s).append(", ");
        } else {
            sb.append("<empty>, ");
        }
        sb.append("AppName=");
        s = this.getAppName();
        if (null != s) {
            sb.append(s);
        } else {
            sb.append("<empty>");
        }
        sb.append("\nUri=");
        s = this.getUri();
        if (null != s) {
            sb.append(s).append(", ");
        } else {
            sb.append("<empty>, ");
        }
        sb.append("Href=");
        s = this.getHref();
        if (null != s) {
            sb.append(s);
        } else {
            sb.append("<empty>");
        }
        List<DirectiveParameter> p = this.getParameters();
        if (null != p) {
            sb.append("\nParameters:\n");
            int cnt = 0;
            for (DirectiveParameter dp : p) {
                if (cnt++ > 0) {
                    sb.append('\n');
                }
                sb.append(dp.toString());
            }
        }
        return sb.toString();
    }
}

