/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.directives.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractDirectiveUrlCreator {
    private String action = "Director";
    private String directive;
    private Properties parameters = new Properties();

    protected void addParameter(String name, String value) {
        this.parameters.setProperty(name, value);
    }

    protected Properties getParameters() {
        return this.parameters;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setDirective(String directive) {
        this.directive = directive;
    }

    protected abstract List<String> onValidate();

    public void validate() {
        List<String> validations = this.onValidate();
        if (null == validations) {
            validations = new ArrayList<String>();
        }
        if (null == this.directive) {
            validations.add("Directive value is null.");
        }
        if (null == this.action) {
            validations.add("Action value is null.");
        }
        if (!validations.isEmpty()) {
            StringBuilder builder = new StringBuilder(100);
            builder.append("The following validation errors have occured:\n");
            for (String validation : validations) {
                builder.append("\t" + validation);
            }
            throw new IllegalStateException(builder.toString());
        }
    }

    public String getQueryString() {
        StringBuilder queryString = new StringBuilder(100);
        Iterator<Map.Entry<Object, Object>> it = this.parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            try {
                value = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Received UnsupportedEncoding for UTF-8. This is a required encoding per the java language specification.", e);
            }
            queryString.append(name).append('=').append(value);
            if (!it.hasNext()) continue;
            queryString.append('&');
        }
        return queryString.toString();
    }

    public String getUrl() {
        StringBuilder builder = new StringBuilder(50);
        builder.append(this.action);
        builder.append('?');
        builder.append("_directive").append('=').append(this.directive);
        builder.append('&').append(this.getQueryString());
        return builder.toString();
    }
}

