/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.jndi;

import com.sas.codepolicy.SASScope;
import com.sas.services.connection.AuthServer;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.Credential;
import com.sas.services.connection.LoginException;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.connection.Puddle;
import com.sas.services.connection.PuddleEnvelope;
import com.sas.services.connection.jndi.JNDIConnectionFactoryConfiguration;
import com.sas.services.connection.jndi.RB;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

@SASScope
public class JNDIAuthServer
extends AuthServer {
    private static SearchControls objectScopedSearchControls = null;
    private static SearchControls treeScopedSearchControls = null;
    private JNDIConnectionFactoryConfiguration cxfConfig = null;
    private Set adminCache = null;
    private Set namingContexts = null;

    protected JNDIAuthServer(PuddleEnvelope[] envs, JNDIConnectionFactoryConfiguration cxfConfig) {
        super(envs, false, true);
        if (cxfConfig.isAdminAuth()) {
            this.adminCache = new HashSet();
            this.adminCache.add(cxfConfig.getPrivLogin());
        }
        ArrayList<String> domains = new ArrayList<String>(1);
        String repositoryDomain = cxfConfig.getRepositoryDomain();
        domains.add(repositoryDomain);
        this.setDomains(domains);
        this.cxfConfig = cxfConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void authorizeAdmin(Credential adminLogin) throws ConnectionFactoryException {
        if (this.adminCache == null) {
            return;
        }
        if (this.adminCache.contains(adminLogin = this.normalize(adminLogin))) {
            return;
        }
        String domain = adminLogin.getDomain();
        List domainList = this.getDomains(adminLogin);
        if (!domainList.contains(domain)) {
            String messageIndex = "cxj.000.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex, (Object)domain);
            throw new LoginException(message);
        }
        DirContext ctx = (DirContext)this.authenticate(adminLogin);
        if (ctx == null) {
            String messageIndex = "cxj.001.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex, (Object)adminLogin.getDomain());
            throw new LoginException(message);
        }
        try {
            PuddleEnvelope[] envs = this.getPuddleEnvelopes();
            for (int i = 0; i < envs.length; ++i) {
                Puddle puddle = envs[i].getPuddle();
                String loginDN = puddle.getPuddleID();
                Object o = null;
                try {
                    o = ctx.lookup(loginDN);
                }
                catch (CommunicationException ce) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                    ctx = (DirContext)this.authenticate(adminLogin);
                    if (ctx != null) {
                        try {
                            o = ctx.lookup(loginDN);
                        }
                        catch (NamingException namingException) {}
                    }
                }
                catch (NamingException ce) {
                    // empty catch block
                }
                if (o != null) continue;
                String messageIndex = "cxj.002.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex);
                String message = Message.format((String)messagePattern, (Object)messageIndex);
                throw new LoginException(message);
            }
        }
        finally {
            this.closeIdentity(ctx);
        }
        this.adminCache.add(adminLogin);
    }

    @Override
    protected Credential normalize(Credential credential) {
        String normDN;
        if (credential == null || !(credential instanceof PasswordCredential)) {
            return credential;
        }
        PasswordCredential login = (PasswordCredential)credential;
        String dn = login.getUserName();
        return dn.equals(normDN = JNDIConnectionFactoryConfiguration.normalizeDN(dn)) ? login : new PasswordCredential(normDN, login.getPassword(), login.getDomain());
    }

    @Override
    protected Object authenticate(Credential credential) throws ConnectionFactoryException {
        if (!(credential instanceof PasswordCredential)) {
            throw new IllegalArgumentException("\"credential\" must be an instance of PasswordCredential.");
        }
        PasswordCredential login = (PasswordCredential)credential;
        Hashtable env = this.cxfConfig.getEnv();
        Hashtable<String, String> authEnv = new Hashtable<String, String>();
        authEnv.put("java.naming.security.principal", login.getUserName());
        authEnv.put("java.naming.security.credentials", login.getPassword());
        authEnv.put("java.naming.security.authentication", "simple");
        authEnv.put("java.naming.provider.url", (String)env.get("java.naming.provider.url"));
        authEnv.put("java.naming.factory.initial", (String)env.get("java.naming.factory.initial"));
        try {
            return new InitialDirContext(authEnv);
        }
        catch (NamingException ne) {
            return null;
        }
    }

    @Override
    protected boolean authorizeUser(Object identity, Puddle puddle) throws ConnectionFactoryException {
        try {
            Set users = puddle.getUsers();
            DirContext ctx = (DirContext)identity;
            Hashtable<?, ?> env = ctx.getEnvironment();
            String dn = (String)env.get("java.naming.security.principal");
            dn = JNDIConnectionFactoryConfiguration.normalizeDN(dn);
            if (users.contains(dn)) {
                return true;
            }
            String baseDN = this.findGroupBaseDN(dn);
            HashSet visitedGroups = new HashSet();
            return this.authorizeGroups(dn, baseDN, visitedGroups, users);
        }
        catch (NamingException ne) {
            throw new ConnectionFactoryException(ne);
        }
    }

    @Override
    protected void closeIdentity(Object identity) {
        if (identity != null) {
            try {
                ((DirContext)identity).close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private String findGroupBaseDN(String personDN) {
        if (this.namingContexts == null) {
            this.namingContexts = new HashSet();
            this.findNamingContexts();
        }
        for (String namingContext : this.namingContexts) {
            if (personDN.indexOf(namingContext) < 0) continue;
            return namingContext;
        }
        int length = personDN.length();
        int lastComma = personDN.lastIndexOf(44);
        if (lastComma <= 0 || lastComma + 1 == length) {
            return personDN;
        }
        int secondToLastComma = personDN.lastIndexOf(44, lastComma - 1);
        if (secondToLastComma < 0) {
            return personDN.substring(lastComma + 1);
        }
        return personDN.substring(secondToLastComma + 1);
    }

    private void findNamingContexts() {
        try {
            DirContext context = this.cxfConfig.getContext();
            NamingEnumeration<SearchResult> results = null;
            try {
                results = context.search("", "(objectclass=*)", objectScopedSearchControls);
            }
            catch (CommunicationException ce) {
                this.cxfConfig.reconnect(ce);
                context = this.cxfConfig.getContext();
                results = context.search("", "(objectclass=*)", objectScopedSearchControls);
            }
            while (results.hasMore()) {
                SearchResult result = results.next();
                Attributes resultAttrs = result.getAttributes();
                Attribute resultAttr = resultAttrs.get("namingContexts");
                if (resultAttr == null) continue;
                NamingEnumeration<?> values = resultAttr.getAll();
                while (values.hasMore()) {
                    String value = (String)values.next();
                    value = JNDIConnectionFactoryConfiguration.normalizeDN(value);
                    this.namingContexts.add(value);
                }
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private boolean authorizeGroups(String personDN, String groupBaseDN, Set visitedGroups, Set authorizedUserIdentities) throws ConnectionFactoryException {
        try {
            DirContext context = this.cxfConfig.getContext();
            StringBuffer buffer = new StringBuffer(128);
            buffer.append("(|(uniquemember=").append(personDN).append(")(member=");
            String filter = buffer.append(personDN).append("))").toString();
            buffer.setLength(0);
            NamingEnumeration<SearchResult> results = null;
            try {
                results = context.search(groupBaseDN, filter, treeScopedSearchControls);
            }
            catch (CommunicationException ce) {
                this.cxfConfig.reconnect(ce);
                context = this.cxfConfig.getContext();
                results = context.search(groupBaseDN, filter, treeScopedSearchControls);
            }
            while (results.hasMore()) {
                SearchResult result = results.next();
                buffer.append(result.getName()).append(",").append(groupBaseDN);
                String groupDN = JNDIConnectionFactoryConfiguration.normalizeDN(buffer.toString());
                buffer.setLength(0);
                if (authorizedUserIdentities.contains(groupDN)) {
                    return true;
                }
                if (!visitedGroups.add(groupDN)) continue;
                if (this.authorizeGroups(groupDN, groupBaseDN, visitedGroups, authorizedUserIdentities)) {
                    // empty if block
                }
                return true;
            }
        }
        catch (NamingException e) {
            throw new ConnectionFactoryException(e);
        }
        return false;
    }

    static {
        objectScopedSearchControls = new SearchControls();
        objectScopedSearchControls.setSearchScope(0);
        treeScopedSearchControls = new SearchControls();
        treeScopedSearchControls.setSearchScope(2);
    }
}

