/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.services.connection.HostPortPair;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class HostPortSet
extends LinkedHashSet<HostPortPair> {
    private static final long serialVersionUID = 1L;

    public static HostPortSet newInstance(String hostProperty, String portProperty) {
        HostPortSet nodes;
        block10: {
            if (hostProperty == null || hostProperty.isEmpty()) {
                throw new IllegalArgumentException("Host list is empty.");
            }
            if (portProperty == null || portProperty.isEmpty()) {
                throw new IllegalArgumentException("Port list is empty.");
            }
            nodes = new HostPortSet();
            String[] hostArray = hostProperty.split("\\s+");
            String[] portArray = portProperty.split("\\s+");
            try {
                if (hostArray.length == portArray.length) {
                    int len = hostArray.length;
                    for (int index = 0; index < len; ++index) {
                        nodes.add(new HostPortPair(hostArray[index], Integer.parseInt(portArray[index])));
                    }
                    break block10;
                }
                if (portArray.length == 1) {
                    int len = hostArray.length;
                    for (int index = 0; index < len; ++index) {
                        nodes.add(new HostPortPair(hostArray[index], Integer.parseInt(portArray[0])));
                    }
                    break block10;
                }
                if (hostArray.length == 1) {
                    int len = portArray.length;
                    for (int index = 0; index < len; ++index) {
                        nodes.add(new HostPortPair(hostArray[0], Integer.parseInt(portArray[index])));
                    }
                    break block10;
                }
                throw new IllegalArgumentException("Host and port lists do not match.");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("\"" + portProperty + "\" is not a valid port list.");
            }
        }
        return nodes;
    }

    public String getHosts() {
        StringBuilder sbHost = new StringBuilder();
        String firstHost = null;
        boolean allHostsMatch = true;
        for (HostPortPair pair : this) {
            if (firstHost == null) {
                firstHost = pair.getHost();
            } else {
                sbHost.append(" ");
                allHostsMatch = allHostsMatch && pair.getHost().equalsIgnoreCase(firstHost);
            }
            sbHost.append(pair.getHost());
        }
        if (allHostsMatch) {
            return firstHost;
        }
        return sbHost.toString();
    }

    public String getPorts() {
        StringBuilder sbPort = new StringBuilder();
        int firstPort = -1;
        boolean allPortsMatch = true;
        for (HostPortPair pair : this) {
            if (firstPort == -1) {
                firstPort = pair.getPort();
            } else {
                sbPort.append(" ");
                allPortsMatch = allPortsMatch && pair.getPort() == firstPort;
            }
            sbPort.append(Integer.toString(pair.getPort()));
        }
        if (allPortsMatch) {
            return Integer.toString(firstPort);
        }
        return sbPort.toString();
    }

    public boolean intersects(HostPortSet set) {
        HostPortSet smaller = set;
        HostPortSet larger = this;
        if (this.size() < set.size()) {
            smaller = this;
            larger = set;
        }
        for (HostPortPair pair : smaller) {
            if (!larger.contains(pair)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        Iterator iterator;
        if (this.size() == 1 && (iterator = this.iterator()).hasNext()) {
            HostPortPair node = (HostPortPair)iterator.next();
            return node.toString();
        }
        StringBuffer buf = new StringBuffer("{");
        boolean first = true;
        for (HostPortPair node : this) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append("(");
            buf.append(node.toString());
            buf.append(")");
        }
        buf.append("}");
        return buf.toString();
    }
}

