/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.SASScope;
import com.sas.services.connection.ConnectionEnvelope;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionInterface;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.ObjectImpl;

@SASScope
public class ConnectionImpl
implements ConnectionInterface {
    private ConnectionEnvelope _cxEnv;
    private ConnectionFactoryKernel _kernel;
    private int _clientNumber;
    private String _connectionID;

    protected ConnectionImpl(ConnectionEnvelope cxEnv, ConnectionFactoryKernel kernel, int clientNumber) {
        this._cxEnv = cxEnv;
        this._kernel = kernel;
        this._clientNumber = clientNumber;
        this._connectionID = cxEnv.getConnectionID();
    }

    @Override
    public Object getObject() {
        ConnectionEnvelope myEnv = this.getHandle();
        return myEnv.getUserObject();
    }

    @Override
    public void generatePassword(String userName, StringHolder qualUserNameHolder, StringHolder genPasswordHolder) throws ConnectionFactoryException {
        ConnectionEnvelope myEnv = this.getHandle();
        ObjectImpl objImpl = (ObjectImpl)myEnv.getUserObject();
        Request request = objImpl._request("_generate_password");
        Any _userName = request.add_in_arg();
        _userName.insert_string(userName);
        Any _qualUserName = request.add_out_arg();
        _qualUserName.type(objImpl._orb().get_primitive_tc(TCKind.tk_string));
        Any _genPassword = request.add_out_arg();
        _genPassword.type(objImpl._orb().get_primitive_tc(TCKind.tk_string));
        try {
            request.invoke();
        }
        catch (SystemException se) {
            throw new ConnectionFactoryException(se);
        }
        qualUserNameHolder.value = _qualUserName.extract_string();
        genPasswordHolder.value = _genPassword.extract_string();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ConnectionEnvelope myEnv = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this._cxEnv == null) {
                return;
            }
            myEnv = this._cxEnv;
            this._cxEnv = null;
        }
        this._kernel.reactivateConnection(myEnv, this._clientNumber, 0);
    }

    public String toString() {
        String className = this.getClass().getName();
        int classNameL = className.length();
        int connectionIDL = this._connectionID.length();
        int bufL = classNameL + connectionIDL;
        StringBuffer buf = new StringBuffer(bufL);
        buf.append(className).append(this._connectionID);
        String str = buf.toString();
        return str;
    }

    protected synchronized ConnectionEnvelope getHandle() {
        this.checkHandle();
        return this._cxEnv;
    }

    protected ConnectionFactoryKernel getKernel() {
        return this._kernel;
    }

    protected void finalize() throws Throwable {
        try {
            if (this._cxEnv == null) {
                return;
            }
            try {
                this._kernel.reactivateConnection(this._cxEnv, this._clientNumber, 1);
            }
            finally {
                this._cxEnv = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    private void checkHandle() {
        if (this._cxEnv == null) {
            throw new IllegalStateException("This connection handle has been closed.");
        }
    }
}

