/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb.brg;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.AnyImpl;
import com.sas.iom.orb.brg.Conversation;
import com.sas.iom.orb.brg.Marshaller;
import com.sas.iom.orb.brg.OutboundPacket;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.omg.CORBA.IntHolder;

@SASScope
public final class Marshaller0100
extends Marshaller {
    private static final double timeConversionFactor = 1.19036736E10;

    protected Marshaller0100() {
    }

    @Override
    protected void calculateParameterArraySize(Conversation conversation, OutboundPacket packet, IntHolder mapCountHolder, IntHolder dataSizeHolder, List stringList) {
        AnyImpl[] parmArray = packet.getParameterArray();
        if (parmArray != null) {
            int type = packet.getType();
            int methodID = packet.getMethodId();
            for (int i = 0; i < parmArray.length; ++i) {
                AnyImpl parm = parmArray[i];
                int iomType = parm.iomType();
                if (type == 0 && methodID == 1 && iomType == 4) {
                    byte[] d = (byte[])parm.extractIOM();
                    this.calculateWZXOctet1dArrayNTSize(conversation, d, mapCountHolder, dataSizeHolder);
                    continue;
                }
                this.calculateParameterSize(conversation, parm, mapCountHolder, dataSizeHolder, stringList);
            }
        }
    }

    @Override
    protected void marshalParameterArray(Conversation conversation, OutboundPacket packet, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        AnyImpl[] parmArray = packet.getParameterArray();
        List stringLst = packet.getEncodedStringLst();
        Iterator stringItr = stringLst.iterator();
        int type = packet.getType();
        int methodID = packet.getMethodId();
        for (int i = 0; i < parmArray.length; ++i) {
            AnyImpl parm = parmArray[i];
            int iomType = parm.iomType();
            if (type == 0 && methodID == 1 && iomType == 4) {
                byte[] d = (byte[])parm.extractIOM();
                this.marshalWZXOctet1dArrayNT(conversation, d, mapBuf, dataBuf);
                continue;
            }
            this.marshalParameter(conversation, parm, mapBuf, dataBuf, stringItr);
        }
    }

    @Override
    protected void marshalDatetime(Conversation conversation, long d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        double s = Marshaller0100.corbaToSas(d);
        this.marshalDouble(conversation, s, mapBuf, dataBuf);
    }

    @Override
    protected void marshalDatetime1dArray(Conversation conversation, long[] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        this.marshalShort(conversation, (short)1, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong(conversation, d.length, mapBuf, dataBuf);
        if (d.length > 0) {
            Marshaller0100.marshalMaps(0x5000000, d.length, mapBuf);
            for (int i = 0; i < d.length; ++i) {
                double s = Marshaller0100.corbaToSas(d[i]);
                dataBuf.putDouble(s);
            }
        }
    }

    @Override
    protected void marshalDatetime2dArray(Conversation conversation, long[][] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int l0 = d.length;
        int l1 = l0 > 0 ? d[0].length : 0;
        int l = l0 * l1;
        this.marshalShort(conversation, (short)2, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong1dArray2Elements(conversation, l0, l1, mapBuf, dataBuf);
        if (l > 0) {
            Marshaller0100.marshalMaps(0x5000000, l, mapBuf);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    double s = Marshaller0100.corbaToSas(d[i0][i1]);
                    dataBuf.putDouble(s);
                }
            }
        }
    }

    @Override
    protected long unmarshalDatetime(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        double s = this.unmarshalDouble(conversation, mapBuf, dataBuf);
        return Marshaller0100.sasToCorba(s);
    }

    @Override
    protected long[] unmarshalDatetime1dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller0100.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        Marshaller0100.unmarshalMaps(conversation, mapBuf, 0x1400000, 1);
        dataBuf.getShort();
        int l = dataBuf.getInt();
        long[] d = new long[l];
        if (l > 0) {
            Marshaller0100.unmarshalMaps(conversation, mapBuf, 0x5000000, l);
            for (int i = 0; i < l; ++i) {
                double s = dataBuf.getDouble();
                d[i] = Marshaller0100.sasToCorba(s);
            }
        }
        return d;
    }

    @Override
    protected long[][] unmarshalDatetime2dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller0100.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        Marshaller0100.unmarshalMaps(conversation, mapBuf, 0x1400000, 2);
        dataBuf.getShort();
        int l0 = dataBuf.getInt();
        int l1 = dataBuf.getInt();
        int l = l0 * l1;
        long[][] d = new long[l0][l1];
        if (l > 0) {
            Marshaller0100.unmarshalMaps(conversation, mapBuf, 0x5000000, l);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    double s = dataBuf.getDouble();
                    d[i0][i1] = Marshaller0100.sasToCorba(s);
                }
            }
        }
        return d;
    }

    private static double corbaToSas(long corba) {
        double corbaInSecs = (double)corba / 1.0E7;
        double sasTime = corbaInSecs - 1.19036736E10;
        return sasTime;
    }

    private static long sasToCorba(double sas) {
        double corbaInSecs = sas + 1.19036736E10;
        long corbaTime = (long)(corbaInSecs * 1.0E7);
        return corbaTime;
    }
}

