/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.CP_ID;
import com.sas.iom.orb.UUIDConverter;
import java.util.Arrays;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class CP_IDConverter {
    private CP_IDConverter() {
    }

    public static String cp_idToString(CP_ID cpid) {
        int i;
        StringBuffer buf = new StringBuffer(36);
        UUIDConverter.dataToString(cpid.Data1, 8, buf);
        buf.append("-");
        UUIDConverter.dataToString(cpid.Data2, 4, buf);
        buf.append("-");
        UUIDConverter.dataToString(cpid.Data3, 4, buf);
        buf.append("-");
        for (i = 0; i < 2; ++i) {
            UUIDConverter.dataToString(cpid.Data4[i], 2, buf);
        }
        buf.append("-");
        for (i = 2; i < 8; ++i) {
            UUIDConverter.dataToString(cpid.Data4[i], 2, buf);
        }
        String s = buf.toString();
        return s;
    }

    public static CP_ID stringToCP_ID(String str) {
        int i;
        if (str.startsWith("DCE:") && str.length() > 40) {
            str = str.substring(4, 40);
        }
        int d1 = (int)Long.parseLong(str.substring(0, 8), 16);
        short d2 = (short)Long.parseLong(str.substring(9, 13), 16);
        short d3 = (short)Long.parseLong(str.substring(14, 18), 16);
        byte[] d4 = new byte[8];
        for (i = 0; i < 2; ++i) {
            d4[i] = (byte)Long.parseLong(str.substring(i * 2 + 19, i * 2 + 21), 16);
        }
        for (i = 2; i < 8; ++i) {
            d4[i] = (byte)Long.parseLong(str.substring(i * 2 + 20, i * 2 + 22), 16);
        }
        CP_ID cpid = new CP_ID(d1, d2, d3, d4);
        return cpid;
    }

    public static boolean equals(CP_ID cp_id1, CP_ID cp_id2) {
        if (cp_id1 == cp_id2) {
            return true;
        }
        if (cp_id1 == null || cp_id2 == null) {
            return false;
        }
        if (cp_id1.Data1 != cp_id2.Data1) {
            return false;
        }
        if (cp_id1.Data2 != cp_id2.Data2) {
            return false;
        }
        if (cp_id1.Data3 != cp_id2.Data3) {
            return false;
        }
        return Arrays.equals(cp_id1.Data4, cp_id2.Data4);
    }
}

