/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.WorkspacePool;
import com.sas.services.connection.ConnectionInterface;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class WorkspaceConnector {
    private WorkspacePool pool = null;
    private ConnectionInterface cx = null;
    private IWorkspace iWorkspace = null;
    private boolean closed = false;

    @SASScope
    protected WorkspaceConnector(WorkspacePool pool, ConnectionInterface cx, IWorkspace iWorkspace) {
        this.pool = pool;
        this.cx = cx;
        this.iWorkspace = iWorkspace;
    }

    public synchronized IWorkspace getWorkspace() {
        return this.iWorkspace;
    }

    public synchronized void close() {
        if (!this.closed) {
            this.cx.close();
            this.closed = true;
            this.pool.removeConnector(this);
        }
    }

    @SASScope
    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                this.pool.removeConnector(this);
            }
        }
        finally {
            super.finalize();
        }
    }
}

