/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.user;

import com.sas.services.InitializationException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import java.rmi.RemoteException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class UserFactory {
    private static final Logger LOGGER = LogManager.getLogger(UserFactory.class);
    private UserServiceInterface userService;
    private SessionServiceInterface sessionService;
    private UserContextInterface securedUser;
    private Properties users;
    private static final String PUBLISH_USER = "publish.user";
    private static final String METADATA_USER = "metadata.user";
    private static final String JDBC_USER = "jdbc.user";
    private static final String ROLE_USER = "role.user";

    public void setUserService(UserServiceInterface u) {
        this.userService = u;
    }

    public void setSessionService(SessionServiceInterface s) {
        this.sessionService = s;
    }

    public void setUser(UserContextInterface u) {
        this.securedUser = u;
    }

    public void setUsers(Properties u) {
        this.users = u;
    }

    public UserContextInterface getMetadataUser() {
        return this.getUser(this.getUserName(METADATA_USER));
    }

    public UserContextInterface getPublishUser() {
        return this.getUser(this.getUserName(PUBLISH_USER));
    }

    public UserContextInterface getRoleUser() {
        return this.getUser(this.getUserName(ROLE_USER));
    }

    public UserContextInterface getJdbcUser() {
        return this.getUser(this.getUserName(JDBC_USER));
    }

    public UserContextInterface getUser(String name) {
        try {
            UserContextInterface user = this.userService.getUser(this.securedUser, name);
            if (null == user) {
                throw new IllegalStateException("Unable to retrieve requested user, " + name + ". Is one defined in the remote UserService with the required name?");
            }
            SessionContextInterface session = user.getSessionContext();
            if (null == session) {
                this.sessionService.newSessionContext(user);
            }
            return user;
        }
        catch (RemoteException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Error retrieving user: " + name);
        }
        catch (InitializationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Error retrieve user: " + name + ". Unable to create session context.");
        }
    }

    private String getUserName(String name) {
        return this.users.getProperty(name);
    }
}

