/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.themes.dao.registry;

import com.sas.framework.services.metadata.BaseAssociationFilter;
import com.sas.framework.themes.dao.registry.ThemeRegistrationDAOInterface;
import com.sas.services.information.Filter;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.config.client.ApplicationRegistration;
import com.sas.util.UsageVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetadataThemeRegistrationDAO
implements ThemeRegistrationDAOInterface {
    private static final Logger LOGGER = LogManager.getLogger(MetadataThemeRegistrationDAO.class);
    private static final String TCPIP_INTERNAL = "Internal Subnet";
    private static final String TCPIP_EXTERNAL = "External URI";
    private InformationServiceInterface info;
    private UserContextInterface user;
    private List<String> protocols = Collections.singletonList("omi");
    private static Map<String, ApplicationRegistration> map = new HashMap<String, ApplicationRegistration>();
    private static final UsageVersion VERSION = new UsageVersion(1, 0);
    private static final String TEMPLATE = "<Templates><DeployedComponent Name=\"\"><DescriptiveComponent/><SourceConnections search=\"@Name='Connection URI' or @Name='External URI' or @Name='Internal Subnet'\"/></DeployedComponent><SoftwareComponent Name=\"\"/><TCPIPConnection CommunicationProtocol=\"\" HostName=\"\" Port=\"\" Service=\"\" /></Templates>";
    private static final String XML_SELECT = "<XMLSelect search=\"DeployedComponent[@Name='SAS Presentation Theme'][DescriptiveComponent/SoftwareComponent[@UsageVersion='" + VERSION.encode() + "' or @UsageVersion='0.0']]\"/>";

    public void setProtocols(List<String> p) {
        this.protocols = new ArrayList<String>(this.protocols);
        for (String protocol : p) {
            if (this.protocols.contains(protocol)) continue;
            this.protocols.add(protocol);
        }
    }

    public void setInformationService(InformationServiceInterface service) {
        this.info = service;
    }

    public void setUser(UserContextInterface service) {
        this.user = service;
    }

    public void reload() {
        this.init();
    }

    public void init() {
        BaseAssociationFilter filter = new BaseAssociationFilter();
        filter.setXMLSelect(XML_SELECT);
        filter.setOMRTemplate(TEMPLATE);
        filter.setOMRFlags(0x200 | filter.getOMRFlags());
        filter.setType("DeployedComponent");
        try {
            List list = this.info.browseSearchProtocols(this.user, this.protocols, (Filter)filter);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ApplicationRegistration r = new ApplicationRegistration();
                BrowseMetadataInterface dc = (BrowseMetadataInterface)it.next();
                BrowseMetadataInterface sc = this.getFirstElement(dc, "DescriptiveComponent");
                List connections = (List)dc.get("SourceConnections");
                for (BrowseMetadataInterface con : connections) {
                    if (TCPIP_INTERNAL.equals(con.getName())) {
                        r.setSubnet(this.getAttribute(con, "HostName"));
                        continue;
                    }
                    if (TCPIP_EXTERNAL.equals(con.getName())) {
                        r.setExternalProtocol(this.getAttribute(con, "CommunicationProtocol"));
                        r.setExternalHost(this.getHost(con));
                        r.setExternalPort(this.getPort(con));
                        r.setExternalContext(this.getAttribute(con, "Service"));
                        continue;
                    }
                    r.setProtocol(this.getAttribute(con, "CommunicationProtocol"));
                    r.setHost(this.getHost(con));
                    r.setPort(this.getPort(con));
                    r.setContext(this.getAttribute(con, "Service"));
                }
                String name = sc.getName();
                r.setName(name);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Processed theme registration for '" + name + "'.");
                }
                map.put(name, r);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize themes.", e);
        }
    }

    private String getHost(BrowseMetadataInterface con) {
        String host = System.getProperty("sas.theme.host");
        if (null == host) {
            host = this.getAttribute(con, "HostName");
        }
        return host;
    }

    private int getPort(BrowseMetadataInterface con) {
        String port = System.getProperty("sas.theme.port");
        if (null == port) {
            port = this.getAttribute(con, "Port");
        }
        return Integer.parseInt(port);
    }

    private String getAttribute(BrowseMetadataInterface bmi, String name) {
        return (String)bmi.get(name);
    }

    private BrowseMetadataInterface getFirstElement(BrowseMetadataInterface bmi, String name) {
        List list = (List)bmi.get(name);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return (BrowseMetadataInterface)list.get(0);
    }

    public ApplicationRegistration getTheme(String name) {
        return map.get(name);
    }

    public List<ApplicationRegistration> getAllThemes() {
        ArrayList<ApplicationRegistration> list = new ArrayList<ApplicationRegistration>();
        for (Map.Entry<String, ApplicationRegistration> entry : map.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }
}

