/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.remoting;

import com.sas.framework.services.remoting.ReachabilityChecker;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EndpointLocator {
    private static final Logger logger = LogManager.getLogger(EndpointLocator.class);
    private static final String OMI_PROTOCOL = "omi";
    private static List<String> PROTOCOLS = Arrays.asList("omi");
    private static final String SOAP_SERVICE_CONTEXT_PATH = "services/";
    private static final String CLIENT_ACCESS_SERVICE_CONTEXT_PATH = "remote/";
    private static final String TREE_NAME = "Registered SAS Services";
    private static final String SERVICE_NAME = "ServiceRegistry";
    private static final String INTERNAL_CONNECTION_NAME = "Connection URI";
    private static final String EXTERNAL_CONNECTION_NAME = "External URI";
    private static final String DEPLOYED_COMPONENTS_NAME = "Registered SAS Application";
    private static final String APP_CONFIG_SET_NAME = "Application Configuration";
    private static final String SOFTWARE_COMPONENT_SOAP_SVCS = "Web Infra Platfrm Soap Svcs";
    private static final String SOFTWARE_COMPONENT_CLIENT_ACCESS = "Web Infra Platfrm ClntAccss";
    private static final String SERVICE_REGISTRY_SEARCH = "<XMLSelect search=\"Tree[@Name='Registered SAS Services']\" />";
    private static final String SERVICE_REGISTRY_TEMPLATE = "<Templates><Tree Id=\"\" Name=\"\"><Members search=\"@Name='ServiceRegistry'\"/></Tree><DeployedComponent Id=\"\" Name=\"\"><DescriptiveComponent/><SourceConnections search=\"@Name='Connection URI' or @Name='External URI'\"/><Properties/><PropertySets search=\"@Name='Application Configuration'\"/><Keywords/></DeployedComponent><SoftwareComponent Name=\"\"><DeployedComponents search=\"@Name='Registered SAS Application'\"/><Properties/></SoftwareComponent><TCPIPConnection Name=\"\" CommunicationProtocol=\"\" HostName=\"\" Port=\"\" Service=\"\"/><Property Name=\"\" PropertyName=\"\" DefaultValue=\"\"/><PropertySet><SetProperties/></PropertySet></Templates>";

    @Deprecated
    public static String getSoapRegistryUrl(InformationServiceInterface infoService, UserContextInterface userContext) throws RemoteException, ServiceException {
        try {
            return EndpointLocator.getURLHelper(infoService, userContext, SOFTWARE_COMPONENT_SOAP_SVCS, SOAP_SERVICE_CONTEXT_PATH);
        }
        catch (ServiceConfigurationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String getServiceRegistryUrl(UserContextInterface userContext) throws RemoteException, ServiceException {
        try {
            return EndpointLocator.getURLHelper(null, userContext, SOFTWARE_COMPONENT_CLIENT_ACCESS, CLIENT_ACCESS_SERVICE_CONTEXT_PATH);
        }
        catch (ServiceConfigurationException serviceConfigurationException) {
            return null;
        }
    }

    private static String getURLHelper(InformationServiceInterface infoService, UserContextInterface userContext, String softwareCompName, String contextPath) throws RemoteException, ServiceException, ServiceConfigurationException {
        String url = EndpointLocator.getURLHelper(infoService, userContext, softwareCompName, contextPath, INTERNAL_CONNECTION_NAME);
        if (ReachabilityChecker.isReachable(url)) {
            return url;
        }
        url = EndpointLocator.getURLHelper(infoService, userContext, softwareCompName, contextPath, EXTERNAL_CONNECTION_NAME);
        if (ReachabilityChecker.isReachable(url)) {
            return url;
        }
        throw new ServiceConfigurationException("Neither internal nor external connections were reachable");
    }

    private static String getURLHelper(InformationServiceInterface infoService, UserContextInterface userContext, String softwareCompName, String contextPath, String connectionName) throws RemoteException, ServiceException, ServiceConfigurationException {
        String url = null;
        Filter filter = new Filter();
        filter.setExplicitSearchString(OMI_PROTOCOL, SERVICE_REGISTRY_SEARCH);
        filter.setOMRTemplate(SERVICE_REGISTRY_TEMPLATE);
        filter.setOMRFlags(512);
        List results = infoService != null ? infoService.browseSearchProtocols(userContext, PROTOCOLS, filter) : userContext.getAuthServer().browseSearch((FilterInterface)filter);
        if (results.isEmpty()) {
            String message = "No results from metadata query";
            logger.info("No results from metadata query");
            throw new ServiceConfigurationException("No results from metadata query");
        }
        BrowseMetadataInterface tree = (BrowseMetadataInterface)results.get(0);
        for (BrowseMetadataInterface deployedComp : tree.getMembers()) {
            BrowseMetadataInterface soapServices = EndpointLocator.getAssocObj(deployedComp, "DescriptiveComponent", softwareCompName);
            if (soapServices == null) continue;
            BrowseMetadataInterface regSASApp = EndpointLocator.getAssocObj(soapServices, "DeployedComponents", DEPLOYED_COMPONENTS_NAME);
            if (regSASApp == null) {
                String message = "Registered SAS Application not found";
                logger.info("Registered SAS Application not found");
                throw new ServiceConfigurationException("Registered SAS Application not found");
            }
            BrowseMetadataInterface connectionURI = EndpointLocator.getAssocObj(regSASApp, "SourceConnections", connectionName);
            if (connectionURI == null) {
                String message = connectionName + " not found";
                logger.info(message);
                throw new ServiceConfigurationException(message);
            }
            url = EndpointLocator.buildUrl(connectionURI, contextPath);
        }
        if (url == null) {
            String message = softwareCompName + " not found";
            logger.info(message);
            throw new ServiceConfigurationException(message);
        }
        return url;
    }

    private static String buildUrl(BrowseMetadataInterface connectionURI, String contextPath) {
        StringBuffer url = new StringBuffer();
        String protocol = (String)connectionURI.get("CommunicationProtocol");
        url.append(protocol);
        url.append("://");
        String host = (String)connectionURI.get("HostName");
        url.append(host);
        url.append(":");
        String portStr = (String)connectionURI.get("Port");
        int port = portStr != null && !portStr.equals("") ? Integer.parseInt(portStr) : ("https".equals(protocol) ? 443 : 80);
        url.append(Integer.toString(port));
        String context = (String)connectionURI.get("Service");
        if (context.length() == 0 || context.charAt(0) != '/') {
            url.append("/");
        }
        url.append(context);
        if (!context.endsWith("/")) {
            url.append("/");
        }
        url.append(contextPath);
        url.append(SERVICE_NAME);
        return url.toString();
    }

    private static BrowseMetadataInterface getAssocObj(BrowseMetadataInterface bmi, String assocName, String objName) {
        List assocList = (List)bmi.get(assocName);
        if (assocList != null) {
            for (BrowseMetadataInterface assocBmi : assocList) {
                if (!assocBmi.getName().contains(objName)) continue;
                return assocBmi;
            }
        }
        return null;
    }

    private static class ServiceConfigurationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ServiceConfigurationException(String message) {
            super(message);
        }
    }
}

