/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.config.dao;

import com.sas.framework.services.config.dao.PropertySetDataSource;
import com.sas.framework.services.config.dao.PropertySetDatabaseDAO;
import com.sas.framework.services.config.dao.PropertySetInterface;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class PropertySetFactoryBean
implements FactoryBean<Properties>,
InitializingBean {
    private PropertySetInterface _dao;
    private DataSource _dataSource;

    public Properties getObject() {
        Map<String, String> map = this._dao.getPropertyMap("Environment.Properties");
        Properties properties = new Properties();
        properties.putAll(map);
        return properties;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setPropertySetDAO(PropertySetInterface dao) {
        this._dao = dao;
    }

    public Class<Properties> getObjectType() {
        return Properties.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        if (null == this._dao) {
            if (null == this._dataSource) {
                throw new IllegalStateException("Property 'dataSource' or 'propertySetDAO' must be specified.");
            }
            PropertySetDataSource propertySetDataSource = new PropertySetDataSource();
            propertySetDataSource.setDataSource(this._dataSource);
            PropertySetDatabaseDAO dao = new PropertySetDatabaseDAO();
            dao.setDataSource(propertySetDataSource);
            this._dao = dao;
        }
    }
}

