/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.config.dao;

import com.sas.framework.services.config.dao.AppProperty;
import com.sas.framework.services.config.dao.PropertySetAdminInterface;
import com.sas.framework.services.config.dao.PropertySetDatabaseAdminDAO;
import com.sas.svcs.data.vendor.DatabaseVendor;
import com.sas.util.Strings;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public class PropertySetDataSource
implements DataSource,
InitializingBean,
ApplicationContextAware {
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(PropertySetDataSource.class);
    private ApplicationContext _applicationContext;
    private DataSource _dataSource;
    private DatabaseVendor _databaseVendor;
    private boolean _isInitialized;
    private final Object _syncObject = new Object();
    private PropertySetAdminInterface _sourcePropertySetDAO;
    private String _propertySetName = "Environment.Properties";
    private String _eventKey = "/sas/properties/environment";
    private String _changeFlagPropertyName = "properties.change.flag";
    private int _minConnections = 1;
    private boolean _isPublishAppContextEvent;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this._applicationContext = applicationContext;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setIsPublishAppContextEvent(boolean isPublishAppContextEvent) {
        this._isPublishAppContextEvent = isPublishAppContextEvent;
    }

    public void setMinConnections(int minConnections) {
        this._minConnections = minConnections;
    }

    public String getPropertySetName() {
        return this._propertySetName;
    }

    public void setPropertySetName(String propertySetName) {
        this._propertySetName = propertySetName;
    }

    public void setChangeFlagName(String changeFlagName) {
        this._changeFlagPropertyName = changeFlagName;
    }

    public String getChangeFlagName() {
        return this._changeFlagPropertyName;
    }

    public void setPropertySetSourceDAO(PropertySetAdminInterface propertySetDAO) {
        this._sourcePropertySetDAO = propertySetDAO;
    }

    public void setEventKey(String eventKey) {
        this._eventKey = null == eventKey || 0 == eventKey.trim().length() ? null : eventKey;
    }

    public String getEventKey() {
        return this._eventKey;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = this._dataSource.getConnection();
        this.initialize();
        return connection;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection connection = this._dataSource.getConnection(username, password);
        this.initialize();
        return connection;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this._dataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this._dataSource.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this._dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this._dataSource.setLoginTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = this._syncObject;
        synchronized (object) {
            if (!this._isInitialized) {
                String propertyValueIsChangeFlag;
                this._isInitialized = true;
                boolean isDebugLog = LOGGER.isDebugEnabled();
                boolean hasSourceDAO = this._sourcePropertySetDAO != null;
                PropertySetDatabaseAdminDAO propertySetDAO = new PropertySetDatabaseAdminDAO();
                propertySetDAO.setDatabaseVendor(this._databaseVendor);
                propertySetDAO.setDataSource(this._dataSource);
                PropertySetAdminInterface sourcePropertySetDAO = hasSourceDAO ? this._sourcePropertySetDAO : propertySetDAO;
                Map<String, String> propertiesMap = sourcePropertySetDAO.getPropertyMap(this._propertySetName);
                if (this._isPublishAppContextEvent) {
                    PropertySetDataSource.publishApplicationContextEvent(this._propertySetName, this._applicationContext, this._eventKey, propertiesMap);
                }
                if (Boolean.parseBoolean(propertyValueIsChangeFlag = propertiesMap.get(this._changeFlagPropertyName))) {
                    if (isDebugLog) {
                        LOGGER.debug("Change detected for property set '" + this._propertySetName + "'.");
                    }
                    PropertySetDataSource.updatePropertyValue(sourcePropertySetDAO, new AppProperty(this._propertySetName, this._changeFlagPropertyName, Boolean.FALSE.toString()));
                    propertiesMap.put(this._changeFlagPropertyName, Boolean.FALSE.toString());
                }
                if (!propertySetDAO.equals(sourcePropertySetDAO)) {
                    List<AppProperty> appProperties;
                    Map<String, String> propertiesMap2 = propertySetDAO.getPropertyMap(this._propertySetName);
                    List<AppProperty> updateAppProperties = PropertySetDataSource.getUpdateProperties(this._propertySetName, propertiesMap, propertiesMap2);
                    if (0 < updateAppProperties.size()) {
                        propertySetDAO.updateProperties(updateAppProperties);
                    }
                    if (0 < (appProperties = PropertySetDataSource.getNewProperties(this._propertySetName, propertiesMap, propertiesMap2)).size()) {
                        propertySetDAO.addProperties(appProperties);
                    }
                }
            }
        }
    }

    public void afterPropertiesSet() {
        if (null == this._dataSource) {
            throw new IllegalStateException("Property 'dataSource' must be set.");
        }
        for (int i = 0; i < this._minConnections; ++i) {
            try {
                this.getConnection();
                continue;
            }
            catch (SQLException e) {
                throw new IllegalStateException("Unable to get database connection.", e);
            }
        }
    }

    private static List<AppProperty> getNewProperties(String propertySetName, Map<String, String> propertiesMap1, Map<String, String> propertiesMap2) {
        List<AppProperty> appProperties = null;
        HashMap<String, String> propertiesMap = new HashMap<String, String>(propertiesMap1.size());
        for (Map.Entry<String, String> mapEntry : propertiesMap1.entrySet()) {
            String key = mapEntry.getKey();
            if (propertiesMap2.containsKey(key)) continue;
            propertiesMap.put(key, mapEntry.getValue());
        }
        int numProperties = propertiesMap.size();
        if (0 < numProperties) {
            appProperties = new ArrayList<AppProperty>(numProperties);
            for (Map.Entry mapEntry : propertiesMap.entrySet()) {
                AppProperty appProperty = new AppProperty();
                appProperty.setPropertySetName(propertySetName);
                appProperty.setName((String)mapEntry.getKey());
                appProperty.setValue((String)mapEntry.getValue());
                appProperties.add(appProperty);
            }
        }
        if (null == appProperties) {
            appProperties = Collections.emptyList();
        }
        return appProperties;
    }

    private static List<AppProperty> getUpdateProperties(String propertySetName, Map<String, String> propertiesMap1, Map<String, String> propertiesMap2) {
        List<AppProperty> appProperties = null;
        if (0 < propertiesMap2.size()) {
            HashMap<String, String> propertiesMap = new HashMap<String, String>(propertiesMap1.size());
            for (Map.Entry<String, String> mapEntry : propertiesMap1.entrySet()) {
                String key = mapEntry.getKey();
                String value = mapEntry.getValue();
                if (!propertiesMap2.containsKey(key) || Strings.equal((String)value, (String)propertiesMap2.get(key), (boolean)false, (boolean)false)) continue;
                propertiesMap.put(key, value);
            }
            int numProperties = propertiesMap.size();
            if (0 < propertiesMap.size()) {
                appProperties = new ArrayList<AppProperty>(numProperties);
                for (Map.Entry mapEntry : propertiesMap.entrySet()) {
                    AppProperty appProperty = new AppProperty();
                    appProperty.setPropertySetName(propertySetName);
                    appProperty.setName((String)mapEntry.getKey());
                    appProperty.setValue((String)mapEntry.getValue());
                    appProperties.add(appProperty);
                }
            }
        }
        if (null == appProperties) {
            appProperties = Collections.emptyList();
        }
        return appProperties;
    }

    private static boolean updatePropertyValue(PropertySetAdminInterface propertySetDAO, AppProperty appProperty) {
        boolean isDebugLog = LOGGER.isDebugEnabled();
        boolean wasUpdated = propertySetDAO.updateProperty(appProperty);
        if (isDebugLog) {
            LOGGER.debug("Property '" + appProperty.getName() + "' has been updated.");
        }
        return wasUpdated;
    }

    private static boolean publishApplicationContextEvent(String propertySetName, ApplicationContext applicationContext, String eventKey, Map<String, String> propertyMap) {
        boolean wasPublished = false;
        boolean isDebugLog = LOGGER.isDebugEnabled();
        if (null != applicationContext && null != eventKey && null != propertyMap) {
            Properties properties = new Properties();
            properties.putAll(propertyMap);
            HashMap<String, Properties> applicationEventMap = new HashMap<String, Properties>();
            applicationEventMap.put(eventKey, properties);
            if (isDebugLog) {
                LOGGER.debug("Event '" + eventKey + "' is being published for property set '" + propertySetName + "...");
            }
            applicationContext.publishEvent(new ApplicationEvent(applicationEventMap){
                private static final long serialVersionUID = 1L;
            });
            wasPublished = true;
        }
        if (isDebugLog) {
            LOGGER.debug("Event '" + eventKey + "' has been published for property set '" + propertySetName + "...");
        }
        return wasPublished;
    }

    public void setDatabaseVendor(DatabaseVendor databaseVendor) {
        this._databaseVendor = databaseVendor;
    }

    public DatabaseVendor getDatabaseVendor() {
        return this._databaseVendor;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException();
    }
}

