/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.bootstrap;

import com.sas.framework.commons.util.SystemProperty;
import com.sas.framework.services.bootstrap.RMIMarkerObject;
import com.sas.framework.services.metadata.BaseAssociationFilter;
import com.sas.framework.services.metadata.BrowseMetadataUtil;
import com.sas.services.information.Filter;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class SASRemoteServices {
    private static final Logger LOGGER = LogManager.getLogger(SASRemoteServices.class);
    private static final String DEFAULT_CONTEXT_LOCATION = "jps-config.xml";

    private SASRemoteServices() {
    }

    public static void main(String[] args) {
        try {
            String contextLocation;
            if (null == args || 0 == args.length) {
                contextLocation = DEFAULT_CONTEXT_LOCATION;
            } else if (1 == args.length) {
                contextLocation = args[0];
            } else {
                throw new IllegalArgumentException("Only a single argument, the classpath location of the context file, is permitted.");
            }
            DateFormat df = DateFormat.getDateTimeInstance(0, 0, Locale.getDefault());
            System.out.println();
            SASRemoteServices.log("SAS Foundation Services - Remote Deployment");
            SASRemoteServices.log("Version " + SASRemoteServices.class.getPackage().getImplementationVersion());
            SASRemoteServices.log("Starting at " + df.format(new Date()) + "...");
            SASRemoteServices.log("Initializing ... ");
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(contextLocation);
            if (SystemProperty.SAS_BIND_MARKER_OBJECT.getBoolean()) {
                InformationServiceInterface informationService = (InformationServiceInterface)context.getBean("informationService");
                UserContextInterface metadataUser = (UserContextInterface)context.getBean("user");
                Properties props = (Properties)context.getBean("jpsProperties");
                String componentName = props.getProperty("software_component");
                String xmlSelect = "<XMLSelect search=\"TCPIPConnection[@ApplicationProtocol='RMI'][Source/DeployedComponent/Trees/Tree/SoftwareComponents/SoftwareComponent[@Name='" + componentName + "']]\" />";
                BaseAssociationFilter f = new BaseAssociationFilter();
                f.setXMLSelect(xmlSelect);
                f.setType("TCPIPConnection");
                f.setOMRTemplate("<TCPIPConnection Name=\"\" HostName=\"\" Port=\"\" />");
                ArrayList<String> protocols = new ArrayList<String>();
                protocols.add("omi");
                List results = informationService.browseSearchProtocols(metadataUser, protocols, (Filter)f);
                if (results.isEmpty()) {
                    throw new IllegalStateException("Unable to determine the rmi host and port to bind our object to.");
                }
                if (results.size() > 1) {
                    LOGGER.warn("Found more than one RMI registry for criteria, using the first one.");
                }
                BrowseMetadataInterface bmi = (BrowseMetadataInterface)results.get(0);
                String hostName = BrowseMetadataUtil.getAttribute(bmi, "HostName");
                String portString = BrowseMetadataUtil.getAttribute(bmi, "Port");
                int port = Integer.parseInt(portString);
                Registry registry = LocateRegistry.getRegistry(hostName, port);
                registry.bind("com.sas.framework.services.bootstrap.Marker", new RMIMarkerObject());
            }
            System.out.println();
            SASRemoteServices.log("SAH401001I Services are deployed and running. Press CTRL-C to stop.");
            System.out.println();
            Runtime.getRuntime().addShutdownHook(SASRemoteServices.newShutdownHook());
        }
        catch (Throwable t) {
            System.out.println("Received error while starting the application.");
            LOGGER.fatal(t.getMessage(), t);
            System.exit(-1);
        }
    }

    private static void log(String string) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(string);
        } else {
            System.out.println(string);
        }
    }

    private static ShutdownHook newShutdownHook() {
        return new ShutdownHook();
    }

    static class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            SASRemoteServices.log("SAH409002I Services are stopped.");
        }
    }
}

