/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.bootstrap;

import com.sas.framework.services.bootstrap.QuiesceController;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class Quiescer {
    private static final String RESUME_COMMAND = "resume";
    private static final String QUIESCE_COMMAND = "quiesce";
    private static final Logger LOGGER = LogManager.getLogger(Quiescer.class);

    private Quiescer() {
    }

    public static void main(String[] args) {
        int systemExitCode = -2;
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Beginning quiescer processing...");
            }
            if (0 < args.length) {
                String argument = args[0];
                if (QUIESCE_COMMAND.equals(argument)) {
                    QuiesceController controller = Quiescer.getQuiesceController();
                    if (null != controller) {
                        controller.quiesce();
                        systemExitCode = 0;
                    }
                } else if (RESUME_COMMAND.equals(argument)) {
                    QuiesceController controller = Quiescer.getQuiesceController();
                    if (null != controller) {
                        controller.resume();
                        systemExitCode = 0;
                    }
                } else {
                    Quiescer.usage();
                }
            } else {
                Quiescer.usage();
            }
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            systemExitCode = -1;
        }
        System.exit(systemExitCode);
    }

    private static QuiesceController getQuiesceController() {
        QuiesceController controller = null;
        try (ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("quiescer-config.xml");){
            Map beans = ctx.getBeansOfType(QuiesceController.class);
            int numBeans = beans.size();
            if (0 < numBeans) {
                controller = (QuiesceController)beans.values().iterator().next();
                if (1 < numBeans && LOGGER.isInfoEnabled()) {
                    LOGGER.info("Found more than one quiesce controller. Only the first one will be invoked.");
                }
            } else {
                LOGGER.info("A quiesce controller is not available.");
            }
        }
        return controller;
    }

    private static void usage() {
        System.out.println("Usage: ");
        System.out.println("\tQuiescer quiesce|resume");
    }
}

