/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services;

import com.sas.framework.config.ConfigurationServiceInterface;
import com.sas.framework.services.PlatformServiceResolverInterface;
import com.sas.framework.services.SASServicesException;
import com.sas.framework.services.ServicesFacadeInterface;
import com.sas.preferences.SASProfile;
import com.sas.preferences.SASProfileInterface;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.util.ChainedException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Properties;

public class SASServicesFacade
implements ServicesFacadeInterface {
    private UserContextInterface securedUser;
    private ConfigurationServiceInterface configService;
    private PlatformServiceResolverInterface pfsResolver;
    private UserServiceInterface userService;
    private SessionServiceInterface sessionService;

    public void setUserService(UserServiceInterface service) {
        this.userService = service;
    }

    public void setSessionService(SessionServiceInterface service) {
        this.sessionService = service;
    }

    public void setPlatformServiceResolver(PlatformServiceResolverInterface p) {
        this.pfsResolver = p;
    }

    public void setUser(UserContextInterface u) {
        this.securedUser = u;
    }

    public void setConfigurationService(ConfigurationServiceInterface c) {
        this.configService = c;
    }

    @Override
    public SessionContextInterface getSessionContext(String sessionKey) throws SASServicesException, RemoteException {
        if (null == sessionKey) {
            return null;
        }
        SessionServiceInterface sessionSrv = this.getSessionService(sessionKey);
        return sessionSrv.getSessionContext(this.securedUser, sessionKey);
    }

    @Override
    public SessionContextInterface getSessionContext(String sessionKey, String softwareComponent) throws SASServicesException, RemoteException {
        SessionContextInterface sessionContext = this.getSessionContext(sessionKey);
        if (null != sessionContext) {
            UserContextInterface userContext = sessionContext.getUserContext();
            ProfileInterface profile = null;
            ProfileInterface sasProfile = null;
            try {
                profile = userContext.getProfile();
                sasProfile = profile.getProfile("SAS");
            }
            catch (ServiceException se) {
                try {
                    SASProfile sp = new SASProfile("SAS");
                    profile.createSubprofile((ProfileInterface)sp);
                    profile.addProfile("SAS", (ProfileInterface)sp, true);
                    profile.persist("SAS", true);
                    sasProfile = sp;
                }
                catch (Throwable t) {
                    ChainedException.printStackTrace((Throwable)t, (PrintStream)System.out, (boolean)true);
                }
            }
            if (sasProfile instanceof SASProfileInterface) {
                SASProfileInterface spi = (SASProfileInterface)sasProfile;
                Properties props = this.configService.getSettings(softwareComponent);
                spi.setDefaultProperties(props);
            }
        }
        return sessionContext;
    }

    @Override
    public SessionContextInterface createSessionFromUser(UserContextInterface user) throws SASServicesException, RemoteException, InitializationException {
        SessionServiceInterface sessionSrvs = this.getSessionService();
        UserServiceInterface userSrvs = this.getUserService();
        userSrvs.setUser(user);
        SessionContextInterface sessionContext = sessionSrvs.newSessionContext(user);
        user.setSessionContext(sessionContext);
        sessionContext = this.getSessionContext(sessionContext.getEntityKey());
        return sessionContext;
    }

    private UserServiceInterface getUserService() {
        if (null != this.pfsResolver) {
            return this.pfsResolver.getUserService();
        }
        return this.userService;
    }

    @Override
    public SessionServiceInterface getSessionService() {
        if (null != this.pfsResolver) {
            return this.pfsResolver.getSessionService();
        }
        return this.sessionService;
    }

    @Override
    public SessionServiceInterface getSessionService(String key) {
        if (null != this.pfsResolver) {
            return this.pfsResolver.getSessionService(key);
        }
        return this.sessionService;
    }
}

