/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services;

import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.IsRemotelyAccessibleAttribute;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class PlatformServiceFactoryBean
implements FactoryBean,
InitializingBean {
    private DiscoveryServiceInterface discoveryService;
    private Class<?> serviceInterface;
    private boolean remote = false;
    private boolean required = true;
    private RemoteServiceInterface serviceInstance;

    public void setServiceInterface(Class<?> k) {
        this.serviceInterface = k;
    }

    public void setDiscoveryService(DiscoveryServiceInterface d) {
        this.discoveryService = d;
    }

    public void setRemote(boolean b) {
        this.remote = b;
    }

    public void setRequired(boolean r) {
        this.required = r;
    }

    public void afterPropertiesSet() throws Exception {
        ServiceTemplate t = this.remote ? new ServiceTemplate(new Class[]{this.serviceInterface}, new ServiceAttributeInterface[]{new IsRemotelyAccessibleAttribute(Boolean.TRUE)}) : new ServiceTemplate(new Class[]{this.serviceInterface});
        try {
            this.serviceInstance = this.discoveryService.findService(t);
        }
        catch (ServiceNotAvailableException e) {
            if (this.required) {
                throw e;
            }
            this.serviceInstance = null;
        }
    }

    public Object getObject() throws Exception {
        return this.serviceInstance;
    }

    public Class<?> getObjectType() {
        return this.serviceInterface;
    }

    public boolean isSingleton() {
        return true;
    }
}

