/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services;

import com.sas.services.deployment.Environment;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class EnvironmentFactoryBean
implements FactoryBean<Environment>,
InitializingBean {
    Properties properties;
    private Environment environment;
    private String moduleClass = "com.sas.services.security.login.OMILoginModule";

    public void setLocation(String location) {
        InputStream istream = null;
        try {
            istream = this.getClassPathInputStream(location);
            this.properties = new Properties();
            this.properties.load(istream);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            if (null != istream) {
                try {
                    istream.close();
                }
                catch (IOException e) {
                    LogManager.getLogger(EnvironmentFactoryBean.class).error("Exception closing properties input stream.", (Throwable)e);
                }
            }
        }
    }

    public void setModuleClass(String clazz) {
        this.moduleClass = clazz;
    }

    public void afterPropertiesSet() throws Exception {
        HashMap<String, String> optionsMap = new HashMap<String, String>(this.properties.size());
        for (Map.Entry<Object, Object> nextEntry : this.properties.entrySet()) {
            optionsMap.put((String)nextEntry.getKey(), (String)nextEntry.getValue());
        }
        this.environment = new Environment();
        this.environment.setAppConfigurationEntry(new AppConfigurationEntry[]{new AppConfigurationEntry(this.moduleClass, AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, optionsMap)});
    }

    public Environment getObject() {
        return this.environment;
    }

    public Class<Environment> getObjectType() {
        return Environment.class;
    }

    public boolean isSingleton() {
        return false;
    }

    private InputStream getClassPathInputStream(String location) {
        return this.getClass().getClassLoader().getResourceAsStream(location);
    }
}

