/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.platform.di.client.util;

import com.sas.services.util.XMLUtil;
import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataIntegrationTransportUtil {
    public static List<String> getAssignedServersForLibraryConnection(ConnectionPoint cp) {
        if (!"Library".equals(cp.getMappingName())) {
            return Collections.emptyList();
        }
        ArrayList<String> serverNames = new ArrayList<String>();
        String assignedServersProperty = cp.getProperty("AssignedServers");
        if (assignedServersProperty != null) {
            Node serversNode;
            Document doc = XMLUtil.convertStringToDocument((String)assignedServersProperty);
            if (doc != null && (serversNode = doc.getFirstChild()) != null) {
                NodeList childNodes = serversNode.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node childNode = childNodes.item(i);
                    NamedNodeMap attrs = childNode.getAttributes();
                    Node nameNode = attrs.getNamedItem("Name");
                    serverNames.add(nameNode.getNodeValue());
                }
            }
        } else {
            serverNames.add(cp.getProperty("ServerName"));
        }
        return serverNames;
    }
}

