/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.proxy;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.DefaultPropertyListener;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.proxy.InvalidProxyURIException;
import com.sas.workspace.mgmt.visuals.customizers.proxy.ProxyListItem;
import java.net.URI;
import java.rmi.RemoteException;
import javax.swing.JOptionPane;

public class ProxyProperty
extends IOMProperty {
    public ProxyProperty(CMetadata object, AbstractProperty metaProp, int viewType) {
        super(object, metaProp, viewType);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.removeAllPersistedPropertyEventListeners();
        this.addPersistedPropertyEventListener(new ProxyPersistedPropertyEventListener());
        this.addPropertyValidationEventListener(new ProxyPropertyValidationEventListener());
    }

    public class ProxyPersistedPropertyEventListener
    extends DefaultPropertyListener {
        @Override
        public void readProperty(IOMProperty.PersistedPropertyEvent evt) {
            TCPIPConnection conn = (TCPIPConnection)ProxyProperty.this.m_object;
            try {
                AssociationList props = conn.getProperties();
                String path = null;
                for (int i = 0; i < props.size(); ++i) {
                    Property prop = (Property)props.get(i);
                    if (!prop.getPropertyName().equals("ProxyPath")) continue;
                    path = prop.getDefaultValue();
                    break;
                }
                ProxyListItem proxy = new ProxyListItem(conn.getCommunicationProtocol(), conn.getHostName(), conn.getPort(), path);
                IOMProperty iomProp = evt.getProperty();
                iomProp.setPropertyValue(proxy.toString());
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
        }

        @Override
        public void writeProperty(IOMProperty.PersistedPropertyEvent evt) {
            IOMProperty prop = evt.getProperty();
            TCPIPConnection conn = (TCPIPConnection)ProxyProperty.this.m_object;
            URI uri = URI.create(prop.getDataValue().toString());
            ProxyListItem proxy = ProxyListItem.fromURI(uri);
            try {
                conn.setCommunicationProtocol(proxy.getScheme());
                conn.setHostName(proxy.getHost());
                if (proxy.isUsingDefaultPort()) {
                    conn.setPort(ProxyListItem.getDefaultPortForScheme(proxy.getScheme()));
                } else {
                    conn.setPort(proxy.getPort());
                }
                AssociationList propList = conn.getProperties();
                Property pathProp = null;
                boolean found = false;
                for (int j = 0; j < propList.size() && !found; ++j) {
                    pathProp = (Property)propList.get(j);
                    found = pathProp.getPropertyName().equals("ProxyPath");
                }
                if (proxy.getPath() != null && proxy.getPath().length() != 0) {
                    if (!found) {
                        pathProp = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)conn.getObjectStore(), null, IOMProperty.getDisplayString(0, "Proxy.URI.PathProperty.Name.xmlKey.txt"), "Property", conn.getRepositoryID());
                        pathProp.setPropertyName("ProxyPath");
                        pathProp.setSQLType(12);
                        conn.getProperties().add((Object)pathProp);
                    }
                    if (pathProp != null) {
                        pathProp.setDefaultValue(proxy.getPath());
                    }
                } else if (found) {
                    conn.getObjectStore().deleteObject((CMetadata)pathProp);
                    pathProp = null;
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
        }
    }

    public class ProxyPropertyValidationEventListener
    implements IOMProperty.PropertyValidationEventListener {
        @Override
        public void validateProperty(IOMProperty.PersistedPropertyEvent evt) {
            ProxyProperty prop = (ProxyProperty)evt.getProperty();
            try {
                ProxyListItem.validate(URI.create(prop.getDataValue().toString()));
                prop.setValid(true);
            }
            catch (InvalidProxyURIException e) {
                JOptionPane.showMessageDialog(ProxyProperty.this.m_data.getTopLevelAncestor(), e.getMessage(), IOMProperty.getDisplayString(0, "Proxy.URI.Error.Title.xmlKey.txt"), 0);
                prop.setValid(false);
            }
        }
    }
}

