/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMCustomizer;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMPropertyList;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JOptionPane;

public class UUIDConnectionCustomizer
extends IOMCustomizer {
    private static final long serialVersionUID = 1L;
    private IOMProperty m_uuidNode;

    public UUIDConnectionCustomizer(Root root, List groupPropertiesList, int viewType) {
        super(root, groupPropertiesList, viewType);
    }

    @Override
    protected void initialize() {
        try {
            this.setName(((AbstractProperty)this.m_propList.get(0)).getAssociatedPropertyGroup().getName());
            this.m_iomProps = new IOMPropertyList();
            for (int i = 0; i < this.m_propList.size(); ++i) {
                AbstractProperty prop = (AbstractProperty)this.m_propList.get(i);
                if (!(prop instanceof Property) || !((Property)prop).getPropertyName().equals("UUIDNode")) continue;
                this.m_uuidNode = new IOMProperty((CMetadata)this.m_root, prop, this.m_viewType);
                this.m_iomProps.add(this.m_uuidNode);
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    private boolean isValidUUIDNode(String uuidNode) {
        if (uuidNode.length() != 12) {
            return false;
        }
        String hexNums = "abcdefABCDEF1234567890";
        for (int i = 0; i < uuidNode.length(); ++i) {
            if (hexNums.indexOf(uuidNode.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validateData() {
        String uuidValue;
        if (this.m_uuidNode != null && (uuidValue = (String)this.m_uuidNode.getDataValue()).length() > 0 && !this.isValidUUIDNode(uuidValue)) {
            JOptionPane.showMessageDialog((Component)((Object)this), IOMProperty.getDisplayString(1, "Connection.Property.UUIDNode.Error.Message.xmlKey.txt"), IOMProperty.getDisplayString(1, "Connection.Property.UUIDNode.Error.Title.xmlKey.txt"), 0);
            return false;
        }
        return super.validateData();
    }
}

