/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMPropertyList;
import com.sas.workspace.mgmt.visuals.customizers.iom.ListPropertyDialogImpl;
import com.sas.workspace.mgmt.visuals.customizers.iom.LoginProperty;
import java.awt.Component;
import java.awt.Dialog;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;

public class Puddle
extends ListPropertyDialogImpl {
    private boolean m_editMode;
    private Group m_group;
    private IOMProperty m_name;
    private IOMPropertyList m_pudProps;
    private boolean m_nameChanged;
    private boolean m_new;
    private Tree m_pool;
    private List<String> m_rgNames;
    private boolean m_updated;

    public Puddle(Tree pool, Prototype pudProto, int viewType) {
        this(pool, null, pudProto, viewType);
    }

    public Puddle(Tree pool, Group pudGroup, Prototype pudProto, int viewType) {
        try {
            this.m_pool = pool;
            this.m_group = pudGroup;
            this.m_pudProps = new IOMPropertyList();
            if (this.m_group == null) {
                this.m_new = true;
                this.m_group = (Group)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_pool.getObjectStore(), null, "", "Group", this.m_pool.getRepositoryID(), null);
            } else {
                this.m_new = false;
            }
            try {
                AssociationList propList = pudProto.getPrimaryPropertyGroup().getGroupedProperties();
                for (int i = 0; i < propList.size(); ++i) {
                    try {
                        IOMProperty iomProp;
                        AbstractProperty absProp = (AbstractProperty)propList.get(i);
                        if (absProp instanceof AssociationProperty && ((AssociationProperty)absProp).getMetadataType().equals("Login")) {
                            iomProp = new LoginProperty((CMetadata)this.m_group, (AssociationProperty)absProp, viewType);
                        } else {
                            iomProp = new IOMProperty((CMetadata)this.m_group, (AbstractProperty)propList.get(i), viewType);
                            if (iomProp.getPropertyName().equals("Name")) {
                                this.m_name = iomProp;
                            }
                        }
                        this.m_pudProps.add(iomProp);
                        continue;
                    }
                    catch (IOMProperty.IllegalPropertyTypeException illegalPropertyTypeException) {
                        // empty catch block
                    }
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
            for (int i = 0; i < this.m_pudProps.size(); ++i) {
                this.m_pudProps.get(i).readProperty();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void delete() {
        try {
            for (int i = 0; i < this.m_pudProps.size(); ++i) {
                this.m_pudProps.get(i).deleteProperty();
            }
            this.m_pool.getObjectStore().deleteObject((CMetadata)this.m_group);
            this.m_group = null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public boolean equals(Object puddle) {
        if (puddle == null) {
            return false;
        }
        if (puddle instanceof Puddle) {
            return this.toString().equals(puddle.toString());
        }
        return false;
    }

    @Override
    public WAStandardDialog getDialog(Dialog owner, int button) {
        WAPanel panel = new WAPanel();
        panel.add((Component)this.m_pudProps.getPropertiesPanel());
        this.m_dialog = new WAStandardDialog(owner, "", true, panel){
            private static final long serialVersionUID = 1L;

            protected boolean onOK() {
                Puddle.this.m_name.updateProperty();
                if (((String)Puddle.this.m_name.getDataValue()).trim().length() == 0) {
                    JOptionPane.showMessageDialog(Puddle.this.m_dialog.getOwner(), IOMProperty.getDisplayString(0, "PuddleDialog.Error.NameFieldRequired.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "PuddleDialog.Error.NameFieldRequired.Title.xmlKey.txt"), 0);
                    return false;
                }
                if (Puddle.this.m_rgNames.contains(Puddle.this.m_name.getDataValue()) && (!Puddle.this.m_editMode || Puddle.this.m_nameChanged)) {
                    JOptionPane.showMessageDialog(Puddle.this.m_dialog.getOwner(), IOMProperty.getDisplayString(0, "PuddleDialog.Error.Duplicate.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "PuddleDialog.Error.Duplicate.Title.xmlKey.txt"), 0);
                    return false;
                }
                Puddle.this.updatePuddle();
                return super.onOK();
            }
        };
        this.m_dialog.setHelpProduct("templatedata");
        this.m_dialog.setHelpTopic("puddle");
        if (0 == button) {
            this.m_dialog.setTitle(IOMProperty.getDisplayString(0, "PuddleDialog.New.Title.xmlKey.txt"));
            this.m_editMode = false;
        } else if (1 == button) {
            this.m_dialog.setTitle(IOMProperty.getDisplayString(0, "PuddleDialog.Edit.Title.xmlKey.txt"));
            this.m_editMode = true;
        }
        return this.m_dialog;
    }

    public Group getGroup() {
        if (this.m_group == null) {
            this.updatePuddle();
        }
        return this.m_group;
    }

    public String getName() {
        return (String)this.m_name.getDataValue();
    }

    @Override
    public Object getValue() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_name.getDataValue().hashCode();
        return result;
    }

    public boolean isNew() {
        return this.m_new;
    }

    public boolean isUpdated() {
        return this.m_updated;
    }

    @Override
    public void Reset() {
        for (int i = 0; i < this.m_pudProps.size(); ++i) {
            this.m_pudProps.get(i).resetProperty();
        }
    }

    @Override
    public void setInitialValue(Object value) {
        DefaultListModel model = (DefaultListModel)value;
        this.m_rgNames = new ArrayList<String>();
        for (int i = 0; i < model.size(); ++i) {
            this.m_rgNames.add(((Puddle)model.get(i)).getName());
        }
    }

    public String toString() {
        return this.getName();
    }

    public void updatePuddle() {
        for (int i = 0; i < this.m_pudProps.size(); ++i) {
            this.m_pudProps.get(i).writeProperty();
        }
    }
}

