/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMCustomizer;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMPropertyList;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;

public class PollingQueueCustomizer
extends IOMCustomizer {
    private static final long serialVersionUID = 7575322593928289580L;

    public PollingQueueCustomizer(Root root, List groupPropertiesList, int viewType) {
        super(root, groupPropertiesList, viewType);
    }

    @Override
    protected void initialize() {
        this.m_iomProps = new IOMPropertyList();
        for (int i = 0; i < this.m_propList.size(); ++i) {
            try {
                IOMProperty iomProp = this.m_propList.get(i) instanceof AssociationProperty && ((AssociationProperty)this.m_propList.get(i)).getMetadataType().equals("Transformation") ? new QueueListProperty((CMetadata)this.m_root, (AbstractProperty)this.m_propList.get(i), this.m_viewType) : new IOMProperty((CMetadata)this.m_root, (AbstractProperty)this.m_propList.get(i), this.m_viewType);
                this.m_iomProps.add(iomProp);
                continue;
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
    }

    @Override
    public String createFinishString() {
        return super.createFinishString();
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        this.removePPVFormatting();
        super.moveDataToView();
    }

    public class QueueListProperty
    extends IOMProperty {
        @Override
        public String toString() {
            if (!this.m_visible) {
                return "";
            }
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(this.m_finName);
            strBuffer.append("\n\t");
            if (((JComboBox)this.m_data).getSelectedItem() instanceof Transformation) {
                Transformation queue = (Transformation)((JComboBox)this.m_data).getSelectedItem();
                try {
                    if (queue.getDeployedComponents().size() == 0) {
                        return "None\n";
                    }
                    ServerComponent qMan = (ServerComponent)queue.getDeployedComponents().get(0);
                    if (queue.getPublicType().equalsIgnoreCase("MessageQueue")) {
                        strBuffer.append(queue.getName() + " (" + qMan.getName() + ":" + qMan.getAssociatedMachine().getName() + ")");
                    } else if (queue.getPublicType().equalsIgnoreCase("JMSDestination")) {
                        AssociationList props = qMan.getProperties();
                        String conFac = null;
                        for (int i = 0; i < props.size(); ++i) {
                            Property prop = (Property)props.get(i);
                            if (!prop.getPropertyName().equalsIgnoreCase("jmsConnFac")) continue;
                            conFac = prop.getDefaultValue();
                            break;
                        }
                        if (conFac != null) {
                            strBuffer.append(queue.getName() + " (" + qMan.getName() + ":" + conFac + ")");
                        }
                    }
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                }
                strBuffer.append("\n");
                return strBuffer.toString();
            }
            return "None\n";
        }

        public QueueListProperty(CMetadata object, AbstractProperty metaProp, int viewType) {
            super(object, metaProp, viewType);
            if (this.m_data instanceof JComboBox) {
                ((JComboBox)this.m_data).setRenderer(new DefaultListCellRenderer(){
                    private static final long serialVersionUID = 4600306035498578677L;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                        if (value instanceof Transformation) {
                            Transformation trans = (Transformation)value;
                            boolean textSet = false;
                            try {
                                String displayName = null;
                                ServerComponent qMan = (ServerComponent)trans.getDeployedComponents().get(0);
                                if (qMan != null) {
                                    Machine machine;
                                    if (trans.getPublicType().equals("JMSDestination")) {
                                        AssociationList props = qMan.getProperties();
                                        String conFac = null;
                                        for (int i = 0; i < props.size(); ++i) {
                                            Property prop = (Property)props.get(i);
                                            if (!prop.getPropertyName().equalsIgnoreCase("jmsConnFac")) continue;
                                            conFac = prop.getDefaultValue();
                                            break;
                                        }
                                        if (conFac != null) {
                                            displayName = trans.getName() + " (" + qMan.getName() + ":" + conFac + ")";
                                        }
                                    } else if (trans.getPublicType().equals("MessageQueue") && (machine = qMan.getAssociatedMachine()) != null) {
                                        displayName = trans.getName() + " (" + qMan.getName() + ":" + machine.getName() + ")";
                                    }
                                }
                                if (displayName != null) {
                                    ((JLabel)comp).setText(displayName);
                                    textSet = true;
                                }
                            }
                            catch (RemoteException e) {
                                Workspace.handleRemoteException((RemoteException)e);
                            }
                            catch (MdException ex) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                            }
                            finally {
                                if (!textSet) {
                                    ((JComboBox)QueueListProperty.this.m_data).removeItem(value);
                                }
                            }
                        }
                        return comp;
                    }
                });
            }
        }
    }
}

