/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.Machine;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;

public class MachineListSelector
extends DualListSelector {
    private static final long serialVersionUID = 1L;
    private List<Machine> m_permTargets = new Vector<Machine>();

    public MachineListSelector() {
        this.setTargetCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList arg0, Object arg1, int arg2, boolean arg3, boolean arg4) {
                Component comp = super.getListCellRendererComponent((JList<?>)arg0, arg1, arg2, arg3, arg4);
                Machine machine = (Machine)arg1;
                if (MachineListSelector.this.m_permTargets.contains(machine)) {
                    comp.setEnabled(false);
                }
                return comp;
            }
        });
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            JList target = (JList)this.getTargetComponent();
            Vector<String> machines = new Vector<String>();
            for (int i = 0; i < target.getSelectedIndices().length; ++i) {
                Machine machine = (Machine)target.getModel().getElementAt(target.getSelectedIndices()[i]);
                if (!this.m_permTargets.contains(machine)) {
                    machines.add(Integer.toString(target.getSelectedIndices()[i]));
                    continue;
                }
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), MessageFormat.format(IOMProperty.getDisplayString(0, "MachineList.Error.PermanentTarget.Message.xmlKey.txt"), machine.getName()), IOMProperty.getDisplayString(0, "MachineList.Error.PermanentTarget.Title.xmlKey.txt"), 2);
            }
            int[] indices = new int[machines.size()];
            for (int j = 0; j < machines.size(); ++j) {
                indices[j] = Integer.parseInt((String)machines.get(j));
            }
            target.setSelectedIndices(indices);
            super.actionPerformed(arg0);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public boolean canTransferAllTargetItems() {
        return this.m_permTargets.size() <= 0;
    }

    public List getPermanentTargets() {
        return this.m_permTargets;
    }

    public void setPermanentTarget(Machine machine) {
        this.m_permTargets.add(machine);
        DefaultListModel source = (DefaultListModel)this.getModel();
        DefaultListModel target = (DefaultListModel)this.getTargetModel();
        if (!target.contains(machine)) {
            target.addElement(machine);
        }
        if (source.contains(machine)) {
            source.removeElement(machine);
        }
    }
}

