/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.ListPropertyDialog;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListProperty
extends IOMProperty
implements ListSelectionListener,
ActionListener {
    protected JButton[] m_buttons;
    protected ListPropertyDialog[] m_dialogs;
    protected JList m_list;
    protected DefaultListModel m_listMdl;
    protected JScrollPane m_scrPane;
    protected boolean[] m_useButton;
    public static final int NEW_BUTTON = 0;
    public static final int EDIT_BUTTON = 1;
    public static final int REMOVE_BUTTON = 2;
    public static final int CLEAR_BUTTON = 3;
    public static final int DEFAULT_BUTTON_CT = 4;
    protected int m_numButtons;
    protected static final String NEW_COMMAND = "New";
    protected static final String EDIT_COMMAND = "Edit";
    protected static final String REMOVE_COMMAND = "Remove";
    protected static final String CLEAR_COMMAND = "Clear";

    public ListProperty(CMetadata object, AbstractProperty metaProp, int viewType) {
        super(object, metaProp, viewType);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getActionCommand().equals(NEW_COMMAND)) {
                if (this.m_dialogs[0] != null && this.ShowDialog(0) == 1) {
                    ListPropertyDialog propDialog = this.m_dialogs[0];
                    this.m_listMdl.addElement(propDialog.getValue());
                    this.m_list.setSelectedIndex(this.m_listMdl.getSize() - 1);
                }
            } else if (e.getActionCommand().equals(EDIT_COMMAND)) {
                if (this.m_dialogs[1] != null && this.ShowDialog(1) == 1) {
                    ListPropertyDialog propDialog = this.m_dialogs[1];
                    this.m_listMdl.setElementAt(propDialog.getValue(), this.m_list.getSelectedIndex());
                }
            } else if (e.getActionCommand().equals(REMOVE_COMMAND)) {
                if (this.m_dialogs[2] != null) {
                    this.ShowDialog(2);
                }
                int[] indices = this.m_list.getSelectedIndices();
                for (int i = 0; i < indices.length; ++i) {
                    this.m_listMdl.remove(indices[i]);
                }
            } else if (e.getActionCommand().equals(CLEAR_COMMAND)) {
                if (this.m_dialogs[3] != null) {
                    this.ShowDialog(3);
                }
                this.m_listMdl.removeAllElements();
            }
        }
        catch (Exception ex) {
            return;
        }
    }

    @Override
    public void addPropertyToPanel(JPanel panel) {
        GridBagConstraints gbc;
        if (!this.m_visible) {
            return;
        }
        if (this.m_viewType == 1) {
            this.m_scrPane.setMinimumSize(new Dimension(240, 100));
        } else {
            this.m_scrPane.setMinimumSize(new Dimension(160, 100));
        }
        int gridx = 0;
        int gridy = ListProperty.getNextComponentHorizontalGridValue(panel);
        GridBagLayout gbLayout = (GridBagLayout)panel.getLayout();
        JPanel pnlButton = new JPanel();
        int btnsUsed = 0;
        for (int i = 0; i < this.m_numButtons; ++i) {
            if (!this.m_useButton[i]) continue;
            ++btnsUsed;
        }
        GridLayout gLayout = new GridLayout(1, 1, 10, 10);
        gLayout.setRows(btnsUsed == 4 ? 2 : btnsUsed);
        gLayout.setColumns(btnsUsed == 4 ? 2 : 1);
        pnlButton.setLayout(gLayout);
        for (int i = 0; i < this.m_numButtons; ++i) {
            if (!this.m_useButton[i]) continue;
            pnlButton.add(this.m_buttons[i]);
        }
        if (this.m_sep != null) {
            gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridy = gridy++;
            gbc.gridx = gridx++;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(12, 12, 12, 0);
            gbLayout.setConstraints(this.m_sep, gbc);
            panel.add(this.m_sep);
        } else if (this.m_useLabel) {
            try {
                ((JLabel)this.m_label).setLabelFor(this.m_list);
                ListProperty.setMnemonic(this.m_label, 1, this.m_metaProp.getName());
                gbc = new GridBagConstraints();
                gbc.anchor = 17;
                gbc.fill = 1;
                gbc.gridx = gridx++;
                gbc.gridy = gridy;
                gbc.insets = new Insets(0, 12, 0, 12);
                gbLayout.setConstraints(this.m_label, gbc);
                panel.add(this.m_label);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        gbc = new GridBagConstraints();
        gbc.gridy = gridy;
        gbc.gridx = gridx;
        gbc.weightx = 1.0;
        gbLayout.setConstraints(this.m_scrPane, gbc);
        panel.add(this.m_scrPane);
        gbc = new GridBagConstraints();
        gbc.gridy = gridy;
        gbc.gridx = gridx += 3;
        gbLayout.setConstraints(pnlButton, gbc);
        panel.add(pnlButton);
    }

    @Override
    public Object getDataValue() {
        if (this.m_listMdl.size() == 0) {
            return null;
        }
        StringBuffer strValue = new StringBuffer(this.m_listMdl.get(0).toString());
        for (int i = 1; i < this.m_listMdl.size(); ++i) {
            strValue.append(", " + this.m_listMdl.get(i).toString());
        }
        return strValue.toString();
    }

    @Override
    protected void initialize() {
        try {
            this.m_listMdl = new DefaultListModel();
            this.m_listMdl.addListDataListener(new ListDataListener(){

                @Override
                public void contentsChanged(ListDataEvent e) {
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                    ListProperty.this.m_buttons[3].setEnabled(true);
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    if (ListProperty.this.m_listMdl.size() == 0) {
                        ListProperty.this.m_buttons[3].setEnabled(false);
                        ListProperty.this.m_buttons[2].setEnabled(false);
                    }
                }
            });
            this.m_list = new JList(this.m_listMdl);
            if (this.m_metaProp.getDesc().trim().length() > 0) {
                this.m_list.setToolTipText(IOMProperty.getDisplayString(1, this.m_metaProp.getDesc()));
            }
            this.m_list.setLayoutOrientation(0);
            this.m_list.addListSelectionListener(this);
            this.m_list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (ListProperty.this.m_useButton[1] && e.getClickCount() == 2) {
                        ListProperty.this.actionPerformed(new ActionEvent(this, 1001, ListProperty.EDIT_COMMAND));
                    }
                }
            });
            this.m_list.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    try {
                        super.focusLost(arg0);
                        if (ListProperty.this.m_prop != null) {
                            ListProperty.this.m_prop.setDefaultValue((String)ListProperty.this.getDataValue());
                        }
                    }
                    catch (RemoteException ex) {
                        Workspace.handleRemoteException((RemoteException)ex);
                    }
                }
            });
            this.m_scrPane = new JScrollPane(this.m_list, 20, 30);
            if (this.m_numButtons == 0) {
                this.m_numButtons = 4;
            }
            this.m_buttons = new JButton[this.m_numButtons];
            this.m_useButton = new boolean[this.m_numButtons];
            this.m_dialogs = new ListPropertyDialog[this.m_numButtons];
            JButton button = new JButton(IOMProperty.getDisplayString(0, "ListProperty.Button.New.Name.xmlKey.txt"));
            ListProperty.setMnemonic(button, 0, "ListProperty.Button.New.Name.xmlKey.txt");
            button.setActionCommand(NEW_COMMAND);
            int height = button.getMinimumSize().height;
            button.setMinimumSize(new Dimension(100, height));
            button.addActionListener(this);
            this.m_buttons[0] = button;
            this.m_useButton[0] = true;
            button = new JButton(IOMProperty.getDisplayString(0, "ListProperty.Button.Edit.Name.xmlKey.txt"));
            ListProperty.setMnemonic(button, 0, "ListProperty.Button.Edit.Name.xmlKey.txt");
            button.setActionCommand(EDIT_COMMAND);
            button.setMinimumSize(new Dimension(100, height));
            button.addActionListener(this);
            button.setEnabled(false);
            this.m_buttons[1] = button;
            this.m_useButton[1] = true;
            button = new JButton(IOMProperty.getDisplayString(0, "ListProperty.Button.Remove.Name.xmlKey.txt"));
            ListProperty.setMnemonic(button, 0, "ListProperty.Button.Remove.Name.xmlKey.txt");
            button.setActionCommand(REMOVE_COMMAND);
            button.setMinimumSize(new Dimension(100, height));
            button.addActionListener(this);
            button.setEnabled(false);
            this.m_buttons[2] = button;
            this.m_useButton[2] = true;
            button = new JButton(IOMProperty.getDisplayString(0, "ListProperty.Button.Clear.Name.xmlKey.txt"));
            ListProperty.setMnemonic(button, 0, "ListProperty.Button.Clear.Name.xmlKey.txt");
            button.setActionCommand(CLEAR_COMMAND);
            button.setMinimumSize(new Dimension(100, height));
            button.addActionListener(this);
            button.setEnabled(false);
            this.m_buttons[3] = button;
            this.m_useButton[3] = true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    public void readProperty() {
        this.fireReadPropertyEvent(new IOMProperty.PersistedPropertyEvent(this));
    }

    public void setButtonDialog(int button, ListPropertyDialog dialog) {
        this.m_dialogs[button] = dialog;
    }

    public void setButtonMnemonic(int button, String key) {
        ListProperty.setMnemonic(this.m_buttons[button], 0, key);
    }

    public void setButtonText(int button, String text) {
        this.m_buttons[button].setText(text);
    }

    public void setOwningObject(CMetadata object) {
        this.m_object = object;
    }

    @Override
    public void setPreferredDataSize(Dimension size) {
        this.m_scrPane.setPreferredSize(size);
    }

    public void setPreferredSize(int button, Dimension size) {
        this.m_buttons[button].setPreferredSize(size);
    }

    public void setPropertyValue(String value) {
        if (value.trim().length() == 0) {
            return;
        }
        String rest = value;
        int pos = rest.indexOf(",");
        while (pos != -1) {
            this.m_listMdl.addElement(rest.substring(0, pos));
            rest = rest.substring(pos + 1, rest.length());
            pos = rest.indexOf(",");
        }
        this.m_listMdl.addElement(rest);
    }

    @Override
    public void setPropertyValue(Object value) {
        if (value instanceof String) {
            this.setPropertyValue((String)value);
        } else {
            super.setPropertyValue(value);
        }
    }

    public void setUseButton(int button, boolean useButton) {
        this.m_useButton[button] = useButton;
    }

    private int ShowDialog(int button) {
        Dialog owner = (Dialog)this.m_buttons[button].getTopLevelAncestor();
        ListPropertyDialog propDialog = this.m_dialogs[button];
        propDialog.Reset();
        if (button != 0) {
            propDialog.setInitialValue(this.getDataValue());
        }
        WAStandardDialog dialog = propDialog.getDialog(owner, button);
        dialog.show();
        return dialog.getReturnValue();
    }

    @Override
    public String toString() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(((JLabel)this.m_label).getText());
        strBuffer.append("\n\t");
        for (int i = 0; i < this.m_listMdl.size(); ++i) {
            strBuffer.append(this.m_listMdl.get(i).toString());
            strBuffer.append("\n\t");
        }
        strBuffer.append("\n");
        return strBuffer.toString();
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        if (this.m_list.getSelectedIndices().length > 0) {
            this.m_buttons[1].setEnabled(true);
            this.m_buttons[2].setEnabled(true);
        } else {
            this.m_buttons[1].setEnabled(false);
            this.m_buttons[2].setEnabled(false);
        }
    }

    @Override
    public void writeProperty() {
        this.fireWritePropertyEvent(new IOMProperty.PersistedPropertyEvent(this));
    }
}

