/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;

public class DefaultPropertyListener
implements IOMProperty.PersistedPropertyEventListener {
    @Override
    public void deleteProperty(IOMProperty.PersistedPropertyEvent evt) {
        try {
            IOMProperty iomProp = evt.getProperty();
            switch (iomProp.getMetadataPropertyType()) {
                case 0: {
                    Property realProp = iomProp.getProperty();
                    if (realProp == null) break;
                    if (iomProp.hasBeenCreated() || !realProp.isNewObject()) {
                        iomProp.getParentObject().getObjectStore().deleteObject((CMetadata)realProp);
                    }
                    iomProp.removePropertyFromStore();
                }
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    @Override
    public void readProperty(IOMProperty.PersistedPropertyEvent evt) {
        IOMProperty iomProp = evt.getProperty();
        Root parent = (Root)iomProp.getParentObject();
        try {
            block1 : switch (iomProp.getMetadataPropertyType()) {
                case 0: {
                    AssociationList propList = parent.getProperties(true);
                    boolean found = false;
                    for (int i = 0; i < propList.size() && !found; ++i) {
                        Property prop = (Property)propList.get(i);
                        if (!iomProp.getPropertyName().equals(prop.getPropertyName())) continue;
                        iomProp.setProperty(prop);
                        found = true;
                    }
                    if (found || iomProp.hasBeenCreated()) break;
                    iomProp.createNewProperty();
                    break;
                }
                case 1: {
                    if (!iomProp.isVisible() || !iomProp.isEnabled()) break;
                    String strMethod = "get" + iomProp.getPropertyName();
                    Method method = parent.getClass().getMethod(strMethod, new Class[0]);
                    Object value = null;
                    if (null != method) {
                        value = method.invoke((Object)parent, new Object[0]);
                    }
                    boolean skip = false;
                    if (null != value && iomProp.m_viewType == 0) {
                        if (value instanceof Integer && (Integer)value == 0) {
                            skip = true;
                        }
                        if (value instanceof String && value.equals("")) {
                            skip = true;
                        }
                    }
                    if (!skip) {
                        iomProp.setPropertyValue(method.invoke((Object)parent, new Object[0]));
                    }
                    break;
                }
                case 2: {
                    AssociationProperty assocProp = (AssociationProperty)iomProp.getMetadataProperty();
                    String strMethod = "get" + assocProp.getAssociationName();
                    Method method = parent.getClass().getMethod(strMethod, new Class[0]);
                    AssociationList objList = null;
                    if (null != method) {
                        objList = (AssociationList)method.invoke((Object)parent, new Object[0]);
                    }
                    if (objList == null) break;
                    Class<?> metaType = Class.forName("com.sas.metadata.remote.impl." + assocProp.getMetadataType() + "Impl");
                    for (int i = 0; i < objList.size(); ++i) {
                        if (!objList.get(i).getClass().equals(metaType)) continue;
                        iomProp.setPropertyValue(objList.get(i));
                        break block1;
                    }
                    break;
                }
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void writeProperty(IOMProperty.PersistedPropertyEvent evt) {
        IOMProperty iomProp = evt.getProperty();
        Root parent = (Root)iomProp.getParentObject();
        boolean found = false;
        try {
            switch (iomProp.getMetadataPropertyType()) {
                case 0: {
                    AssociationList propList = parent.getProperties(false);
                    for (int i = 0; i < propList.size() && !found; ++i) {
                        Property prop = (Property)propList.get(i);
                        if (prop == null || !iomProp.getPropertyName().equals(prop.getPropertyName())) continue;
                        found = true;
                        if (prop.getDefaultValue().equalsIgnoreCase(iomProp.getProperty().getDefaultValue())) continue;
                        propList.set(i, (Object)iomProp.getProperty());
                    }
                    if (!found) {
                        if (iomProp.hasBeenDeleted()) {
                            iomProp.createNewProperty();
                        }
                        propList.add((Object)iomProp.getProperty());
                    }
                    parent.setProperties(propList);
                    break;
                }
                case 1: {
                    String strMethod = "set" + iomProp.getPropertyName();
                    String getMethod = "get" + iomProp.getPropertyName();
                    Method method = parent.getClass().getMethod(getMethod, new Class[0]);
                    Object value = method.invoke((Object)parent, new Object[0]);
                    Object currValue = iomProp.getDataValue();
                    if (currValue.toString().equalsIgnoreCase(value.toString())) break;
                    method = parent.getClass().getMethod(strMethod, String.class);
                    method.invoke((Object)parent, iomProp.getDataValue());
                    break;
                }
                case 2: {
                    AssociationProperty assocProp = (AssociationProperty)iomProp.getMetadataProperty();
                    String strGetMethod = "get" + assocProp.getAssociationName();
                    String strSetMethod = "set" + assocProp.getAssociationName();
                    Method method = parent.getClass().getMethod(strGetMethod, new Class[0]);
                    AssociationList objList = (AssociationList)method.invoke((Object)parent, new Object[0]);
                    Class<?> metaType = Class.forName("com.sas.metadata.remote.impl." + assocProp.getMetadataType() + "Impl");
                    Object propObj = iomProp.getDataValue();
                    if (propObj == null) break;
                    Object[] newItems = propObj instanceof Object[] ? (Object[])propObj : new Object[]{propObj};
                    String noneString = IOMProperty.getDisplayString(1, "Server.Common.Property.Value.None.xmlKey.txt");
                    for (int i = 0; i < newItems.length; ++i) {
                        Object newItem = newItems[i];
                        if (null == newItem) continue;
                        if (newItem.getClass().equals(metaType)) {
                            found = false;
                            for (int j = 0; j < objList.size() && !found; ++j) {
                                Root metaObj = (Root)objList.get(j);
                                if (null == metaObj) continue;
                                if (metaObj.getId().equals(((Root)newItem).getId())) {
                                    found = true;
                                    continue;
                                }
                                if (assocProp.getMaximum() != 1 || !metaObj.getClass().equals(metaType)) continue;
                                objList.remove((Object)metaObj);
                            }
                            if (found) continue;
                            objList.add(newItem);
                            method = parent.getClass().getMethod(strSetMethod, AssociationList.class);
                            method.invoke((Object)parent, objList);
                            continue;
                        }
                        if (!newItem.equals(noneString)) continue;
                        method = parent.getClass().getMethod(strSetMethod, AssociationList.class);
                        int k = 0;
                        while (k < objList.size()) {
                            if (objList.get(k).getClass().equals(metaType)) {
                                objList.remove(k);
                                continue;
                            }
                            ++k;
                        }
                        method.invoke((Object)parent, objList);
                    }
                    break;
                }
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (SecurityException re) {
        }
        catch (NoSuchMethodException re) {
        }
        catch (IllegalArgumentException re) {
        }
        catch (IllegalAccessException re) {
        }
        catch (InvocationTargetException re) {
        }
        catch (ClassNotFoundException ex) {
            ex.getCause();
        }
    }
}

