/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.infomap;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.TextStore;
import com.sas.util.UsageVersion;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.mgmt.LoginSearchModel;
import com.sas.workspace.mgmt.SortUtil;
import com.sas.workspace.mgmt.visuals.LoginSearchPanel;
import com.sas.workspace.mgmt.visuals.MetadataObjectCellRenderer;
import com.sas.workspace.mgmt.visuals.ServerWizard;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InfomapLibraryConnectionPanel
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 5935602646051647044L;
    protected JLabel m_serverLabel;
    protected JComboBox m_serverChoice;
    protected JButton m_serverButton;
    protected JLabel m_loginLabel;
    protected JComboBox m_loginChoice;
    protected JLabel m_pathLabel;
    protected WATextField m_pathText;
    protected JButton m_pathButton;
    protected SASLibrary sas_library;
    protected DeployedComponent m_selectedServer;
    protected List m_serversList;
    protected List m_connectionsList;
    protected List m_loginsList;
    protected List newMetadataObjectsList;
    protected AuthenticationDomain m_currentDomain;
    private Login m_currentLogin;
    private Login m_selectedLogin;
    protected DeployedComponent defaultLocalServer = null;
    final String MD_SERVER_ID = "0217e202-b560-11db-ad91-001083ff6836";
    private static final WAdminResource bundle = WAdminResource.getBundle(InfomapLibraryConnectionPanel.class);

    public InfomapLibraryConnectionPanel(SASLibrary lib) {
        this.sas_library = lib;
        this._initialize();
        this.layoutWidgets();
    }

    protected void _initialize() {
        this.m_serverLabel = new JLabel();
        this.m_serverLabel.setText(bundle.getString("Customizer.InfomapLib.MetaServerLabel.txt"));
        this.m_serverLabel.getAccessibleContext().setAccessibleName(bundle.getString("Customizer.InfomapLib.MetaServerLabel.notrans"));
        this.m_serverChoice = new JComboBox();
        this.m_serverChoice.getAccessibleContext().setAccessibleName(bundle.getString("Customizer.InfomapLib.MetaServerLabel.notrans"));
        this.m_serverChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                InfomapLibraryConnectionPanel.this.onServerChanged(evt);
            }
        });
        this.m_serverButton = new JButton(bundle.getString("Common.New....txt"));
        this.m_serverButton.getAccessibleContext().setAccessibleName(bundle.getString("Common.New....notrans"));
        this.m_serverButton.setMargin(new Insets(0, 4, 0, 4));
        this.m_serverButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InfomapLibraryConnectionPanel.this.onNewServer();
            }
        });
        this.m_loginLabel = new JLabel(bundle.getString("Customizer.InfomapLib.LoginLabel.txt"));
        this.m_loginLabel.getAccessibleContext().setAccessibleName(bundle.getString("Customizer.InfomapLib.LoginLabel.notrans"));
        this.m_loginChoice = new JComboBox();
        this.m_loginChoice.getAccessibleContext().setAccessibleName(bundle.getString("Customizer.InfomapLib.LoginLabel.notrans"));
        this.m_loginChoice.setRenderer(new MetadataObjectCellRenderer());
        this.m_loginChoice.setEnabled(false);
        this.m_loginChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                InfomapLibraryConnectionPanel.this.onMoreLogins(evt);
            }
        });
        this.m_pathLabel = new JLabel(bundle.getString("Customizer.InfomapLib.MappathLabel.txt"));
        this.m_pathLabel.getAccessibleContext().setAccessibleName(bundle.getString("Customizer.InfomapLib.MappathLabel.notrans"));
        this.m_pathText = new WATextField();
        this.m_pathText.getAccessibleContext().setAccessibleName(bundle.getString("Customizer.InfomapLib.MappathLabel.notrans"));
        this.m_pathText.setEnabled(false);
        this.m_pathButton = new JButton(bundle.getString("Common.Browse....txt"));
        this.m_pathButton.getAccessibleContext().setAccessibleName(bundle.getString("Common.Browse....notrans"));
        this.m_pathButton.setEnabled(false);
        this.m_pathButton.setMargin(new Insets(0, 4, 0, 4));
        this.m_pathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InfomapLibraryConnectionPanel.this.onBrowse();
            }
        });
    }

    public void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_serverLabel, gbc);
        this.add(this.m_serverLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_serverChoice, gbc);
        this.add(this.m_serverChoice);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_serverButton, gbc);
        this.add(this.m_serverButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_loginLabel, gbc);
        this.add(this.m_loginLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_loginChoice, gbc);
        this.add(this.m_loginChoice);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_pathLabel, gbc);
        this.add(this.m_pathLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_pathText, gbc);
        this.add((Component)this.m_pathText);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_pathButton, gbc);
        this.add(this.m_pathButton);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
        Dimension svr_buttDim = this.m_serverButton.getPreferredSize();
        Dimension path_buttDim = this.m_pathButton.getPreferredSize();
        if (svr_buttDim.getWidth() > path_buttDim.getWidth() || svr_buttDim.getHeight() > path_buttDim.getHeight()) {
            this.m_pathButton.setPreferredSize(svr_buttDim);
        } else {
            this.m_serverButton.setPreferredSize(path_buttDim);
        }
    }

    public void moveDataToView() {
        try {
            boolean bInProjectRepo = WsRepositoryUtil.getRepositoryType((MdFactory)Workspace.getMdFactory(), (String)("A0000001." + this.sas_library.getRepositoryID())).equalsIgnoreCase("PROJECT");
            if (bInProjectRepo) {
                this.m_serverButton.setEnabled(false);
            }
            this.m_serverChoice.removeAllItems();
            DeployedComponent mdserver_hold = null;
            if (this.m_selectedServer != null && this.m_selectedServer.getFQID().indexOf("$") != -1) {
                mdserver_hold = this.m_selectedServer;
                mdserver_hold.setName(mdserver_hold.getName().concat(" " + bundle.getString("Customizer.InfomapLib.MetaServerString.Current.txt")));
            }
            String strType = "ServerComponent";
            String strTemplate = "<TEMPLATES><ServerComponent Name=\"\"><SourceConnections/><DataPackages/></ServerComponent><SASClientConnection><Domain/></SASClientConnection><AuthenticationDomain Name=\"\"><Logins/></AuthenticationDomain><Login Name=\"\" UserID=\"\" /><DatabaseSchema Name=\"\" /></TEMPLATES>";
            String strClassID = "0217e202-b560-11db-ad91-001083ff6836";
            String strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='" + strClassID + "'][SourceConnections/SASClientConnection[@ApplicationProtocol='SBIP']]\"/>";
            String strOptions = strTemplate + strSelect;
            int flags = 8588;
            this.m_serversList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.sas_library.getObjectStore(), "A0000001." + this.sas_library.getRepositoryID(), strType, flags, strOptions);
            if (mdserver_hold != null) {
                this.m_serversList.add(mdserver_hold);
            }
            String currentHost = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("host").trim();
            String currentPort = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("port").trim();
            if (this.m_serversList != null) {
                for (int i = 0; i < this.m_serversList.size(); ++i) {
                    DeployedComponent dc = (DeployedComponent)this.m_serversList.get(i);
                    AssociationList sourceConnections = dc.getSourceConnections();
                    for (int j = 0; j < sourceConnections.size(); ++j) {
                        Connection conn = (Connection)sourceConnections.get(j);
                        if (!(conn instanceof SASClientConnection)) continue;
                        SASClientConnection sasConn = (SASClientConnection)conn;
                        Integer portInt = new Integer(sasConn.getPort());
                        String remAddr = sasConn.getRemoteAddress().trim();
                        Workspace.getDefaultLogger().debug((Object)("Located Metadata Server '" + dc.getName() + "', " + remAddr + ", " + portInt.toString()));
                        if (this.defaultLocalServer != null || !remAddr.equalsIgnoreCase(currentHost) || !portInt.toString().equalsIgnoreCase(currentPort)) break;
                        this.defaultLocalServer = dc;
                        Workspace.getDefaultLogger().debug((Object)("Assigned defaultLocalServer = '" + dc.toString() + "'"));
                        break;
                    }
                    this.m_serverChoice.addItem(dc);
                }
            }
            SASClientConnection libraryConnection = null;
            if (this.sas_library != null) {
                libraryConnection = this.sas_library.getLibraryConnection();
            }
            if (libraryConnection != null) {
                DeployedComponent libraryServer = libraryConnection.getSource();
                this.m_serverChoice.setSelectedItem(libraryServer);
            } else if (this.defaultLocalServer != null) {
                this.m_serverChoice.setSelectedItem(this.defaultLocalServer);
            }
            AssociationList propertyList = this.sas_library.getProperties();
            for (int propIndex = 0; propIndex < propertyList.size(); ++propIndex) {
                Property property = (Property)propertyList.get(propIndex);
                if (!property.getPropertyName().trim().equalsIgnoreCase("MAPPATH")) continue;
                String strPropValue = property.getDefaultValue().replace("\"", "");
                this.m_pathText.setText(strPropValue);
            }
        }
        catch (RemoteException rex) {
            String msg = rex.getLocalizedMessage();
            Workspace.getDefaultLogger().error((Object)msg);
            MessageUtil.displayMessage((String)msg, (int)0);
        }
        catch (MdException mdex) {
            Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
            MessageUtil.displayMetadataExceptionMessage((MdException)mdex, (String)"Reading");
        }
    }

    public boolean validateData() {
        boolean bValid = true;
        if (this.m_serverChoice.getSelectedItem() == null) {
            bValid = false;
            String strMessage = bundle.getString("Customizer.InfomapLib.NoMetaServerError.txt");
            String strTitle = bundle.getString("Common.RequiredField.txt");
            MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
            return bValid;
        }
        if (this.m_pathText.getText().trim().length() == 0) {
            bValid = false;
            String strMessage = bundle.getString("Customizer.InfomapLib.NoMappathError.txt");
            String strTitle = bundle.getString("Common.RequiredField.txt");
            MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
            return bValid;
        }
        return bValid;
    }

    public void moveDataToStore() {
        try {
            if (this.m_selectedServer == null) {
                return;
            }
            SASClientConnection conn = (SASClientConnection)this.m_connectionsList.get(0);
            if (conn != null && this.sas_library.getLibraryConnection() != conn) {
                this.sas_library.setLibraryConnection(conn);
                Workspace.getDefaultLogger().debug((Object)("Associated SASClientConnection '" + conn.getName() + "' to SASLibrary '" + this.sas_library.getName() + "'"));
            }
            Login login = null;
            if (this.m_loginChoice.getSelectedItem() instanceof Login) {
                this.m_selectedLogin = login = (Login)this.m_loginChoice.getSelectedItem();
            }
            if (login == null && this.sas_library.getDefaultLogins().size() > 0) {
                this.sas_library.getDefaultLogins().removeAllElements();
            }
            if (login != null && this.sas_library.getDefaultLogin() != login) {
                this.sas_library.setDefaultLogin(login);
                Workspace.getDefaultLogger().debug((Object)("Associated Default login '" + login.getName() + "' to SASLibrary '" + this.sas_library.getName() + "'"));
            }
            DatabaseSchema schema = null;
            if (this.sas_library.getUsingPackages().size() > 0) {
                for (int count = 0; count < this.sas_library.getUsingPackages().size(); ++count) {
                    Root root = (Root)this.sas_library.getUsingPackages().get(count);
                    if (!(root instanceof DatabaseSchema)) continue;
                    schema = (DatabaseSchema)root;
                    break;
                }
                if (schema != null && !schema.getName().equals(this.sas_library.getName())) {
                    schema.setName(this.sas_library.getName());
                }
                if (schema != null && !schema.getSchemaName().equals("")) {
                    schema.setSchemaName("");
                }
            }
            if (schema == null && (schema = (DatabaseSchema)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.sas_library.getObjectStore(), null, this.sas_library.getName(), "DatabaseSchema", this.sas_library.getRepositoryID(), null)) != null) {
                schema.setSchemaName("");
            }
            if (schema != null && !this.sas_library.getUsingPackages().contains(schema)) {
                this.sas_library.getUsingPackages().add(schema);
                Workspace.getDefaultLogger().debug((Object)("Associated DatabaseSchema '" + schema.getName() + "' to SASLibrary '" + this.sas_library.getName() + "'"));
            }
            if (schema != null && this.m_selectedServer != null && !schema.getDeployedComponents().contains((Object)this.m_selectedServer)) {
                AssociationList schemaDeployedComponentsList = schema.getDeployedComponents();
                schemaDeployedComponentsList.clear();
                schemaDeployedComponentsList.add(this.m_selectedServer);
                Workspace.getDefaultLogger().debug((Object)("Associated DatabaseSchema '" + schema.getName() + "' (schema name attribute: '" + schema.getSchemaName() + "') to Database Server '" + this.m_selectedServer.getName() + "'"));
            }
            if (this.m_selectedServer.getFQID().indexOf("$") == -1) {
                this.deleteMetadataServerObjects(this.newMetadataObjectsList);
            } else {
                this.m_selectedServer.setName(this.m_selectedServer.getName().replace(" " + bundle.getString("Customizer.InfomapLib.MetaServerString.Current.txt"), ""));
            }
            String path = this.m_pathText.getText().trim();
            if (path.length() != 0) {
                if (!path.startsWith("\"")) {
                    path = "\"" + path;
                }
                if (!path.endsWith("\"")) {
                    path = path + "\"";
                }
                boolean bPropertySet = false;
                AssociationList propertyList = this.sas_library.getProperties();
                for (int propIndex = 0; propIndex < propertyList.size(); ++propIndex) {
                    Property property = (Property)propertyList.get(propIndex);
                    if (!property.getPropertyName().trim().equalsIgnoreCase("MAPPATH")) continue;
                    String strValue = property.getDefaultValue().trim();
                    if (strValue.equalsIgnoreCase(path)) {
                        return;
                    }
                    property.setDefaultValue(path, 1);
                    Workspace.getDefaultLogger().debug((Object)("Associated MAPPATH " + path + " to SASLibrary '" + this.sas_library.getName() + "'"));
                    bPropertySet = true;
                }
                if (!bPropertySet) {
                    Property property = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.sas_library.getObjectStore(), null, "Library.Common.Property.Path.Name.xmlkey.txt", "Property", this.sas_library.getRepositoryID());
                    property.setPropertyName("MAPPATH", 1);
                    property.setDelimiter("=");
                    property.setUseValueOnly("0");
                    property.setDefaultValue(path, 1);
                    PropertyType type = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.sas_library.getObjectStore(), null, "PropertyType", "PropertyType", this.sas_library.getRepositoryID());
                    type.setName("String", 1);
                    type.setSQLType("12", 1);
                    property.setOwningType(type);
                    propertyList.add(property);
                    Workspace.getDefaultLogger().debug((Object)("Associated MAPPATH " + path + " to SASLibrary '" + this.sas_library.getName() + "'"));
                }
            }
        }
        catch (MdException mdex) {
            Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
            MessageUtil.displayMetadataExceptionMessage((MdException)mdex, (String)"Reading");
        }
        catch (RemoteException rex) {
            String msg = rex.getLocalizedMessage();
            Workspace.getDefaultLogger().error((Object)msg);
            MessageUtil.displayMessage((String)msg, (int)0);
        }
    }

    public String createFinishString() {
        String path;
        String strFinish = bundle.getString("Customizer.InfomapLib.MetaServerLabel.txt") + "\n\t" + MetadataObjectCellRenderer.getDisplayName((Root)this.m_selectedServer) + "\n";
        if (this.m_loginChoice.getSelectedItem() instanceof Root) {
            strFinish = strFinish + bundle.getString("Customizer.InfomapLib.LoginLabel.txt") + "\n\t" + MetadataObjectCellRenderer.getDisplayName((Root)this.m_loginChoice.getSelectedItem()) + "\n";
        }
        if (!(path = this.m_pathText.getText().trim()).startsWith("\"")) {
            path = "\"" + path;
        }
        if (!path.endsWith("\"")) {
            path = path + "\"";
        }
        strFinish = strFinish + bundle.getString("Customizer.InfomapLib.MappathLabel.txt") + "\n\t" + path + "\n";
        return strFinish;
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_selectedLogin == null || this.m_currentLogin == this.m_selectedLogin) {
            return;
        }
        Workspace.getWorkspace().getWorkspaceFile().removeProperty("DBMSLibname.MRU.Domain.3");
        Workspace.getWorkspace().getWorkspaceFile().removeProperty("DBMSLibname.MRU.Login.3");
        String strDomainMRU2 = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("DBMSLibname.MRU.Domain.2");
        String strLoginMRU2 = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("DBMSLibname.MRU.Login.2");
        if (strDomainMRU2.length() > 0 && strLoginMRU2.length() > 0) {
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("DBMSLibname.MRU.Domain.3", strDomainMRU2);
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("DBMSLibname.MRU.Login.3", strLoginMRU2);
        }
        String strDomainMRU1 = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("DBMSLibname.MRU.Domain.1");
        String strLoginMRU1 = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("DBMSLibname.MRU.Login.1");
        if (strDomainMRU1.length() > 0 && strLoginMRU1.length() > 0) {
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("DBMSLibname.MRU.Domain.2", strDomainMRU1);
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("DBMSLibname.MRU.Login.2", strLoginMRU1);
        }
        try {
            if (this.m_selectedLogin.getDomain() != null) {
                Workspace.getWorkspace().getWorkspaceFile().setPropertyString("DBMSLibname.MRU.Domain.1", this.m_selectedLogin.getDomain().getName());
            } else {
                Workspace.getWorkspace().getWorkspaceFile().setPropertyString("DBMSLibname.MRU.Domain.1", " ");
            }
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("DBMSLibname.MRU.Login.1", this.m_selectedLogin.getUserID());
        }
        catch (MdException mdex) {
            Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
        }
        catch (RemoteException rex) {
            Workspace.getDefaultLogger().error((Object)rex.getLocalizedMessage());
        }
        Workspace.getWorkspace().getWorkspaceFile().saveExisting();
    }

    public void onNewServer() {
        try {
            String strClassID = "0217e202-b560-11db-ad91-001083ff6836";
            Container parent = this.getTopLevelAncestor();
            ServerWizard wizard = null;
            MdObjectStore oStore = Workspace.getMdFactory().createObjectStore();
            ViewListener viewListener = new ViewListener(this.m_serverChoice, "ServerComponent", oStore);
            Workspace.getMdFactory().addMdFactoryListener((MdFactoryListener)viewListener);
            strClassID = "SAS Application Server";
            String serverWizardTitle = bundle.getString("Customizer.InfomapLib.ServerWizard.Title.txt");
            String repoID = "A0000001." + this.sas_library.getRepositoryID();
            if (parent instanceof JFrame) {
                wizard = new ServerWizard((JFrame)parent, repoID, serverWizardTitle, strClassID, oStore);
            } else if (parent instanceof Dialog) {
                wizard = new ServerWizard((Dialog)parent, oStore, repoID, serverWizardTitle, strClassID);
            }
            wizard.show();
            if (wizard.getReturnValue() == 2) {
                Workspace.getMdFactory().removeMdFactoryListener((MdFactoryListener)viewListener);
            }
            if (oStore != null) {
                oStore.dispose();
            }
        }
        catch (RemoteException rex) {
            String msg = rex.getLocalizedMessage();
            Workspace.getDefaultLogger().error((Object)msg);
            MessageUtil.displayMessage((String)msg, (int)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServerChanged(ItemEvent evt) {
        Container parent = this.getTopLevelAncestor();
        try {
            Login login;
            if (evt.getStateChange() != 1) {
                return;
            }
            Workspace.getDefaultLogger().debug((Object)("Selected Metadata Server '" + this.m_serverChoice.getSelectedItem() + "'"));
            parent.setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_serverChoice.getItemCount() == 0) {
                parent.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            boolean bServerExists = this.m_serverChoice.getItemCount() > 0;
            boolean bEditable = this.isEditable();
            this.m_connectionsList = null;
            this.m_selectedServer = (DeployedComponent)this.m_serverChoice.getSelectedItem();
            if (this.m_selectedServer.getFQID().indexOf("$") != -1) {
                this.m_connectionsList = this.m_selectedServer.getSourceConnections();
            } else {
                String strSelect;
                String strType = "SASClientConnection";
                String strOptions = strSelect = "<XMLSELECT search=\"*[Source/ServerComponent[@Name='" + this.m_selectedServer.getName() + "']]\"/>";
                int flags = 8584;
                this.m_connectionsList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.sas_library.getObjectStore(), "A0000001." + this.sas_library.getRepositoryID(), strType, flags, strOptions);
            }
            this.m_pathText.setEnabled(bEditable && bServerExists);
            this.m_pathButton.setEnabled(bEditable && bServerExists);
            this.m_loginChoice.setEnabled(bEditable && bServerExists);
            this.m_loginsList = new Vector();
            this.m_loginChoice.removeAllItems();
            SASClientConnection conn = (SASClientConnection)this.m_connectionsList.get(0);
            AuthenticationDomain serverDomain = null;
            serverDomain = conn.getDomain();
            if (serverDomain != null) {
                this.m_currentDomain = serverDomain;
            }
            this.m_loginChoice.setEnabled(bEditable && bServerExists && this.m_currentDomain != null);
            Vector<String> mruList = new Vector<String>(3);
            for (int index = 1; index < 4; ++index) {
                String strMruDomain = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("DBMSLibname.MRU.Domain." + String.valueOf(index));
                String strMruLogin = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("DBMSLibname.MRU.Login." + String.valueOf(index));
                if (strMruDomain.length() <= 0 || strMruLogin.length() <= 0 || this.m_currentDomain == null || !strMruDomain.trim().equalsIgnoreCase(this.m_currentDomain.getName().trim())) continue;
                mruList.add(strMruDomain);
                mruList.add(strMruLogin);
            }
            String strTemplate = "<TEMPLATES><Login><Domain/></Login></TEMPLATES>";
            for (int mruIndex = 0; mruIndex < mruList.size(); mruIndex += 2) {
                String strDomain = ((String)mruList.get(mruIndex)).trim();
                String strLogin = (String)mruList.get(mruIndex + 1);
                String strXMLSelect = "<XMLSELECT search=\"Login[@UserId='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strLogin) + "'][Domain/AuthenticationDomain[@Name='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strDomain) + "']]\" />";
                if (strDomain.length() == 0) {
                    strXMLSelect = "<XMLSELECT search=\"Login[@UserId='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strLogin) + "']\" />";
                }
                int flags = 8604;
                String strOptions = strTemplate + strXMLSelect;
                List loginList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.sas_library.getObjectStore(), "A0000001." + this.sas_library.getRepositoryID(), "Login", flags, strOptions);
                for (int loginIndex = 0; loginIndex < loginList.size(); ++loginIndex) {
                    Login login2 = (Login)loginList.get(loginIndex);
                    if (this.m_loginsList.contains(login2)) continue;
                    this.m_loginsList.add(login2);
                }
            }
            this.populateLogins();
            if (this.sas_library != null && (login = this.sas_library.getDefaultLogin()) != null && this.m_currentDomain != null && this.m_currentDomain.getLogins().contains((Object)login)) {
                if (!this.m_loginsList.contains(login)) {
                    this.m_loginsList.add(login);
                    this.populateLogins();
                }
                this.m_loginChoice.setSelectedItem(login);
            }
            this.m_currentLogin = null;
            if (this.m_loginChoice.getSelectedItem() instanceof Login) {
                this.m_currentLogin = (Login)this.m_loginChoice.getSelectedItem();
            }
        }
        catch (MdException mdex) {
            Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
            MessageUtil.displayMetadataExceptionMessage((MdException)mdex, (String)"Reading");
        }
        catch (RemoteException rex) {
            String msg = rex.getLocalizedMessage();
            Workspace.getDefaultLogger().error((Object)msg);
            MessageUtil.displayMessage((String)msg, (int)0);
        }
        finally {
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * Exception decompiling
     */
    protected void onBrowse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void onMoreLogins(ItemEvent evt) {
        try {
            String strObj;
            if (evt.getStateChange() != 1) {
                return;
            }
            Object obj = evt.getItem();
            if (obj instanceof String && (strObj = (String)obj).trim().equalsIgnoreCase(bundle.getString("Customizer.InfomapLib.Login.MoreLogins.txt"))) {
                LoginSearchModel model = new LoginSearchModel(Workspace.getWorkspace().getCMRHandle(), (MdObjectStore)this.sas_library.getObjectStore(), "A0000001." + this.sas_library.getRepositoryID());
                if (this.m_currentDomain != null) {
                    model.setAuthDomain(this.m_currentDomain);
                }
                if (this.m_currentLogin != null) {
                    model.setUserID(this.m_currentLogin.getUserID());
                }
                LoginSearchPanel panel = new LoginSearchPanel(model);
                Container parent = this.getTopLevelAncestor();
                WAStandardDialog dialog = null;
                if (parent instanceof JFrame) {
                    dialog = new WAStandardDialog((Frame)((JFrame)parent));
                }
                if (parent instanceof Dialog) {
                    dialog = new WAStandardDialog((Dialog)parent);
                }
                dialog.setModal(true);
                dialog.setTitle(bundle.getString("Customizer.InfomapLib.LoginSearchPanel.Title.txt"));
                dialog.setMainPanel((WAPanel)panel);
                dialog.show();
                if (dialog.getReturnValue() == 1) {
                    List resultsList = model.getResults();
                    if (resultsList.size() > 0) {
                        Login resultLogin = (Login)resultsList.get(0);
                        if (resultLogin != this.m_currentLogin && !this.m_loginsList.contains(resultLogin)) {
                            this.m_loginsList.add(resultLogin);
                            this.populateLogins();
                        }
                        this.m_loginChoice.setSelectedItem(resultLogin);
                    }
                } else if (this.m_currentLogin != null) {
                    this.m_loginChoice.setSelectedItem(this.m_currentLogin);
                } else {
                    this.m_loginChoice.setSelectedIndex(0);
                }
                model.dispose();
                model = null;
            }
        }
        catch (RemoteException rex) {
            String msg = rex.getLocalizedMessage();
            Workspace.getDefaultLogger().error((Object)msg);
            MessageUtil.displayMessage((String)msg, (int)0);
        }
    }

    private void populateLogins() {
        this.m_loginChoice.removeAllItems();
        this.m_loginChoice.addItem(bundle.getString("Customizer.InfomapLib.Login.None.txt"));
        this.m_loginsList = SortUtil.sortAscending(this.m_loginsList);
        if (this.m_loginsList != null) {
            for (int i = 0; i < this.m_loginsList.size(); ++i) {
                Login login = (Login)this.m_loginsList.get(i);
                this.m_loginChoice.addItem(login);
            }
        }
        this.m_loginChoice.addItem(bundle.getString("Customizer.InfomapLib.Login.MoreLogins.txt"));
    }

    private void deleteMetadataServerObjects(List objList) {
        try {
            if (objList != null) {
                for (int i = 0; i < objList.size(); ++i) {
                    Root dc = (Root)objList.get(i);
                    dc.delete();
                }
            }
        }
        catch (RemoteException rex) {
            Workspace.getDefaultLogger().error((Object)rex.getLocalizedMessage());
        }
    }

    private ServerComponent createMetadataServerWithSASClientConnection(String name, String host, String port) {
        ServerComponent newMdServerComp = null;
        this.deleteMetadataServerObjects(this.newMetadataObjectsList);
        this.newMetadataObjectsList = new Vector();
        try {
            MdFactory factory = Workspace.getMdFactory();
            MdObjectStore objectStore = (MdObjectStore)this.sas_library.getObjectStore();
            String repository = this.sas_library.getRepositoryID();
            ServerContext newMdServerCont = (ServerContext)factory.createComplexMetadataObject(objectStore, (MdStore)null, name, "ServerContext", repository);
            this.newMetadataObjectsList.add(newMdServerCont);
            newMdServerCont.setClassIdentifier("SAS Application Server");
            newMdServerCont.setMajor("9");
            newMdServerCont.setMinor("2");
            newMdServerCont.setSoftwareVersion("9.2");
            newMdServerCont.setProductName("SAS");
            newMdServerCont.setVendor("SAS Institute");
            newMdServerCont.setPublicType("ApplicationServer");
            newMdServerCont.setUsageVersion(new UsageVersion(1, 0).encode());
            ServiceType dataService = (ServiceType)factory.createComplexMetadataObject(objectStore, (MdStore)null, "Data Service", "ServiceType", repository);
            this.newMetadataObjectsList.add(dataService);
            newMdServerCont.getServiceTypes().add((Object)dataService);
            newMdServerComp = (ServerComponent)factory.createComplexMetadataObject(objectStore, (MdStore)null, bundle.formatString("Customizer.InfomapLib.NewMdServerComponent.Name.fmt.txt", (Object)name), "ServerComponent", repository);
            this.newMetadataObjectsList.add(newMdServerComp);
            newMdServerComp.setClassIdentifier("0217e202-b560-11db-ad91-001083ff6836");
            newMdServerComp.setMajor("9");
            newMdServerComp.setMinor("2");
            newMdServerComp.setSoftwareVersion("9.2");
            newMdServerComp.setProductName("SAS Metadata Server");
            newMdServerComp.setVendor("SAS Institute");
            newMdServerComp.setPublicType("Server.Metadata");
            newMdServerComp.setUsageVersion(new UsageVersion(1, 0).encode());
            ServiceType iomServer = (ServiceType)factory.createComplexMetadataObject(objectStore, (MdStore)null, "IOM Server", "ServiceType", repository);
            this.newMetadataObjectsList.add(iomServer);
            newMdServerComp.getServiceTypes().add((Object)iomServer);
            Machine defaultMachine = null;
            int flags = 8456;
            List m_machineList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, "A0000001." + repository, "Machine", flags, "");
            for (int i = 0; i < m_machineList.size(); ++i) {
                Machine mach = (Machine)m_machineList.get(i);
                if (!mach.getName().trim().equalsIgnoreCase(host.trim())) continue;
                defaultMachine = mach;
                break;
            }
            if (defaultMachine == null) {
                defaultMachine = (Machine)factory.createComplexMetadataObject(objectStore, (MdStore)null, host, "Machine", repository);
                this.newMetadataObjectsList.add(defaultMachine);
            }
            newMdServerComp.getAssociatedMachines().add(defaultMachine);
            LogicalServer newMdLogicalServer = (LogicalServer)factory.createComplexMetadataObject(objectStore, (MdStore)null, bundle.formatString("Customizer.InfomapLib.LogicalServer.Name.fmt.txt", (Object)name), "LogicalServer", repository);
            this.newMetadataObjectsList.add(newMdLogicalServer);
            newMdLogicalServer.setClassIdentifier("0217e202-b560-11db-ad91-001083ff6836");
            newMdLogicalServer.setPublicType("LogicalServer.Metadata");
            newMdLogicalServer.setUsageVersion(new UsageVersion(1, 0).encode());
            newMdLogicalServer.getUsingComponents().add((Object)newMdServerComp);
            newMdLogicalServer.getUsedByComponents().add((Object)newMdServerCont);
            ServiceType log_iomServer = (ServiceType)factory.createComplexMetadataObject(objectStore, (MdStore)null, "Logical IOM Server", "ServiceType", repository);
            this.newMetadataObjectsList.add(log_iomServer);
            newMdLogicalServer.getServiceTypes().add((Object)log_iomServer);
            Property newProp = (Property)factory.createComplexMetadataObject(objectStore, (MdStore)null, "LogicalServer.Security.Property.AuthService.Name.xmlKey.txt", "Property", repository);
            this.newMetadataObjectsList.add(newProp);
            newProp.setPropertyName("AuthService");
            newProp.setDefaultValue("Metadata");
            newProp.setDelimiter("");
            newProp.setUseValueOnly("0");
            newMdLogicalServer.getProperties().add((Object)newProp);
            PropertyType newPropType = (PropertyType)factory.createComplexMetadataObject(objectStore, (MdStore)null, "AuthorizationServiceType", "PropertyType", repository);
            this.newMetadataObjectsList.add(newPropType);
            newPropType.setSQLType("12");
            newProp.setOwningType(newPropType);
            String textStoreName = "Enumeration of Authorization Service Types";
            TextStore newTextStore = (TextStore)factory.createComplexMetadataObject(objectStore, (MdStore)null, textStoreName, "TextStore", repository);
            this.newMetadataObjectsList.add(newTextStore);
            newTextStore.setTextType("xml");
            newTextStore.setTextRole("config");
            newTextStore.setStoredText("<Configuration><Enumeration><Value name=\"Host\">LogicalServer.AuthService.Host.Value.xmlKey.txt</Value><Value name=\"Metadata\">LogicalServer.AuthService.Metadata.Value.xmlKey.txt</Value><Value name=\"Prompt\">LogicalServer.AuthService.Prompt.Value.xmlKey.txt</Value></Enumeration></Configuration>");
            newPropType.getStoredConfigurations().add((Object)newTextStore);
            SASClientConnection conn = (SASClientConnection)factory.createComplexMetadataObject(objectStore, (MdStore)null, bundle.formatString("Customizer.InfomapLib.SASClientConnection.Name.fmt.txt", (Object)newMdServerComp.getName()), "SASClientConnection", repository);
            this.newMetadataObjectsList.add(conn);
            conn.setRemoteAddress(host);
            conn.setAuthenticationType("user/password");
            conn.setApplicationProtocol("SBIP");
            conn.setPort(port);
            conn.setCommunicationProtocol("TCP");
            newMdServerComp.getSourceConnections().add((Object)conn);
            AuthenticationDomain defaultAuthDom = null;
            flags = 8456;
            List m_domainList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, "A0000001." + repository, "AuthenticationDomain", flags, "");
            for (int i = 0; i < m_domainList.size(); ++i) {
                AuthenticationDomain dom = (AuthenticationDomain)m_domainList.get(i);
                if (!dom.getName().trim().equalsIgnoreCase("DefaultAuth")) continue;
                defaultAuthDom = dom;
                break;
            }
            if (defaultAuthDom == null) {
                defaultAuthDom = (AuthenticationDomain)factory.createComplexMetadataObject(objectStore, (MdStore)null, "DefaultAuth", "AuthenticationDomain", repository);
                this.newMetadataObjectsList.add(defaultAuthDom);
            }
            conn.setDomain(defaultAuthDom);
        }
        catch (MdException mdex) {
            Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
        }
        catch (RemoteException rex) {
            Workspace.getDefaultLogger().error((Object)rex.getLocalizedMessage());
        }
        return newMdServerComp;
    }

    protected class ViewListener
    implements MdFactoryListener {
        protected JComboBox m_choice;
        protected String m_strMetadataType;
        protected MdObjectStore m_store;

        public ViewListener(JComboBox choice, String strMetadataType, MdObjectStore store) {
            this.m_choice = choice;
            this.m_strMetadataType = strMetadataType;
            this.m_store = store;
        }

        public void MdObjectsCreated(MdFactoryEvent e) {
            try {
                boolean bProcessed = false;
                Object[] ids = e.getObjectMap().keySet().toArray();
                for (int i = 0; i < ids.length; ++i) {
                    String strID = (String)ids[i];
                    CMetadata meta = this.m_store.getObject(strID);
                    if (meta == null) {
                        return;
                    }
                    if (!meta.getCMetadataType().trim().equalsIgnoreCase(this.m_strMetadataType.trim())) continue;
                    Root root = (Root)meta;
                    this.m_choice.removeAllItems();
                    DeployedComponent mdserver_hold = null;
                    if (InfomapLibraryConnectionPanel.this.m_selectedServer != null && InfomapLibraryConnectionPanel.this.m_selectedServer.getFQID().indexOf("$") != -1) {
                        mdserver_hold = InfomapLibraryConnectionPanel.this.m_selectedServer;
                    }
                    List itemsList = null;
                    String strType = this.m_strMetadataType;
                    String strTemplate = "<TEMPLATES><ServerComponent><SourceConnections/><DataPackages/></ServerComponent><SASClientConnection><Domain/></SASClientConnection><AuthenticationDomain><Logins/></AuthenticationDomain><Login/><DatabaseSchema/></TEMPLATES>";
                    String strClassID = "0217e202-b560-11db-ad91-001083ff6836";
                    String strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='" + strClassID + "'][SourceConnections/SASClientConnection[@ApplicationProtocol='SBIP']]\"/>";
                    String strOptions = strTemplate + strSelect;
                    int flags = 8588;
                    itemsList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(InfomapLibraryConnectionPanel.this.sas_library.getObjectStore(), "A0000001." + InfomapLibraryConnectionPanel.this.sas_library.getRepositoryID(), strType, flags, strOptions);
                    if (mdserver_hold != null) {
                        itemsList.add(mdserver_hold);
                    }
                    for (int j = 0; itemsList != null && j < itemsList.size(); ++j) {
                        Root itemRoot = (Root)itemsList.get(j);
                        this.m_choice.addItem(itemRoot);
                        if (!itemRoot.getFQID().trim().equalsIgnoreCase(root.getFQID().trim())) continue;
                        this.m_choice.setSelectedItem(itemRoot);
                        bProcessed = true;
                    }
                }
                if (bProcessed) {
                    Workspace.getMdFactory().removeMdFactoryListener((MdFactoryListener)this);
                }
            }
            catch (MdException mdex) {
                Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
            }
            catch (RemoteException rex) {
                Workspace.getDefaultLogger().error((Object)rex.getLocalizedMessage());
            }
        }

        public void MdObjectsModified(MdFactoryEvent e) {
        }

        public void MdObjectsDeleted(MdFactoryEvent e) {
        }
    }
}

