/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.meta.SASOMI.ISecurity;
import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.SecurityUtil;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.AuthenticationDomainDialog;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.LibraryWizard;
import com.sas.workspace.mgmt.visuals.OLAPSchemaFolderException;
import com.sas.workspace.mgmt.visuals.OLAPSchemaWizard;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.Server;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServerConfigView
extends WsDescriptionWizardTab {
    protected Server m_server;
    protected Prototype m_prototype;
    protected AssociationProperty m_property;
    protected String m_strServerType;
    protected String m_strClassID;
    protected String m_strViewName;
    protected Machine m_prevMachine;
    protected String m_strDefaultRequest;
    protected String m_strConfigClassParms;
    protected List m_domainList;
    protected Root m_createdRoot;
    protected boolean m_bCustomServerDefined = false;
    protected boolean m_bIsWorkspaceServer = false;
    protected boolean m_bIsStoredProcessServer = false;
    protected boolean m_bIsMetadataServer = false;
    protected boolean m_bIsOLAPServer = false;
    protected boolean m_bIsConnectServer = false;
    protected boolean m_bIsPooledWorkspaceServer = false;
    protected boolean m_bIsABMServer = false;
    protected boolean m_bIsProcessOrchestrationServer = false;
    protected JRadioButton m_defaultRadio;
    protected JRadioButton m_customRadio;
    protected WATextArea m_defaultText;
    protected WATextArea m_customText;
    protected JLabel m_domainLabel;
    protected JLabel m_hostLabel;
    protected JLabel m_portLabel;
    protected JComboBox m_domainChoice;
    protected JTextField m_hostText;
    protected JTextField m_portText;
    protected JButton m_domainButton;
    protected boolean m_bDomainChoiceState = true;
    protected boolean m_bHostTextState = true;
    protected boolean m_bPortTextState = true;
    protected static final WAdminResource bundle = new WAdminResource(ServerConfigView.class);
    private static final long serialVersionUID = -5017110150686685540L;

    public ServerConfigView(Server server) {
        this.m_server = server;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        try {
            if (!bSaveToModel) {
                Library parentLib;
                Component comp = this.m_server.getParentComponent();
                if (comp instanceof LibraryWizard) {
                    LibraryWizard wizard = (LibraryWizard)((Object)comp);
                    parentLib = wizard.m_library;
                    if (((SASLibrary)parentLib.getDeployedDataPackage()).getEngine().equalsIgnoreCase("SASIOIME")) {
                        this.disableBasicWidgets();
                        return true;
                    }
                } else if (comp instanceof WAPropertyDialog) {
                    WAPropertyDialog propDialog = (WAPropertyDialog)comp;
                    if (propDialog.getMetadataObject() instanceof SASLibrary && (parentLib = (SASLibrary)propDialog.getMetadataObject()).getEngine().equalsIgnoreCase("SASIOIME")) {
                        this.disableBasicWidgets();
                        return true;
                    }
                    if (propDialog.getMetadataObject() instanceof DatabaseSchema) {
                        DatabaseSchema schema = (DatabaseSchema)propDialog.getMetadataObject();
                        try {
                            if (((ServerComponent)schema.getDeployedComponents().get(0)).getClassIdentifier().equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836")) {
                                this.disableBasicWidgets();
                                return true;
                            }
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        }
                        catch (RemoteException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                }
                this.onRadioChanged();
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                this.m_prototype = (Prototype)parent.getWizardData("ServerContextPrototype");
                List namesList = (List)parent.getWizardData("ServerTypesList");
                this.m_strServerType = (String)namesList.get(0);
                String strDescription = bundle.formatString("ServerConfigView.WizardTitle.fmt.txt", (Object)PrototypeUtil.getDisplayString(this.m_strServerType, this.m_prototype));
                this.setDescription(strDescription);
                this.m_bIsWorkspaceServer = false;
                this.m_bIsStoredProcessServer = false;
                this.m_bIsMetadataServer = false;
                this.m_bIsOLAPServer = false;
                this.m_bIsConnectServer = false;
                this.m_bIsPooledWorkspaceServer = false;
                this.m_bIsABMServer = false;
                this.m_bIsProcessOrchestrationServer = false;
                this._loadDomains();
                this.m_hostText.setText("localhost");
                List prototypesList = this.m_server.getLogicalServerComponentPrototypes((Component)parent);
                for (int i = 0; i < prototypesList.size(); ++i) {
                    Prototype prototype = (Prototype)prototypesList.get(i);
                    String strName = PrototypeUtil.getDisplayString(prototype.getName(), prototype);
                    try {
                        AssociationList propertiesList = prototype.getPrototypeProperties();
                        boolean bPropertyFound = false;
                        if (strName.equals(this.m_strServerType)) {
                            for (int j = 0; j < propertiesList.size(); ++j) {
                                AttributeProperty ap;
                                AbstractProperty property = (AbstractProperty)propertiesList.get(j);
                                if (!(property instanceof AttributeProperty) || !(ap = (AttributeProperty)property).getPropertyName().equals("ClassIdentifier")) continue;
                                String strClassID = ap.getDefaultValue();
                                if (strClassID.equalsIgnoreCase("440196D4-90F0-11D0-9F41-00A024BB830C")) {
                                    this.m_bIsWorkspaceServer = true;
                                    this.m_portText.setText("8591");
                                } else if (strClassID.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
                                    this.m_bIsStoredProcessServer = true;
                                    this.m_portText.setText("8601");
                                } else if (strClassID.equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836")) {
                                    this.m_bIsMetadataServer = true;
                                    this.m_portText.setText("8561");
                                } else if (strClassID.equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6")) {
                                    this.m_bIsOLAPServer = true;
                                    this.m_portText.setText("5451");
                                } else if (strClassID.equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06")) {
                                    this.m_bIsConnectServer = true;
                                    this.m_portText.setText("7551");
                                } else if (strClassID.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) {
                                    this.m_bIsPooledWorkspaceServer = true;
                                    this.m_portText.setText("8701");
                                } else if (strClassID.equalsIgnoreCase("510A5F10-8E07-44AC-942B-EFB5A4782A39")) {
                                    this.m_bIsABMServer = true;
                                    this.m_portText.setText("6785");
                                } else if (strClassID.equalsIgnoreCase("94D98CD0-56C5-40A3-A140-49D21D17BDCE")) {
                                    this.m_bIsProcessOrchestrationServer = true;
                                    this.m_portText.setText("21040");
                                } else {
                                    this.m_portText.setText("");
                                }
                                bPropertyFound = true;
                                this.m_strClassID = strClassID;
                                break;
                            }
                        }
                        if (!bPropertyFound) continue;
                        break;
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        return false;
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                }
                if (this.m_bIsWorkspaceServer || this.m_bIsStoredProcessServer || this.m_bIsMetadataServer || this.m_bIsOLAPServer || this.m_bIsPooledWorkspaceServer || this.m_bIsABMServer || this.m_bIsProcessOrchestrationServer) {
                    this.m_defaultText.setText(bundle.getString("ServerConfigView.DefaultText.IOM.txt"));
                } else {
                    this.m_defaultText.setText(bundle.getString("ServerConfigView.DefaultText.txt"));
                }
                Hashtable propertiesTable = (Hashtable)parent.getWizardData("Properties");
                if (propertiesTable != null) {
                    Enumeration e = propertiesTable.keys();
                    while (e.hasMoreElements()) {
                        Object key = e.nextElement();
                        if (!(key instanceof Connection)) continue;
                        Connection ptConn = (Connection)key;
                        Hashtable[] connTableArray = (Hashtable[])propertiesTable.get(ptConn);
                        for (int index = 0; index < connTableArray.length; ++index) {
                            String strPort;
                            String strRemoteAddress;
                            String strHost;
                            Hashtable connTable = connTableArray[index];
                            String strDomain = (String)connTable.get("AssociationName");
                            if (strDomain != null && strDomain.equals("Domain")) {
                                String strUpdateable;
                                Object defaultValue = connTable.get("DefaultValue");
                                if (defaultValue != null) {
                                    this.m_domainChoice.setSelectedItem(defaultValue);
                                }
                                if ((strUpdateable = (String)connTable.get("IsUpdateable")) != null) {
                                    this.m_domainChoice.setEnabled(strUpdateable.equals("1"));
                                    this.m_bDomainChoiceState = strUpdateable.equals("1");
                                }
                            }
                            if ((strHost = (String)connTable.get("PropertyName")) != null && strHost.equals("HostName")) {
                                String strUpdateable;
                                String strDefaultValue = (String)connTable.get("DefaultValue");
                                if (strDefaultValue != null) {
                                    this.m_hostText.setText(strDefaultValue);
                                }
                                if ((strUpdateable = (String)connTable.get("IsUpdateable")) != null) {
                                    this.m_hostText.setEnabled(strUpdateable.equals("1"));
                                    this.m_bHostTextState = strUpdateable.equals("1");
                                }
                            }
                            if ((strRemoteAddress = (String)connTable.get("PropertyName")) != null && strRemoteAddress.equals("RemoteAddress")) {
                                String strUpdateable;
                                String strDefaultValue = (String)connTable.get("DefaultValue");
                                if (strDefaultValue != null) {
                                    this.m_hostText.setText(strDefaultValue);
                                }
                                if ((strUpdateable = (String)connTable.get("IsUpdateable")) != null) {
                                    this.m_hostText.setEnabled(strUpdateable.equals("1"));
                                    this.m_bHostTextState = strUpdateable.equals("1");
                                }
                            }
                            if ((strPort = (String)connTable.get("PropertyName")) != null && strPort.equals("Port")) {
                                String strUpdateable;
                                String strDefaultValue = (String)connTable.get("DefaultValue");
                                if (strDefaultValue != null) {
                                    this.m_portText.setText(strDefaultValue);
                                }
                                if ((strUpdateable = (String)connTable.get("IsUpdateable")) != null) {
                                    this.m_portText.setEnabled(strUpdateable.equals("1"));
                                    this.m_bPortTextState = strUpdateable.equals("1");
                                }
                            }
                            try {
                                if (ptConn.getSource() != null) continue;
                                Vector<Connection> objectsToRemoveList = new Vector<Connection>();
                                objectsToRemoveList.add(ptConn);
                                ((MdObjectStore)((Connection)key).getObjectStore()).removeObjectsFromStore(objectsToRemoveList);
                                continue;
                            }
                            catch (MdException exc) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Deleting");
                                continue;
                            }
                            catch (RemoteException exc) {
                                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                            }
                        }
                    }
                }
                this._parseXML();
                this.removeAll();
                this._layoutWidgets();
                this.revalidate();
            }
            return false;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return false;
        }
    }

    public boolean validateData() {
        AssociationList dataPackagesList;
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        boolean bValid = true;
        if (this.m_customRadio.isSelected()) {
            return bValid;
        }
        if (this.m_domainChoice.getSelectedItem() == null) {
            this._showErrorMessage((Container)parent, this.m_domainLabel.getText().trim());
            bValid = false;
            return bValid;
        }
        if (this.m_hostText.getText().trim().length() == 0) {
            this._showErrorMessage((Container)parent, this.m_hostLabel.getText().trim());
            bValid = false;
            return bValid;
        }
        if (this.m_portText.getText().trim().length() == 0) {
            this._showErrorMessage((Container)parent, this.m_portLabel.getText().trim());
            bValid = false;
            return bValid;
        }
        Server server = (Server)parent.getWizardData("Server");
        if (server != null) {
            try {
                ServerContext scxt = (ServerContext)server.getDeployedComponent();
                dataPackagesList = scxt.getDataPackages();
                MdObjectStore store = server.getStore();
                Vector<Object> objectsToRemoveList = new Vector<Object>();
                for (int dpIndex = 0; dpIndex < dataPackagesList.size(); ++dpIndex) {
                    Tree parentFolder;
                    DeployedDataPackage ddp = (DeployedDataPackage)dataPackagesList.get(dpIndex);
                    if (!(ddp instanceof OLAPSchema) || ddp.getFQID().indexOf(36) == -1) continue;
                    objectsToRemoveList.add(ddp);
                    AssociationList ddpPropList = ddp.getProperties();
                    for (int propIndex = 0; propIndex < ddpPropList.size(); ++propIndex) {
                        Property prop = (Property)ddpPropList.get(propIndex);
                        objectsToRemoveList.add(prop);
                        PropertyType propType = prop.getOwningType();
                        if (propType == null) continue;
                        objectsToRemoveList.add(propType);
                        TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                        if (propTypeText == null) continue;
                        objectsToRemoveList.add(propTypeText);
                    }
                    AssociationList lstParentFolders = ddp.getTrees();
                    if (lstParentFolders.size() <= 0 || (parentFolder = (Tree)lstParentFolders.get(0)).getFQID().indexOf(36) == -1) continue;
                    objectsToRemoveList.add(parentFolder);
                }
                store.removeObjectsFromStore(objectsToRemoveList);
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
        if (this.m_bIsOLAPServer) {
            OLAPSchema schema = null;
            try {
                dataPackagesList = server.getDeployedComponent().getDataPackages();
                for (int dpIndex = 0; dpIndex < dataPackagesList.size(); ++dpIndex) {
                    DeployedDataPackage ddp = (DeployedDataPackage)dataPackagesList.get(dpIndex);
                    if (!(ddp instanceof OLAPSchema)) continue;
                    dataPackagesList.remove(ddp);
                    --dpIndex;
                }
                String strSchemaName = bundle.formatString("ServerConfigView.OLAPSchemaName.fmt.txt", (Object)server.getDeployedComponent().getName());
                String strOLAPSelect = "<XMLSELECT search=\"*[@Name='" + strSchemaName + "']\" />";
                int flags = 8584;
                List schemaList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_server.getDeployedComponent().getObjectStore(), this.m_server.getContext(), "OLAPSchema", flags, strOLAPSelect);
                if (schemaList.size() > 0) {
                    int returnValue = MessageUtil.displayMessage((String)bundle.formatString("ServerConfigView.OLAPSchemaExistsWarning.fmt.txt", (Object)strSchemaName, (Object)server.getDeployedComponent().getName()), (int)2, (int)0);
                    if (returnValue == 0) {
                        schema = (OLAPSchema)schemaList.get(0);
                        dataPackagesList.add(schema);
                    }
                } else {
                    block21: {
                        schema = (OLAPSchema)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)server.getDeployedComponent().getObjectStore(), null, strSchemaName, "OLAPSchema", server.getContext().substring(9), null);
                        try {
                            OLAPSchemaWizard.setOLAPSchemaDefaults(schema);
                        }
                        catch (OLAPSchemaFolderException e) {
                            WAStandardDialog dialog = new WAStandardDialog((Dialog)parent, bundle.getString("ServerConfigView.SelectLocation.Title.txt"));
                            OLAPSchemaFolderPanel panel = new OLAPSchemaFolderPanel();
                            dialog.setMainPanel((WAPanel)panel);
                            dialog.setModal(true);
                            dialog.setApplyButtonVisible(false);
                            dialog.setHelpButtonVisible(false);
                            dialog.setCancelButtonVisible(false);
                            dialog.setCloseButtonVisible(false);
                            dialog.setVisible(true);
                            if (dialog.getReturnValue() != 1) break block21;
                            schema.getTrees().add((Object)panel.getFolder());
                        }
                    }
                    dataPackagesList.add(schema);
                }
                if (schema.getTrees().size() == 0) {
                    MessageUtil.displayMessage((String)bundle.getString("ServerConfigView.OLAPSchemaNoLocation.txt"), (int)0);
                    bValid = false;
                    return bValid;
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
        return bValid;
    }

    protected void _showErrorMessage(Container parent, String strFieldName) {
        String strMessage = bundle.formatString("PropertiesPropertyView.FieldIsRequired.fmt.txt", (Object)strFieldName);
        String strTitle = bundle.getString("Common.RequiredField.txt");
        MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
    }

    public String getViewName() {
        return this.m_strViewName;
    }

    public String createFinishString() {
        try {
            String strFinish = "";
            if (this.m_defaultRadio.isSelected()) {
                strFinish = strFinish + bundle.getString("ServerConfigView.AuthenticationDomain.txt") + "\n\t" + ((AuthenticationDomain)this.m_domainChoice.getSelectedItem()).getName() + "\n";
                strFinish = strFinish + bundle.getString("ServerConfigView.Host.txt") + "\n\t" + this.m_hostText.getText().trim() + "\n";
                strFinish = strFinish + bundle.getString("ServerConfigView.Port.txt") + "\n\t" + this.m_portText.getText().trim() + "\n";
            }
            return strFinish;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    protected void _loadDomains() {
        this.m_domainChoice.removeAllItems();
        try {
            int flags = 8456;
            this.m_domainList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_server.getStore(), this.m_server.getContext(), "AuthenticationDomain", flags, "");
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        for (int i = 0; i < this.m_domainList.size(); ++i) {
            AuthenticationDomain domain = (AuthenticationDomain)this.m_domainList.get(i);
            this.m_domainChoice.addItem(domain);
        }
    }

    public void onRadioChanged() {
        if (this.m_defaultRadio.isSelected()) {
            this.m_domainLabel.setEnabled(true);
            this.m_domainChoice.setEnabled(true);
            this.m_domainButton.setEnabled(true);
            this.m_hostLabel.setEnabled(true);
            this.m_portLabel.setEnabled(true);
            this.m_hostText.setEnabled(true);
            this.m_portText.setEnabled(true);
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            Hashtable propertiesTable = (Hashtable)parent.getWizardData("Properties");
            if (propertiesTable != null) {
                this.m_domainChoice.setEnabled(this.m_bDomainChoiceState);
                this.m_hostText.setEnabled(this.m_bHostTextState);
                this.m_portText.setEnabled(this.m_bPortTextState);
            }
        } else if (this.m_customRadio.isSelected()) {
            this.m_domainLabel.setEnabled(false);
            this.m_domainChoice.setEnabled(false);
            this.m_domainButton.setEnabled(false);
            this.m_hostLabel.setEnabled(false);
            this.m_portLabel.setEnabled(false);
            this.m_hostText.setEnabled(false);
            this.m_portText.setEnabled(false);
        }
    }

    public void onNewDomain() {
        try {
            ViewListener viewListener = new ViewListener(this.m_domainChoice, "AuthenticationDomain");
            Workspace.getMdFactory().addMdObjectFactoryListener((MdObjectFactoryListener)viewListener);
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            AuthenticationDomainDialog dialog = new AuthenticationDomainDialog((Dialog)parent, Workspace.getMdFactory().createObjectStore(), this.m_server.getContext());
            dialog.show();
            if (dialog.getReturnValue() == 2) {
                Workspace.getMdFactory().removeMdObjectFactoryListener((MdObjectFactoryListener)viewListener);
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public Root getCreatedObject() {
        return this.m_createdRoot;
    }

    protected void _parseXML() {
        String strXML = "";
        try {
            this.m_property = (AssociationProperty)this.m_prototype.getAssociations().get(0);
            strXML = ((TextStore)this.m_property.getStoredConfiguration()).getStoredText();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            return;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        if (strXML.indexOf("SASInstantiations") != -1) {
            String strStart = "<SASInstantiations>";
            String strEnd = "</SASInstantiations>";
            strXML = strXML.substring(strXML.indexOf(strStart), strXML.indexOf(strEnd) + strEnd.length());
            Document doc = null;
            try {
                doc = Workspace.getMdFactory().getOMIUtil().parseXML(strXML);
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                return;
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            if (doc != null) {
                this._buildData(doc);
            }
        }
    }

    private void _buildData(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this._buildData(children.item(childIndex));
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equals("SASInstantiation")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String strClassID = childNodeMap.getNamedItem("ClassIdentifier").getNodeValue();
                    if (!strClassID.equals(this.m_strClassID)) break;
                    NodeList serverNodeList = node.getChildNodes();
                    for (int j = 0; j < serverNodeList.getLength(); ++j) {
                        Node serverChildNode = serverNodeList.item(j);
                        this._buildChildData(serverChildNode);
                    }
                } else {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                        this._buildData(children.item(childIndex));
                    }
                }
                break;
            }
        }
    }

    private void _buildChildData(Node node) {
        try {
            short nodeType = node.getNodeType();
            switch (nodeType) {
                case 9: {
                    NodeList children = node.getChildNodes();
                    for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                        this._buildChildData(children.item(childIndex));
                    }
                    break;
                }
                case 1: {
                    if (node.getNodeName().equals("DefaultConfiguration")) {
                        String strStart = "<DefaultConfiguration>";
                        String strEnd = "</DefaultConfiguration>";
                        String strRequest = Workspace.getMdFactory().getUtil().createStringForNode(node);
                        this.m_strDefaultRequest = strRequest.substring(strRequest.indexOf(strStart) + strStart.length(), strRequest.indexOf(strEnd)).trim();
                        break;
                    }
                    if (node.getNodeName().equals("CustomConfiguration")) {
                        String strStart = "<CustomConfiguration>";
                        String strEnd = "</CustomConfiguration>";
                        String strClassParms = Workspace.getMdFactory().getUtil().createStringForNode(node);
                        this.m_strConfigClassParms = strClassParms.substring(strClassParms.indexOf(strStart) + strStart.length(), strClassParms.indexOf(strEnd)).trim();
                        break;
                    }
                    NodeList children = node.getChildNodes();
                    if (children != null) {
                        for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                            this._buildChildData(children.item(childIndex));
                        }
                    }
                    break;
                }
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void onNext() {
        block33: {
            try {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                if (this.m_defaultRadio.isSelected()) {
                    int index;
                    String strName = Workspace.getMdFactory().getOMIUtil().cleanStringForXML(this.m_server.getDeployedComponent().getName());
                    String strDomainID = ((AuthenticationDomain)this.m_domainChoice.getSelectedItem()).getFQID();
                    String strHost = this.m_hostText.getText().trim();
                    String strPort = this.m_portText.getText().trim();
                    String strReposID = this.m_server.getContext();
                    String strRequest = this.m_strDefaultRequest;
                    String strSelect = "<XMLSELECT search=\"@Name='" + strHost + "'\" />";
                    int flags = 8584;
                    String strMachineID = "$Machine";
                    try {
                        List machineList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_server.getStore(), this.m_server.getContext(), "Machine", flags, strSelect);
                        if (this.m_prevMachine != null && this.m_prevMachine.getFQID().indexOf(36) != -1) {
                            Vector<Machine> objectsToRemoveList = new Vector<Machine>();
                            objectsToRemoveList.add(this.m_prevMachine);
                            ((MdObjectStore)this.m_prevMachine.getObjectStore()).removeObjectsFromStore(objectsToRemoveList);
                        }
                        if (!machineList.isEmpty()) {
                            strMachineID = ((Machine)machineList.get(0)).getFQID();
                            Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(strRequest);
                            this._removeMachineNode(doc);
                            strRequest = Workspace.getMdFactory().getUtil().createStringForNode((Node)doc);
                        } else {
                            Machine machine = (Machine)Workspace.getMdFactory().createComplexMetadataObject(this.m_server.getStore(), null, strHost, "Machine", this.m_server.getContext().substring(9), null);
                            strMachineID = machine.getFQID();
                            this.m_prevMachine = machine;
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                    String transKey = ".xmlKey";
                    while (strRequest.indexOf(transKey) != -1) {
                        int endKey;
                        int keyIndex = strRequest.indexOf(transKey);
                        int beginKey = strRequest.lastIndexOf("\"", keyIndex);
                        String key = strRequest.substring(beginKey + 1, endKey = strRequest.indexOf("\"", keyIndex));
                        String value = PrototypeUtil.getDisplayString(key);
                        if (value.indexOf("Missing resource") != -1) {
                            value = "Error! Missing Resource";
                        }
                        while (strRequest.indexOf(key) != -1) {
                            index = strRequest.indexOf(key);
                            strRequest = strRequest.substring(0, index) + value + strRequest.substring(index + key.length());
                        }
                    }
                    String[][] strReplaceArray = new String[][]{{"_Name_", strName}, {"_DomainID_", strDomainID}, {"_MachineID_", strMachineID}, {"_Host_", strHost}, {"_Port_", strPort}, {"_ReposID_", strReposID}, {"_ReposID8_", strReposID.substring(9)}};
                    for (int i = 0; i < strReplaceArray.length; ++i) {
                        String[] myStr = strReplaceArray[i];
                        String replString = myStr[0];
                        String replaceWithString = myStr[1];
                        while (strRequest.indexOf(replString) != -1) {
                            index = strRequest.indexOf(replString);
                            strRequest = strRequest.substring(0, index) + replaceWithString + strRequest.substring(index + replString.length());
                        }
                    }
                    Vector<String> requestList = (Vector<String>)parent.getWizardData("MetadataRequestList");
                    if (requestList == null) {
                        requestList = new Vector<String>();
                    }
                    ((Vector)requestList).removeAllElements();
                    requestList.add(strRequest);
                    parent.replaceWizardData("MetadataRequestList", requestList);
                    Server childServer = (Server)parent.getWizardData("ChildServer");
                    if (childServer != null) {
                        try {
                            MdObjectStore store = childServer.getStore();
                            ServerComponent sc = (ServerComponent)childServer.getDeployedComponent();
                            Vector<Object> objectsToRemoveList = new Vector<Object>();
                            objectsToRemoveList.add(sc);
                            AssociationList propList = sc.getProperties();
                            for (int propIndex = 0; propIndex < propList.size(); ++propIndex) {
                                Property prop = (Property)propList.get(propIndex);
                                objectsToRemoveList.add(prop);
                                PropertyType propType = prop.getOwningType();
                                if (propType == null) continue;
                                objectsToRemoveList.add(propType);
                                TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                                if (propTypeText == null) continue;
                                objectsToRemoveList.add(propTypeText);
                            }
                            AssociationList scConnList = sc.getSourceConnections();
                            for (int connIndex = 0; connIndex < scConnList.size(); ++connIndex) {
                                Connection scConn = (Connection)scConnList.get(connIndex);
                                objectsToRemoveList.add(scConn);
                                AssociationList connPropList = scConn.getProperties();
                                for (int propIndex = 0; propIndex < connPropList.size(); ++propIndex) {
                                    Property prop = (Property)connPropList.get(propIndex);
                                    objectsToRemoveList.add(prop);
                                    PropertyType propType = prop.getOwningType();
                                    if (propType == null) continue;
                                    objectsToRemoveList.add(propType);
                                    TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                                    if (propTypeText == null) continue;
                                    objectsToRemoveList.add(propTypeText);
                                }
                            }
                            AssociationList scInitList = sc.getInitProcesses();
                            for (int initIndex = 0; initIndex < scInitList.size(); ++initIndex) {
                                Transformation scTransform = (Transformation)scInitList.get(initIndex);
                                objectsToRemoveList.add(scTransform);
                                AssociationList tranPropList = scTransform.getProperties();
                                for (int propIndex = 0; propIndex < tranPropList.size(); ++propIndex) {
                                    Property prop = (Property)tranPropList.get(propIndex);
                                    objectsToRemoveList.add(prop);
                                    PropertyType propType = prop.getOwningType();
                                    if (propType == null) continue;
                                    objectsToRemoveList.add(propType);
                                    TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                                    if (propTypeText == null) continue;
                                    objectsToRemoveList.add(propTypeText);
                                }
                            }
                            AssociationList scServiceTypesList = sc.getServiceTypes();
                            for (int sTypeIndex = 0; sTypeIndex < scServiceTypesList.size(); ++sTypeIndex) {
                                ServiceType sType = (ServiceType)scServiceTypesList.get(sTypeIndex);
                                objectsToRemoveList.add(sType);
                            }
                            store.removeObjectsFromStore(objectsToRemoveList);
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        }
                        catch (RemoteException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                    this.setConditionState("NEXT");
                }
                if (!this.m_customRadio.isSelected()) break block33;
                Server childServer = (Server)parent.getWizardData("ChildServer");
                if (childServer != null) {
                    MdObjectStore store = childServer.getStore();
                    ServerComponent sc = (ServerComponent)childServer.getDeployedComponent();
                    Map deletedObjectsMap = store.getDeletedObjects();
                    if (deletedObjectsMap.containsKey(sc.getFQID())) {
                        sc = (ServerComponent)Workspace.getMdFactory().createComplexMetadataObject(store, null, bundle.getString("Server.ServerIdentifierName.Server.txt"), "ServerComponent", childServer.getContext().substring(9), null);
                        childServer.setDeployedComponent((DeployedComponent)sc);
                    }
                }
                Server server = (Server)parent.getWizardData("Server");
                Prototype prototype = (Prototype)parent.getWizardData("DeployedComponentPrototype");
                childServer.getDeployedComponent().setName(server.getDeployedComponent().getName() + " - " + PrototypeUtil.getDisplayString(prototype.getName(), prototype), 1);
                try {
                    ServerContext scxt = (ServerContext)server.getDeployedComponent();
                    MdObjectStore store = server.getStore();
                    Vector<Object> objectsToRemoveList = new Vector<Object>();
                    AssociationList dataPackagesList = scxt.getDataPackages();
                    for (int dpIndex = 0; dpIndex < dataPackagesList.size(); ++dpIndex) {
                        DeployedDataPackage ddp = (DeployedDataPackage)dataPackagesList.get(dpIndex);
                        if (!(ddp instanceof OLAPSchema) || ddp.getFQID().indexOf(36) == -1) continue;
                        objectsToRemoveList.add(ddp);
                        AssociationList ddpPropList = ddp.getProperties();
                        for (int propIndex = 0; propIndex < ddpPropList.size(); ++propIndex) {
                            Property prop = (Property)ddpPropList.get(propIndex);
                            objectsToRemoveList.add(prop);
                            PropertyType propType = prop.getOwningType();
                            if (propType == null) continue;
                            objectsToRemoveList.add(propType);
                            TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                            if (propTypeText == null) continue;
                            objectsToRemoveList.add(propTypeText);
                        }
                    }
                    store.removeObjectsFromStore(objectsToRemoveList);
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
                parent.replaceWizardData("ChildServer", (Object)childServer);
                List requestList = (List)parent.getWizardData("MetadataRequestList");
                if (requestList != null) {
                    ((Vector)requestList).removeAllElements();
                    parent.replaceWizardData("MetadataRequestList", (Object)requestList);
                }
                this.setConditionState("CUSTOM");
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
    }

    public void onBack() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        List requestList = (List)parent.getWizardData("MetadataRequestList");
        if (requestList != null && requestList.size() > 0) {
            requestList.remove(requestList.size() - 1);
        }
        if (requestList != null) {
            parent.replaceWizardData("MetadataRequestList", (Object)requestList);
        }
    }

    private void _removeMachineNode(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this._removeMachineNode(children.item(childIndex));
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equals("Machine")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    Node idNode = childNodeMap.getNamedItem("Id");
                    if (idNode != null) {
                        node.getParentNode().removeChild(node);
                        return;
                    }
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                        this._removeMachineNode(children.item(childIndex));
                    }
                } else {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                        this._removeMachineNode(children.item(childIndex));
                    }
                }
                break;
            }
        }
    }

    private void disableBasicWidgets() {
        this.m_defaultRadio.setEnabled(false);
        this.m_domainChoice.setEnabled(false);
        this.m_domainButton.setEnabled(false);
        this.m_hostText.setEnabled(false);
        this.m_hostText.setEditable(false);
        this.m_portText.setEnabled(false);
        this.m_portText.setEditable(false);
        this.m_customRadio.setSelected(true);
    }

    protected void _initialize() {
        this.setHelpProduct("newserver");
        this.setHelpTopic("servwiz_4a_sas");
        this.m_defaultRadio = new JRadioButton(bundle.getString("ServerConfigView.Default.txt"));
        this.m_defaultRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerConfigView.this.onRadioChanged();
            }
        });
        this.m_defaultRadio.setSelected(true);
        MnemonicModel.setButtonTextAndMnemonic(this.m_defaultRadio, bundle.getString("ServerConfigView.Default.txt"));
        this.m_defaultRadio.setToolTipText(bundle.getString("ServerConfigView.DefaultTooltip"));
        this.m_customRadio = new JRadioButton(bundle.getString("ServerConfigView.Custom.txt"));
        this.m_customRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerConfigView.this.onRadioChanged();
            }
        });
        this.m_customRadio.setSelected(false);
        MnemonicModel.setButtonTextAndMnemonic(this.m_customRadio, bundle.getString("ServerConfigView.Custom.txt"));
        this.m_customRadio.setToolTipText(bundle.getString("ServerConfigView.CustomTooltip"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_defaultRadio);
        buttonGroup.add(this.m_customRadio);
        this.m_defaultText = new WATextArea(bundle.getString("ServerConfigView.DefaultText.IOM.txt"));
        this.m_defaultText.setEditable(false);
        this.m_defaultText.setLineWrap(true);
        this.m_defaultText.setWrapStyleWord(true);
        this.m_defaultText.setBorder(null);
        this.m_defaultText.setBackground(this.getBackground());
        this.m_customText = new WATextArea(bundle.getString("ServerConfigView.CustomText.txt"));
        this.m_customText.setEditable(false);
        this.m_customText.setLineWrap(true);
        this.m_customText.setWrapStyleWord(true);
        this.m_customText.setBorder(null);
        this.m_customText.setBackground(this.getBackground());
        this.m_domainLabel = new JLabel(bundle.getString("ServerConfigView.AuthenticationDomain.txt"));
        this.m_domainChoice = new JComboBox();
        this.m_domainButton = new JButton();
        MnemonicModel.setButtonTextAndMnemonic(this.m_domainButton, bundle.getString("Common.New....txt"));
        this.m_domainButton.setMargin(new Insets(0, 4, 0, 4));
        this.m_domainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerConfigView.this.onNewDomain();
            }
        });
        this.m_hostLabel = new JLabel(bundle.getString("ServerConfigView.Host.txt"));
        this.m_hostText = new JTextField(15);
        this.m_portLabel = new JLabel(bundle.getString("ServerConfigView.Port.txt"));
        this.m_portText = new JTextField(15);
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_defaultRadio, gbc);
        this.add(this.m_defaultRadio);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_defaultText, gbc);
        this.add((Component)this.m_defaultText);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 5, 0, 0);
        gridBagLayout.setConstraints(this.m_domainLabel, gbc);
        this.add(this.m_domainLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.gridwidth = -1;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_domainChoice, gbc);
        this.add(this.m_domainChoice);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_domainButton, gbc);
        this.add(this.m_domainButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 5, 0, 0);
        gridBagLayout.setConstraints(this.m_hostLabel, gbc);
        this.add(this.m_hostLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_hostText, gbc);
        this.add(this.m_hostText);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 5, 0, 0);
        gridBagLayout.setConstraints(this.m_portLabel, gbc);
        this.add(this.m_portLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_portText, gbc);
        this.add(this.m_portText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 18;
        gbc.insets = new Insets(12, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_customRadio, gbc);
        this.add(this.m_customRadio);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 5, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_customText, gbc);
        this.add((Component)this.m_customText);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    private class OLAPSchemaFolderPanel
    extends WAPanel {
        private Tree m_folder;
        private WATextArea m_txtTitle;
        private JLabel m_lblLocation;
        private WATextField m_txtLocation;
        private JButton m_btnBrowse;
        private static final long serialVersionUID = 4481746432723595816L;

        public OLAPSchemaFolderPanel() {
            this.initialize();
            this.layoutWidgets();
        }

        public Tree getFolder() {
            return this.m_folder;
        }

        public boolean validateData() {
            boolean bValid = true;
            if (this.getFolder() == null) {
                MessageUtil.displayMessage((String)bundle.getString("ServerConfigView.OLAPSchemaFolderPanel.SelectLocation.txt"), (int)0);
                return false;
            }
            try {
                ISecurity iSec = SecurityUtil.makeISecurityConnection((MdFactory)Workspace.getMdFactory());
                bValid = SecurityUtil.isFolderWriteAuthorized((ISecurity)iSec, (String)this.getFolder().getFQID());
                if (!bValid) {
                    MessageUtil.displayMessage((String)bundle.getString("ServerConfigView.OLAPSchemaFolderPanel.NoWritePermission.txt"), (int)0);
                }
                if (iSec != null) {
                    SecurityUtil.closeISecurityConnection((MdFactory)Workspace.getMdFactory(), (ISecurity)iSec);
                }
            }
            catch (MdException exc) {
                bValid = false;
                MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            catch (RemoteException exc) {
                bValid = false;
                MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            return bValid;
        }

        void onBrowse() {
            try {
                Tree folder;
                String strInitialPath = null;
                if (this.m_folder != null) {
                    strInitialPath = this.getPath(this.m_folder);
                }
                if ((folder = (Tree)WsMetadataUtil.promptForFolder(strInitialPath, (boolean)false)) != null) {
                    this.m_folder = folder;
                    this.m_txtLocation.setText(this.getPath(this.m_folder));
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            catch (RemoteException exc) {
                MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }

        private String getPath(Tree folder) throws MdException, RemoteException {
            if (folder == null) {
                return "";
            }
            String template = "<Templates><Tree Name=\"\"><ParentTree/></Tree></Templates>";
            int flags = 8460;
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)folder, null, null, template, flags);
            Tree element = folder;
            String location = element.getName();
            while (element.getParentTree() != null) {
                element = element.getParentTree();
                location = element.getName() + "/" + location;
            }
            location = "/" + location;
            return location;
        }

        public void initialize() {
            this.m_txtTitle = new WATextArea(bundle.getString("ServerConfigView.OLAPSchemaFolderPanel.Title.txt"));
            this.m_txtTitle.setBehavior(1);
            this.m_txtTitle.setLineWrap(true);
            this.m_txtTitle.setWrapStyleWord(true);
            this.m_lblLocation = new JLabel(bundle.getString("ServerConfigView.OLAPSchemaFolderPanel.Location.txt"));
            this.m_lblLocation.getAccessibleContext().setAccessibleName(bundle.getString("ServerConfigView.OLAPSchemaFolderPanel.Location.notrans"));
            this.m_txtLocation = new WATextField(20);
            this.m_txtLocation.setEditable(false);
            this.m_txtLocation.getAccessibleContext().setAccessibleName(bundle.getString("ServerConfigView.OLAPSchemaFolderPanel.Location.notrans"));
            this.m_btnBrowse = new JButton(bundle.getString("Common.Browse....txt"));
            this.m_btnBrowse.getAccessibleContext().setAccessibleName(bundle.getString("Common.Browse....notrans"));
            this.m_btnBrowse.setMargin(new Insets(0, 4, 0, 4));
            this.m_btnBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OLAPSchemaFolderPanel.this.onBrowse();
                }
            });
        }

        public void layoutWidgets() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            int gridy = 0;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.insets = new Insets(12, 12, 0, 12);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gridBagLayout.setConstraints((Component)this.m_txtTitle, gbc);
            this.add((Component)this.m_txtTitle);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.insets = new Insets(12, 12, 12, 0);
            gridBagLayout.setConstraints(this.m_lblLocation, gbc);
            this.add(this.m_lblLocation);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy;
            gbc.insets = new Insets(12, 12, 12, 0);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gridBagLayout.setConstraints((Component)this.m_txtLocation, gbc);
            this.add((Component)this.m_txtLocation);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = gridy;
            gbc.insets = new Insets(12, 12, 12, 12);
            gridBagLayout.setConstraints(this.m_btnBrowse, gbc);
            this.add(this.m_btnBrowse);
        }
    }

    protected class ViewListener
    implements MdObjectFactoryListener {
        protected JComboBox m_choice;
        protected String m_strMetadataType;

        public ViewListener(JComboBox choice, String strMetadataType) {
            this.m_choice = choice;
            this.m_strMetadataType = strMetadataType;
        }

        public void MdObjectCreated(MdEvent event, String strID) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(strID);
            this._onCreate(list);
        }

        public void MdObjectsCreated(MdEvent event, List idList) {
            this._onCreate(idList);
        }

        public void MdObjectDeleted(MdEvent event, String strID) {
        }

        protected void _onCreate(List idList) {
            try {
                boolean bProcessed = false;
                block5: for (int i = 0; i < idList.size(); ++i) {
                    String strID = (String)idList.get(i);
                    CMetadata meta = Workspace.getMdFactory().getObject(strID);
                    if (!meta.getCMetadataType().equals(this.m_strMetadataType)) continue;
                    Root root = (Root)meta;
                    if (this.m_choice != null) {
                        this.m_choice.removeAllItems();
                    }
                    List itemsList = null;
                    int flags = 8456;
                    try {
                        itemsList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)ServerConfigView.this.m_server.getStore(), ServerConfigView.this.m_server.getContext(), this.m_strMetadataType, flags, "");
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                        return;
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                    for (int j = 0; itemsList != null && j < itemsList.size(); ++j) {
                        Root itemRoot = (Root)itemsList.get(j);
                        if (this.m_choice != null) {
                            this.m_choice.addItem(itemRoot);
                        }
                        if (!itemRoot.getFQID().equals(root.getFQID())) continue;
                        if (this.m_choice != null) {
                            this.m_choice.setSelectedItem(itemRoot);
                        }
                        bProcessed = true;
                        continue block5;
                    }
                }
                if (bProcessed) {
                    Workspace.getMdFactory().removeMdObjectFactoryListener((MdObjectFactoryListener)this);
                }
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
    }
}

