/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.DBSchema;
import com.sas.workspace.mgmt.visuals.GeneralPropertyView;
import com.sas.workspace.mgmt.visuals.PrototypeNotFoundException;
import com.sas.workspace.mgmt.visuals.SchemaPropertyView;
import com.sas.workspace.mgmt.visuals.ServerTypePropertyView;
import com.sas.workspace.mgmt.visuals.ServerWizard;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class SchemaWizard
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    protected DBSchema m_schema;
    protected Component m_component;
    protected String m_strContext;
    protected MdObjectStore m_objectStore = null;
    protected boolean m_bShowWizard = true;
    private static final WAdminResource bundle = WAdminResource.getBundle(SchemaWizard.class);

    public SchemaWizard(JFrame frame, String strContext) {
        this(frame, strContext, bundle.getString("SchemaWizard.Title.txt"));
    }

    public SchemaWizard(JFrame frame, String strContext, String strTitle) {
        this(frame, strContext, strTitle, (MdObjectStore)null);
    }

    public SchemaWizard(JFrame frame, String strContext, String strTitle, MdObjectStore objectStore) {
        this(frame, strContext, strTitle, (String[])null, objectStore);
    }

    public SchemaWizard(JFrame frame, String strContext, String strTitle, String strClassID) {
        this(frame, strContext, strTitle, strClassID, null);
    }

    public SchemaWizard(JFrame frame, String strContext, String strTitle, String strClassID, MdObjectStore objectStore) {
        this(frame, strContext, strTitle, new String[]{strClassID}, objectStore);
    }

    public SchemaWizard(JFrame frame, String strContext, String strTitle, String[] classIDArray) {
        this(frame, strContext, strTitle, classIDArray, null);
    }

    public SchemaWizard(JFrame frame, String strContext, String strTitle, String[] classIDArray, MdObjectStore objectStore) {
        this(frame, strContext, strTitle, classIDArray, objectStore, null);
    }

    public SchemaWizard(JFrame frame, String strContext, String strTitle, String[] classIDArray, MdObjectStore objectStore, Hashtable propertiesTable) {
        super((Frame)frame, true, objectStore);
        this._init(frame, strContext, strTitle, classIDArray, propertiesTable);
    }

    public SchemaWizard(Dialog dialog, String strContext) {
        this(dialog, strContext, bundle.getString("SchemaWizard.Title.txt"));
    }

    public SchemaWizard(Dialog dialog, String strContext, String strTitle) {
        this(dialog, strContext, strTitle, (MdObjectStore)null);
    }

    public SchemaWizard(Dialog dialog, String strContext, String strTitle, MdObjectStore objectStore) {
        this(dialog, strContext, strTitle, (String[])null, objectStore);
    }

    public SchemaWizard(Dialog dialog, String strContext, String strTitle, String strClassID) {
        this(dialog, strContext, strTitle, strClassID, null);
    }

    public SchemaWizard(Dialog dialog, String strContext, String strTitle, String strClassID, MdObjectStore objectStore) {
        this(dialog, strContext, strTitle, new String[]{strClassID}, objectStore);
    }

    public SchemaWizard(Dialog dialog, String strContext, String strTitle, String[] classIDArray) {
        this(dialog, strContext, strTitle, classIDArray, null);
    }

    public SchemaWizard(Dialog dialog, String strContext, String strTitle, String[] classIDArray, MdObjectStore objectStore) {
        this(dialog, strContext, strTitle, classIDArray, objectStore, null);
    }

    public SchemaWizard(Dialog dialog, String strContext, String strTitle, String[] classIDArray, MdObjectStore objectStore, Hashtable propertiesTable) {
        super(dialog, true, objectStore);
        this._init(dialog, strContext, strTitle, classIDArray, propertiesTable);
    }

    protected void _init(Component component, String strContext, String strTitle, String[] classIDArray, Hashtable propertiesTable) {
        block12: {
            try {
                this.setHelpProduct("newschema");
                this.m_objectStore = (MdObjectStore)this.getWizardData("OBJECTSTORE");
                Boolean bDisposeStore = new Boolean(false);
                this.replaceWizardData("DisposeStore", bDisposeStore);
                DatabaseSchema dbSchema = null;
                if (propertiesTable != null) {
                    Enumeration e = propertiesTable.keys();
                    while (e.hasMoreElements()) {
                        Root elementRoot = (Root)e.nextElement();
                        if (!elementRoot.getCMetadataType().equalsIgnoreCase("DatabaseSchema")) continue;
                        dbSchema = (DatabaseSchema)elementRoot;
                        break;
                    }
                }
                this.m_schema = dbSchema != null ? new DBSchema(strContext, dbSchema, this.m_objectStore) : new DBSchema(strContext, this.m_objectStore);
                this.m_schema.setParentComponent(component);
                this.m_component = component;
                this.m_strContext = strContext;
                WATransitionWizardModel model = new WATransitionWizardModel();
                this.setWizardModel((WAWizardModel)model);
                if (propertiesTable != null) {
                    this.replaceWizardData("Properties", propertiesTable);
                }
                if (classIDArray != null && classIDArray.length == 1) {
                    Prototype prototype = ServerWizard.getPrototype("Extensions", "ServerClassIdentifier", classIDArray[0], this.m_strContext, this.m_objectStore, this.m_component, this, "DatabaseSchemaPrototype");
                    boolean bl = this.m_bShowWizard = prototype != null;
                    if (prototype != null) {
                        String strType = prototype.getMetadataType();
                        Root root = (Root)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, bundle.getString("DBSchema.SchemaIdentifierName.Schema.txt"), strType, this.m_strContext.substring(9));
                        DatabaseSchema schema = this.m_schema.getSchema();
                        try {
                            Vector<Object> objectsToRemoveList = new Vector<Object>();
                            objectsToRemoveList.add(schema);
                            AssociationList propList = schema.getProperties();
                            for (int propIndex = 0; propIndex < propList.size(); ++propIndex) {
                                Property prop = (Property)propList.get(propIndex);
                                objectsToRemoveList.add(prop);
                                PropertyType propType = prop.getOwningType();
                                if (propType == null) continue;
                                objectsToRemoveList.add(propType);
                                TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                                if (propTypeText == null) continue;
                                objectsToRemoveList.add(propTypeText);
                            }
                            ((MdObjectStore)schema.getObjectStore()).removeObjectsFromStore(objectsToRemoveList);
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        }
                        catch (RemoteException re) {
                            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                        }
                        this.m_schema.setSchema((DatabaseSchema)root);
                        if (propertiesTable != null) {
                            propertiesTable.put(root, propertiesTable.remove(schema));
                            this.replaceWizardData("Properties", propertiesTable);
                        }
                    }
                    this.addWizardTabs(model, strTitle);
                    break block12;
                }
                this._initializeFirstTab(strTitle);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    protected void _initializeFirstTab(String title) {
        try {
            ServerTypePropertyView typeTab = new ServerTypePropertyView(this.m_schema, this.m_objectStore);
            this.addTab(title, "ServerType", (WAPropertyTab)typeTab, bundle.getString("Common.NameDescriptionTab.image"), bundle.getImageIcon("Common.NameDescriptionTab.image"));
            String[][] transition = new String[][]{{"ServerType", "NEXT", "General"}};
            ((WATransitionWizardModel)this.getWizardModel()).addTransitions(transition);
        }
        catch (PrototypeNotFoundException exc) {
            this.m_bShowWizard = false;
        }
        this.addWizardTabs((WATransitionWizardModel)this.getWizardModel(), title);
    }

    public Root getMetadataObject() {
        return (Root)this.getWizardData("DatabaseSchema");
    }

    public void show() {
        if (this.m_bShowWizard) {
            super.show();
        }
    }

    public void setPreferredSize(Dimension dimension) {
        this.getMainPanel().setPreferredSize(dimension);
    }

    public boolean onCompletion() {
        this.m_schema.persist();
        return super.doCleanup();
    }

    protected boolean onFinish() {
        this.dispose();
        OpRequestUI request = new OpRequestUI((JDialog)((Object)this), bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt"), bundle.getString("WriteMetadataProgressIndicator.Msg.Title"));
        request.setProgressShownOnStatusBar(false);
        cOnCompletionRunnable runOnCompletion = this.createOnCompletionRunnable();
        request.execute((Runnable)runOnCompletion);
        return runOnCompletion.getReturnValue();
    }

    protected void addWizardTabs(WATransitionWizardModel model, String strTitle) {
        this.setTitle(strTitle);
        GeneralPropertyView generalTab = new GeneralPropertyView(this.m_schema, 0);
        this.addTab(strTitle, "General", (WAPropertyTab)generalTab, bundle.getString("Common.NameDescriptionTab.image"), bundle.getImageIcon("Common.NameDescriptionTab.image"));
        SchemaPropertyView optionsTab = new SchemaPropertyView(this.m_schema, 0);
        this.addTab(strTitle, "Options", (WAPropertyTab)optionsTab, bundle.getString("Common.PropertiesTab.image"), bundle.getImageIcon("Common.PropertiesTab.image"));
        WizardFinishTab finishTab = new WizardFinishTab(bundle.getString("SchemaWizard.DefinitionSuccess.txt"));
        finishTab.setHelpProduct("newschema");
        finishTab.setHelpTopic("dbwiz_4");
        this.addTab(strTitle, "Completion", (WAPropertyTab)finishTab, bundle.getString("Common.FinishTab.image"), bundle.getImageIcon("Common.FinishTab.image"));
        String[][] transitions = new String[][]{{"General", "NEXT", "Options"}, {"Options", "NEXT", "Completion"}};
        model.addTransitions(transitions);
        this.addWizardData("Schema", this.m_schema);
    }

    protected cOnCompletionRunnable createOnCompletionRunnable() {
        return new cOnCompletionRunnable();
    }

    protected class cOnCompletionRunnable
    implements Runnable {
        boolean returnValue = false;

        @Override
        public synchronized void run() {
            this.returnValue = SchemaWizard.this.onCompletion();
        }

        public synchronized boolean getReturnValue() {
            return this.returnValue;
        }
    }
}

