/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.RepositoryUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RepositoryTypeView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected JRadioButton m_foundationOption;
    protected JRadioButton m_projectOption;
    protected JRadioButton m_customOption;
    protected WATextArea m_foundationText;
    protected WATextArea m_projectText;
    protected WATextArea m_customText;
    protected MetadataRepositoryService repositoryService = null;
    protected List<Repository> reposList;
    protected static final WAdminResource bundle = new WAdminResource(RepositoryTypeView.class);

    public RepositoryTypeView(MetadataRepositoryService repositoryService) {
        super(bundle.getString("NewReposWizard.TypeTab.Description.txt"));
        this.repositoryService = repositoryService;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            // empty if block
        }
        return false;
    }

    public boolean validateData() {
        if (this.m_foundationOption.isSelected()) {
            boolean Fexists = false;
            if (this.reposList != null) {
                Iterator<Repository> it = this.reposList.iterator();
                while (it.hasNext() && !Fexists) {
                    Repository repos = it.next();
                    if (!repos.isFoundation()) continue;
                    Fexists = true;
                }
            }
            if (Fexists) {
                MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.TypeTab.MultipleFoundations.txt"), (String)bundle.getString("NewReposWizard.TypeTab.MultipleFoundations.Title.txt"), (int)0);
                return false;
            }
            boolean isUnrestrictedbyFile = true;
            RepositoryUtil.ConnectedIdentityInfo connUserInfo = null;
            try {
                connUserInfo = new RepositoryUtil.ConnectedIdentityInfo(Workspace.getMdFactory());
            }
            catch (Exception e) {
                MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.TypeTab.UnrestrictedUser.FoundationError.txt"), (String)bundle.getString("NewReposWizard.UnableToDetermineAdminPermission.Error.txt"), (int)0);
                return false;
            }
            if (connUserInfo.m_UserClass.indexOf("Unrestricted") != -1 && connUserInfo.m_UnrestrictedSource != null && connUserInfo.m_UnrestrictedSource.indexOf("ConfigFile") == -1) {
                isUnrestrictedbyFile = false;
            }
            if (!isUnrestrictedbyFile) {
                MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.TypeTab.UnrestrictedUser.FoundationError.txt"), (String)bundle.getString("NewReposWizard.UserNotAuthorized.Descripton.txt"), (int)0);
                return false;
            }
            this.setConditionState("NEXT");
        } else if (this.m_customOption.isSelected()) {
            try {
                boolean isAuthorized = RepositoryUtil.isConnectedUserAuthorizedOnBIPService(Workspace.getMdFactory());
                if (!isAuthorized) {
                    MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.UserNotAuthorized.Error.txt"), (String)bundle.getString("NewReposWizard.UserNotAuthorized.Descripton.txt"), (int)0);
                    return false;
                }
            }
            catch (Exception e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0, (int)-1);
                return false;
            }
            this.setConditionState("NEXT");
        } else if (this.m_projectOption.isSelected()) {
            this.setConditionState("PROJECT");
        }
        return true;
    }

    public void onNext() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        if (this.m_projectOption.isSelected()) {
            parent.replaceWizardData("Type", (Object)"Project");
        } else if (this.m_foundationOption.isSelected()) {
            parent.replaceWizardData("Type", (Object)"Foundation");
        } else {
            parent.replaceWizardData("Type", (Object)"Custom");
        }
    }

    protected void _initialize() {
        this.reposList = null;
        try {
            this.reposList = this.repositoryService.getRepositories();
        }
        catch (Exception e) {
            String strMessage = e.getMessage();
            if (strMessage != null) {
                MessageUtil.displayMessage((String)strMessage);
            }
            e.printStackTrace();
        }
        boolean Fexists = false;
        if (this.reposList != null) {
            Iterator<Repository> it = this.reposList.iterator();
            while (it.hasNext() && !Fexists) {
                Repository repos = it.next();
                if (!repos.isFoundation()) continue;
                Fexists = true;
            }
        }
        this.m_foundationOption = new JRadioButton(bundle.getString("NewReposWizard.NewReposTypeTab.Foundation.txt"));
        MnemonicModel.setButtonTextAndMnemonic(this.m_foundationOption, bundle.getString("NewReposWizard.NewReposTypeTab.Foundation.txt"));
        this.m_customOption = new JRadioButton(bundle.getString("NewReposWizard.NewReposTypeTab.Custom.txt"));
        MnemonicModel.setButtonTextAndMnemonic(this.m_customOption, bundle.getString("NewReposWizard.NewReposTypeTab.Custom.txt"));
        this.m_projectOption = new JRadioButton(bundle.getString("NewReposWizard.NewReposTypeTab.Project.txt"));
        MnemonicModel.setButtonTextAndMnemonic(this.m_projectOption, bundle.getString("NewReposWizard.NewReposTypeTab.Project.txt"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_foundationOption);
        buttonGroup.add(this.m_customOption);
        buttonGroup.add(this.m_projectOption);
        this.m_foundationText = new WATextArea(bundle.getString("NewReposWizard.NewReposTypeTab.FoundationDesc.txt"));
        this.m_foundationText.setEditable(false);
        this.m_foundationText.setLineWrap(true);
        this.m_foundationText.setWrapStyleWord(true);
        this.m_foundationText.setBorder(null);
        this.m_foundationText.setBackground(this.getBackground());
        this.m_foundationText.setBehavior(1);
        this.m_projectText = new WATextArea(bundle.getString("NewReposWizard.NewReposTypeTab.ProjectDesc.txt"));
        this.m_projectText.setEditable(false);
        this.m_projectText.setLineWrap(true);
        this.m_projectText.setWrapStyleWord(true);
        this.m_projectText.setBorder(null);
        this.m_projectText.setBackground(this.getBackground());
        this.m_projectText.setBehavior(1);
        this.m_customText = new WATextArea(bundle.getString("NewReposWizard.NewReposTypeTab.CustomDesc.txt"));
        this.m_customText.setLineWrap(true);
        this.m_customText.setWrapStyleWord(true);
        this.m_customText.setBorder(null);
        this.m_customText.setBackground(this.getBackground());
        this.m_customText.setBehavior(1);
        if (Fexists) {
            this.m_foundationOption.setSelected(false);
            this.m_foundationOption.setEnabled(false);
            this.m_foundationText.setEnabled(false);
            this.m_customOption.setSelected(true);
        } else {
            this.m_foundationOption.setSelected(true);
            this.m_customOption.setSelected(false);
        }
        this.m_projectOption.setSelected(false);
        if (this.reposList == null || this.reposList.size() == 0) {
            this.m_customOption.setEnabled(false);
            this.m_customText.setEnabled(false);
            this.m_projectOption.setEnabled(false);
            this.m_projectText.setEnabled(false);
        }
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(5, 0, 12, 0);
        gridBagLayout.setConstraints(this.m_foundationOption, gbc);
        this.add(this.m_foundationOption);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 12, 0);
        gridBagLayout.setConstraints((Component)this.m_foundationText, gbc);
        this.add((Component)this.m_foundationText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 0, 12, 0);
        gridBagLayout.setConstraints(this.m_projectOption, gbc);
        this.add(this.m_projectOption);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 12, 0);
        gridBagLayout.setConstraints((Component)this.m_projectText, gbc);
        this.add((Component)this.m_projectText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 0, 12, 0);
        gridBagLayout.setConstraints(this.m_customOption, gbc);
        this.add(this.m_customOption);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 12, 0);
        gridBagLayout.setConstraints((Component)this.m_customText, gbc);
        this.add((Component)this.m_customText);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    public Component getDefaultFocusComponent() {
        if (this.m_customOption.isSelected()) {
            return this.m_customOption;
        }
        if (this.m_projectOption.isSelected()) {
            return this.m_projectOption;
        }
        return this.m_foundationOption;
    }
}

