/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Prototype;
import com.sas.svcs.metadata.mgmt.impl.repository.ResourceTemplateHelper;
import com.sas.visuals.util.XMLUtility;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.mgmt.visuals.PrototypeCustomView;
import com.sas.workspace.mgmt.visuals.PrototypeTypeView;
import com.sas.workspace.mgmt.visuals.PrototypeTypicalView;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JDialog;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrototypeWizard
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    protected Prototype m_prototype;
    protected String m_strContext;
    protected Component m_parent;
    private static final String xmlFileError = "FILE ERROR";
    protected static final WAdminResource bundle = new WAdminResource(PrototypeWizard.class);

    public PrototypeWizard(Frame frame, String strContext) {
        super(frame, true);
        this.m_parent = frame;
        this._initialize(strContext);
    }

    public PrototypeWizard(Dialog dialog, String strContext) {
        super(dialog, true);
        this.m_parent = dialog;
        this._initialize(strContext);
    }

    protected void _initialize(String strContext) {
        this.setHelpProduct("newtemplate");
        String strTitle = bundle.getString("PrototypeWizard.Title.txt");
        this.setTitle(strTitle);
        this.m_strContext = strContext;
        WATransitionWizardModel model = new WATransitionWizardModel();
        this.setWizardModel((WAWizardModel)model);
        PrototypeTypeView typeTab = new PrototypeTypeView();
        typeTab.setHelpTopic("tempwiz_1");
        this.addTab(strTitle, "Type", (WAPropertyTab)typeTab, bundle.getString("PrototypeWizard.TemplateTypeImage.image"), bundle.getImageIcon("PrototypeWizard.TemplateTypeImage.image"));
        PrototypeTypicalView typicalTab = new PrototypeTypicalView(strContext);
        typicalTab.setHelpTopic("tempwiz_2");
        this.addTab(strTitle, "Typical", (WAPropertyTab)typicalTab, bundle.getString("PrototypeWizard.TemplateSourceImage.image"), bundle.getImageIcon("PrototypeWizard.TemplateSourceImage.image"));
        PrototypeCustomView customTab = new PrototypeCustomView(strContext);
        customTab.setHelpTopic("tempwiz_4");
        this.addTab(strTitle, "Custom", (WAPropertyTab)customTab, bundle.getString("PrototypeWizard.TemplateSourceImage.image"), bundle.getImageIcon("PrototypeWizard.TemplateSourceImage.image"));
        WizardFinishTab finishTab = new WizardFinishTab(bundle.getString("PrototypeFinishView.WizardTitle.txt"));
        finishTab.setHelpProduct("newtemplate");
        finishTab.setHelpTopic("tempwiz_3");
        this.addTab(strTitle, "Finish", (WAPropertyTab)finishTab, bundle.getString("Common.FinishTab.image"), bundle.getImageIcon("Common.FinishTab.image"));
        String[][] transitions = new String[][]{{"Type", "NEXT", "Typical"}, {"Type", "CUSTOM", "Custom"}, {"Typical", "NEXT", "Finish"}, {"Custom", "NEXT", "Finish"}};
        model.addTransitions(transitions);
    }

    public boolean onCompletion() {
        if (!super.onFinish()) {
            return false;
        }
        IOMI omiConnection = Workspace.getWorkspace().getCMRHandle();
        String strReposType = WsRepositoryUtil.getRepositoryType((IOMI)omiConnection, (String)this.m_strContext);
        if (!strReposType.equalsIgnoreCase("FOUNDATION")) {
            MessageUtil.displayMessage((String)bundle.getString("PrototypeWizard.TemplatesInFoundationOnlyMessage.Error.txt"), (int)0);
            return false;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        List localeList = (List)this.getWizardData("LocaleList");
        List metadataTypeList = (List)this.getWizardData("MetadataTypeList");
        List uniqueIDList = (List)this.getWizardData("UniqueIDList");
        List xmlNameList = (List)this.getWizardData("XMLNameList");
        List xmlList = (List)this.getWizardData("XMLList");
        String rtName = null;
        boolean bShowDuplicateMessage = true;
        for (int i = 0; i < xmlList.size(); ++i) {
            try {
                String strXML = (String)xmlList.get(i);
                if (metadataTypeList != null && uniqueIDList != null) {
                    boolean bAddTemplate;
                    if (localeList != null) {
                        String strLocale = (String)localeList.get(i);
                        if (strLocale.length() == 0) continue;
                        int metadataTypeIndex = i;
                        if (i >= metadataTypeList.size()) {
                            metadataTypeIndex = i - (localeList.size() - metadataTypeList.size());
                        }
                        String strMetadataType = (String)metadataTypeList.get(metadataTypeIndex);
                        int uniqueIDIndex = i;
                        if (i >= uniqueIDList.size()) {
                            uniqueIDIndex = i - (localeList.size() - uniqueIDList.size());
                        }
                        String strUniqueID = (String)uniqueIDList.get(uniqueIDIndex);
                        int xmlNameIndex = i;
                        if (i >= xmlNameList.size()) {
                            xmlNameIndex = i - (localeList.size() - xmlNameList.size());
                        }
                        rtName = (String)xmlNameList.get(xmlNameIndex);
                        bAddTemplate = PrototypeWizard._duplicateNotFound(Workspace.getMdFactory(), this.m_parent, this.m_strContext, bShowDuplicateMessage, strLocale, strMetadataType, strUniqueID);
                    } else {
                        int metadataTypeIndex = i;
                        String strMetadataType = (String)metadataTypeList.get(metadataTypeIndex);
                        int uniqueIDIndex = i;
                        String strUniqueID = (String)uniqueIDList.get(uniqueIDIndex);
                        int xmlNameIndex = i;
                        rtName = (String)xmlNameList.get(xmlNameIndex);
                        bAddTemplate = PrototypeWizard._duplicateNotFound(Workspace.getMdFactory(), this.m_parent, this.m_strContext, bShowDuplicateMessage, "Generic", strMetadataType, strUniqueID);
                    }
                    if (!bAddTemplate) {
                        bShowDuplicateMessage = false;
                        continue;
                    }
                }
                Workspace.getMdFactory().getOMIUtil().DoRequest(strXML, true);
                continue;
            }
            catch (Exception exc) {
                String strMessage = exc.getMessage();
                String errorMsg = bundle.formatString("PrototypeWizard.LoadingTemplate.Error.txt", rtName, (Object)strMessage);
                if (!(exc instanceof MdException)) continue;
                MessageUtil.displayMessage((String)errorMsg, (int)0);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    protected static boolean _duplicateNotFound(MdFactory m_Factory, String strContext, boolean bShowDuplicateMessage, String strLocale, String strMetadataType, String strUniqueID) {
        boolean bAddTemplate = PrototypeWizard._duplicateNotFound(m_Factory, null, strContext, bShowDuplicateMessage, strLocale, strMetadataType, strUniqueID);
        return bAddTemplate;
    }

    protected static boolean _duplicateNotFound(MdFactory m_Factory, Component parent, String strContext, boolean bShowDuplicateMessage, String strLocale, String strMetadataType, String strUniqueID) {
        try {
            boolean bDuplicateNotFound = true;
            MdObjectStore store = m_Factory.createObjectStore();
            m_Factory.getConnection().getCMRHandle();
            try {
                Locale localeToFind = null;
                if (!strLocale.equalsIgnoreCase("Generic")) {
                    localeToFind = PrototypeUtil.getLocale(strLocale);
                }
                Prototype prototype = null;
                prototype = PrototypeUtil.getPrototypeByIdentifier(m_Factory, strUniqueID, strContext, strMetadataType, localeToFind, (MdStore)store);
                if (prototype != null) {
                    bDuplicateNotFound = false;
                }
            }
            catch (MdException exc) {
                if (parent != null) {
                    MdException finalExc = exc;
                    MessageUtil.displayMetadataExceptionMessage((MdException)finalExc, (String)"Accessing");
                } else {
                    m_Factory.getUtil().printOutputln(exc.getMessage());
                }
                return false;
            }
            if (!bDuplicateNotFound && bShowDuplicateMessage) {
                String strMessage;
                if (parent != null) {
                    strMessage = bundle.getString("PrototypeWizard.DuplicateTemplates.Message.txt");
                    String strTitle = bundle.getString("PrototypeWizard.DuplicateTemplates.Title.txt");
                    MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)1);
                } else {
                    strMessage = bundle.getString("PrototypeWizard.DuplicateTemplates.ShortMessage.txt");
                    m_Factory.getUtil().printOutputln(strMessage);
                }
            }
            return bDuplicateNotFound;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    protected boolean onFinish() {
        this.dispose();
        OpRequestUI request = new OpRequestUI((JDialog)((Object)this), bundle.getString("PrototypeWizard.ProgressMessage2.txt"), bundle.getString("PrototypeWizard.ProgressMessage2.Title.txt"));
        return (Boolean)request.exec((Object)this, "onCompletion");
    }

    public static void addAll(MdFactory m_Factory, String strContext) throws Exception {
        PrototypeWizard.addAll(m_Factory, null, strContext);
    }

    public static void addAll(MdFactory m_Factory, OpRequestUI progressIndicator, String strContext) throws Exception {
        Document doc;
        boolean errorOccurred = false;
        String strReposType = WsRepositoryUtil.getRepositoryType((MdFactory)m_Factory, (String)strContext);
        if (progressIndicator != null && !strReposType.equalsIgnoreCase("FOUNDATION")) {
            throw new Exception(bundle.getString("PrototypeWizard.TemplatesInFoundationOnlyMessage.Error.txt"));
        }
        Vector xmlToAddList = new Vector();
        Vector localeList = new Vector();
        Vector metadataTypeList = new Vector();
        Vector uniqueIDList = new Vector();
        Vector uniqueNameList = new Vector();
        if (progressIndicator != null) {
            progressIndicator.setMessage(bundle.getString("PrototypeWizard.ProgressMessage.Init.txt"));
        }
        URL defaultUrl = ResourceTemplateHelper.getURLfromPrototypeIndexFile((Locale)PrototypeUtil.getLocale("en_US"));
        try {
            doc = m_Factory.getOMIUtil().parseXML(defaultUrl);
        }
        catch (MdException exc) {
            throw new Exception(bundle.formatString("PrototypeWizard.ParsingIndexFile.Error.txt", (Object)exc.getMessage()));
        }
        if (doc != null) {
            PrototypeWizard._buildData(m_Factory, doc, xmlToAddList, localeList, metadataTypeList, uniqueIDList, uniqueNameList, strContext, null, progressIndicator);
        }
        int size = xmlToAddList.size();
        boolean bShowDuplicateMessage = true;
        for (int i = 0; i < xmlToAddList.size(); ++i) {
            String rtName = null;
            try {
                String strXML = (String)xmlToAddList.get(i);
                if (strXML.equalsIgnoreCase(xmlFileError)) continue;
                if (localeList != null && metadataTypeList != null && uniqueIDList != null) {
                    String strUniqueName;
                    String strLocale = (String)localeList.get(i);
                    int metadataTypeIndex = i;
                    if (i >= metadataTypeList.size()) {
                        metadataTypeIndex = i - (localeList.size() - metadataTypeList.size());
                    }
                    String strMetadataType = (String)metadataTypeList.get(metadataTypeIndex);
                    int uniqueIDIndex = i;
                    if (i >= uniqueIDList.size()) {
                        uniqueIDIndex = i - (localeList.size() - uniqueIDList.size());
                    }
                    String strUniqueID = (String)uniqueIDList.get(uniqueIDIndex);
                    int uniqueNameIndex = i;
                    if (i >= uniqueNameList.size()) {
                        uniqueNameIndex = i - (localeList.size() - uniqueNameList.size());
                    }
                    rtName = strUniqueName = (String)uniqueNameList.get(uniqueNameIndex);
                    boolean bAddTemplate = progressIndicator != null ? PrototypeWizard._duplicateNotFound(m_Factory, (Component)Workspace.getWorkspace(), strContext, bShowDuplicateMessage, strLocale, strMetadataType, strUniqueID) : PrototypeWizard._duplicateNotFound(m_Factory, strContext, bShowDuplicateMessage, strLocale, strMetadataType, strUniqueID);
                    if (!bAddTemplate) {
                        bShowDuplicateMessage = false;
                        continue;
                    }
                }
                if (progressIndicator != null) {
                    progressIndicator.setMessage(bundle.formatString("PrototypeWizard.ProgressMessage.fmt.txt", (Object)String.valueOf(i + 1), (Object)String.valueOf(size)));
                }
                m_Factory.getOMIUtil().DoRequest(strXML, false);
                continue;
            }
            catch (Exception exc) {
                String strMessage = exc.getMessage();
                String errorMsg = bundle.formatString("PrototypeWizard.LoadingTemplate.Error.txt", rtName, (Object)strMessage);
                errorOccurred = true;
                if (progressIndicator != null) {
                    if (exc instanceof MdException) {
                        MessageUtil.displayMessage((String)errorMsg, (int)0);
                        continue;
                    }
                    exc.printStackTrace();
                    continue;
                }
                try {
                    if (exc instanceof MdException) {
                        m_Factory.getUtil().printOutputln(errorMsg);
                        continue;
                    }
                    m_Factory.getUtil().printStackTrace((Throwable)exc);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        if (errorOccurred) {
            throw new Exception(bundle.getString("PrototypeWizard.AddAllResourceTemplates.Error.txt"));
        }
    }

    private static void _buildData(MdFactory m_Factory, Node node, List xmlToAddList, List localeList, List metadataTypeList, List uniqueIDList, List uniqueNameList, String strContext, Locale locale, OpRequestUI progressIndicator) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    PrototypeWizard._buildData(m_Factory, children.item(childIndex), xmlToAddList, localeList, metadataTypeList, uniqueIDList, uniqueNameList, strContext, locale, progressIndicator);
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equals("Prototype")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String strFileName = childNodeMap.getNamedItem("FileName").getNodeValue();
                    if (strFileName.indexOf("_gx.xml") == -1) {
                        return;
                    }
                    if (locale != null) {
                        localeList.add(locale.toString());
                    } else {
                        localeList.add("Generic");
                    }
                    String strMetadataType = childNodeMap.getNamedItem("MetadataType").getNodeValue();
                    metadataTypeList.add(strMetadataType);
                    Node nameNode = childNodeMap.getNamedItem("Name");
                    if (nameNode != null && nameNode.getNodeValue().length() > 0) {
                        String strPrototypeName = null;
                        strPrototypeName = progressIndicator == null ? PrototypeUtil.getDisplayStringOld(nameNode.getNodeValue(), false, null) : PrototypeUtil.getDisplayString(nameNode.getNodeValue());
                        uniqueNameList.add(strPrototypeName);
                    }
                    Node classIDNode = childNodeMap.getNamedItem("ClassIdentifier");
                    Node engineIDNode = childNodeMap.getNamedItem("Engine");
                    Node serverClassIDNode = childNodeMap.getNamedItem("ServerClassIdentifier");
                    String strUniqueID = "";
                    if (classIDNode != null && classIDNode.getNodeValue().length() > 0) {
                        strUniqueID = classIDNode.getNodeValue();
                    }
                    if (engineIDNode != null) {
                        if (engineIDNode.getNodeValue().length() > 0) {
                            strUniqueID = engineIDNode.getNodeValue();
                        }
                        if (strUniqueID.equals("DB2")) {
                            strUniqueID = serverClassIDNode.getNodeValue();
                        }
                    }
                    if (serverClassIDNode != null && serverClassIDNode.getNodeValue().length() > 0) {
                        strUniqueID = serverClassIDNode.getNodeValue();
                    }
                    uniqueIDList.add(strUniqueID);
                    try {
                        URL fileUrl;
                        Document doc = null;
                        try {
                            fileUrl = locale != null ? XMLUtility.urlFromFile((String)strFileName, (Locale)locale) : XMLUtility.urlFromFile((String)strFileName);
                        }
                        catch (IOException exc) {
                            if (progressIndicator != null) {
                                Workspace.getDefaultLogger().error((Object)"", (Throwable)exc);
                            } else {
                                try {
                                    m_Factory.getUtil().printStackTrace((Throwable)exc);
                                }
                                catch (RemoteException remoteException) {
                                    // empty catch block
                                }
                            }
                            xmlToAddList.add(xmlFileError);
                            return;
                        }
                        try {
                            doc = m_Factory.getOMIUtil().parseXML(fileUrl);
                        }
                        catch (MdException exc) {
                            if (progressIndicator != null) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                            } else {
                                m_Factory.getUtil().printOutputln(exc.getMessage());
                            }
                            xmlToAddList.add(xmlFileError);
                            return;
                        }
                        catch (RemoteException re) {
                            if (progressIndicator != null) {
                                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                            }
                            m_Factory.getUtil().printStackTrace((Throwable)re);
                        }
                        String strFileContents = m_Factory.getUtil().createStringForNode((Node)doc);
                        int reposIndex = strFileContents.lastIndexOf("_ReposID_");
                        String strFileXML = strFileContents.substring(0, reposIndex) + strContext + strFileContents.substring(reposIndex + 9);
                        xmlToAddList.add(strFileXML);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    PrototypeWizard._buildData(m_Factory, children.item(childIndex), xmlToAddList, localeList, metadataTypeList, uniqueIDList, uniqueNameList, strContext, locale, progressIndicator);
                }
                break;
            }
        }
    }
}

