/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.svcs.metadata.mgmt.impl.repository.ResourceTemplateHelper;
import com.sas.svcs.metadata.mgmt.impl.repository.data.ResourceTemplates.ResourceBundleReader;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.util.XMLUtility;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.DBSchema;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.PropertiesPropertyView;
import com.sas.workspace.mgmt.visuals.Server;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrototypeUtil {
    public static final String CLASS_IDENTIFIER = "ClassIdentifier";
    public static final String ENGINE = "Engine";
    public static final String SERVERCLASSIDENTIFIER = "ServerClassIdentifier";
    public static final String EXTENSION_ASSOC = "Extensions";
    public static final String PROTOTYPE_PROPERTIES_ASSOC = "PrototypeProperties";
    public static final String GENERIC_TEMPLATE = "Generic";
    public static final String NONGENERIC_TEMPLATE = "NonGeneric";
    public static final String ALL_TEMPLATES = "All";
    public static final String XML_KEY = ".xmlKey";
    public static final String BUNDLE_LINE_BREAK = "[LINE_BREAK]";
    public static final String BUNDLE_LINE_BREAK_PARSE = "\\[LINE_BREAK\\]";
    public static final String CUSTOMIZER_PROPERTYNAME = "Customizer";
    protected static final WAdminResource bundle = new WAdminResource(PrototypeUtil.class);

    public static Locale getLocale(String strSuffix) {
        String strLanguageCode = strSuffix.substring(0, 2);
        Locale locale = new Locale(strLanguageCode);
        if ((strSuffix = strSuffix.substring(2)).length() > 0) {
            strSuffix = strSuffix.substring(1);
            String strCountryCode = strSuffix.substring(0, 2);
            locale = null;
            locale = new Locale(strLanguageCode, strCountryCode);
            if ((strSuffix = strSuffix.substring(2)).length() > 0) {
                String strVariant = strSuffix = strSuffix.substring(1);
                locale = null;
                locale = new Locale(strLanguageCode, strCountryCode, strVariant);
            }
        }
        return locale;
    }

    public static boolean isPrototypeCompatible(Root root, Component parent) throws MdException, RemoteException {
        boolean bCompatible = true;
        Prototype prototype = (Prototype)root.getUsingPrototype();
        if (prototype != null) {
            prototype = PrototypeUtil.getParentPrototype(prototype, "A0000001." + root.getFQID().substring(0, 8));
        }
        if (prototype == null && root instanceof ServerComponent) {
            Server server = new Server((MdObjectStore)root.getObjectStore(), "A0000001." + root.getFQID().substring(0, 8), (DeployedComponent)((ServerComponent)root));
            prototype = server.getDeployedComponentPrototype(parent);
        } else if (prototype == null && root instanceof SASLibrary) {
            Library library = new Library("A0000001." + root.getFQID().substring(0, 8), (DeployedDataPackage)((SASLibrary)root), (MdObjectStore)root.getObjectStore());
            prototype = library.getDeployedDataPackagePrototype(parent);
        } else if (prototype == null && root instanceof DatabaseSchema) {
            DBSchema schema = new DBSchema("A0000001." + root.getFQID().substring(0, 8), (DatabaseSchema)root, (MdObjectStore)root.getObjectStore());
            prototype = schema.getDatabaseSchemaPrototype(parent);
        }
        if (prototype != null) {
            boolean bContainsVersion = false;
            AssociationList groupsList = prototype.getGroups();
            int groupsListSize = groupsList.size();
            for (int groupIndex = 0; groupIndex < groupsListSize; ++groupIndex) {
                Group group = (Group)groupsList.get(groupIndex);
                AssociationList extensionsList = group.getExtensions();
                int extensionsListSize = extensionsList.size();
                for (int extIndex = 0; extIndex < extensionsListSize; ++extIndex) {
                    Extension extension = (Extension)extensionsList.get(extIndex);
                    if (!extension.getName().equalsIgnoreCase("ResourceTemplateVersion")) continue;
                    bContainsVersion = true;
                    String strVersion = extension.getValue();
                    try {
                        double dVersion = Double.parseDouble(strVersion);
                        if (!(PropertiesPropertyView.getVersion() < dVersion)) break;
                        bCompatible = false;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                if (bContainsVersion) break;
            }
            if (!bContainsVersion) {
                double dVersion = 9.13;
                if (PropertiesPropertyView.getVersion() < dVersion) {
                    bCompatible = false;
                }
            }
        }
        return bCompatible;
    }

    protected static Prototype getParentPrototype(Prototype prototype, String strContext) {
        try {
            Prototype parentPrototype;
            block17: {
                parentPrototype = prototype;
                if (parentPrototype.getMetadataType().equals("ServerContext") || parentPrototype.getMetadataType().equals("ServerComponent") || parentPrototype.getMetadataType().equals("SASLibrary") || parentPrototype.getMetadataType().equals("DatabaseSchema")) {
                    return parentPrototype;
                }
                try {
                    Prototype prot;
                    int apIndex;
                    AssociationList assocPrototypesList;
                    AssociationProperty ap;
                    int assocIndex;
                    AssociationList associationList;
                    if (parentPrototype.getMetadataType().equals("LogicalServer")) {
                        associationList = parentPrototype.getAssociations();
                        block5: for (assocIndex = 0; assocIndex < associationList.size(); ++assocIndex) {
                            ap = (AssociationProperty)associationList.get(assocIndex);
                            if (!ap.getAssociationName().equals("UsedByComponents")) continue;
                            assocPrototypesList = ap.getAssociatedPrototypes();
                            for (apIndex = 0; apIndex < assocPrototypesList.size(); ++apIndex) {
                                prot = (Prototype)assocPrototypesList.get(apIndex);
                                if (!prot.getMetadataType().equals("ServerComponent")) continue;
                                parentPrototype = PrototypeUtil.getParentPrototype(prot, strContext);
                                break block5;
                            }
                            break;
                        }
                    }
                    if (parentPrototype.getMetadataType().equals("TCPIPConnection") || parentPrototype.getMetadataType().equals("COMConnection") || parentPrototype.getMetadataType().equals("SASClientConnection") || parentPrototype.getMetadataType().equals("OpenClientConnection") || parentPrototype.getMetadataType().equals("Connection")) {
                        associationList = parentPrototype.getAssociations();
                        block7: for (assocIndex = 0; assocIndex < associationList.size(); ++assocIndex) {
                            ap = (AssociationProperty)associationList.get(assocIndex);
                            if (!ap.getAssociationName().equals("SourceConnections")) continue;
                            assocPrototypesList = ap.getAssociatedPrototypes();
                            for (apIndex = 0; apIndex < assocPrototypesList.size(); ++apIndex) {
                                prot = (Prototype)assocPrototypesList.get(apIndex);
                                if (!prot.getMetadataType().equals("ServerComponent")) continue;
                                parentPrototype = PrototypeUtil.getParentPrototype(prot, strContext);
                                break block7;
                            }
                            break;
                        }
                    }
                    if (parentPrototype.getMetadataType().equals("Transformation")) {
                        associationList = parentPrototype.getAssociations();
                        block9: for (assocIndex = 0; assocIndex < associationList.size(); ++assocIndex) {
                            ap = (AssociationProperty)associationList.get(assocIndex);
                            if (!ap.getAssociationName().equals("InitProcesses")) continue;
                            assocPrototypesList = ap.getAssociatedPrototypes();
                            for (apIndex = 0; apIndex < assocPrototypesList.size(); ++apIndex) {
                                prot = (Prototype)assocPrototypesList.get(apIndex);
                                if (!prot.getMetadataType().equals("ServerComponent") && !prot.getMetadataType().equals("LogicalServer")) continue;
                                parentPrototype = PrototypeUtil.getParentPrototype(prot, strContext);
                                break block9;
                            }
                            break;
                        }
                    }
                    if (!parentPrototype.getMetadataType().equals("Tree")) break block17;
                    associationList = parentPrototype.getAssociations();
                    for (assocIndex = 0; assocIndex < associationList.size(); ++assocIndex) {
                        ap = (AssociationProperty)associationList.get(assocIndex);
                        if (!ap.getAssociationName().equals("SoftwareTrees")) continue;
                        assocPrototypesList = ap.getAssociatedPrototypes();
                        for (apIndex = 0; apIndex < assocPrototypesList.size(); ++apIndex) {
                            prot = (Prototype)assocPrototypesList.get(apIndex);
                            if (!prot.getMetadataType().equals("LogicalServer")) continue;
                            parentPrototype = PrototypeUtil.getParentPrototype(prot, strContext);
                            break block17;
                        }
                        break;
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            return parentPrototype;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }

    protected static List getAssociatedPrototypesRecursive(Prototype prototype, String strContext) {
        Vector<AssociationProperty> assocPropertyList = new Vector<AssociationProperty>();
        Vector<Prototype> prototypeList = new Vector<Prototype>();
        try {
            prototypeList.add(prototype);
            for (int i = 0; i < prototypeList.size(); ++i) {
                AssociationProperty property;
                int j;
                String strAssocSelect;
                Prototype p = (Prototype)prototypeList.get(i);
                String strPrototypeID = p.getFQID();
                String strAssocOptions = strAssocSelect = "<XMLSELECT search=\"*[AssociatedPrototypes/*[@Id='" + strPrototypeID + "']]\" />";
                int assocFlags = 392;
                int assocIndex = assocPropertyList.size();
                List assocObjectList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(prototype.getObjectStore(), strContext, "AssociationProperty", assocFlags, strAssocOptions);
                for (j = 0; j < assocObjectList.size(); ++j) {
                    property = (AssociationProperty)assocObjectList.get(j);
                    if (assocPropertyList.contains(property)) continue;
                    assocPropertyList.add(property);
                }
                for (j = assocIndex; j < assocPropertyList.size(); ++j) {
                    String strSelect;
                    property = (AssociationProperty)assocPropertyList.get(j);
                    String strPropertyID = property.getFQID();
                    String strOptions = strSelect = "<XMLSELECT search=\"*[Associations/*[@Id='" + strPropertyID + "']]\" />";
                    int flags = 392;
                    List objectList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(prototype.getObjectStore(), strContext, "Prototype", flags, strOptions);
                    for (int k = 0; k < objectList.size(); ++k) {
                        Prototype prot = (Prototype)objectList.get(k);
                        if (prototypeList.contains(prot)) continue;
                        prototypeList.add(prot);
                    }
                }
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        return prototypeList;
    }

    public static List getTemplateLocales(IOMI omiConnection, String strReposId, MdStore store) {
        ArrayList<Locale> localeList = new ArrayList<Locale>(0);
        String template = "<TEMPLATES><Extension Name=\"\"><OwningObject><Prototype MetadataType=\"\"/></OwningObject></Extension></TEMPLATES>";
        String select = "<XMLSELECT search=\"Extension[@Name='Locale'][OwningObject/Prototype[@MetadataType='ServerContext' OR @MetadataType='ServerComponent' OR @MetadataType='SASLibrary' OR @MetadataType='DatabaseSchema']]\" />";
        int flags = 396;
        String options = template + select;
        List resultList = null;
        try {
            resultList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(store, strReposId, "Extension", flags, options, false);
            for (int i = 0; i < resultList.size(); ++i) {
                Locale locale;
                boolean found = false;
                Extension obj = (Extension)resultList.get(i);
                String localeStr = obj.getValue();
                if (localeStr.equalsIgnoreCase(GENERIC_TEMPLATE)) continue;
                for (int j = 0; j < localeList.size(); ++j) {
                    Locale loc = (Locale)localeList.get(j);
                    String country = loc.getCountry();
                    String language = loc.getLanguage();
                    String variant = loc.getVariant();
                    String dispName = language;
                    if (country != null && country.length() > 0) {
                        dispName = dispName + "_" + country;
                        if (variant != null && variant.length() > 0) {
                            dispName = dispName + "_" + variant;
                        }
                    }
                    if (!dispName.equalsIgnoreCase(localeStr)) continue;
                    found = true;
                }
                if (found || localeList.contains(locale = PrototypeUtil.getLocale(localeStr))) continue;
                localeList.add(locale);
            }
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage());
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        return localeList;
    }

    public static List getTemplateLocales(MdFactory m_Factory, String strReposId, MdStore store) {
        ArrayList<Locale> localeList = new ArrayList<Locale>(0);
        String template = "<TEMPLATES><Extension Name=\"\"><OwningObject><Prototype MetadataType=\"\"/></OwningObject></Extension></TEMPLATES>";
        String select = "<XMLSELECT search=\"Extension[@Name='Locale'][OwningObject/Prototype[@MetadataType='ServerContext' OR @MetadataType='ServerComponent' OR @MetadataType='SASLibrary' OR @MetadataType='DatabaseSchema']]\" />";
        int flags = 396;
        String options = template + select;
        List resultList = null;
        try {
            resultList = m_Factory.getOMIUtil().getMetadataObjectsSubset(store, strReposId, "Extension", flags, options, false);
            for (int i = 0; i < resultList.size(); ++i) {
                Locale locale;
                boolean found = false;
                Extension obj = (Extension)resultList.get(i);
                String localeStr = obj.getValue();
                if (localeStr.equalsIgnoreCase(GENERIC_TEMPLATE)) continue;
                for (int j = 0; j < localeList.size(); ++j) {
                    Locale loc = (Locale)localeList.get(j);
                    String country = loc.getCountry();
                    String language = loc.getLanguage();
                    String variant = loc.getVariant();
                    String dispName = language;
                    if (country != null && country.length() > 0) {
                        dispName = dispName + "_" + country;
                        if (variant != null && variant.length() > 0) {
                            dispName = dispName + "_" + variant;
                        }
                    }
                    if (!dispName.equalsIgnoreCase(localeStr)) continue;
                    found = true;
                }
                if (found || localeList.contains(locale = PrototypeUtil.getLocale(localeStr))) continue;
                localeList.add(locale);
            }
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage());
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        return localeList;
    }

    public static void addPrototype(IOMI omiConnection, String strAttribute, String strValue, String strReposId) throws MdException, RemoteException {
        String strXML = new String();
        Document doc = null;
        try {
            URL url = ResourceTemplateHelper.getURLfromPrototypeIndexFile();
            try {
                doc = Workspace.getMdFactory().getOMIUtil().parseXML(url);
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                return;
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
            strXML = Workspace.getMdFactory().getUtil().createStringForNode((Node)doc);
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        if (strXML.equals("")) {
            return;
        }
        strXML = strXML.substring(strXML.indexOf("<Prototypes"), strXML.indexOf("</Configuration"));
        if (doc != null) {
            PrototypeUtil.buildData(Workspace.getMdFactory(), doc, strAttribute, strValue, strReposId);
        }
    }

    public static void addPrototype(MdFactory m_Factory, String strAttribute, String strValue, String strReposId) throws MdException, RemoteException {
        String strXML = new String();
        Document doc = null;
        try {
            URL url = ResourceTemplateHelper.getURLfromPrototypeIndexFile();
            try {
                doc = m_Factory.getOMIUtil().parseXML(url);
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                return;
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
            strXML = m_Factory.getUtil().createStringForNode((Node)doc);
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        if (strXML.equals("")) {
            return;
        }
        strXML = strXML.substring(strXML.indexOf("<Prototypes"), strXML.indexOf("</Configuration"));
        if (doc != null) {
            PrototypeUtil.buildData(m_Factory, doc, strAttribute, strValue, strReposId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void buildData(MdFactory m_Factory, Node node, String strAttribute, String strValue, String strContext) throws MdException, RemoteException {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    PrototypeUtil.buildData(m_Factory, children.item(childIndex), strAttribute, strValue, strContext);
                }
                return;
            }
            case 1: {
                if (node.getNodeName().equals("Prototype")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String strPrototypeName = PrototypeUtil.getDisplayString(childNodeMap.getNamedItem(strAttribute).getNodeValue(), null);
                    if (!strPrototypeName.equalsIgnoreCase(strValue)) return;
                    String strFileName = childNodeMap.getNamedItem("FileName").getNodeValue();
                    try {
                        URL url = XMLUtility.urlFromFile((String)strFileName);
                        Document doc = null;
                        try {
                            doc = m_Factory.getOMIUtil().parseXML(url);
                        }
                        catch (MdException exc) {
                            throw exc;
                        }
                        catch (RemoteException re) {
                            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                        }
                        String strContents = m_Factory.getUtil().createStringForNode((Node)doc);
                        int reposIndex = strContents.lastIndexOf("_ReposID_");
                        String strPrototypeXML = strContents.substring(0, reposIndex) + strContext + strContents.substring(reposIndex + 9);
                        try {
                            m_Factory.getOMIUtil().DoRequest(strPrototypeXML, true);
                            return;
                        }
                        catch (Exception exc) {
                            if (!(exc instanceof MdException)) return;
                            throw (MdException)((Object)exc);
                        }
                    }
                    catch (IOException exc) {
                        exc.printStackTrace();
                    }
                    return;
                }
                NodeList children = node.getChildNodes();
                if (children == null) return;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    PrototypeUtil.buildData(m_Factory, children.item(childIndex), strAttribute, strValue, strContext);
                }
                return;
            }
        }
    }

    public static void deletePrototype(IOMI omiConnection, Prototype prototype) throws MdException, RemoteException {
        PrototypeUtil.deletePrototype(Workspace.getMdFactory(), prototype);
    }

    public static void deletePrototype(MdFactory m_Factory, Prototype prototype) throws MdException, RemoteException {
        String deletelist = "";
        if (prototype != null) {
            deletelist = "<Prototype Id=\"" + prototype.getFQID() + "\" TemplateName=\"ResourceTemplate\"/>";
            String strDeleteTemplate = bundle.getString("PrototypeUtil.DeleteTemplate.notrans");
            String options = "<Options>" + strDeleteTemplate + "</Options>";
            String flags = "<Flags>402654212</Flags><ns>SAS</ns>";
            String request = "<DeleteMetadata><Metadata>" + deletelist + "</Metadata>" + flags + options + "</DeleteMetadata>";
            try {
                m_Factory.getOMIUtil().DoRequest(request, false);
            }
            catch (MdException exc) {
                throw exc;
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        }
    }

    public static Prototype getPrototypeByIdentifier(IOMI omiConnection, String strAssociation, String strAttribute, String strValue, String strReposId, String strMetadataType, Locale locale, MdStore store) throws MdException, RemoteException {
        Prototype prototype;
        block20: {
            String strLocale;
            String strLanguage;
            prototype = null;
            if (locale == null) {
                strLanguage = GENERIC_TEMPLATE;
                strLocale = GENERIC_TEMPLATE;
            } else {
                strLanguage = locale.getLanguage();
                strLocale = locale.toString();
            }
            if (strMetadataType == null) {
                strMetadataType = strAttribute.equalsIgnoreCase(ENGINE) ? "SASLibrary" : (strAttribute.equalsIgnoreCase(SERVERCLASSIDENTIFIER) ? "DatabaseSchema" : "ServerComponent");
            }
            String strNameAttribute = "Name";
            String strValueAttribute = "Value";
            if (strAssociation != null && strAssociation.equalsIgnoreCase(PROTOTYPE_PROPERTIES_ASSOC)) {
                strNameAttribute = "Property" + strNameAttribute;
                strValueAttribute = "Default" + strValueAttribute;
            }
            String strType = bundle.getString("Prototype.Type.notrans");
            String strTemplate = bundle.getString("Prototype.Template.Simple.notrans");
            String strSelect = "<XMLSELECT search=\"*[@MetadataType='" + strMetadataType + "'][" + strAssociation + "/*[@" + strNameAttribute + "='" + strAttribute + "' AND @" + strValueAttribute + "='" + strValue + "']/OwningPrototype/Prototype/Extensions/*[@Name='Locale' AND @Value='" + strLocale + "']]\"/>";
            if (strMetadataType.equals("DatabaseSchema") || strMetadataType.equals("SASLibrary") && strAttribute.equals(SERVERCLASSIDENTIFIER)) {
                strSelect = "<XMLSELECT search=\"*[@MetadataType='" + strMetadataType + "'][" + strAssociation + "/*[@" + strNameAttribute + "='" + strAttribute + "' AND @" + strValueAttribute + "='" + strValue + "']/OwningObject/Prototype/Extensions/*[@Name='Locale' AND @Value='" + strLocale + "']]\"/>";
            }
            if (strAssociation == null) {
                strSelect = "<XMLSELECT search=\"@" + strAttribute + "='" + strValue + "'\"/>";
            }
            String strOptions = strTemplate + strSelect;
            int flags = 8588;
            List prototypeList = new Vector();
            try {
                prototypeList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(store, strReposId, strType, flags, strOptions, true);
            }
            catch (MdException exc) {
                throw exc;
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
            if (prototypeList.size() > 0) {
                try {
                    String localeValue;
                    Extension extension;
                    int extIndex;
                    AssociationList extensionList;
                    Prototype prot;
                    int protIndex;
                    for (protIndex = 0; protIndex < prototypeList.size(); ++protIndex) {
                        prot = (Prototype)prototypeList.get(protIndex);
                        extensionList = prot.getExtensions();
                        for (extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                            extension = (Extension)extensionList.get(extIndex);
                            if (!extension.getName().equals("Locale")) continue;
                            localeValue = extension.getValue();
                            if (localeValue.equalsIgnoreCase(GENERIC_TEMPLATE) && strLanguage == GENERIC_TEMPLATE) {
                                prototype = prot;
                                break;
                            }
                            if (!PrototypeUtil.getLocale(localeValue).equals(locale)) continue;
                            prototype = prot;
                            break;
                        }
                        if (prototype != null) break;
                    }
                    if (prototype != null) break block20;
                    for (protIndex = 0; protIndex < prototypeList.size(); ++protIndex) {
                        prot = (Prototype)prototypeList.get(protIndex);
                        extensionList = prot.getExtensions();
                        for (extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                            extension = (Extension)extensionList.get(extIndex);
                            if (!extension.getName().equals("Locale")) continue;
                            localeValue = extension.getValue();
                            if (localeValue.equalsIgnoreCase(GENERIC_TEMPLATE) && strLanguage.equals(localeValue)) {
                                prototype = prot;
                                break;
                            }
                            if (!PrototypeUtil.getLocale(localeValue).getLanguage().equals(strLanguage)) continue;
                            prototype = prot;
                            break;
                        }
                        if (prototype == null) {
                            continue;
                        }
                        break;
                    }
                }
                catch (MdException exc) {
                    throw exc;
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
        }
        return prototype;
    }

    public static Prototype getPrototypeByIdentifier(MdFactory m_MdFactory, String strAssociation, String strAttribute, String strValue, String strReposId, String strMetadataType, Locale locale, MdStore store) throws MdException, RemoteException {
        Prototype prototype;
        block20: {
            String strLocale;
            String strLanguage;
            prototype = null;
            if (locale == null) {
                strLanguage = GENERIC_TEMPLATE;
                strLocale = GENERIC_TEMPLATE;
            } else {
                strLanguage = locale.getLanguage();
                strLocale = locale.toString();
            }
            if (strMetadataType == null) {
                strMetadataType = strAttribute.equalsIgnoreCase(ENGINE) ? "SASLibrary" : (strAttribute.equalsIgnoreCase(SERVERCLASSIDENTIFIER) ? "DatabaseSchema" : "ServerComponent");
            }
            String strNameAttribute = "Name";
            String strValueAttribute = "Value";
            if (strAssociation != null && strAssociation.equalsIgnoreCase(PROTOTYPE_PROPERTIES_ASSOC)) {
                strNameAttribute = "Property" + strNameAttribute;
                strValueAttribute = "Default" + strValueAttribute;
            }
            String strType = bundle.getString("Prototype.Type.notrans");
            String strTemplate = bundle.getString("Prototype.Template.Simple.notrans");
            String strSelect = "<XMLSELECT search=\"*[@MetadataType='" + strMetadataType + "'][" + strAssociation + "/*[@" + strNameAttribute + "='" + strAttribute + "' AND @" + strValueAttribute + "='" + strValue + "']/OwningPrototype/Prototype/Extensions/*[@Name='Locale' AND @Value='" + strLocale + "']]\"/>";
            if (strMetadataType.equals("DatabaseSchema") || strMetadataType.equals("SASLibrary") && strAttribute.equals(SERVERCLASSIDENTIFIER)) {
                strSelect = "<XMLSELECT search=\"*[@MetadataType='" + strMetadataType + "'][" + strAssociation + "/*[@" + strNameAttribute + "='" + strAttribute + "' AND @" + strValueAttribute + "='" + strValue + "']/OwningObject/Prototype/Extensions/*[@Name='Locale' AND @Value='" + strLocale + "']]\"/>";
            }
            if (strAssociation == null) {
                strSelect = "<XMLSELECT search=\"@" + strAttribute + "='" + strValue + "'\"/>";
            }
            String strOptions = strTemplate + strSelect;
            int flags = 396;
            List prototypeList = new Vector();
            try {
                prototypeList = m_MdFactory.getOMIUtil().getMetadataObjectsSubset(store, strReposId, strType, flags, strOptions, true);
            }
            catch (MdException exc) {
                throw exc;
            }
            catch (RemoteException re) {
                m_MdFactory.getUtil().printStackTrace((Throwable)re);
            }
            if (prototypeList.size() > 0) {
                try {
                    String localeValue;
                    Extension extension;
                    int extIndex;
                    AssociationList extensionList;
                    Prototype prot;
                    int protIndex;
                    for (protIndex = 0; protIndex < prototypeList.size(); ++protIndex) {
                        prot = (Prototype)prototypeList.get(protIndex);
                        extensionList = prot.getExtensions();
                        for (extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                            extension = (Extension)extensionList.get(extIndex);
                            if (!extension.getName().equals("Locale")) continue;
                            localeValue = extension.getValue();
                            if (localeValue.equalsIgnoreCase(GENERIC_TEMPLATE) && strLanguage == GENERIC_TEMPLATE) {
                                prototype = prot;
                                break;
                            }
                            if (!PrototypeUtil.getLocale(localeValue).equals(locale)) continue;
                            prototype = prot;
                            break;
                        }
                        if (prototype != null) break;
                    }
                    if (prototype != null) break block20;
                    for (protIndex = 0; protIndex < prototypeList.size(); ++protIndex) {
                        prot = (Prototype)prototypeList.get(protIndex);
                        extensionList = prot.getExtensions();
                        for (extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                            extension = (Extension)extensionList.get(extIndex);
                            if (!extension.getName().equals("Locale")) continue;
                            localeValue = extension.getValue();
                            if (localeValue.equalsIgnoreCase(GENERIC_TEMPLATE) && strLanguage.equals(localeValue)) {
                                prototype = prot;
                                break;
                            }
                            if (!PrototypeUtil.getLocale(localeValue).getLanguage().equals(strLanguage)) continue;
                            prototype = prot;
                            break;
                        }
                        if (prototype == null) {
                            continue;
                        }
                        break;
                    }
                }
                catch (MdException exc) {
                    throw exc;
                }
                catch (RemoteException re) {
                    m_MdFactory.getUtil().printStackTrace((Throwable)re);
                }
            }
        }
        return prototype;
    }

    public static Prototype getPrototypeByIdentifier(IOMI omiConnection, String strValue, String strReposId, String strMetadataType, Locale locale, MdStore store) throws MdException, RemoteException {
        String strAssociation = PROTOTYPE_PROPERTIES_ASSOC;
        String strAttribute = CLASS_IDENTIFIER;
        if (strMetadataType == null) {
            return null;
        }
        if (strMetadataType.equalsIgnoreCase("DatabaseSchema")) {
            strAssociation = EXTENSION_ASSOC;
            strAttribute = SERVERCLASSIDENTIFIER;
        } else if (strMetadataType.equalsIgnoreCase("SASLibrary")) {
            if (strValue.equalsIgnoreCase("DB2UNXPC") || strValue.equalsIgnoreCase("DB2OS390")) {
                strAssociation = EXTENSION_ASSOC;
                strAttribute = SERVERCLASSIDENTIFIER;
            } else {
                strAttribute = ENGINE;
            }
        }
        return PrototypeUtil.getPrototypeByIdentifier(omiConnection, strAssociation, strAttribute, strValue, strReposId, strMetadataType, locale, store);
    }

    public static Prototype getPrototypeByIdentifier(MdFactory m_MdFactory, String strValue, String strReposId, String strMetadataType, Locale locale, MdStore store) throws MdException, RemoteException {
        String strAssociation = PROTOTYPE_PROPERTIES_ASSOC;
        String strAttribute = CLASS_IDENTIFIER;
        if (strMetadataType == null) {
            return null;
        }
        if (strMetadataType.equalsIgnoreCase("DatabaseSchema")) {
            strAssociation = EXTENSION_ASSOC;
            strAttribute = SERVERCLASSIDENTIFIER;
        } else if (strMetadataType.equalsIgnoreCase("SASLibrary")) {
            if (strValue.equalsIgnoreCase("DB2UNXPC") || strValue.equalsIgnoreCase("DB2OS390")) {
                strAssociation = EXTENSION_ASSOC;
                strAttribute = SERVERCLASSIDENTIFIER;
            } else {
                strAttribute = ENGINE;
            }
        }
        return PrototypeUtil.getPrototypeByIdentifier(m_MdFactory, strAssociation, strAttribute, strValue, strReposId, strMetadataType, locale, store);
    }

    public static void addPropertyBundleNode(String fileName, Document doc, Node parent) throws MdException, FileNotFoundException, IOException {
        String temp = fileName.substring(0, fileName.indexOf(".properties"));
        if (temp.indexOf("_") == -1) {
            throw new MdException(bundle.getString("PrototypeUtil.InvalidPropertyBundleFileName.txt"));
        }
        String locale = temp.substring(temp.indexOf("_") + 1);
        StringBuffer fileContents = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        while (reader.ready()) {
            fileContents.append(reader.readLine() + BUNDLE_LINE_BREAK);
        }
        Element textStore = doc.createElement("TextStore");
        textStore.setAttribute("Name", locale);
        textStore.setAttribute("TextRole", "PropertyBundle");
        textStore.setAttribute("TextType", "PlainText");
        textStore.setAttribute("StoredText", fileContents.toString());
        parent.appendChild(textStore);
    }

    public static String getDisplayString(String value) {
        return PrototypeUtil.getDisplayString(value, null);
    }

    public static String getDisplayString(String value, Prototype prototype) {
        return PrototypeUtil.getDisplayString(value, false, prototype);
    }

    public static String getDisplayString(String value, boolean includeMnemonics) {
        return PrototypeUtil.getDisplayString(value, includeMnemonics, null);
    }

    public static String getDisplayString(String value, boolean includeMnemonics, Prototype prototype) {
        String displayString = value;
        if (value == null || value.length() == 0 || value.indexOf(XML_KEY) == -1) {
            return value;
        }
        if (prototype != null) {
            try {
                URL[] urls;
                URLClassLoader tempClassLoader;
                WAdminResource tempBundle;
                String tempString;
                AssociationList notes = prototype.getNotes();
                String bundleName = null;
                for (int i = 0; i < notes.size(); ++i) {
                    if (!((TextStore)notes.get(i)).getTextRole().equals("PropertyBundle")) continue;
                    bundleName = prototype.getFQID().replaceAll("\\.", "");
                    TextStore textStore = (TextStore)notes.get(i);
                    File tempFile = new File(PrototypeUtil.getResourceTemplateBundlesDir(), bundleName + "_" + textStore.getName() + ".properties");
                    if (!tempFile.exists()) {
                        PrototypeUtil.writePropertyBundle(textStore.getStoredText(), tempFile, prototype);
                        continue;
                    }
                    BufferedReader reader = new BufferedReader(new FileReader(tempFile));
                    if (reader.ready()) {
                        String firstLine = reader.readLine();
                        if (firstLine.equals("#MetadataUpdated:" + prototype.getMetadataUpdated())) continue;
                        tempFile.delete();
                        PrototypeUtil.writePropertyBundle(textStore.getStoredText(), tempFile, prototype);
                    }
                    reader.close();
                }
                if (bundleName != null && (tempString = (tempBundle = new WAdminResource(bundleName, (ClassLoader)(tempClassLoader = new URLClassLoader(urls = new URL[]{PrototypeUtil.getResourceTemplateBundlesDir().toURL()}, PrototypeUtil.class.getClassLoader())))).getRawString(value)) != null) {
                    if (includeMnemonics) {
                        return tempString;
                    }
                    return Util.getDisplayLabel((String)tempString);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (value != null && value.length() > 0 && value.indexOf(XML_KEY) > -1) {
            try {
                displayString = ResourceBundleReader.getDisplayString((String)value);
            }
            catch (MissingResourceException e) {
                Workspace.getDefaultLogger().warn((Object)("Missing resource (" + value + ") is called from the following:"), new Throwable());
                displayString = "Missing resource " + value;
            }
        }
        if (includeMnemonics) {
            return displayString;
        }
        return Util.getDisplayLabel((String)displayString);
    }

    public static String getDisplayStringOld(String value, boolean includeMnemonics, Prototype prototype) {
        String displayString = value;
        WAdminResource resBundle = new WAdminResource("com.sas.workspace.visuals.res.PropertyBundle");
        if (value == null || value.length() == 0 || value.indexOf(XML_KEY) == -1) {
            return value;
        }
        if (prototype != null) {
            try {
                URL[] urls;
                URLClassLoader tempClassLoader;
                WAdminResource tempBundle;
                String tempString;
                AssociationList notes = prototype.getNotes();
                String bundleName = null;
                for (int i = 0; i < notes.size(); ++i) {
                    if (!((TextStore)notes.get(i)).getTextRole().equals("PropertyBundle")) continue;
                    bundleName = prototype.getFQID().replaceAll("\\.", "");
                    TextStore textStore = (TextStore)notes.get(i);
                    File tempFile = new File(PrototypeUtil.getResourceTemplateBundlesDir(), bundleName + "_" + textStore.getName() + ".properties");
                    if (!tempFile.exists()) {
                        PrototypeUtil.writePropertyBundle(textStore.getStoredText(), tempFile, prototype);
                        continue;
                    }
                    BufferedReader reader = new BufferedReader(new FileReader(tempFile));
                    if (reader.ready()) {
                        String firstLine = reader.readLine();
                        if (firstLine.equals("#MetadataUpdated:" + prototype.getMetadataUpdated())) continue;
                        tempFile.delete();
                        PrototypeUtil.writePropertyBundle(textStore.getStoredText(), tempFile, prototype);
                    }
                    reader.close();
                }
                if (bundleName != null && (tempString = (tempBundle = new WAdminResource(bundleName, (ClassLoader)(tempClassLoader = new URLClassLoader(urls = new URL[]{PrototypeUtil.getResourceTemplateBundlesDir().toURL()}, PrototypeUtil.class.getClassLoader())))).getRawString(value)) != null) {
                    if (includeMnemonics) {
                        return tempString;
                    }
                    return Util.getDisplayLabel((String)tempString);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (value != null && value.length() > 0 && value.indexOf(XML_KEY) > -1) {
            displayString = resBundle.getString(value);
        }
        if (includeMnemonics) {
            return displayString;
        }
        return Util.getDisplayLabel((String)displayString);
    }

    private static void writePropertyBundle(String bundle, File outputFile, Prototype prototype) throws RemoteException, IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        out.println("#MetadataUpdated:" + prototype.getMetadataUpdated());
        String[] lines = bundle.split(BUNDLE_LINE_BREAK_PARSE);
        for (int j = 0; j < lines.length; ++j) {
            out.println(lines[j]);
        }
        out.close();
    }

    private static File getResourceTemplateBundlesDir() {
        File bundlesDir;
        String appData = Workspace.getAppDataPath();
        String separator = File.separator;
        String environmentLocation = appData + separator + "SAS" + separator + "ResourceTemplateBundles" + separator + "9.2";
        if (separator.equals("/")) {
            environmentLocation = appData + separator + ".SASAppData" + separator + "ResourceTemplateBundles" + separator + "9.2";
        }
        if (!(bundlesDir = new File(environmentLocation)).exists()) {
            bundlesDir.mkdirs();
        }
        return bundlesDir;
    }

    public static boolean deleteTemplates(MdFactory m_Factory, String reposId, String templateType) throws MdException, RemoteException {
        List m_protoList = null;
        if (reposId != null) {
            try {
                m_protoList = PrototypeUtil.populateTemplateList(m_Factory, reposId, templateType);
            }
            catch (MdException exc) {
                throw new MdException("Error populating template list Cause: " + exc.getLocalizedMessage());
            }
            catch (RemoteException re) {
                throw re;
            }
            if (m_protoList == null) {
                return false;
            }
            if (m_protoList.isEmpty()) {
                return true;
            }
            if (templateType == ALL_TEMPLATES) {
                return PrototypeUtil.deleteAllTemplates(m_Factory, reposId, m_protoList);
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean deleteAllTemplates(MdFactory factory, String reposId, List protoList) throws RemoteException {
        String deletelist = "";
        for (int index = 0; index < protoList.size(); ++index) {
            Prototype item = (Prototype)protoList.get(index);
            if (item == null) continue;
            deletelist = "<Prototype Id=\"" + item.getFQID() + "\" TemplateName=\"ResourceTemplate\"/>";
            String strDeleteTemplate = bundle.getString("PrototypeUtil.DeleteTemplate.notrans");
            String options = "<Options>" + strDeleteTemplate + "</Options>";
            String flags = "<Flags>402654212</Flags><ns>SAS</ns>";
            String request = "<DeleteMetadata><Metadata>" + deletelist + "</Metadata>" + flags + options + "</DeleteMetadata>";
            try {
                factory.getOMIUtil().DoRequest(request, false);
                continue;
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static List populateTemplateList(MdFactory m_Factory, String reposId, String templateType) throws MdException, RemoteException {
        Vector<Prototype> prototypesList = null;
        String strType = bundle.getString("Prototype.Type.notrans");
        String strTemplate = bundle.getString("PrototypeUtil.Template.notrans");
        String strSelect = bundle.getString("PrototypeUtil.Select.notrans");
        String strOptions = strTemplate + strSelect;
        int flags = 396;
        List objectList = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)m_Factory.createObjectStore(), reposId, strType, flags, strOptions);
        if (prototypesList == null) {
            prototypesList = new Vector<Prototype>();
        }
        block0: for (int k = 0; k < objectList.size(); ++k) {
            Prototype prot = (Prototype)objectList.get(k);
            AssociationList extensionList = prot.getExtensions(false);
            for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                Extension extension = (Extension)extensionList.get(extIndex);
                if (!extension.getName().equals("Locale")) continue;
                String localeValue = extension.getValue();
                if (templateType.equalsIgnoreCase(GENERIC_TEMPLATE)) {
                    if (!localeValue.equalsIgnoreCase(GENERIC_TEMPLATE)) continue;
                    prototypesList.add(prot);
                    continue block0;
                }
                if (templateType.equalsIgnoreCase(NONGENERIC_TEMPLATE)) {
                    if (localeValue.equalsIgnoreCase(GENERIC_TEMPLATE)) continue;
                    prototypesList.add(prot);
                    continue block0;
                }
                if (!templateType.equalsIgnoreCase(ALL_TEMPLATES)) continue;
                prototypesList.add(prot);
                continue block0;
            }
        }
        return prototypesList;
    }

    public static List getAllGroupsRecursive(PropertyGroup group) throws MdException, RemoteException {
        Vector groupList = new Vector();
        AssociationList subgroupList = group.getSubpropertyGroups();
        groupList.addAll(subgroupList);
        for (int i = 0; i < subgroupList.size(); ++i) {
            PropertyGroup subgroup = (PropertyGroup)subgroupList.get(i);
            groupList.addAll(PrototypeUtil.getAllGroupsRecursive(subgroup));
        }
        return groupList;
    }

    public static List getAllPropertiesRecursive(PropertyGroup group) throws MdException, RemoteException {
        Vector propertiesList = new Vector();
        propertiesList.addAll(group.getGroupedProperties());
        List groupsList = PrototypeUtil.getAllGroupsRecursive(group);
        for (int groupIndex = 0; groupIndex < groupsList.size(); ++groupIndex) {
            PropertyGroup subgroup = (PropertyGroup)groupsList.get(groupIndex);
            propertiesList.addAll(subgroup.getGroupedProperties());
        }
        return propertiesList;
    }

    public static List getAllRequiredPropertiesRecursive(PropertyGroup group) throws MdException, RemoteException {
        Vector<AbstractProperty> requiredPropertiesList = new Vector<AbstractProperty>();
        List propertiesList = PrototypeUtil.getAllPropertiesRecursive(group);
        for (int propIndex = 0; propIndex < propertiesList.size(); ++propIndex) {
            AbstractProperty ap = (AbstractProperty)propertiesList.get(propIndex);
            if (ap.getIsRequired() != 1) continue;
            requiredPropertiesList.add(ap);
        }
        return requiredPropertiesList;
    }

    public static boolean isGroupEntirelyExpert(PropertyGroup group) throws MdException, RemoteException {
        boolean bIsExpert = true;
        AssociationList propertiesList = group.getGroupedProperties();
        for (int i = 0; i < propertiesList.size(); ++i) {
            AbstractProperty property = (AbstractProperty)propertiesList.get(i);
            if (property instanceof AssociationProperty) continue;
            if (property instanceof AttributeProperty) {
                AttributeProperty ap = (AttributeProperty)property;
                boolean bl = bIsExpert = ap.getIsExpert() == 1;
            }
            if (property instanceof Property) {
                Property p = (Property)property;
                boolean bl = bIsExpert = p.getIsExpert() == 1;
            }
            if (bIsExpert) continue;
            return false;
        }
        AssociationList subgroupList = group.getSubpropertyGroups();
        for (int j = 0; j < subgroupList.size(); ++j) {
            PropertyGroup subgroup = (PropertyGroup)subgroupList.get(j);
            bIsExpert = PrototypeUtil.isGroupEntirelyExpert(subgroup);
            if (bIsExpert) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVisibleProperty(PropertyGroup group) throws MdException, RemoteException {
        boolean bIsVisible = false;
        AssociationList propertiesList = group.getGroupedProperties();
        for (int i = 0; i < propertiesList.size(); ++i) {
            AbstractProperty property = (AbstractProperty)propertiesList.get(i);
            if (property instanceof AssociationProperty) continue;
            if (property instanceof AttributeProperty) {
                AttributeProperty ap = (AttributeProperty)property;
                boolean bl = bIsVisible = ap.getIsVisible() == 1;
            }
            if (property instanceof Property) {
                Property p = (Property)property;
                boolean bl = bIsVisible = p.getIsVisible() == 1;
            }
            if (!bIsVisible) continue;
            return true;
        }
        AssociationList subgroupList = group.getSubpropertyGroups();
        for (int j = 0; j < subgroupList.size(); ++j) {
            PropertyGroup subgroup = (PropertyGroup)subgroupList.get(j);
            bIsVisible = PrototypeUtil.hasVisibleProperty(subgroup);
            if (!bIsVisible) continue;
            return true;
        }
        return false;
    }

    public static boolean hasARequiredValuePropertySpecified(PropertyGroup group) throws MdException, RemoteException {
        boolean bIsRequiredValueSpecified = false;
        AssociationList propertiesList = group.getGroupedProperties();
        for (int i = 0; i < propertiesList.size(); ++i) {
            AbstractProperty property = (AbstractProperty)propertiesList.get(i);
            boolean bl = bIsRequiredValueSpecified = property.getIsRequired() == 1;
            if (!bIsRequiredValueSpecified) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnExpertPropertySpecified(PropertyGroup group) throws MdException, RemoteException {
        boolean bIsExpertSpecified = false;
        AssociationList propertiesList = group.getGroupedProperties();
        for (int i = 0; i < propertiesList.size(); ++i) {
            AbstractProperty property = (AbstractProperty)propertiesList.get(i);
            boolean bl = bIsExpertSpecified = property.getIsExpert() == 1;
            if (!bIsExpertSpecified) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAVisibleExpertPropertySpecified(PropertyGroup group) throws MdException, RemoteException {
        boolean bIsVisibleExpertSpecified = false;
        AssociationList propertiesList = group.getGroupedProperties();
        for (int i = 0; i < propertiesList.size(); ++i) {
            AbstractProperty property = (AbstractProperty)propertiesList.get(i);
            boolean bl = bIsVisibleExpertSpecified = property.getIsVisible() == 1 && property.getIsExpert() == 1;
            if (!bIsVisibleExpertSpecified) continue;
            return true;
        }
        return false;
    }

    public static boolean hasADefaultValuePropertySpecified(PropertyGroup group) throws MdException, RemoteException {
        boolean bIsDefaultValueSpecified = false;
        AssociationList propertiesList = group.getGroupedProperties();
        for (int i = 0; i < propertiesList.size(); ++i) {
            AbstractProperty property = (AbstractProperty)propertiesList.get(i);
            if (property instanceof AssociationProperty) continue;
            if (property instanceof AttributeProperty) {
                AttributeProperty ap = (AttributeProperty)property;
                boolean bl = bIsDefaultValueSpecified = ap.getDefaultValue().length() > 0;
            }
            if (property instanceof Property) {
                Property p = (Property)property;
                boolean bl = bIsDefaultValueSpecified = p.getDefaultValue().length() > 0;
            }
            if (!bIsDefaultValueSpecified) continue;
            return true;
        }
        AssociationList subgroupList = group.getSubpropertyGroups();
        for (int j = 0; j < subgroupList.size(); ++j) {
            PropertyGroup subgroup = (PropertyGroup)subgroupList.get(j);
            bIsDefaultValueSpecified = PrototypeUtil.hasADefaultValuePropertySpecified(subgroup);
            if (!bIsDefaultValueSpecified) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimaryCustomViewGroup(PropertyGroup group) throws MdException, RemoteException {
        return PrototypeUtil.containsCustomizer(group) && PrototypeUtil.isPrimaryPropertyGroup(group);
    }

    public static boolean isSimpleCustomViewGroup(PropertyGroup group) throws MdException, RemoteException {
        return PrototypeUtil.containsCustomizer(group) && !PrototypeUtil.isGroupEntirelyExpert(group);
    }

    public static boolean isAdvancedCustomViewGroup(PropertyGroup group) throws MdException, RemoteException {
        return PrototypeUtil.containsCustomizer(group) && PrototypeUtil.isGroupEntirelyExpert(group);
    }

    public static boolean isPrimaryPropertyGroup(PropertyGroup group) throws MdException, RemoteException {
        return group == PrototypeUtil.getPrimaryPropertyGroup(group);
    }

    public static boolean containsCustomizer(PropertyGroup group) throws MdException, RemoteException {
        return group.getCustomizers().size() > 0 || PrototypeUtil.newCustomizerFormatExists(group);
    }

    public static PropertyGroup getPrimaryPropertyGroup(PropertyGroup group) throws MdException, RemoteException {
        PropertyGroup parentGroup = group.getParentGroup();
        return parentGroup == null ? group : PrototypeUtil.getPrimaryPropertyGroup(parentGroup);
    }

    public static List getAllExpertRequiredPropertiesRecursive(PropertyGroup group) throws MdException, RemoteException {
        Vector<AbstractProperty> expertRequiredPropertiesList = new Vector<AbstractProperty>();
        List propertiesList = PrototypeUtil.getAllExpertPropertiesRecursive(group);
        for (int propIndex = 0; propIndex < propertiesList.size(); ++propIndex) {
            AbstractProperty ap = (AbstractProperty)propertiesList.get(propIndex);
            if (ap.getIsRequired() != 1) continue;
            expertRequiredPropertiesList.add(ap);
        }
        return expertRequiredPropertiesList;
    }

    public static List getAllSimplePropertiesRecursive(PropertyGroup group) throws MdException, RemoteException {
        Vector<AbstractProperty> simplePropertiesList = new Vector<AbstractProperty>();
        List propertiesList = PrototypeUtil.getAllPropertiesRecursive(group);
        for (int propIndex = 0; propIndex < propertiesList.size(); ++propIndex) {
            AbstractProperty ap = (AbstractProperty)propertiesList.get(propIndex);
            if (ap.getIsExpert() != 0) continue;
            simplePropertiesList.add(ap);
        }
        return simplePropertiesList;
    }

    public static List getAllExpertPropertiesRecursive(PropertyGroup group) throws MdException, RemoteException {
        Vector<AbstractProperty> expertPropertiesList = new Vector<AbstractProperty>();
        List propertiesList = PrototypeUtil.getAllPropertiesRecursive(group);
        for (int propIndex = 0; propIndex < propertiesList.size(); ++propIndex) {
            AbstractProperty ap = (AbstractProperty)propertiesList.get(propIndex);
            if (ap.getIsExpert() != 1) continue;
            expertPropertiesList.add(ap);
        }
        return expertPropertiesList;
    }

    public static Property createProperty(Property populatedProperty, MdObjectStore store, String reposID) throws MdException, RemoteException {
        Property property = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "Property", "Property", reposID.substring(9));
        property.setName(populatedProperty.getName(), 1);
        property.setPropertyName(populatedProperty.getPropertyName(), 1);
        property.setDelimiter(populatedProperty.getDelimiter(), 1);
        property.setUseValueOnly(populatedProperty.getUseValueOnly(), 1);
        property.setDefaultValue(populatedProperty.getDefaultValue(), 1);
        PropertyType type = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(store, null, "PropertyType", "PropertyType", reposID.substring(9));
        PropertyType populatedType = populatedProperty.getOwningType();
        type.setName(populatedType.getName(), 1);
        type.setSQLType(populatedType.getSQLType(), 1);
        if (populatedType.getStoredConfiguration() != null) {
            TextStore text = (TextStore)Workspace.getMdFactory().createComplexMetadataObject(store, null, "TextStore", "TextStore", reposID.substring(9));
            TextStore populatedText = (TextStore)populatedType.getStoredConfiguration();
            text.setName(populatedText.getName(), 1);
            text.setTextRole(populatedText.getTextRole(), 1);
            text.setTextType(populatedText.getTextType(), 1);
            text.setStoredText(populatedText.getStoredText(), 1);
            type.setStoredConfiguration((Text)text);
        }
        property.setOwningType(type);
        return property;
    }

    public static void deleteProperty(Property property) throws MdException, RemoteException {
        ArrayList<Object> lstObjects = new ArrayList<Object>(1);
        lstObjects.add(property);
        PropertyType type = property.getOwningType();
        if (type != null) {
            lstObjects.add(type);
            if (type.getStoredConfiguration() != null) {
                Text text = type.getStoredConfiguration();
                lstObjects.add(text);
            }
        }
        for (int index = 0; index < lstObjects.size(); ++index) {
            Root object = (Root)lstObjects.get(index);
            object.delete();
        }
    }

    public static boolean isIntegralType(AbstractProperty property) throws MdException, RemoteException {
        boolean bIsIntegralType = false;
        if (property instanceof AttributeProperty && (((AttributeProperty)property).getOwningType().getSQLType() == 4 || ((AttributeProperty)property).getOwningType().getSQLType() == -7)) {
            bIsIntegralType = true;
        }
        if (property instanceof Property && (((Property)property).getOwningType().getSQLType() == 4 || ((Property)property).getOwningType().getSQLType() == -7)) {
            bIsIntegralType = true;
        }
        return bIsIntegralType;
    }

    public static boolean isBooleanType(AbstractProperty property) throws MdException, RemoteException {
        boolean bIsBooleanType = false;
        if (property instanceof AttributeProperty && ((AttributeProperty)property).getOwningType().getSQLType() == -7) {
            bIsBooleanType = true;
        }
        if (property instanceof Property && ((Property)property).getOwningType().getSQLType() == -7) {
            bIsBooleanType = true;
        }
        return bIsBooleanType;
    }

    public static boolean newCustomizerFormatExists(PropertyGroup group) throws MdException, RemoteException {
        AssociationList lstProperties = group.getProperties();
        for (int propIndex = 0; propIndex < lstProperties.size(); ++propIndex) {
            Property property = (Property)lstProperties.get(propIndex);
            if (!property.getPropertyName().equalsIgnoreCase(CUSTOMIZER_PROPERTYNAME)) continue;
            return true;
        }
        return false;
    }
}

