/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.plugins.PluginLoader;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.visuals.util.XMLUtility;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PrototypeLocaleView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected String m_strContext;
    protected DualListSelector m_listSelector;
    protected JList m_sourceList;
    protected JList m_targetList;
    protected List m_availableLocaleList;
    protected List m_selectedLocaleList;
    private static final WAdminResource bundle = WAdminResource.getBundle(PrototypeLocaleView.class);

    public PrototypeLocaleView(String strContext) {
        super(bundle.getString("PrototypeLocaleView.WizardTitle.txt"));
        this.m_strContext = strContext;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        if (!bSaveToModel) {
            this.m_availableLocaleList = (List)parent.getWizardData("AvailableLocaleList");
            this.m_selectedLocaleList = (List)parent.getWizardData("SelectedLocaleList");
            if (this.m_selectedLocaleList != null && this.m_selectedLocaleList.contains("en_US")) {
                this.m_selectedLocaleList.remove("en_US");
            }
            if (this.m_availableLocaleList == null && this.m_selectedLocaleList == null) {
                this.m_availableLocaleList = new Vector();
                this.m_selectedLocaleList = new Vector();
                Locale clientLocale = Locale.getDefault();
                File fileLocation = new File(bundle.getString("PrototypeFileLocation.notrans"));
                String[] fileList = fileLocation.list();
                Vector<String> fileVector = new Vector<String>();
                for (int fileIndex = 0; fileList != null && fileIndex < fileList.length; ++fileIndex) {
                    fileVector.add(fileList[fileIndex]);
                }
                try {
                    Vector<URL> jarUrlList = new Vector<URL>();
                    Enumeration<URL> urls = ClassLoader.getSystemResources(bundle.getString("PrototypeFileLocation.notrans"));
                    while (urls.hasMoreElements()) {
                        URL url = urls.nextElement();
                        if (jarUrlList.contains(url)) continue;
                        jarUrlList.add(url);
                    }
                    Workspace.getWorkspace().getPluginLoader();
                    ClassLoader pluginLoader = PluginLoader.getClassLoader();
                    urls = pluginLoader instanceof URLClassLoader ? ((URLClassLoader)pluginLoader).findResources(bundle.getString("PrototypeFileLocation.notrans")) : ClassLoader.getSystemResources(bundle.getString("PrototypeFileLocation.notrans"));
                    while (urls.hasMoreElements()) {
                        URL url = urls.nextElement();
                        if (jarUrlList.contains(url)) continue;
                        jarUrlList.add(url);
                    }
                    for (int urlIndex = 0; urlIndex < jarUrlList.size(); ++urlIndex) {
                        URL url = (URL)jarUrlList.get(urlIndex);
                        if (url == null || !url.getProtocol().equalsIgnoreCase("jar")) continue;
                        String strURL = url.toString();
                        try {
                            url = new URL(strURL.substring(strURL.indexOf("jar:") + 4));
                            String strPath = url.getFile();
                            strPath = strPath.substring(0, strPath.indexOf(".jar") + 4);
                            try {
                                strPath = URLDecoder.decode(strPath, "UTF-8");
                                File jarFile = new File(strPath);
                                JarFile jar = new JarFile(jarFile);
                                Enumeration<JarEntry> e = jar.entries();
                                while (e.hasMoreElements()) {
                                    String strFileName;
                                    JarEntry je = e.nextElement();
                                    if (je.isDirectory() || !je.getName().startsWith(bundle.getString("PrototypeFileLocation.notrans")) || fileVector.contains(strFileName = je.getName().substring(je.getName().indexOf(bundle.getString("PrototypeFileLocation.notrans")) + bundle.getString("PrototypeFileLocation.notrans").length()))) continue;
                                    fileVector.add(strFileName);
                                }
                                continue;
                            }
                            catch (IOException exc) {
                                exc.printStackTrace();
                                continue;
                            }
                        }
                        catch (MalformedURLException exc) {
                            exc.printStackTrace();
                        }
                    }
                    fileList = new String[fileVector.size()];
                    fileList = fileVector.toArray(fileList);
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
                String strPrefix = "Prototypes_Index";
                String strExtension = ".xml";
                for (int fileIndex = 0; fileList != null && fileIndex < fileList.length; ++fileIndex) {
                    String strFile = fileList[fileIndex];
                    if (!strFile.startsWith(strPrefix) || !strFile.endsWith(strExtension)) continue;
                    String strSuffix = strFile.substring(strPrefix.length(), strFile.length() - strExtension.length());
                    strSuffix = strSuffix.length() > 0 ? strSuffix.substring(1) : "en_US";
                    Locale indexFileLocale = PrototypeUtil.getLocale(strSuffix);
                    if (indexFileLocale.equals(clientLocale)) {
                        if (this.m_selectedLocaleList.contains(strSuffix) || strSuffix.equals("en_US")) continue;
                        this.m_selectedLocaleList.add(strSuffix);
                        continue;
                    }
                    if (this.m_selectedLocaleList.contains(strSuffix) || strSuffix.equals("en_US")) continue;
                    this.m_availableLocaleList.add(strSuffix);
                }
            }
            DefaultListModel sourceModel = new DefaultListModel();
            for (int index = 0; index < this.m_availableLocaleList.size(); ++index) {
                sourceModel.add(index, this.m_availableLocaleList.get(index));
            }
            this.m_listSelector.setModel(sourceModel);
            DefaultListModel targetModel = new DefaultListModel();
            for (int index = 0; index < this.m_selectedLocaleList.size(); ++index) {
                targetModel.add(index, this.m_selectedLocaleList.get(index));
            }
            this.m_listSelector.setTargetModel(targetModel);
            this.m_listSelector.setSourceCellRenderer((ListCellRenderer)new SelectorListCellRenderer());
            this.m_listSelector.setTargetCellRenderer((ListCellRenderer)new SelectorListCellRenderer());
        }
        return true;
    }

    public boolean validateData() {
        return true;
    }

    public String createFinishString() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        String strFinish = "\n\n" + bundle.getString("PrototypeFinishView.LocalesTitle.txt") + "\n";
        List selectedLocaleList = (List)parent.getWizardData("SelectedLocaleList");
        for (int localeIndex = 0; localeIndex < selectedLocaleList.size(); ++localeIndex) {
            strFinish = strFinish + "\t" + PrototypeUtil.getLocale((String)selectedLocaleList.get(localeIndex)).getDisplayName(Locale.getDefault()) + "\n";
        }
        return strFinish;
    }

    public void onNext() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        ListModel sourceListModel = this.m_listSelector.getModel();
        Vector sourceList = new Vector(sourceListModel.getSize());
        for (int sourceIndex = 0; sourceIndex < sourceListModel.getSize(); ++sourceIndex) {
            sourceList.add(sourceListModel.getElementAt(sourceIndex));
        }
        ListModel targetListModel = this.m_listSelector.getTargetModel();
        Vector targetList = new Vector(targetListModel.getSize());
        for (int targetIndex = 0; targetIndex < targetListModel.getSize(); ++targetIndex) {
            targetList.add(targetListModel.getElementAt(targetIndex));
        }
        if (!targetList.contains("en_US")) {
            targetList.add("en_US");
        }
        parent.replaceWizardData("AvailableLocaleList", sourceList);
        parent.replaceWizardData("SelectedLocaleList", targetList);
        List xmlFileNameList = (List)parent.getWizardData("XMLFileNameList");
        Vector<String> localeXmlToAddList = new Vector<String>();
        Vector<String> localeList = new Vector<String>();
        for (int localeIndex = 0; localeIndex < targetList.size(); ++localeIndex) {
            String strLocale = (String)targetList.get(localeIndex);
            block6: for (int fileNameIndex = 0; fileNameIndex < xmlFileNameList.size(); ++fileNameIndex) {
                String strFileName = (String)xmlFileNameList.get(fileNameIndex);
                String strTemplate = "_Template";
                strFileName = strFileName.substring(0, strFileName.indexOf(strTemplate) + strTemplate.length());
                if (!strLocale.equals("en_US")) {
                    strFileName = strFileName + "_" + strLocale;
                }
                strFileName = strFileName + ".xml";
                while (true) {
                    try {
                        URL url = XMLUtility.urlFromFile((String)strFileName, (Locale)PrototypeUtil.getLocale(strLocale));
                        Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(url);
                        String strContents = Workspace.getMdFactory().getUtil().createStringForNode((Node)doc);
                        int reposIndex = strContents.lastIndexOf("_ReposID_");
                        String strXML = strContents.substring(0, reposIndex) + this.m_strContext + strContents.substring(reposIndex + 9);
                        localeXmlToAddList.add(strXML);
                        localeList.add(strLocale);
                        continue block6;
                    }
                    catch (IOException exc) {
                        if (!(exc instanceof FileNotFoundException)) continue block6;
                        if ((strFileName = strFileName.substring(0, strFileName.lastIndexOf(95))).indexOf(strTemplate) == -1) {
                            strFileName = strFileName + strTemplate + ".xml";
                            continue;
                        }
                        strFileName = strFileName + ".xml";
                        continue;
                    }
                    catch (MdException exc) {
                        if (exc.getCause() instanceof FileNotFoundException) {
                            localeXmlToAddList.add("");
                            localeList.add("");
                            continue block6;
                        }
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    break;
                }
            }
        }
        parent.replaceWizardData("XMLListLocale", localeXmlToAddList);
        parent.replaceWizardData("LocaleList", localeList);
    }

    public void onBack() {
        this.onNext();
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        parent.removeWizardData("XMLListLocale");
        parent.removeWizardData("LocaleList");
    }

    protected void _initialize() {
        this.m_listSelector = new DualListSelector();
        this.m_listSelector.setPreferredSize(new Dimension(315, 235));
        this.m_listSelector.setSourceLabel(bundle.getString("PrototypeLocaleView.SourceLabel.txt"));
        this.m_listSelector.setTargetLabel(bundle.getString("PrototypeLocaleView.TargetLabel.txt"));
        this.m_sourceList = (JList)this.m_listSelector.getSourceComponent();
        this.m_targetList = (JList)this.m_listSelector.getTargetComponent();
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_listSelector, gbc);
        this.add((Component)this.m_listSelector);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    public class SelectorListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof String) {
                this.setText(PrototypeUtil.getLocale((String)value).getDisplayName(Locale.getDefault()));
            }
            return comp;
        }
    }
}

