/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PrototypeFinishView
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected WATextArea m_titleText;
    protected WATextArea m_summaryText;
    protected JScrollPane m_summaryPane;
    private static final WAdminResource bundle = WAdminResource.getBundle(PrototypeFinishView.class);

    public PrototypeFinishView() {
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            ((WAStandardDialog)this.getTopLevelAncestor()).setCursor(Cursor.getPredefinedCursor(3));
            this.onCompletion();
            ((WAStandardDialog)this.getTopLevelAncestor()).setCursor(Cursor.getPredefinedCursor(0));
        } else {
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            this.m_summaryText.setText("");
            List list = (List)parent.getWizardData("XMLNameList");
            for (int i = 0; i < list.size(); ++i) {
                String strName = (String)list.get(i);
                this.m_summaryText.append(strName + "\n");
            }
        }
        return false;
    }

    public boolean validateData() {
        return true;
    }

    public void onCompletion() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        List xmlList = (List)parent.getWizardData("XMLList");
        for (int i = 0; i < xmlList.size(); ++i) {
            String strXML = (String)xmlList.get(i);
            try {
                Workspace.getMdFactory().getOMIUtil().DoRequest(strXML);
                continue;
            }
            catch (Exception exc) {
                String strMessage = exc.getMessage();
                if (!(exc instanceof MdException)) continue;
                MessageUtil.displayMessage((String)("Your prototype is not correctly or completely defined! \n" + strMessage), (int)0);
            }
        }
    }

    public void onNext() {
    }

    public void onBack() {
    }

    protected void _initialize() {
        this.setName(bundle.getString("PrototypeFinishView.TabName.txt"));
        this.m_titleText = new WATextArea(bundle.getString("PrototypeFinishView.WizardTitle.txt"));
        this.m_titleText.setEditable(false);
        this.m_titleText.setLineWrap(true);
        this.m_titleText.setWrapStyleWord(true);
        this.m_titleText.setBorder(null);
        this.m_titleText.setBackground(this.getBackground());
        this.m_summaryText = new WATextArea();
        this.m_summaryText.setEditable(false);
        this.m_summaryText.setBackground(this.getBackground());
        this.m_summaryPane = new JScrollPane((Component)this.m_summaryText, 20, 30);
        this.m_summaryPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_summaryPane.setPreferredSize(new Dimension(315, 200));
        this.m_summaryPane.setMinimumSize(new Dimension(315, 190));
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_titleText, gbc);
        this.add((Component)this.m_titleText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_summaryPane, gbc);
        this.add(this.m_summaryPane);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

