/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidAuthType;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidResourceSpec;
import com.sas.meta.SASOMI.ISecurityPackage.NotTrustedUser;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdRepositoryUtil;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.util.XMLUtil;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.OLAPSchemaAssignTab;
import com.sas.workspace.mgmt.visuals.OLAPSchemaFolderException;
import com.sas.workspace.mgmt.visuals.OLAPSchemaGeneralTab;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Dialog;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.ImageIcon;

public class OLAPSchemaWizard
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(OLAPSchemaWizard.class);
    private OLAPSchemaGeneralTab generalTab;
    private OLAPSchemaAssignTab assignTab;
    private WizardFinishTab finishTab;
    private static final String OLAPSCHEMA_PUBLICTYPE = "OLAPSchema";
    private static final int OLAPSCHEMA_MAJOR = 1;
    private static final int OLAPSCHEMA_MINOR = 0;
    private static final int OLAPSCHEMA_MICRO = 0;

    public OLAPSchemaWizard(Frame frame, String title, String reposId, MdStore store, boolean allowAssignTab) {
        super(frame, title, true);
        if (store == null) {
            store = (MdStore)this.getWizardData("OBJECTSTORE");
        }
        this.generalTab = new OLAPSchemaGeneralTab(store, reposId);
        if (allowAssignTab) {
            this.assignTab = new OLAPSchemaAssignTab(store, reposId);
        }
        this.finishTab = new WizardFinishTab();
        this.finishTab.setHelpProduct("olapschemawiz");
        this.finishTab.setHelpTopic("os_finish");
        this.setupWizard();
    }

    public OLAPSchemaWizard(Frame frame, String title, String reposId, MdStore store) {
        this(frame, title, reposId, store, false);
    }

    public OLAPSchemaWizard(Frame frame, String title, String reposId) {
        this(frame, title, reposId, null, false);
    }

    public OLAPSchemaWizard(Dialog dialog, String title, String reposId) {
        this(dialog, title, reposId, null, false);
    }

    public OLAPSchemaWizard(Dialog dialog, String title, String reposId, MdStore store) {
        this(dialog, title, reposId, store, false);
    }

    public OLAPSchemaWizard(Dialog dialog, String title, String reposId, MdStore store, boolean allowAssignTab) {
        super(dialog, title, true);
        if (store == null) {
            store = (MdStore)this.getWizardData("OBJECTSTORE");
        }
        this.generalTab = new OLAPSchemaGeneralTab(store, reposId);
        if (allowAssignTab) {
            this.assignTab = new OLAPSchemaAssignTab(store, reposId);
        }
        this.finishTab = new WizardFinishTab();
        this.finishTab.setHelpProduct("olapschemawiz");
        this.finishTab.setHelpTopic("os_finish");
        this.setupWizard();
    }

    private void setupWizard() {
        this.setCanFinishEarly(false);
        ImageIcon image = bundle.getImageIcon("Common.NameDescriptionTab.image");
        ImageIcon image1 = bundle.getImageIcon("Common.PropertiesTab.image");
        ImageIcon image2 = bundle.getImageIcon("Common.FinishTab.image");
        String imagename = bundle.getString("Common.NameDescriptionTab.image");
        String imagename1 = bundle.getString("Common.PropertiesTab.image");
        String imagename2 = bundle.getString("Common.FinishTab.image");
        this.addTab(bundle.getString("Common.General.txt"), "tab1", (WAPropertyTab)this.generalTab, imagename, image, false);
        if (this.assignTab != null) {
            this.addTab(bundle.getString("OLAPSchemaWizard.Assign.top.txt"), "tab2", (WAPropertyTab)this.assignTab, imagename1, image1, false);
        }
        this.addTab(bundle.getString("OLAPSchemaFinishTab.Title.txt"), "tab3", (WAPropertyTab)this.finishTab, imagename2, image2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setOLAPSchemaDefaults(OLAPSchema schema) throws RemoteException, MdException, OLAPSchemaFolderException {
        String type;
        AssociationList trees;
        UsageVersion version;
        double omrVersion;
        String publictype = schema.getPublicType();
        if (publictype == null || Strings.trimmedLength((String)publictype) == 0) {
            schema.setPublicType(OLAPSCHEMA_PUBLICTYPE);
        }
        if ((omrVersion = schema.getUsageVersion()) < (version = new UsageVersion(1, 0, 0)).encode()) {
            schema.setUsageVersion(version.encode());
        }
        if (!(trees = schema.getTrees()).isEmpty()) return;
        MdObjectStore store = (MdObjectStore)schema.getObjectStore();
        String shortReposID = schema.getRepositoryID();
        MdFactory factory = Workspace.getMdFactory();
        MdRepositoryUtil repositoryUtil = factory.getRepositoryUtil();
        MdOMIUtil omiUtil = factory.getOMIUtil();
        String reposID = omiUtil.getReposIdFromMetadataObject((CMetadata)schema);
        Tree schemaParentFolder = null;
        if (repositoryUtil.isFoundationType(reposID) || repositoryUtil.isProjectType(reposID)) {
            String options;
            int flags;
            List folders;
            String foundationId = reposID;
            if (repositoryUtil.isProjectType(reposID)) {
                foundationId = omiUtil.getFoundationReposID();
            }
            if ((folders = omiUtil.getMetadataObjects(foundationId, type = "Tree", flags = 0x10000180, options = "<XMLSELECT search=\"*[@Name='Shared Data'][SoftwareComponents/*[@Name='BIP Service']]\"/>")).isEmpty()) {
                throw new OLAPSchemaFolderException(bundle.getString("OLAPSchema.FolderNotFound.txt"));
            }
            schemaParentFolder = (Tree)factory.createComplexMetadataObject(store, (CMetadata)folders.get(0));
        } else if (repositoryUtil.isCustomType(reposID)) {
            type = "SoftwareComponent";
            int flags = 0x10000180;
            String options = "<XMLSELECT search=\"@Name='BIP Service'\"/>";
            List services = omiUtil.getMetadataObjects(reposID, type, flags, options);
            if (services.isEmpty()) throw new OLAPSchemaFolderException(bundle.getString("OLAPSchema.FolderNotFound.txt"));
            SoftwareComponent bipService = (SoftwareComponent)factory.createComplexMetadataObject(store, (CMetadata)services.get(0));
            AssociationList softwareTrees = bipService.getSoftwareTrees(true);
            if (softwareTrees.isEmpty()) throw new OLAPSchemaFolderException(bundle.getString("OLAPSchema.FolderNotFound.txt"));
            schemaParentFolder = (Tree)softwareTrees.get(0);
        }
        Tree schemaFolder = (Tree)factory.createComplexMetadataObject(store, schema.getName(), "Tree", shortReposID);
        schemaFolder.setTreeType("BIP Folder");
        schemaFolder.setPublicType("Folder");
        UsageVersion folderVersion = new UsageVersion(1, 0);
        schemaFolder.setUsageVersion(folderVersion.encode());
        trees.add((Object)schemaFolder);
        if (schemaParentFolder == null) return;
        boolean nameOK = false;
        int count = 1;
        int flags = 128;
        String parentName = schemaParentFolder.getName();
        do {
            String resource = "<GetMetadataObjects><Reposid>" + reposID + "</Reposid><Type>" + "Tree" + "</Type><Objects/><NS>SAS</NS><Flags>" + flags + "</Flags><Options>";
            String normalizedName = XMLUtil.normalize((String)schemaFolder.getName());
            String normalizedParent = XMLUtil.normalize((String)parentName);
            String xmlselect = "<XMLSELECT search=\"Tree[@Name='" + normalizedName + "'][ParentTree/*[@Name='" + normalizedParent + "']]\"/>";
            if (OLAPSchemaWizard.getNumberOfItems(resource = resource + xmlselect + "<Templates></Templates></Options></GetMetadataObjects>") == 0) {
                nameOK = true;
                continue;
            }
            String name = schema.getName() + String.valueOf(count);
            ++count;
            schemaFolder.setName(name);
        } while (!nameOK);
        schemaFolder.setParentTree(schemaParentFolder);
    }

    private static int getNumberOfItems(String template) {
        int numberOfItems = 0;
        try {
            VariableArray2dOfStringHolder returnAuths = new VariableArray2dOfStringHolder();
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            ISecurity_1_1 security = Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle);
            security.GetAuthorizations("getCountNoSecurity", "", template, "", returnAuths);
            numberOfItems = Integer.valueOf(returnAuths.value[0][1]);
            Workspace.getMdFactory().getConnection().closeISecurityConnection((ISecurity)security);
        }
        catch (RemoteException error) {
            numberOfItems = 0;
        }
        catch (MdException error) {
            numberOfItems = 0;
        }
        catch (InvalidAuthType error) {
            numberOfItems = 0;
        }
        catch (InvalidCredHandle error) {
            numberOfItems = 0;
        }
        catch (NotTrustedUser error) {
            numberOfItems = 0;
        }
        catch (GenericError error) {
            numberOfItems = 0;
        }
        catch (InvalidResourceSpec error) {
            numberOfItems = 0;
        }
        return numberOfItems;
    }
}

