/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;

public class OLAPSchemaAssignTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected OLAPSchema m_schema;
    protected WAWizardDialog m_parent;
    protected MdStore m_store;
    protected String m_reposid;
    protected DualListSelector m_list;
    protected CollectionToListModelAdapter m_available;
    protected CollectionToListModelAdapter m_selected;
    private boolean initialized;
    protected Vector m_serversList;
    private static final WAdminResource bundle = WAdminResource.getBundle(OLAPSchemaAssignTab.class);

    public OLAPSchemaAssignTab(CMetadata schema, String reposid) {
        super(bundle.getString("OLAPSchemaAssignTab.instruct.txt"));
        this.m_schema = (OLAPSchema)schema;
        try {
            this.m_store = this.m_schema.getObjectStore();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            this.m_store = null;
        }
        this.m_reposid = reposid;
        this._initialize();
        this._layoutWidgets();
    }

    public OLAPSchemaAssignTab(MdStore store, String reposid) {
        super(bundle.getString("OLAPSchemaAssignTab.instruct.txt"));
        this.m_schema = null;
        this.m_store = store;
        this.m_reposid = reposid;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            if (this.m_schema == null) {
                this.m_schema = (OLAPSchema)this.m_parent.getWizardData("MASTEROBJECT");
            }
            try {
                this.m_schema.touch();
                AssociationList servers = this.m_schema.getDeployedComponents();
                servers.removeAllElements();
                int size = this.m_selected.getSize();
                for (int i = 0; i < size; ++i) {
                    ServerItem serverItem = (ServerItem)this.m_selected.getElementAt(i);
                    DeployedComponent server = (DeployedComponent)serverItem.metadataObject;
                    AssociationList datapkgs = server.getDataPackages();
                    boolean found = false;
                    for (int j = 0; j < datapkgs.size() && !found; ++j) {
                        CMetadata obj = (CMetadata)datapkgs.get(j);
                        if (!(obj instanceof OLAPSchema)) continue;
                        datapkgs.remove((Object)obj);
                        found = true;
                    }
                    servers.addElement((Object)server);
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        } else if (!this.initialized) {
            this.initialized = true;
            Container temp = this.getTopLevelAncestor();
            if (temp instanceof WAWizardDialog) {
                this.m_parent = (WAWizardDialog)temp;
            }
            if (this.m_store == null & this.m_parent != null) {
                this.m_store = (MdObjectStore)this.m_parent.getWizardData("OBJECTSTORE");
            }
            String strSelect = "<XMLSELECT search=\"*[UsingComponents/*[@CLASSIDENTIFIER='f3f46472-1e31-11d5-87c2-00c04f38f9f6']]\"/>";
            int flags = 8604;
            try {
                this.m_serversList = (Vector)Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_store, this.m_reposid, "ServerContext", flags, strSelect);
                AssociationList servers = null;
                if (this.m_schema != null) {
                    servers = this.m_schema.getDeployedComponents(true);
                }
                TreeSet<ServerItem> availableSet = new TreeSet<ServerItem>();
                TreeSet<ServerItem> selectedSet = new TreeSet<ServerItem>();
                for (int i = 0; i < this.m_serversList.size(); ++i) {
                    DeployedComponent deployedComponent = (DeployedComponent)this.m_serversList.get(i);
                    if (servers != null) {
                        if (!servers.contains((Object)deployedComponent)) {
                            availableSet.add(new ServerItem((CMetadata)deployedComponent));
                            continue;
                        }
                        selectedSet.add(new ServerItem((CMetadata)deployedComponent));
                        continue;
                    }
                    availableSet.add(new ServerItem((CMetadata)deployedComponent));
                }
                this.m_available.setModel(availableSet);
                this.m_selected.setModel(selectedSet);
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return false;
    }

    public String createFinishString() {
        String strFinish = "";
        if (this.m_selected.getSize() == 0) {
            return strFinish;
        }
        strFinish = strFinish + bundle.getString("OLAPSchemaAssignTab.FinishString.txt");
        for (int i = 0; i < this.m_selected.getSize(); ++i) {
            ServerItem serverItem = (ServerItem)this.m_selected.getElementAt(i);
            strFinish = strFinish + serverItem.toString();
            strFinish = strFinish + (i < this.m_selected.getSize() - 1 ? "\n\t" : "\n\n");
        }
        return strFinish;
    }

    public boolean validateData() {
        int retValue;
        if (this.m_schema == null) {
            this.m_schema = (OLAPSchema)this.m_parent.getWizardData("MASTEROBJECT");
        }
        ArrayList<DeployedComponent> hasSchema = new ArrayList<DeployedComponent>();
        int size = this.m_selected.getSize();
        for (int i = 0; i < size; ++i) {
            ServerItem serverItem = (ServerItem)this.m_selected.getElementAt(i);
            DeployedComponent server = (DeployedComponent)serverItem.metadataObject;
            AssociationList datapkgs = null;
            try {
                datapkgs = server.getDataPackages();
                boolean found = false;
                for (int j = 0; j < datapkgs.size() && !found; ++j) {
                    CMetadata obj = (CMetadata)datapkgs.get(j);
                    if (!(obj instanceof OLAPSchema)) continue;
                    found = true;
                    OLAPSchema temp = (OLAPSchema)obj;
                    if (temp.equals(this.m_schema)) continue;
                    hasSchema.add(server);
                }
                continue;
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                continue;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return hasSchema.size() <= 0 || (retValue = MessageUtil.displayListMessage((String)bundle.getString("OLAPSchemaConfirmPanel.instructions.txt"), hasSchema, (String)bundle.getString("OLAPSchemaConfirmDialog.title.txt"), (int)1, (int)2)) != 2;
    }

    protected void _initialize() {
        JLabel label;
        int mnemonic;
        this.setHelpProduct("olapschemawiz");
        this.setHelpTopic("os_serverassignment");
        this.m_available = new CollectionToListModelAdapter();
        this.m_selected = new CollectionToListModelAdapter();
        this.m_list = new DualListSelector();
        this.m_list.setModel((ListModel)this.m_available);
        this.m_list.setTargetModel((ListModel)this.m_selected);
        this.m_list.setToolTipText(bundle.getString("OLAPSchemaAssignTab.Tooltip.ServerList.txt"));
        this.m_list.setName("OLAPSchemaServerList");
        String source = bundle.getString("OLAPSchemaAssignTab.Title.Available.txt");
        String sourceText = Util.getLabelWithoutMnemonic((String)source);
        this.m_list.setSourceLabel(sourceText);
        int index = Util.getDisplayedMnemonicIndex((String)source);
        if (index > -1) {
            mnemonic = Util.getDisplayedMnemonic((String)source);
            label = (JLabel)this.m_list.getSourceLabelComponent();
            label.setDisplayedMnemonic(mnemonic);
        }
        source = bundle.getString("OLAPSchemaAssignTab.Title.Selected.txt");
        sourceText = Util.getLabelWithoutMnemonic((String)source);
        this.m_list.setTargetLabel(sourceText);
        index = Util.getDisplayedMnemonicIndex((String)source);
        if (index > -1) {
            mnemonic = Util.getDisplayedMnemonic((String)source);
            label = (JLabel)this.m_list.getTargetLabelComponent();
            label.setDisplayedMnemonic(mnemonic);
        }
        this.m_list.setTargetControlsVisible(false);
        this.m_list.setTransferAllControlsVisible(true);
        this.m_list.setAlternatingMultipleButtonStyle(true);
        JComponent targetComp = this.m_list.getTargetComponent();
        JList target = null;
        if (targetComp instanceof JList) {
            target = (JList)targetComp;
            this.listenForDataChangesTo(target);
        }
    }

    protected void _layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.m_list.setPreferredSize(new Dimension(300, 200));
        this.add((Component)this.m_list, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    class ServerItem
    implements Comparable {
        CMetadata metadataObject;

        public ServerItem(CMetadata server) {
            this.metadataObject = server;
        }

        public int compareTo(Object o) {
            return this.toString().compareToIgnoreCase(o.toString());
        }

        public String toString() {
            String name = "";
            try {
                name = this.metadataObject.getName();
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            return name;
        }
    }
}

