/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASCatalog;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.PropertiesPropertyView;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LibraryPropertyView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected Library m_library;
    protected Prototype m_libraryPrototype;
    protected int m_type;
    protected JPanel m_view;
    protected Tree m_tree = null;
    protected DatabaseSchema m_dbSchema;
    protected Directory m_directory;
    protected OLAPSchema m_olapSchema;
    protected SASCatalog m_sasCatalog;
    protected SASLibrary m_sasLibrary;
    protected RelationalSchema m_relSchema;
    private boolean m_bPropertiesPropertyViewCreated = false;
    private static final WAdminResource bundle = WAdminResource.getBundle(LibraryPropertyView.class);

    public LibraryPropertyView(Library library, int type) {
        super(bundle.getString("LibraryPropertyView.WizardTitle.txt"));
        this.m_library = library;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets(false);
    }

    public LibraryPropertyView(Library library, int type, Tree tree) {
        this(library, type);
        this.m_tree = tree;
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            this.moveDataToStore();
        } else {
            this.populateStore();
            this.moveDataToView();
        }
        return false;
    }

    public void moveDataToStore() {
        if (this.m_type == 1) {
            this._setViewProperties();
        }
    }

    public void populateStore() {
        if (this.m_type == 0) {
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            this.m_libraryPrototype = (Prototype)parent.getWizardData("DeployedDataPackagePrototype");
        }
        if (this.m_type == 1) {
            try {
                if (this.m_libraryPrototype == null) {
                    this.m_libraryPrototype = this.m_library.getDeployedDataPackagePrototype(this.getTopLevelAncestor());
                }
            }
            catch (MdException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
    }

    public void moveDataToView() {
        this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
        if (this.m_type == 0) {
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            this.m_libraryPrototype = (Prototype)parent.getWizardData("DeployedDataPackagePrototype");
        }
        if (this.m_type == 1) {
            try {
                if (this.m_libraryPrototype == null) {
                    this.m_libraryPrototype = this.m_library.getDeployedDataPackagePrototype(this.getTopLevelAncestor(), true);
                }
            }
            catch (MdException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
        this.removeAll();
        this._layoutWidgets(true);
        this.revalidate();
        if (this.m_view instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_view)).doDataExchange(false);
        }
        this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean validateData() {
        if (this.m_view instanceof PropertiesPropertyView) {
            return ((PropertiesPropertyView)((Object)this.m_view)).validateData();
        }
        return true;
    }

    protected void _setViewProperties() {
        try {
            if (this.m_view instanceof PropertiesPropertyView) {
                ((PropertiesPropertyView)((Object)this.m_view)).setViewProperties();
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void onNext() {
        try {
            if (this.m_view instanceof PropertiesPropertyView) {
                ((PropertiesPropertyView)((Object)this.m_view)).onNext();
            }
            this.m_library.getDeployedDataPackage().setUsingPrototype((Root)this.m_libraryPrototype);
            if (((SASLibrary)this.m_library.getDeployedDataPackage()).getIsDBMSLibname() == 1 && !((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().equalsIgnoreCase("SASIOIME")) {
                this.setConditionState("ISDBMSLIBNAME");
            } else {
                this.setConditionState("NEXT");
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void onBack() {
        if (this.m_view instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_view)).onBack();
        }
    }

    public String createFinishString() {
        String strFinish = "";
        if (this.m_view instanceof PropertiesPropertyView) {
            strFinish = strFinish + ((PropertiesPropertyView)((Object)this.m_view)).createFinishString();
        }
        return strFinish;
    }

    public Component getDefaultFocusComponent() {
        Component comp = null;
        if (this.m_view instanceof PropertiesPropertyView) {
            comp = ((PropertiesPropertyView)((Object)this.m_view)).getDefaultFocusComponent();
        }
        return comp;
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_view instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_view)).saveSettingsAndCleanUp();
        }
    }

    protected void _initialize() {
        this.setPreferredSize(new Dimension(690, 430));
        this.setName(bundle.getString("LibraryPropertyView.TabName.txt"));
    }

    protected void _layoutWidgets(boolean bShowErrorMessage) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        PropertyGroup group = null;
        try {
            if (this.m_libraryPrototype != null) {
                group = this.m_libraryPrototype.getPrimaryPropertyGroup();
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        if (group != null) {
            Hashtable propertiesTable = null;
            if (this.m_type == 0) {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                propertiesTable = (Hashtable)parent.getWizardData("Properties");
            }
            if (!this.m_bPropertiesPropertyViewCreated) {
                this.m_view = new PropertiesPropertyView((Root)this.m_library.getDeployedDataPackage(), group, this.m_type, propertiesTable, this.m_libraryPrototype);
                this.m_bPropertiesPropertyViewCreated = true;
            } else if (this.m_view instanceof PropertiesPropertyView && !((PropertiesPropertyView)((Object)this.m_view)).getMetadataObject().equals(this.m_library.getDeployedDataPackage())) {
                this.m_view = new PropertiesPropertyView((Root)this.m_library.getDeployedDataPackage(), group, this.m_type, propertiesTable, this.m_libraryPrototype);
            }
            try {
                AssociationList extensionList = group.getExtensions();
                for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                    Extension extension = (Extension)extensionList.get(extIndex);
                    if (extension.getName().equalsIgnoreCase("HelpSet")) {
                        String strHelpSet = extension.getValue();
                        this.setHelpProduct(strHelpSet);
                    }
                    if (!extension.getName().equalsIgnoreCase("HelpTopicSimple")) continue;
                    String strHelpTopic = extension.getValue();
                    this.setHelpTopic(strHelpTopic);
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            ((PropertiesPropertyView)((Object)this.m_view)).setMinimumViewHeight(300);
        } else {
            this.m_view = new JPanel();
            this.m_view.setPreferredSize(new Dimension(475, 300));
            if (bShowErrorMessage) {
                this.m_view.add(new JLabel(bundle.getString("Common.UnableToShowProperties.txt")));
            }
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_view, gbc);
        this.add(this.m_view);
    }
}

