/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.meta.SASOMI.ISecurity;
import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SecurityUtil;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.mgmt.visuals.ConnectionWizard;
import com.sas.workspace.mgmt.visuals.DBSchema;
import com.sas.workspace.mgmt.visuals.FolderUtil;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GeneralPropertyView
extends WsDescriptionWizardTab {
    protected Server m_server;
    protected Connection m_connection;
    protected Library m_library;
    protected DBSchema m_schema;
    protected int m_type;
    protected SASClientConnection m_sasConnection;
    protected TCPIPConnection m_tcpConnection;
    protected COMConnection m_comConnection;
    protected GeneralPanel m_generalPanel;
    protected Prototype m_prototype;
    protected List m_serverList;
    protected List m_connectionList;
    protected List m_schemaList;
    protected String currentNameValue;
    protected Tree currentTreeValue;
    static final WAdminResource bundle = WAdminResource.getBundle(GeneralPropertyView.class);
    private static final long serialVersionUID = -8528056346619581218L;

    public GeneralPropertyView(Server server, int type) {
        this.m_server = server;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets();
    }

    public GeneralPropertyView(Connection connection, int type) {
        super(bundle.getString("GeneralPropertyView.ConnectionWizardTitle.fmt.txt"));
        this.m_connection = connection;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets();
    }

    public GeneralPropertyView(Library library, int type) {
        this.m_library = library;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets();
    }

    public GeneralPropertyView(DBSchema schema, int type) {
        this.m_schema = schema;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        try {
            if (bSaveToModel) {
                if (this.m_type == 1) {
                    String strRootDescValue;
                    String strRootNameValue;
                    String strComponentNameValue = this.m_generalPanel.getNameComponent().getText().trim();
                    String strComponentDescValue = this.m_generalPanel.getDescriptionComponent().getText().trim();
                    Tree componentTreeValue = this.m_generalPanel.getOwningTree();
                    if (this.m_server != null) {
                        strRootNameValue = this.m_server.getDeployedComponent().getName();
                        strRootDescValue = this.m_server.getDeployedComponent().getDesc();
                        if (!strComponentNameValue.equals(strRootNameValue)) {
                            this.m_server.getDeployedComponent().setName(strComponentNameValue);
                        }
                        if (!strComponentDescValue.equals(strRootDescValue)) {
                            this.m_server.getDeployedComponent().setDesc(strComponentDescValue);
                        }
                    }
                    if (this.m_connection != null) {
                        strRootNameValue = this.m_connection.getName();
                        strRootDescValue = this.m_connection.getDesc();
                        if (!strComponentNameValue.equals(strRootNameValue)) {
                            this.m_connection.setName(strComponentNameValue);
                        }
                        if (!strComponentDescValue.equals(strRootDescValue)) {
                            this.m_connection.setDesc(strComponentDescValue);
                        }
                    }
                    if (this.m_library != null) {
                        try {
                            strRootNameValue = this.m_library.getDeployedDataPackage().getName();
                            strRootDescValue = this.m_library.getDeployedDataPackage().getDesc();
                            Tree rootTreeValue = null;
                            if (this.m_library.getDeployedDataPackage().getTrees().size() > 0) {
                                rootTreeValue = (Tree)this.m_library.getDeployedDataPackage().getTrees().get(0);
                            }
                            if (!strComponentNameValue.equals(strRootNameValue)) {
                                this.m_library.getDeployedDataPackage().setName(strComponentNameValue);
                            }
                            if (!strComponentDescValue.equals(strRootDescValue)) {
                                this.m_library.getDeployedDataPackage().setDesc(strComponentDescValue);
                            }
                            if (rootTreeValue == null || componentTreeValue != null && !componentTreeValue.getFQID().equals(rootTreeValue.getFQID())) {
                                this.m_library.getDeployedDataPackage().getTrees().removeAllElements();
                                this.m_library.getDeployedDataPackage().getTrees().add((Object)componentTreeValue);
                            }
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        }
                        catch (RemoteException rex) {
                            String msg = rex.getLocalizedMessage();
                            Workspace.getDefaultLogger().error((Object)msg);
                            MessageUtil.displayMessage((String)msg, (int)0);
                        }
                    }
                    if (this.m_schema != null) {
                        strRootNameValue = this.m_schema.getSchema().getName();
                        strRootDescValue = this.m_schema.getSchema().getDesc();
                        if (!strComponentNameValue.equals(strRootNameValue)) {
                            this.m_schema.getSchema().setName(strComponentNameValue);
                        }
                        if (!strComponentDescValue.equals(strRootDescValue)) {
                            this.m_schema.getSchema().setDesc(strComponentDescValue);
                        }
                    }
                }
            } else {
                WAStandardDialog parent = (WAStandardDialog)this.getTopLevelAncestor();
                if (this.m_server != null) {
                    try {
                        int flags = 8472;
                        this.m_serverList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_server.getStore(), this.m_server.getContext(), "ServerComponent", flags, "");
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                }
                if (parent instanceof ConnectionWizard) {
                    try {
                        int flags = 8472;
                        ServerComponent serverComponent = (ServerComponent)((WAWizardDialog)parent).getWizardData("DeployedComponent");
                        Server server = (Server)((WAWizardDialog)parent).getWizardData("Server");
                        String strSelect = "<XMLSELECT search=\"*[Source/*[@Id='" + serverComponent.getFQID() + "']]\" />";
                        this.m_connection = (Connection)((WAWizardDialog)parent).getWizardData("Connection");
                        this.m_connectionList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)server.getStore(), server.getContext(), "Connection", flags, strSelect);
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                    this.setHelpProduct("newserver");
                    this.setHelpTopic("connwiz_1");
                } else if (this.m_connection != null) {
                    try {
                        ServerComponent serverComponent = (ServerComponent)this.m_connection.getSource();
                        String strSelect = "<XMLSELECT search=\"*[Source/*[@Id='" + serverComponent.getFQID() + "']]\" />";
                        int flags = 8472;
                        this.m_connectionList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(serverComponent.getObjectStore(), "A0000001." + serverComponent.getFQID().substring(0, 8), "Connection", flags, strSelect);
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                }
                if (this.m_schema != null) {
                    try {
                        int flags = 8456;
                        this.m_schemaList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_schema.getStore(), this.m_schema.getContext(), "DatabaseSchema", flags, "");
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                }
                if (this.m_type == 0) {
                    try {
                        if (this.m_server != null) {
                            this.m_prototype = this.m_server.getDeployedComponent() instanceof ServerContext ? (Prototype)((WAWizardDialog)parent).getWizardData("ServerContextPrototype") : (Prototype)((WAWizardDialog)parent).getWizardData("DeployedComponentPrototype");
                            if (this.m_prototype != null) {
                                this.setDescription(bundle.formatString("GeneralPropertyView.WizardTitle.Server.fmt.txt", (Object)PrototypeUtil.getDisplayString(this.m_prototype.getName(), this.m_prototype)));
                            }
                        } else if (this.m_library != null) {
                            this.m_prototype = (Prototype)((WAWizardDialog)parent).getWizardData("DeployedDataPackagePrototype");
                            if (this.m_prototype != null) {
                                this.setDescription(bundle.formatString("GeneralPropertyView.WizardTitle.Library.fmt.txt", (Object)PrototypeUtil.getDisplayString(this.m_prototype.getName(), this.m_prototype)));
                            }
                        } else if (this.m_schema != null) {
                            this.m_prototype = (Prototype)((WAWizardDialog)parent).getWizardData("DatabaseSchemaPrototype");
                            if (this.m_prototype != null) {
                                this.setDescription(bundle.formatString("GeneralPropertyView.WizardTitle.Schema.fmt.txt", (Object)PrototypeUtil.getDisplayString(this.m_prototype.getName(), this.m_prototype)));
                            }
                        }
                        String strTemplate = bundle.getString("Prototype.Template.All.notrans");
                        int flags = 268;
                        if (this.m_prototype != null) {
                            this.m_prototype = (Prototype)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_prototype, new Vector(), new Vector(), strTemplate, flags);
                        }
                        if (this.m_connection != null) {
                            this.m_prototype = (Prototype)((WAWizardDialog)parent).getWizardData("ConnectionPrototype");
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                }
                if (this.m_type == 1) {
                    if (this.m_server != null) {
                        this.m_generalPanel.getNameComponent().setText(this.m_server.getDeployedComponent().getName());
                        this.m_generalPanel.getDescriptionComponent().setText(this.m_server.getDeployedComponent().getDesc());
                    }
                    if (this.m_connection != null) {
                        this.m_generalPanel.getNameComponent().setText(this.m_connection.getName());
                        this.m_generalPanel.getDescriptionComponent().setText(this.m_connection.getDesc());
                    }
                    if (this.m_library != null) {
                        this.m_generalPanel.getNameComponent().setText(this.m_library.getDeployedDataPackage().getName());
                        this.m_generalPanel.getDescriptionComponent().setText(this.m_library.getDeployedDataPackage().getDesc());
                        this.currentNameValue = this.m_generalPanel.getNameComponent().getText().trim();
                        this.currentTreeValue = this.m_generalPanel.getOwningTree();
                    }
                    if (this.m_schema != null) {
                        this.m_generalPanel.getNameComponent().setText(this.m_schema.getSchema().getName());
                        this.m_generalPanel.getDescriptionComponent().setText(this.m_schema.getSchema().getDesc());
                    }
                }
            }
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public boolean validateData() {
        try {
            boolean bValidated = true;
            Container parent = this.getTopLevelAncestor();
            String name = this.m_generalPanel.getNameComponent().getText().trim();
            if (name.length() == 0) {
                JOptionPane.showMessageDialog(parent, bundle.getString("GeneralPropertyView.NameFieldRequired.txt"), bundle.getString("Common.RequiredField.txt"), 0);
                bValidated = false;
            } else if (!WsMetadataNameUtil.isNameValid((String)name)) {
                bValidated = false;
            } else if (this.m_server != null) {
                for (int i = 0; i < this.m_serverList.size(); ++i) {
                    DeployedComponent dc = (DeployedComponent)this.m_serverList.get(i);
                    if (this.m_type == 1 && dc.getName().equalsIgnoreCase(this.m_server.getDeployedComponent().getName()) || !dc.getName().equalsIgnoreCase(this.m_generalPanel.getNameComponent().getText().trim()) && (this.m_type != 0 || !this.isTableServerPrototype() || !dc.getName().equalsIgnoreCase(bundle.formatString("ServerWizard.LogicalFederationName.fmt.txt", (Object)this.m_generalPanel.getNameComponent().getText().trim())) && !dc.getName().equalsIgnoreCase(bundle.formatString("ServerWizard.FederationServerName.fmt.txt", (Object)this.m_generalPanel.getNameComponent().getText().trim())))) continue;
                    JOptionPane.showMessageDialog(parent, bundle.getString("GeneralPropertyView.NameExistsError.Server.txt"), bundle.getString("Common.Error.txt"), 0);
                    bValidated = false;
                    break;
                }
            } else if (this.m_connection != null) {
                for (int i = 0; i < this.m_connectionList.size(); ++i) {
                    Connection conn = (Connection)this.m_connectionList.get(i);
                    if (this.m_type == 1 && conn.getName().equalsIgnoreCase(this.m_connection.getName()) || !conn.getName().equalsIgnoreCase(this.m_generalPanel.getNameComponent().getText().trim())) continue;
                    JOptionPane.showMessageDialog(parent, bundle.getString("GeneralPropertyView.NameExistsError.Connection.txt"), bundle.getString("Common.Error.txt"), 0);
                    bValidated = false;
                    break;
                }
            } else if (this.m_library != null) {
                String libname;
                Tree tree = this.m_generalPanel.getOwningTree();
                if (tree == null) {
                    MessageUtil.displayMessage((String)bundle.getString("GeneralPropertyView.LocationFieldRequired.txt"), (String)bundle.getString("Common.RequiredField.txt"), (int)0);
                    bValidated = false;
                }
                if (!(!bValidated || (libname = this.m_generalPanel.getNameComponent().getText().trim()).equalsIgnoreCase(this.currentNameValue) && this.currentTreeValue != null && tree.getFQID().equals(this.currentTreeValue.getFQID()) || libname.equals(this.currentNameValue) && this.currentTreeValue != null && tree.getFQID().equals(this.currentTreeValue.getFQID()))) {
                    try {
                        if (!(WsRepositoryUtil.getRepositoryType((MdFactory)Workspace.getMdFactory(), (String)this.m_library.getContext()).equalsIgnoreCase("Project") || this.currentTreeValue != null && tree.getFQID().equals(this.currentTreeValue.getFQID()))) {
                            ISecurity iSec = SecurityUtil.makeISecurityConnection((MdFactory)Workspace.getMdFactory());
                            if (!SecurityUtil.isFolderWriteAuthorized((ISecurity)iSec, (String)tree.getFQID())) {
                                String locationDisplayName = FolderUtil.getDisplayPathFromTree(tree);
                                MessageUtil.displayMessage((String)bundle.formatString("GeneralPropertyView.NoWriteAccessToLocationError.txt", (Object)locationDisplayName), (String)bundle.getString("Common.Error.txt"), (int)0);
                                bValidated = false;
                            }
                            if (iSec != null) {
                                SecurityUtil.closeISecurityConnection((MdFactory)Workspace.getMdFactory(), (ISecurity)iSec);
                            }
                        }
                        if (bValidated && !Library.validateLibraryName(this.m_library.getDeployedDataPackage().getId(), libname, tree, (List)this.m_library.getDeployedDataPackage().getDeployedComponents())) {
                            bValidated = false;
                        }
                    }
                    catch (MdException mdex) {
                        Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
                        MessageUtil.displayMetadataExceptionMessage((MdException)mdex, (String)"Reading");
                        bValidated = false;
                    }
                }
            } else if (this.m_schema != null) {
                for (int i = 0; i < this.m_schemaList.size(); ++i) {
                    DatabaseSchema schema = (DatabaseSchema)this.m_schemaList.get(i);
                    if (this.m_type == 1 && schema.getName().equalsIgnoreCase(this.m_schema.getSchema().getName()) || !schema.getName().equalsIgnoreCase(this.m_generalPanel.getNameComponent().getText().trim())) continue;
                    JOptionPane.showMessageDialog(parent, bundle.getString("GeneralPropertyView.NameExistsError.Schema.txt"), bundle.getString("Common.Error.txt"), 0);
                    bValidated = false;
                    break;
                }
            }
            return bValidated;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public void onNext() {
        block45: {
            try {
                int i;
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                DeployedComponent root = null;
                if (this.m_server != null) {
                    root = this.m_server.getDeployedComponent();
                }
                if (this.m_connection != null) {
                    root = this.m_connection;
                } else if (this.m_connection == null && parent instanceof ConnectionWizard) {
                    Prototype connectionPrototype = null;
                    try {
                        Prototype prototype = (Prototype)parent.getWizardData("DeployedComponentPrototype");
                        AssociationList propertiesList = prototype.getAssociations();
                        for (i = 0; i < propertiesList.size(); ++i) {
                            AssociationProperty assocProperty = (AssociationProperty)propertiesList.get(i);
                            if (!assocProperty.getAssociationName().equals("SourceConnections")) continue;
                            Vector<Prototype> cpPrototypeList = new Vector<Prototype>();
                            AssociationList connectionPrototypeList = assocProperty.getAssociatedPrototypes();
                            for (int cpIndex = 0; cpIndex < connectionPrototypeList.size(); ++cpIndex) {
                                Prototype cpPrototype = (Prototype)connectionPrototypeList.get(cpIndex);
                                if (cpPrototype == prototype) continue;
                                cpPrototypeList.add(cpPrototype);
                            }
                            this.m_prototype = connectionPrototype = (Prototype)cpPrototypeList.get(0);
                            parent.addWizardData("ConnectionPrototype", (Object)connectionPrototype);
                            parent.addWizardData("ConnectionName", (Object)this.m_generalPanel.getNameComponent().getText().trim());
                            parent.addWizardData("ConnectionDesc", (Object)this.m_generalPanel.getDescriptionComponent().getText().trim());
                            if (cpPrototypeList.size() <= 1) continue;
                            this.setConditionState("CONNECTIONTYPE");
                            return;
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                    Server server = (Server)parent.getWizardData("Server");
                    if (connectionPrototype.getMetadataType().equals("SASClientConnection")) {
                        if (this.m_sasConnection == null) {
                            this.m_sasConnection = (SASClientConnection)Workspace.getMdFactory().createComplexMetadataObject(server.getStore(), null, "SASClientConnection", "SASClientConnection", server.getContext().substring(9), null);
                            this.m_sasConnection.setUsingPrototype(connectionPrototype);
                        }
                        root = this.m_sasConnection;
                    }
                    if (connectionPrototype.getMetadataType().equals("TCPIPConnection")) {
                        if (this.m_tcpConnection == null) {
                            this.m_tcpConnection = (TCPIPConnection)Workspace.getMdFactory().createComplexMetadataObject(server.getStore(), null, "TCPIPConnection", "TCPIPConnection", server.getContext().substring(9), null);
                            this.m_tcpConnection.setUsingPrototype((Root)connectionPrototype);
                        }
                        root = this.m_tcpConnection;
                    }
                    if (connectionPrototype.getMetadataType().equals("COMConnection")) {
                        if (this.m_comConnection == null) {
                            this.m_comConnection = (COMConnection)Workspace.getMdFactory().createComplexMetadataObject(server.getStore(), null, "COMConnection", "COMConnection", server.getContext().substring(9), null);
                            this.m_comConnection.setUsingPrototype((Root)connectionPrototype);
                        }
                        root = this.m_comConnection;
                    }
                    parent.addWizardData("Connection", (Object)root);
                }
                if (this.m_library != null) {
                    root = this.m_library.getDeployedDataPackage();
                }
                if (this.m_schema != null) {
                    root = this.m_schema.getSchema();
                }
                root.setName(this.m_generalPanel.getNameComponent().getText().trim(), 1);
                root.setDesc(this.m_generalPanel.getDescriptionComponent().getText().trim(), 1);
                if (this.m_server != null) {
                    if (this.m_server.getDeployedComponent() instanceof ServerContext) {
                        parent.replaceWizardData("ServerContext", (Object)root);
                    } else {
                        parent.replaceWizardData("DeployedComponent", (Object)root);
                        List logicalServerList = (List)parent.getWizardData("LogicalServersList");
                        if (logicalServerList != null) {
                            LogicalServer logicalServer = (LogicalServer)logicalServerList.get(0);
                            try {
                                AssociationList usingComponentsList = logicalServer.getUsingComponents();
                                if (!usingComponentsList.contains(root)) {
                                    logicalServer.getUsingComponents().add((Object)root);
                                }
                            }
                            catch (MdException exc) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                            }
                            catch (RemoteException re) {
                                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                            }
                        }
                    }
                }
                if (this.m_library != null) {
                    try {
                        Tree tree = this.m_generalPanel.getOwningTree();
                        if (this.currentTreeValue == null || !tree.getFQID().equals(this.currentTreeValue.getFQID())) {
                            this.m_library.getDeployedDataPackage().getTrees().removeAllElements();
                            this.m_library.getDeployedDataPackage().getTrees().add((Object)tree);
                            this.currentNameValue = this.m_generalPanel.getNameComponent().getText().trim();
                            this.currentTreeValue = tree;
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException rex) {
                        String msg = rex.getLocalizedMessage();
                        Workspace.getDefaultLogger().error((Object)msg);
                        MessageUtil.displayMessage((String)msg, (int)0);
                    }
                    parent.addWizardData("DeployedDataPackage", (Object)root);
                    parent.addWizardData("FolderLocation", (Object)this.getFolderLocation());
                }
                if (this.m_schema != null) {
                    parent.addWizardData("DatabaseSchema", (Object)root);
                }
                if (this.m_connection != null) {
                    parent.addWizardData("Connection", (Object)root);
                    parent.addWizardData("ConnectionName", (Object)root.getName());
                    parent.addWizardData("ConnectionDesc", (Object)root.getDesc());
                }
                if (this.m_connection == null && parent instanceof ConnectionWizard) {
                    return;
                }
                boolean bIsVisibleProperty = false;
                try {
                    bIsVisibleProperty = PrototypeUtil.hasVisibleProperty(this.m_prototype.getPrimaryPropertyGroup());
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
                if (bIsVisibleProperty) {
                    if (this.m_server != null) {
                        this.setConditionState("SERVER");
                    }
                    break block45;
                }
                if (this.m_server == null) break block45;
                try {
                    boolean bShowConnectionView = false;
                    AssociationList associationsList = this.m_prototype.getAssociations();
                    for (i = 0; i < associationsList.size(); ++i) {
                        AssociationProperty property = (AssociationProperty)associationsList.get(i);
                        if (!property.getAssociationName().equals("SourceConnections")) continue;
                        bShowConnectionView = true;
                        break;
                    }
                    if (!bShowConnectionView) {
                        this.setConditionState("TRANSFORMATIONS");
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    public void onBack() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        if (this.m_server != null) {
            if (this.m_server.getDeployedComponent() instanceof ServerContext) {
                parent.removeWizardData("ServerContext");
            } else {
                parent.removeWizardData("DeployedComponent");
            }
        }
        if (this.m_library != null) {
            parent.removeWizardData("DeployedDataPackage");
        }
        if (this.m_schema != null) {
            parent.removeWizardData("DatabaseSchema");
        }
    }

    public String createFinishString() {
        String treePath;
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        String strFinish = "";
        if (this.m_server != null) {
            strFinish = bundle.getString("GeneralPropertyView.Finish.Server.txt") + "\n\t" + this.m_generalPanel.getNameComponent().getText().trim() + "\n";
            if (this.m_server.getDeployedComponent() instanceof ServerContext) {
                strFinish = bundle.getString("GeneralPropertyView.Finish.SASAppServer.txt") + "\n\t" + this.m_generalPanel.getNameComponent().getText().trim() + "\n";
            }
        }
        if (this.m_connection != null) {
            strFinish = bundle.getString("GeneralPropertyView.Finish.Connection.txt") + "\n\t" + this.m_generalPanel.getNameComponent().getText().trim() + "\n";
        }
        if (this.m_connection == null && parent instanceof ConnectionWizard) {
            return strFinish;
        }
        if (this.m_library != null) {
            strFinish = bundle.getString("GeneralPropertyView.Finish.Library.txt") + "\n\t" + this.m_generalPanel.getNameComponent().getText().trim() + "\n";
        }
        if (this.m_schema != null) {
            strFinish = bundle.getString("GeneralPropertyView.Finish.Schema.txt") + "\n\t" + this.m_generalPanel.getNameComponent().getText().trim() + "\n";
        }
        if (this.m_generalPanel.getOwningTree() != null && (treePath = this.m_generalPanel.getCustomTreePath()) != null) {
            strFinish = strFinish + bundle.getString("GeneralPropertyView.Finish.Location.txt") + "\n\t" + treePath + "\n";
        }
        return strFinish;
    }

    private String getFolderLocation() {
        if (this.m_generalPanel.getOwningTree() != null) {
            return this.m_generalPanel.getCustomTreePath();
        }
        return null;
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_library != null) {
            try {
                WAStandardDialog parent = (WAStandardDialog)this.getTopLevelAncestor();
                if (parent.getReturnValue() != 2) {
                    if (this.m_type == 0) {
                        WsMetadataUtil.setDefaultFolder((String)this.m_generalPanel.getOwningTree().getFQID());
                    }
                    if (!(this.m_type != 1 || this.currentTreeValue != null && this.m_generalPanel.getOwningTree().getFQID().equals(this.currentTreeValue.getFQID()))) {
                        WsMetadataUtil.setDefaultFolder((String)this.m_generalPanel.getOwningTree().getFQID());
                    }
                }
            }
            catch (RemoteException rex) {
                String msg = rex.getLocalizedMessage();
                Workspace.getDefaultLogger().error((Object)msg);
            }
        }
    }

    protected void _initialize() {
        this.setName(bundle.getString("GeneralPropertyView.TabName.txt"));
        if (this.m_server != null) {
            this.setHelpProduct("newserver");
            this.setHelpTopic("servwiz_2");
        }
        if (this.m_connection != null) {
            this.setHelpProduct("newserver");
            this.setHelpTopic("connwiz_1");
        }
        if (this.m_library != null) {
            this.setHelpProduct("newlibrary");
            this.setHelpTopic("libwiz_3");
        }
        if (this.m_schema != null) {
            this.setHelpProduct("newschema");
            this.setHelpTopic("dbwiz_2");
        }
        DeployedComponent root = null;
        if (this.m_server != null) {
            root = this.m_server.getDeployedComponent();
        }
        if (this.m_connection != null) {
            root = this.m_connection;
        }
        if (this.m_library != null) {
            root = this.m_library.getDeployedDataPackage();
        }
        if (this.m_schema != null) {
            root = this.m_schema.getSchema();
        }
        if (this.m_library != null) {
            Tree owningTree = null;
            if (root != null) {
                try {
                    Tree defaultLocation;
                    if (root.getTrees().size() > 0) {
                        owningTree = (Tree)root.getTrees().get(0);
                    } else if (this.m_type == 0 && (defaultLocation = WsMetadataUtil.getDefaultFolder((MdObjectStore)((MdObjectStore)root.getObjectStore()))) != null && (WsRepositoryUtil.getRepositoryType((MdFactory)Workspace.getMdFactory(), (String)this.m_library.getContext()).equalsIgnoreCase("Project") || root.getRepositoryID().equalsIgnoreCase(defaultLocation.getRepositoryID()))) {
                        owningTree = defaultLocation;
                    }
                }
                catch (MdException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException re) {
                    String msg = re.getLocalizedMessage();
                    Workspace.getDefaultLogger().error((Object)msg);
                    MessageUtil.displayMessage((String)msg, (int)0);
                }
                catch (ServiceException se) {
                    String msg = se.getLocalizedMessage();
                    Workspace.getDefaultLogger().error((Object)msg);
                    MessageUtil.displayMessage((String)msg, (int)0);
                }
            }
            this.m_generalPanel = new GeneralPanel((Root)root, owningTree);
        } else {
            this.m_generalPanel = new GeneralPanel((Root)root);
        }
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints((Component)((Object)this.m_generalPanel), gbc);
        this.add((Component)((Object)this.m_generalPanel));
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    private boolean isTableServerPrototype() {
        try {
            AssociationList propertiesList = this.m_prototype.getPrototypeProperties();
            for (int pIndex = 0; pIndex < propertiesList.size(); ++pIndex) {
                AttributeProperty ap;
                AbstractProperty property = (AbstractProperty)propertiesList.get(pIndex);
                if (!(property instanceof AttributeProperty) || !(ap = (AttributeProperty)property).getPropertyName().equalsIgnoreCase("ClassIdentifier") || !ap.getDefaultValue().equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc")) continue;
                return true;
            }
        }
        catch (MdException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return false;
    }

    protected class GeneralPanel
    extends WAGeneralPanel {
        protected JLabel m_lblID;
        protected WATextArea m_txtID;
        private static final long serialVersionUID = 4791446576748808581L;
        protected boolean includeGroupComponents;

        public GeneralPanel(Root root) {
            super((CMetadata)root, null, false, false, false);
            this.includeGroupComponents = false;
            this._setIDComponents(root);
            this.removeAll();
            this._layoutWidgets();
            this.revalidate();
        }

        public GeneralPanel(Root root, Tree tree) {
            super((CMetadata)root, null, false, false, false, true, tree);
            this.includeGroupComponents = false;
            this._setIDComponents(root);
            this.includeGroupComponents = true;
            FolderUtil.setPanelLocationRepositoryFilter(this, root);
            this.removeAll();
            this._layoutWidgets();
            this.revalidate();
        }

        private void _setIDComponents(Root root) {
            this.m_lblID = new JLabel(bundle.getString("Common.ID.txt"));
            this.m_txtID = new WATextArea("");
            try {
                if (root != null) {
                    this.m_txtID = new WATextArea(root.getFQID());
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            this.m_txtID.setBehavior(2);
        }

        protected void _layoutWidgets() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            int gridy = 0;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.anchor = 17;
            gbc.insets = new Insets(5, 5, 0, 0);
            gridBagLayout.setConstraints(this.m_lblName, gbc);
            this.add(this.m_lblName);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            gridBagLayout.setConstraints((Component)this.m_txtName, gbc);
            this.add((Component)this.m_txtName);
            if (GeneralPropertyView.this.m_type == 1) {
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridy;
                gbc.anchor = 17;
                gbc.insets = new Insets(5, 5, 0, 0);
                gridBagLayout.setConstraints(this.m_lblID, gbc);
                this.add(this.m_lblID);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = gridy++;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                gbc.gridwidth = 0;
                gbc.insets = new Insets(5, 5, 0, 5);
                gridBagLayout.setConstraints((Component)this.m_txtID, gbc);
                this.add((Component)this.m_txtID);
            }
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.anchor = 18;
            gbc.insets = new Insets(5, 5, 0, 0);
            gridBagLayout.setConstraints(this.m_lblDescription, gbc);
            this.add(this.m_lblDescription);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            gridBagLayout.setConstraints(this.m_scrDescription, gbc);
            this.add(this.m_scrDescription);
            if (this.includeGroupComponents) {
                this.add(this.m_lblGroup, new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
                this.add((Component)this.m_txtGroup, new GridBagConstraints(1, gridy, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
                this.add(this.m_btnGroup, new GridBagConstraints(2, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
                ++gridy;
            }
            JPanel eaterPanel = new JPanel();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.gridwidth = 0;
            gbc.gridheight = 0;
            gbc.insets = new Insets(12, 12, 12, 12);
            gridBagLayout.setConstraints(eaterPanel, gbc);
            this.add(eaterPanel);
        }
    }
}

